/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.antireplay.properties;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(value="hussar.secure.anti-replay")
public class SecureAntiReplayProperties {
    private Boolean enabled = Boolean.FALSE;
    private Long requestValidTime = 10000L;
    private List<String> ignoreUrls = new ArrayList<String>();
    private static final List<String> ignoreUrlsDefaultList = new ArrayList<String>();

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Long getRequestValidTime() {
        return this.requestValidTime;
    }

    public void setRequestValidTime(Long requestValidTime) {
        this.requestValidTime = requestValidTime;
    }

    public List<String> getIgnoreUrls() {
        ArrayList<String> allIgnoreUrls = new ArrayList<String>();
        if (HussarUtils.isEmpty(this.ignoreUrls)) {
            allIgnoreUrls.addAll(ignoreUrlsDefaultList);
            return allIgnoreUrls;
        }
        allIgnoreUrls.addAll(this.ignoreUrls);
        allIgnoreUrls.addAll(ignoreUrlsDefaultList);
        return allIgnoreUrls.stream().distinct().collect(Collectors.toList());
    }

    public void setIgnoreUrls(List<String> ignoreUrls) {
        this.ignoreUrls = ignoreUrls;
    }

    static {
        ignoreUrlsDefaultList.add("/themeConfig/**");
        ignoreUrlsDefaultList.add("/speed/**");
        ignoreUrlsDefaultList.add("/speedcode/**");
        ignoreUrlsDefaultList.add("/formdesign/**");
        ignoreUrlsDefaultList.add("/configure/center/**");
        ignoreUrlsDefaultList.add("/flowAuth/**");
        ignoreUrlsDefaultList.add("/static/**");
        ignoreUrlsDefaultList.add("/favicon.ico");
        ignoreUrlsDefaultList.add("/error");
    }
}

