/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.secure.antireplay.support;

import com.jxdinfo.hussar.encrypt.util.SM3Util;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.secure.antireplay.core.constants.AntiReplay;
import com.jxdinfo.hussar.support.secure.antireplay.core.enums.AntiReplayExceptionEnum;
import com.jxdinfo.hussar.support.secure.antireplay.properties.SecureAntiReplayProperties;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PathMatcher;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class AntiReplayInterceptor
implements HandlerInterceptor {
    @Resource
    private SecureAntiReplayProperties secureAntiReplayProperties;
    public static PathMatcher pathMatcher = new AntPathMatcher();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        if (!this.secureAntiReplayProperties.getEnabled().booleanValue()) {
            return true;
        }
        String uri = request.getRequestURI();
        if (this.ignorePath(uri).booleanValue()) {
            return true;
        }
        Long requestValidTime = this.secureAntiReplayProperties.getRequestValidTime();
        Method method = ((HandlerMethod)handler).getMethod();
        AntiReplay antiReplay = method.getAnnotation(AntiReplay.class);
        if (antiReplay != null) {
            if (!antiReplay.needCheck()) {
                return true;
            }
            requestValidTime = antiReplay.timeout();
        }
        String uniqueId = request.getHeader("uniqueId");
        String timeStr = request.getHeader("jstime");
        String checkCode = request.getHeader("checkCode");
        Boolean isAllEmpty = HussarUtils.isAllEmpty((Object[])new Object[]{uniqueId, checkCode});
        if (isAllEmpty.booleanValue()) {
            return true;
        }
        Boolean hasBlank = HussarUtils.isAnyBlank((CharSequence[])new CharSequence[]{uniqueId, timeStr, checkCode});
        if (hasBlank.booleanValue()) {
            throw new HussarException(AntiReplayExceptionEnum.HEADER_PARAM_IS_NULL.message);
        }
        if (!HussarUtils.equals((Object)checkCode, (Object)SM3Util.digest((String)(uniqueId + timeStr)))) {
            throw new HussarException(AntiReplayExceptionEnum.HEADER_CHECK_CODE_ERROR.message);
        }
        Object obj = HussarCacheUtil.get((String)"Secure-Anti-replay", (Object)uniqueId);
        if (HussarUtils.notNull((Object)obj)) {
            throw new HussarException(AntiReplayExceptionEnum.ANTI_REPLAY_EXCEPTION.message);
        }
        Long expireTime = requestValidTime / 1000L + 1L;
        HussarCacheUtil.put((String)"Secure-Anti-replay", (Object)uniqueId, (Object)requestValidTime, (long)expireTime);
        return true;
    }

    private Boolean ignorePath(String path) {
        if (CollectionUtils.isEmpty(this.secureAntiReplayProperties.getIgnoreUrls())) {
            return false;
        }
        for (String pattern : this.secureAntiReplayProperties.getIgnoreUrls()) {
            if (!pathMatcher.match(pattern, path)) continue;
            return true;
        }
        return false;
    }
}

