/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.rmi;

import com.jxdinfo.hussar.support.rmi.RmiApiBeanRegister;
import com.jxdinfo.hussar.support.rmi.annotation.RmiApiScannerRegister;
import com.jxdinfo.hussar.support.rmi.plugin.spring.config.SpringRmiApiProperties;
import com.jxdinfo.hussar.support.rmi.plugin.spring.interceptor.SpringInterceptorFactory;
import com.jxdinfo.hussar.support.rmi.plugin.spring.reflection.SpringRmiApiObjectFactory;
import com.jxdinfo.hussar.support.rmi.plugin.spring.spring.RmiApiBeanProcessor;
import com.jxdinfo.hussar.support.rmi.properties.RmiApiConfigurationProperties;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RmiApiConfigurationProperties.class})
@Import(value={RmiApiScannerRegister.class})
@ConditionalOnProperty(prefix="hussar.rmi.api", name={"enable"}, havingValue="true", matchIfMissing=true)
public class RmiApiAutoConfiguration {
    @Resource
    private ConfigurableApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean
    public SpringRmiApiProperties rmiApiProperties() {
        return new SpringRmiApiProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringRmiApiObjectFactory rmiApiObjectFactory() {
        return new SpringRmiApiObjectFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringInterceptorFactory rmiApiInterceptorFactory() {
        return new SpringInterceptorFactory();
    }

    @Bean
    @DependsOn(value={"rmiApiBeanProcessor"})
    @ConditionalOnMissingBean
    public RmiApiBeanRegister rmiApiBeanRegister(SpringRmiApiProperties properties, SpringRmiApiObjectFactory rmiApiObjectFactory, SpringInterceptorFactory rmiApiInterceptorFactory, RmiApiConfigurationProperties rmiApiConfigurationProperties) {
        RmiApiBeanRegister register = new RmiApiBeanRegister(this.applicationContext, rmiApiConfigurationProperties, properties, rmiApiObjectFactory, rmiApiInterceptorFactory);
        register.registerRmiApiConfiguration();
        register.registerScanner();
        return register;
    }

    @Bean
    @ConditionalOnMissingBean
    public RmiApiBeanProcessor rmiApiBeanProcessor() {
        return new RmiApiBeanProcessor();
    }
}

