/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.rmi.annotation;

import com.jxdinfo.hussar.support.rmi.annotation.RmiApiScan;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class RmiApiScannerRegister
implements BeanFactoryAware,
ImportBeanDefinitionRegistrar {
    private static List<String> basePackages = new ArrayList<String>();
    private static String configurationId;
    private BeanFactory beanFactory;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Map annotationAttributes = importingClassMetadata.getAnnotationAttributes(RmiApiScan.class.getName());
        if (annotationAttributes != null) {
            AnnotationAttributes annoAttrs = AnnotationAttributes.fromMap((Map)annotationAttributes);
            for (String pkg : annoAttrs.getStringArray("value")) {
                if (!StringUtils.hasText((String)pkg)) continue;
                basePackages.add(pkg);
            }
            for (String pkg : annoAttrs.getStringArray("basePackages")) {
                if (!StringUtils.hasText((String)pkg)) continue;
                basePackages.add(pkg);
            }
            for (Class clazz : annoAttrs.getClassArray("basePackageClasses")) {
                basePackages.add(ClassUtils.getPackageName((Class)clazz));
            }
            configurationId = annoAttrs.getString("configuration");
        }
        if (basePackages.isEmpty()) {
            basePackages.addAll(AutoConfigurationPackages.get((BeanFactory)this.beanFactory));
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public static List<String> getBasePackages() {
        return basePackages;
    }

    public static String getConfigurationId() {
        return configurationId;
    }
}

