/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.rmi.plugin.spring.schema;

import com.jxdinfo.hussar.support.rmi.plugin.spring.beans.ClientFactoryBean;
import com.jxdinfo.hussar.support.rmi.plugin.spring.utils.ClientFactoryBeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class RmiApiClientBeanDefinitionParser
implements BeanDefinitionParser {
    private static final Logger log = LoggerFactory.getLogger(RmiApiClientBeanDefinitionParser.class);
    private final Class factoryBeanClass = ClientFactoryBean.class;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setLazyInit(false);
        String id = element.getAttribute("id");
        id = ClientFactoryBeanUtils.getBeanId(id, this.factoryBeanClass, parserContext);
        if (id != null && id.length() > 0) {
            if (parserContext.getRegistry().containsBeanDefinition(id)) {
                throw new IllegalStateException("Duplicate spring bean id " + id);
            }
            parserContext.getRegistry().registerBeanDefinition(id, (BeanDefinition)beanDefinition);
        }
        String configurationId = element.getAttribute("configuration");
        String clientClassName = element.getAttribute("class");
        ClientFactoryBeanUtils.setupClientFactoryBean((AbstractBeanDefinition)beanDefinition, configurationId, clientClassName);
        log.info("[RmiApi] Created RmiApi Client Bean with name '" + id + "' and Proxy of '" + clientClassName + "' client interface");
        return beanDefinition;
    }
}

