/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.rmi.plugin.spring.spring;

import com.jxdinfo.hussar.support.rmi.core.RmiApi;
import com.jxdinfo.hussar.support.rmi.core.config.RmiApiConfiguration;
import com.jxdinfo.hussar.support.rmi.core.reflection.RmiApiVariableValue;
import com.jxdinfo.hussar.support.rmi.core.utils.StringUtils;
import com.jxdinfo.hussar.support.rmi.plugin.spring.annotation.BindingVar;
import com.jxdinfo.hussar.support.rmi.plugin.spring.spring.SpringVariableValue;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;

public class RmiApiBeanProcessor
implements InstantiationAwareBeanPostProcessor {
    private void processBean(Object bean, Class beanClass) {
        Method[] methods;
        for (Method method : methods = beanClass.getDeclaredMethods()) {
            BindingVar annotation = method.getAnnotation(BindingVar.class);
            if (annotation == null) continue;
            String confId = annotation.configuration();
            RmiApiConfiguration configuration = null;
            configuration = StringUtils.isNotBlank((String)confId) ? RmiApi.config((String)confId) : RmiApi.config();
            String varName = annotation.value();
            SpringVariableValue variableValue = new SpringVariableValue(bean, method);
            configuration.setVariableValue(varName, (RmiApiVariableValue)variableValue);
        }
    }

    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) throws BeansException {
        return null;
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        Class<?> beanClass = bean.getClass();
        this.processBean(bean, beanClass);
        return true;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        return pvs;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

