/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.rmi.plugin.spring.ssl;

import com.jxdinfo.hussar.support.rmi.core.RmiApi;
import com.jxdinfo.hussar.support.rmi.core.exceptions.RmiApiRuntimeException;
import com.jxdinfo.hussar.support.rmi.core.ssl.SSLKeyStore;
import com.jxdinfo.hussar.support.rmi.core.ssl.SSLSocketFactoryBuilder;
import com.jxdinfo.hussar.support.rmi.core.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.net.ssl.HostnameVerifier;
import org.springframework.core.io.ClassPathResource;

public class SpringSSLKeyStore
extends SSLKeyStore {
    private static SSLSocketFactoryBuilder getSSLSocketFactoryBuilder(String sslSocketFactoryBuilderClass) {
        if (StringUtils.isBlank((String)sslSocketFactoryBuilderClass)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(sslSocketFactoryBuilderClass);
            if (!SSLSocketFactoryBuilder.class.isAssignableFrom(clazz)) {
                throw new RmiApiRuntimeException("[RmiApi] The value of property 'sslSocketFactoryBuilder' must be a class inherited from com.jxdinfo.hussar.support.rmi.core.ssl.SSLSocketFactoryBuilder");
            }
            return (SSLSocketFactoryBuilder)RmiApi.config().getRmiApiObjectFactory().getObject(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RmiApiRuntimeException((Throwable)e);
        }
    }

    private static HostnameVerifier getHostnameVerifier(String hostnameVerifierClass) {
        if (StringUtils.isBlank((String)hostnameVerifierClass)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(hostnameVerifierClass);
            if (!HostnameVerifier.class.isAssignableFrom(clazz)) {
                throw new RmiApiRuntimeException("[RmiApi] The value of property 'hostnameVerifier' must be a class inherited from javax.net.ssl.HostnameVerifier");
            }
            return (HostnameVerifier)RmiApi.config().getRmiApiObjectFactory().getObject(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RmiApiRuntimeException((Throwable)e);
        }
    }

    public SpringSSLKeyStore(String id, String keystoreType, String filePath, String keystorePass, String certPass, String hostnameVerifierClass, String sslSocketFactoryBuilderClass) {
        super(id, keystoreType, filePath, keystorePass, certPass, SpringSSLKeyStore.getHostnameVerifier(hostnameVerifierClass), SpringSSLKeyStore.getSSLSocketFactoryBuilder(sslSocketFactoryBuilderClass));
    }

    public void init() {
        if (StringUtils.isBlank((String)this.filePath)) {
            return;
        }
        if (this.filePath.indexOf(":/") == 1 || this.filePath.indexOf(":\\") == 1 || this.filePath.startsWith("/")) {
            File file = new File(this.filePath);
            if (!file.exists()) {
                throw new RmiApiRuntimeException("The file of SSL KeyStore \"" + this.id + "\" " + this.filePath + " cannot be found!");
            }
            try {
                this.inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new RmiApiRuntimeException("An error occurred while reading he file of SSL KeyStore \"\" + id + \"\"", (Throwable)e);
            }
        }
        ClassPathResource resource = new ClassPathResource(this.filePath);
        if (!resource.exists()) {
            throw new RmiApiRuntimeException("The file of SSL KeyStore \"" + this.id + "\" " + this.filePath + " cannot be found!");
        }
        try {
            this.inputStream = resource.getInputStream();
        }
        catch (IOException e) {
            throw new RmiApiRuntimeException("An error occurred while reading he file of SSL KeyStore \"\" + id + \"\"", (Throwable)e);
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }
}

