/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.rmi.plugin.spring.scanner;

import com.jxdinfo.hussar.support.rmi.core.http.body.RequestBodyBuilder;
import com.jxdinfo.hussar.support.rmi.core.multipart.RmiApiMultipartFactory;
import com.jxdinfo.hussar.support.rmi.plugin.spring.body.MultipartRequestBodyBuilder;
import com.jxdinfo.hussar.support.rmi.plugin.spring.body.ResourceRequestBodyBuilder;
import com.jxdinfo.hussar.support.rmi.plugin.spring.file.SpringResource;
import com.jxdinfo.hussar.support.rmi.plugin.spring.utils.ClientFactoryBeanUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;

public class ClassPathClientScanner
extends ClassPathBeanDefinitionScanner {
    private static final String[] RMI_API_METHOD_ANNOTATION_NAMES = new String[]{"com.jxdinfo.hussar.support.rmi.core.annotation.Backend", "com.jxdinfo.hussar.support.rmi.core.annotation.Headers", "com.jxdinfo.hussar.support.rmi.core.annotation.Address", "com.jxdinfo.hussar.support.rmi.core.annotation.Request", "com.jxdinfo.hussar.support.rmi.core.annotation.Get", "com.jxdinfo.hussar.support.rmi.core.annotation.GetRequest", "com.jxdinfo.hussar.support.rmi.core.annotation.Post", "com.jxdinfo.hussar.support.rmi.core.annotation.PostRequest", "com.jxdinfo.hussar.support.rmi.core.annotation.Put", "com.jxdinfo.hussar.support.rmi.core.annotation.PutRequest", "com.jxdinfo.hussar.support.rmi.core.annotation.HeadRequest", "com.jxdinfo.hussar.support.rmi.core.annotation.Options", "com.jxdinfo.hussar.support.rmi.core.annotation.OptionsRequest", "com.jxdinfo.hussar.support.rmi.core.annotation.Patch", "com.jxdinfo.hussar.support.rmi.core.annotation.PatchRequest", "com.jxdinfo.hussar.support.rmi.core.annotation.Trace", "com.jxdinfo.hussar.support.rmi.core.annotation.TraceRequest"};
    private final String configurationId;
    private boolean allInterfaces = true;

    public ClassPathClientScanner(String configurationId, BeanDefinitionRegistry registry) {
        super(registry, false);
        this.configurationId = configurationId;
        this.registerFilters();
        this.registerMultipartTypes();
    }

    public void registerMultipartTypes() {
        RmiApiMultipartFactory.registerFactory(Resource.class, SpringResource.class);
        RequestBodyBuilder.registerBodyBuilder(Resource.class, (RequestBodyBuilder)new ResourceRequestBodyBuilder());
        try {
            Class<?> multipartFileClass = Class.forName("org.springframework.web.multipart.MultipartFile");
            Class<?> springMultipartFileClass = Class.forName("com.jxdinfo.hussar.support.rmi.plugin.spring.file.SpringMultipartFile");
            RmiApiMultipartFactory.registerFactory(multipartFileClass, springMultipartFileClass);
            RequestBodyBuilder.registerBodyBuilder(multipartFileClass, (RequestBodyBuilder)new MultipartRequestBodyBuilder());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean interfaceFilter(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) {
        ClassMetadata classMetadata = metadataReader.getClassMetadata();
        if (!classMetadata.isInterface() || classMetadata.isFinal()) {
            return false;
        }
        String[] superClassNames = metadataReader.getClassMetadata().getInterfaceNames();
        boolean hasSuperRmiApiClient = false;
        for (String superClassName : superClassNames) {
            try {
                MetadataReader superMetaReader = metadataReaderFactory.getMetadataReader(superClassName);
                hasSuperRmiApiClient = this.interfaceFilter(superMetaReader, metadataReaderFactory);
            }
            catch (IOException superMetaReader) {
                // empty catch block
            }
            if (!hasSuperRmiApiClient) continue;
            return true;
        }
        AnnotationMetadata annotationMetadata = metadataReader.getAnnotationMetadata();
        for (String annotationTypeName : annotationMetadata.getAnnotationTypes()) {
            if ("com.jxdinfo.hussar.support.rmi.core.annotation.RmiApiClient".equals(annotationTypeName)) {
                return true;
            }
            if (!"com.jxdinfo.hussar.support.rmi.core.annotation.BaseRequest".equals(annotationTypeName)) continue;
            return true;
        }
        for (String methodAnnName : RMI_API_METHOD_ANNOTATION_NAMES) {
            if (!annotationMetadata.hasAnnotatedMethods(methodAnnName)) continue;
            return true;
        }
        return false;
    }

    public void registerFilters() {
        if (this.allInterfaces) {
            this.addIncludeFilter((metadataReader, metadataReaderFactory) -> this.interfaceFilter(metadataReader, metadataReaderFactory));
        }
        this.addExcludeFilter((metadataReader, metadataReaderFactory) -> {
            String className = metadataReader.getClassMetadata().getClassName();
            return className.endsWith("package-info");
        });
    }

    private void processBeanDefinitions(Set<BeanDefinitionHolder> beanDefinitions) {
        for (BeanDefinitionHolder holder : beanDefinitions) {
            GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
            String beanClassName = definition.getBeanClassName();
            ClientFactoryBeanUtils.setupClientFactoryBean((AbstractBeanDefinition)definition, this.configurationId, beanClassName);
            this.logger.info((Object)("[RmiApi] Created RmiApi Client Bean with name '" + holder.getBeanName() + "' and Proxy of '" + beanClassName + "' client interface"));
        }
    }

    public Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            this.logger.warn((Object)("[RmiApi] No RmiApi client is found in package '" + Arrays.toString(basePackages) + "'."));
        }
        this.processBeanDefinitions(beanDefinitions);
        return beanDefinitions;
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }
}

