/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.oss.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.LocaleMessageUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.oss.core.support.dto.AttachInfoDto;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/attachment"})
@Api(tags={"\u6587\u4ef6\u4e0a\u4f20\u7ba1\u7406"})
@AuditLog(moduleName="\u6587\u4ef6\u4e0a\u4f20\u7ba1\u7406")
public class AttachmentManagerController
extends HussarBaseController<AttachmentManagerModel, AttachmentManagerService> {
    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6", notes="\u4e0a\u4f20\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u6587\u4ef6", required=true, paramType="body")})
    @CheckPermission(value={"attachment:upload"})
    @PostMapping(value={"/add"})
    @AuditLog(eventDesc="\u4e0a\u4f20\u6587\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    @Deprecated
    public ApiResponse<String> upload(@RequestPart(value="file") MultipartFile file) {
        return ((AttachmentManagerService)this.hussarService).upload(file);
    }

    @ApiOperation(value="\u5355\u6587\u4ef6\u4e0a\u4f20", notes="\u5355\u6587\u4ef6\u4e0a\u4f20")
    @ApiImplicitParams(value={@ApiImplicitParam(name="multipartRequest", value="\u6587\u4ef6\u8bf7\u6c42", required=true, paramType="body")})
    @CheckPermission(value={"attachment:uploadfilewithdrag"})
    @PostMapping(value={"/uploadfilewithdrag"})
    @AuditLog(eventDesc="\u5355\u6587\u4ef6\u4e0a\u4f20", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse<AttachmentManagerModelVo> uploadfileWithDrag(MultipartHttpServletRequest multipartRequest, @ApiParam(value="\u4e1a\u52a1ID") Long businessId) throws Exception {
        return ((AttachmentManagerService)this.hussarService).uploadFileWithDrag(multipartRequest, businessId);
    }

    @ApiOperation(value="\u591a\u6587\u4ef6\u4e0a\u4f20", notes="\u591a\u6587\u4ef6\u4e0a\u4f20")
    @ApiImplicitParams(value={@ApiImplicitParam(name="multipartRequest", value="\u6587\u4ef6\u8bf7\u6c42", required=true, paramType="body")})
    @CheckPermission(value={"attachment:uploadMultipleFile"})
    @PostMapping(value={"/uploadMultipleFile"})
    @AuditLog(eventDesc="\u591a\u6587\u4ef6\u4e0a\u4f20", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse<List<AttachmentManagerModelVo>> uploadMultipleFile(MultipartHttpServletRequest multipartRequest, @ApiParam(value="\u4e1a\u52a1ID") Long businessId) throws Exception {
        return ApiResponse.success((Object)((AttachmentManagerService)this.hussarService).uploadMultipleFile(multipartRequest, businessId));
    }

    @ApiOperation(value="\u6587\u4ef6\u4e0b\u8f7d", notes="\u6587\u4ef6\u4e0b\u8f7d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileId", value="\u6587\u4ef6id", required=true, paramType="query")})
    @CheckPermission(value={"attachment:fileDownload"})
    @GetMapping(value={"/fileDownload"})
    @AuditLog(eventDesc="\u6587\u4ef6\u4e0b\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public void fileDownload(HttpServletResponse response, Long fileId) {
        ((AttachmentManagerService)this.hussarService).fileDownload(response, fileId);
    }

    @ApiOperation(value="\u6279\u91cf\u4e0b\u8f7d", notes="\u6279\u91cf\u4e0b\u8f7d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u6587\u4ef6id", required=true, paramType="query")})
    @CheckPermission(value={"attachment:BatchDownload"})
    @GetMapping(value={"/BatchDownload"})
    @AuditLog(eventDesc="\u6279\u91cf\u4e0b\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public void batchDownload(@RequestParam(value="fileId") String ids, HttpServletResponse response) throws ServletException, IOException {
        ((AttachmentManagerService)this.hussarService).batchDownload(ids, response);
    }

    @ApiOperation(value="\u5220\u9664\u6587\u4ef6", notes="\u5220\u9664\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileId", value="\u6587\u4ef6id", required=true, paramType="query")})
    @CheckPermission(value={"attachment:delete"})
    @PostMapping(value={"/delete"})
    @AuditLog(eventDesc="\u5220\u9664\u6587\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Object> fileDelete(@RequestParam Long fileId) {
        return ((AttachmentManagerService)this.hussarService).deleteFile(fileId);
    }

    @CheckPermission(value={"attachment:getAttachmentList"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="info", value="\u9644\u4ef6\u67e5\u8be2\u4fe1\u606f", required=true, paramType="query")})
    @GetMapping(value={"/getAttachmentList"})
    @ApiOperation(value="\u9644\u4ef6\u4fe1\u606f\u5217\u8868\u67e5\u8be2", notes="\u9644\u4ef6\u4fe1\u606f\u5217\u8868\u67e5\u8be2")
    @AuditLog(eventDesc="\u9644\u4ef6\u4fe1\u606f\u5217\u8868\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<AttachmentManagerModel>> getAttachmentList(Page<AttachmentManagerModel> page, AttachInfoDto info) {
        return ApiResponse.success((Object)((AttachmentManagerService)this.hussarService).getAttachmentList(page, info));
    }

    @CheckPermission(value={"attachment:showPicture"})
    @GetMapping(value={"/showPicture"})
    @ApiOperation(value="\u663e\u793a\u56fe\u7247", notes="\u663e\u793a\u56fe\u7247")
    @AuditLog(eventDesc="\u663e\u793a\u56fe\u7247", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public void showImage(HttpServletResponse response, @ApiParam(value="\u56fe\u7247id") Long image) {
        ((AttachmentManagerService)this.hussarService).showImage(response, image);
    }

    @CheckPermission(value={"attachment:uploadFileQuery"})
    @GetMapping(value={"/uploadFileQuery"})
    @ResponseBody
    @ApiOperation(value="\u6587\u4ef6\u4e0a\u4f20\u56de\u663e", notes="\u6587\u4ef6\u4e0a\u4f20\u56de\u663e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileId", value="\u6587\u4ef6id", required=true, paramType="query")})
    @AuditLog(eventDesc="\u6587\u4ef6\u4e0a\u4f20\u56de\u663e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<AttachmentManagerModelVo> uploadFileQuery(@RequestParam(value="fileId") Long fileId) {
        return ApiResponse.success((Object)((AttachmentManagerService)this.hussarService).getByFileId(fileId));
    }

    @GetMapping(value={"/uploadFilesQuery"})
    @ResponseBody
    @ApiOperation(value="\u591a\u4e2a\u6587\u4ef6\u4e0a\u4f20\u56de\u663e", notes="\u591a\u4e2a\u6587\u4ef6\u4e0a\u4f20\u56de\u663e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileIds", value="\u6587\u4ef6ids", required=true, paramType="query")})
    @AuditLog(eventDesc="\u591a\u4e2a\u6587\u4ef6\u4e0a\u4f20\u56de\u663e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<AttachmentManagerModelVo>> uploadFilesQuery(@RequestParam(value="fileIds") String fileIds) {
        if (HussarUtils.isNotBlank((CharSequence)fileIds)) {
            String[] relFileIds = fileIds.split(",");
            return ApiResponse.success((Object)((AttachmentManagerService)this.hussarService).getByFileIds(relFileIds));
        }
        return ApiResponse.fail((String)LocaleMessageUtils.getMessage((String)"FILE_ID_IS_EMPTY"));
    }
}

