/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.oss.plugin.file.support.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.FileUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IoUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.core.properties.OssProperties;
import com.jxdinfo.hussar.support.oss.core.support.dao.AttachmentManagerMapper;
import com.jxdinfo.hussar.support.oss.core.support.dto.AttachInfoDto;
import com.jxdinfo.hussar.support.oss.core.support.dto.FileInfoDto;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.enums.OssExceptionEnum;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.util.CheckUploadFileUtils;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.oss.core.support.vo.RangeDownloadVO;
import com.jxdinfo.hussar.support.oss.plugin.file.properties.OssFileProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@HussarDs(value="master")
public class DefaultAttachmentManagerServiceImpl
extends HussarServiceImpl<AttachmentManagerMapper, AttachmentManagerModel>
implements AttachmentManagerService {
    private final OssFileProperties ossFileProperties;
    private final GetLoginUserService getLoginUserService;
    @Resource
    private OssProperties ossProperties;
    private static Logger logger = LogManager.getLogger(DefaultAttachmentManagerServiceImpl.class);

    public DefaultAttachmentManagerServiceImpl(OssFileProperties ossFileProperties, GetLoginUserService getLoginUserService) {
        this.ossFileProperties = ossFileProperties;
        this.getLoginUserService = getLoginUserService;
    }

    public Long saveAttachment(AttachmentManagerModel attachmentManagerModel) {
        this.save((BaseEntity)attachmentManagerModel);
        return attachmentManagerModel.getId();
    }

    public String findDirById(Long id) {
        AttachmentManagerModel attachmentManagerModel = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)attachmentManagerModel)) {
            return "";
        }
        return attachmentManagerModel.getAttachmentDir();
    }

    public AttachmentManagerModelVo getByFileId(Long fileId) {
        if (HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        return this.getAttachmentVoById(fileId);
    }

    public List<AttachmentManagerModelVo> getByFileIds(String[] fileIds) {
        ArrayList<AttachmentManagerModelVo> attachmentManagerModelVos = new ArrayList<AttachmentManagerModelVo>();
        if (HussarUtils.isEmpty((Object[])fileIds)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        for (String fileId : fileIds) {
            if (!HussarUtils.isNotEmpty((Object)fileId)) continue;
            attachmentManagerModelVos.add(this.getAttachmentVoById(Long.parseLong(fileId)));
        }
        return attachmentManagerModelVos;
    }

    public ApiResponse<String> upload(MultipartFile file) {
        if (HussarUtils.isEmpty((Object)file) || HussarUtils.isEmpty((Object)file.getOriginalFilename())) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        CheckUploadFileUtils.checkFileType((MultipartFile)file, (OssProperties)this.ossProperties);
        String fileName = file.getOriginalFilename();
        String suffix = this.getSuffix(fileName);
        String fName = IdWorker.get32UUID() + suffix;
        try {
            String fileSavePath = this.ossFileProperties.getFileUploadPath();
            file.transferTo(new File(fileSavePath + fName));
        }
        catch (IOException e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.FILE_UPLOAD_ERROR.getExceptionCode(), OssExceptionEnum.FILE_UPLOAD_ERROR.getMessage());
        }
        return ApiResponse.success((String)fName);
    }

    public ApiResponse<AttachmentManagerModelVo> uploadFileWithDrag(MultipartHttpServletRequest multipartRequest, Long businessId) throws Exception {
        if (HussarUtils.isEmpty((Object)multipartRequest)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        multipartRequest.setCharacterEncoding("UTF-8");
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        MultipartFile multipartFile = null;
        Map map = multipartRequest.getFileMap();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            MultipartFile value;
            multipartFile = value = (MultipartFile)iterator.next();
        }
        if (HussarUtils.isNotEmpty(multipartFile)) {
            CheckUploadFileUtils.checkFileType((MultipartFile)multipartFile, (OssProperties)this.ossProperties);
            attachmentManagerModelVo = this.packageAttachmentVo(multipartFile, businessId);
        }
        return ApiResponse.success((Object)attachmentManagerModelVo);
    }

    public ApiResponse<AttachmentManagerModelVo> uploadFileWithDrag(MultipartFile multipartFile, Long businessId) throws Exception {
        if (HussarUtils.isEmpty((Object)multipartFile)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        CheckUploadFileUtils.checkFileType((MultipartFile)multipartFile, (OssProperties)this.ossProperties);
        return ApiResponse.success((Object)this.packageAttachmentVo(multipartFile, businessId));
    }

    public List<AttachmentManagerModelVo> uploadMultipleFile(MultipartHttpServletRequest multipartRequest, Long businessId) throws Exception {
        if (HussarUtils.isEmpty((Object)multipartRequest)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        ArrayList<AttachmentManagerModelVo> voList = new ArrayList<AttachmentManagerModelVo>();
        multipartRequest.setCharacterEncoding("UTF-8");
        Map map = multipartRequest.getFileMap();
        if (HussarUtils.isNotEmpty((Object)map)) {
            map.values().forEach(file -> CheckUploadFileUtils.checkFileType((MultipartFile)file, (OssProperties)this.ossProperties));
        }
        for (MultipartFile file2 : map.values()) {
            MultipartFile multipartFile = file2;
            if (!HussarUtils.isNotEmpty((Object)multipartFile)) continue;
            AttachmentManagerModelVo attachmentManagerModelVo = this.packageAttachmentVo(multipartFile, businessId);
            voList.add(attachmentManagerModelVo);
        }
        return voList;
    }

    public void fileDownload(HttpServletResponse response, Long fileId) {
        if (HussarUtils.isEmpty((Object)response) || HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.getById(fileId);
        if (HussarUtils.isEmpty((Object)attachmentModel)) {
            return;
        }
        String fileName = attachmentModel.getAttachmentName();
        String suffix = this.getSuffix(fileName);
        String path = attachmentModel.getAttachmentDir() + fileId + suffix;
        File file = new File(path);
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file), 10240);
             BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            fileName = URLEncoder.encode(fileName, "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            response.setContentLengthLong(file.length());
            int len = 0;
            byte[] buff = new byte[this.ossProperties.getDownloadBuffSize()];
            while ((len = ((InputStream)bis).read(buff)) > 0) {
                out.write(buff, 0, len);
                out.flush();
            }
        }
        catch (FileNotFoundException e) {
            logger.error("inputParams:{} and errorMessage:{}", (Object)fileName.toString(), (Object)e.getMessage(), (Object)e);
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.FILE_NOT_FOUND.getExceptionCode(), OssExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            logger.error("inputParams:{} and errorMessage:{}", (Object)"\u7f16\u7801\u5f02\u5e38\uff1a", (Object)e.getMessage(), (Object)e);
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
        }
        catch (IOException e) {
            logger.error("inputParams:{} and errorMessage:{}", (Object)"IO\u5f02\u5e38\uff1a", (Object)e.getMessage(), (Object)e);
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
        }
    }

    public void batchDownload(String ids, HttpServletResponse response) throws ServletException, IOException {
        if (HussarUtils.isEmpty((Object)ids) || HussarUtils.isEmpty((Object)response)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        ServletOutputStream os = response.getOutputStream();
        ZipOutputStream zos = new ZipOutputStream((OutputStream)os);
        BufferedInputStream bis = null;
        ArrayList fileIdList = new ArrayList();
        Arrays.stream(ids.split(",")).forEach(s -> {
            if (HussarUtils.isNotEmpty((Object)s) && HussarUtils.isNotEmpty((Object)s.trim())) {
                fileIdList.add(Long.parseLong(s));
            }
        });
        List attachList = this.listByIds(fileIdList);
        try {
            String sourceFilePath = "\u6279\u91cf\u4e0b\u8f7d.zip";
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(sourceFilePath, "UTF-8"));
            int count = 0;
            for (AttachmentManagerModel attach : attachList) {
                ++count;
                Long id = attach.getId();
                String fileName = attach.getAttachmentName();
                String suffix = this.getSuffix(fileName);
                String path = attach.getAttachmentDir() + id + suffix;
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(new File(path)));
                byte[] buf = new byte[this.ossProperties.getDownloadBuffSize()];
                int len = 0;
                ZipEntry zipEntry = new ZipEntry(count + "-" + fileName);
                zos.putNextEntry(zipEntry);
                bis = new BufferedInputStream(inputStream, 10240);
                while ((len = bis.read(buf)) > 0) {
                    zos.write(buf, 0, len);
                    zos.flush();
                }
            }
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
        }
        finally {
            zos.close();
            if (null != bis) {
                bis.close();
            }
        }
    }

    public ApiResponse<Object> deleteFile(Long fileId) {
        if (HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel attachmentManagerModel = (AttachmentManagerModel)this.getById(fileId);
        if (HussarUtils.isNotEmpty((Object)attachmentManagerModel)) {
            String fileName = attachmentManagerModel.getAttachmentName();
            Long id = attachmentManagerModel.getId();
            String fileSavePath = this.findDirById(id);
            String suffix = this.getSuffix(fileName);
            File file = new File(fileSavePath + id + suffix);
            FileUtil.deleteQuietly((File)file);
            this.removeById(id);
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    public void showImage(HttpServletResponse response, Long id) {
        if (HussarUtils.isEmpty((Object)response) || HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        response.setContentType("text/html; charset=UTF-8");
        response.setContentType("image/jpeg");
        AttachmentManagerModel image = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)image)) {
            return;
        }
        String fileName = image.getAttachmentName();
        String fileSavePath = image.getAttachmentDir();
        String suffix = this.getSuffix(fileName);
        String absolutePath = fileSavePath + id + suffix;
        File file = new File(absolutePath);
        try (FileInputStream fis = new FileInputStream(absolutePath);
             ServletOutputStream os = response.getOutputStream();){
            response.setContentLengthLong(file.length());
            byte[] byt = new byte[this.ossProperties.getDownloadBuffSize()];
            int len = 0;
            while ((len = fis.read(byt)) > 0) {
                os.write(byt, 0, len);
                os.flush();
            }
        }
        catch (IOException e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
        }
    }

    public Page<AttachmentManagerModel> getAttachmentList(Page<AttachmentManagerModel> page, AttachInfoDto info) {
        if (HussarUtils.isEmpty(page)) {
            throw new HussarException(OssExceptionEnum.PAGEINFO_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.PAGEINFO_NOT_EMPTY.getMessage());
        }
        String attachmentName = info.getAttachmentName();
        LocalDateTime startDate = info.getStartDate();
        LocalDateTime endDate = info.getEndDate();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)attachmentName)) {
            queryWrapper.like(AttachmentManagerModel::getAttachmentName, (Object)attachmentName);
        }
        if (HussarUtils.isNotEmpty((Object)startDate)) {
            queryWrapper.ge(AttachmentManagerModel::getUploadDate, (Object)startDate);
        }
        if (HussarUtils.isNotEmpty((Object)endDate)) {
            queryWrapper.le(AttachmentManagerModel::getUploadDate, (Object)endDate);
        }
        return (Page)this.page((IPage)page, (Wrapper)queryWrapper);
    }

    public ApiResponse<Boolean> isExist(Long id) {
        String absolutePath = this.getAbsolutePath(id);
        File file = new File(absolutePath);
        if (!file.exists()) {
            return ApiResponse.success((Object)Boolean.FALSE);
        }
        return ApiResponse.success((Object)Boolean.TRUE);
    }

    public ApiResponse<Long> backgroundUpload(MultipartFile file) {
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        String fileName = file.getOriginalFilename();
        String suffix = this.getSuffix(fileName);
        String fileSavePath = this.ossFileProperties.getFileUploadPath();
        FileInfoDto fileInfoDto = new FileInfoDto();
        fileInfoDto.setFileName(fileName);
        fileInfoDto.setFileSavePath(fileSavePath);
        fileInfoDto.setSuffix(suffix);
        fileInfoDto.setFileSize(Long.valueOf(file.getSize()));
        AttachmentManagerModel attachmentManagerModel = this.saveFileManager(null, fileInfoDto);
        Long id = attachmentManagerModel.getId();
        String path = fileSavePath + attachmentManagerModel.getId() + suffix;
        File upload = new File(path);
        try {
            file.transferTo(upload);
        }
        catch (IOException e) {
            throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
        }
        return ApiResponse.success((Object)id);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<byte[]> backgroundDownload(Long id) {
        String absolutePath = this.getAbsolutePath(id);
        try (FileInputStream fis = new FileInputStream(absolutePath);){
            ApiResponse apiResponse = ApiResponse.success((Object)IoUtil.readToByteArray((InputStream)fis));
            return apiResponse;
        }
        catch (IOException e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
        }
    }

    public RangeDownloadVO rangeDownload(AttachmentManagerModel attachmentModel, Long start, Long end) {
        String fileName = attachmentModel.getAttachmentName();
        String suffix = this.getSuffix(fileName);
        String path = attachmentModel.getAttachmentDir() + attachmentModel.getId() + suffix;
        try {
            RandomAccessFile raf = new RandomAccessFile(path, "rw");
            Long fileSize = raf.length();
            raf.seek(start);
            byte[] bytes = new byte[(int)(end - start + 1L)];
            raf.read(bytes);
            return new RangeDownloadVO(fileSize, bytes);
        }
        catch (Exception e) {
            logger.error("\u8303\u56f4\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new HussarException("\u8303\u56f4\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38");
        }
    }

    private AttachmentManagerModel saveFileManager(Long businessId, FileInfoDto fileInfoDto) {
        AttachmentManagerModel attachment = new AttachmentManagerModel();
        attachment.setBusinessId(businessId);
        attachment.setAttachmentName(fileInfoDto.getFileName());
        attachment.setAttachmentType(fileInfoDto.getSuffix().replace(".", ""));
        attachment.setAttachmentSize(fileInfoDto.getFileSize());
        UserDetails user = this.getLoginUserService.getCurrentUserDetail();
        if (user != null) {
            attachment.setUploadPer(user.getUserId());
        }
        attachment.setAttachmentDir(fileInfoDto.getFileSavePath());
        attachment.setUploadDate(LocalDateTime.now());
        this.save((BaseEntity)attachment);
        return attachment;
    }

    private AttachmentManagerModelVo getAttachmentVoById(Long id) {
        AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)attachmentModel)) {
            return null;
        }
        String fileName = attachmentModel.getAttachmentName();
        String suffix = this.getSuffix(fileName);
        String path = attachmentModel.getAttachmentDir() + id + suffix;
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        BeanUtil.copy((Object)attachmentModel, (Object)attachmentManagerModelVo);
        attachmentManagerModelVo.setFileName(fileName);
        attachmentManagerModelVo.setPath(path);
        if (HussarUtils.isNotEmpty((Object)attachmentModel.getAttachmentSize())) {
            attachmentManagerModelVo.setBytes(String.valueOf(attachmentModel.getAttachmentSize()));
        } else {
            File file = new File(path);
            attachmentManagerModelVo.setBytes(String.valueOf(file.length()));
        }
        return attachmentManagerModelVo;
    }

    private AttachmentManagerModelVo packageAttachmentVo(MultipartFile multipartFile, Long businessId) throws IOException {
        String fileName = multipartFile.getOriginalFilename();
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        String suffix = this.getSuffix(fileName);
        String fileSavePath = this.ossFileProperties.getFileUploadPath();
        FileInfoDto fileInfoDto = new FileInfoDto();
        fileInfoDto.setFileName(fileName);
        fileInfoDto.setFileSavePath(fileSavePath);
        fileInfoDto.setSuffix(suffix);
        fileInfoDto.setFileSize(Long.valueOf(multipartFile.getSize()));
        AttachmentManagerModel attachmentManagerModel = this.saveFileManager(businessId, fileInfoDto);
        String path = fileSavePath + attachmentManagerModel.getId() + suffix;
        File file = new File(path);
        multipartFile.transferTo(file);
        BeanUtil.copy((Object)attachmentManagerModel, (Object)attachmentManagerModelVo);
        attachmentManagerModelVo.setFileName(fileName);
        attachmentManagerModelVo.setPath(path);
        attachmentManagerModelVo.setBytes(String.valueOf(file.length()));
        return attachmentManagerModelVo;
    }

    private String getSuffix(String fileName) {
        String suffix = "";
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            suffix = fileName.substring(index);
        }
        return suffix;
    }

    private String getAbsolutePath(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel file = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_FOUND.getExceptionCode(), OssExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        String fileName = file.getAttachmentName();
        String fileSavePath = file.getAttachmentDir();
        String suffix = this.getSuffix(fileName);
        return fileSavePath + id + suffix;
    }
}

