/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.oss.plugin.cloud.support.impl;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IoUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.core.support.enums.OssExceptionEnum;
import com.jxdinfo.hussar.support.oss.core.support.vo.RangeDownloadVO;
import com.jxdinfo.hussar.support.oss.plugin.cloud.properties.OssCloudProperties;
import com.jxdinfo.hussar.support.oss.plugin.cloud.support.CloudService;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StreamUtils;
import org.springframework.web.multipart.MultipartFile;

public class AmazonS3CloudServiceImpl
implements CloudService {
    private static final Logger LOGGER = LogManager.getLogger(AmazonS3CloudServiceImpl.class);
    private final AmazonS3 s3;

    public AmazonS3CloudServiceImpl(OssCloudProperties ossCloudProperties) {
        try {
            this.s3 = this.initClient(ossCloudProperties.getEndpoint(), ossCloudProperties.getAccessKey(), ossCloudProperties.getSecretKey());
        }
        catch (Exception e) {
            LOGGER.error("errorMsg:{}", (Object)e.getMessage());
            throw new HussarException(OssExceptionEnum.CLOUD_CLIENT_INIT_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_CLIENT_INIT_EXCEPTION.getMessage());
        }
    }

    public AmazonS3 initClient(String endpoint, String accessKey, String secretKey) throws Exception {
        BasicAWSCredentials awsCreds = new BasicAWSCredentials(accessKey, secretKey);
        Regions regions = Regions.fromName((String)endpoint);
        if (HussarUtils.isEmpty((Object)regions)) {
            Region currentRegion = Regions.getCurrentRegion();
            regions = HussarUtils.isNotEmpty((Object)currentRegion) ? Regions.fromName((String)currentRegion.getName()) : Regions.CN_NORTH_1;
        }
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(regions)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCreds))).build();
    }

    @Override
    public boolean doesBucketExist(String bucketName) throws Exception {
        return this.s3.doesBucketExistV2(bucketName);
    }

    @Override
    public void createBucket(String bucketName) throws Exception {
        this.s3.createBucket(bucketName);
    }

    @Override
    public void upload(String bucketName, String path, MultipartFile file) throws Exception {
        this.s3.putObject(bucketName, path, file.getInputStream(), null);
    }

    @Override
    public void down(String bucketName, String path, OutputStream outputStream) {
        try (S3Object object = this.s3.getObject(bucketName, path);){
            if (object.getObjectContent() == null) {
                throw new HussarException("inputStream should not be null");
            }
            StreamUtils.copy((InputStream)object.getObjectContent(), (OutputStream)outputStream);
        }
        catch (Exception e) {
            LOGGER.error("errorMsg:{}", (Object)e.getMessage());
            throw new HussarException(OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] down(String bucketName, String path) throws Exception {
        try (S3Object object = this.s3.getObject(bucketName, path);){
            if (object.getObjectContent() == null) {
                throw new HussarException("inputStream should not be null");
            }
            byte[] byArray = IoUtil.readToByteArray((InputStream)object.getObjectContent());
            return byArray;
        }
        catch (Exception e) {
            LOGGER.error("errorMsg:{}", (Object)e.getMessage());
            throw new HussarException(OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getMessage());
        }
    }

    @Override
    public RangeDownloadVO rangeDown(String bucketName, String path, Long start, Long end) throws Exception {
        try {
            GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, path).withRange(start.longValue(), end.longValue());
            S3Object object = this.s3.getObject(getObjectRequest);
            if (object.getObjectContent() == null) {
                throw new HussarException("inputStream should not be null");
            }
            return new RangeDownloadVO(Long.valueOf(object.getObjectMetadata().getInstanceLength()), IoUtil.readToByteArray((InputStream)object.getObjectContent()));
        }
        catch (Exception e) {
            LOGGER.error("\u8303\u56f4\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new HussarException(OssExceptionEnum.CLOUD_RANGE_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_RANGE_DOWN_EXCEPTION.getMessage());
        }
    }

    @Override
    public boolean delete(String bucketName, String path) throws Exception {
        try {
            this.s3.deleteObject(bucketName, path);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error("errorMsg:{}", (Object)e.getMessage());
            throw new HussarException(OssExceptionEnum.CLOUD_DELETE_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DELETE_EXCEPTION.getMessage());
        }
    }

    @Override
    public boolean doesFileExist(String bucketName, String path) throws Exception {
        return this.s3.doesObjectExist(bucketName, path);
    }

    @Override
    public Long getContentLength(String bucketName, String path) throws Exception {
        ObjectMetadata metadata = this.s3.getObjectMetadata(bucketName, path);
        return metadata.getContentLength();
    }
}

