/*
 * Decompiled with CFR 0.152.
 */
package comjxdinfo.hussar.support.oss.plugin.cloud.support.impl;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.jxdinfo.hussar.platform.core.utils.IoUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.core.support.enums.OssExceptionEnum;
import com.jxdinfo.hussar.support.oss.core.support.vo.RangeDownloadVO;
import comjxdinfo.hussar.support.oss.plugin.cloud.properties.OssCloudProperties;
import comjxdinfo.hussar.support.oss.plugin.cloud.support.CloudService;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.multipart.MultipartFile;

public class OssCloudServiceImpl
implements CloudService {
    private static final Logger logger = LogManager.getLogger(OssCloudServiceImpl.class);
    private final OssCloudProperties ossCloudProperties;
    private final OSS oss;

    public OssCloudServiceImpl(OssCloudProperties ossCloudProperties) {
        this.ossCloudProperties = ossCloudProperties;
        try {
            this.oss = this.initClient(ossCloudProperties.getEndpoint(), ossCloudProperties.getAccessKey(), ossCloudProperties.getSecretKey());
        }
        catch (Exception e) {
            throw new HussarException(OssExceptionEnum.CLOUD_CLIENT_INIT_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_CLIENT_INIT_EXCEPTION.getMessage());
        }
    }

    public OSS initClient(String endpoint, String accessKey, String secretKey) throws Exception {
        return new OSSClientBuilder().build(endpoint, accessKey, secretKey);
    }

    @Override
    public boolean doesBucketExist(String bucketName) throws Exception {
        return this.oss.doesBucketExist(bucketName);
    }

    @Override
    public void createBucket(String bucketName) throws Exception {
        this.oss.createBucket(bucketName);
    }

    @Override
    public void upload(String bucketName, String path, MultipartFile file) throws Exception {
        this.oss.putObject(bucketName, path, file.getInputStream());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] down(String bucketName, String path) throws Exception {
        try (OSSObject object = this.oss.getObject(bucketName, path);){
            if (object.getObjectContent() == null) {
                throw new HussarException("inputStream should not be null");
            }
            byte[] byArray = IoUtil.readToByteArray((InputStream)object.getObjectContent());
            return byArray;
        }
        catch (Exception e) {
            logger.error("errorMsg:{}", (Object)e.getMessage());
            throw new HussarException(OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getMessage());
        }
    }

    @Override
    public RangeDownloadVO rangeDown(String bucketName, String path, Long start, Long end) throws Exception {
        try {
            GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, path);
            getObjectRequest.setRange(start.longValue(), end.longValue());
            OSSObject ossObject = this.oss.getObject(getObjectRequest);
            if (ossObject.getObjectContent() == null) {
                throw new HussarException("inputStream should not be null");
            }
            return new RangeDownloadVO(Long.valueOf(this.getInstanceLength(ossObject.getObjectMetadata())), IoUtil.readToByteArray((InputStream)ossObject.getObjectContent()));
        }
        catch (Exception e) {
            logger.error("\u8303\u56f4\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new HussarException(OssExceptionEnum.CLOUD_RANGE_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_RANGE_DOWN_EXCEPTION.getMessage());
        }
    }

    @Override
    public boolean delete(String bucketName, String path) throws Exception {
        this.oss.deleteObject(bucketName, path);
        return Boolean.TRUE;
    }

    @Override
    public boolean doesFileExist(String bucketName, String path) throws Exception {
        return this.oss.doesObjectExist(bucketName, path);
    }

    private long getInstanceLength(ObjectMetadata metadata) {
        int pos;
        String contentRange = (String)metadata.getRawMetadata().get("Content-Range");
        if (contentRange != null && (pos = contentRange.lastIndexOf("/")) >= 0) {
            return Long.parseLong(contentRange.substring(pos + 1));
        }
        return metadata.getContentLength();
    }
}

