/*
 * Decompiled with CFR 0.152.
 */
package comjxdinfo.hussar.support.oss.plugin.cloud.support.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IoUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.core.support.enums.OssExceptionEnum;
import com.jxdinfo.hussar.support.oss.core.support.vo.RangeDownloadVO;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.CreateBucketRequest;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import comjxdinfo.hussar.support.oss.plugin.cloud.properties.OssCloudProperties;
import comjxdinfo.hussar.support.oss.plugin.cloud.support.CloudService;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.multipart.MultipartFile;

public class ObsCloudServiceImpl
implements CloudService {
    private static final Logger logger = LogManager.getLogger(ObsCloudServiceImpl.class);
    private final OssCloudProperties ossCloudProperties;
    private final ObsClient obsClient;

    public ObsCloudServiceImpl(OssCloudProperties ossCloudProperties) {
        this.ossCloudProperties = ossCloudProperties;
        try {
            this.obsClient = this.initClient(ossCloudProperties.getEndpoint(), ossCloudProperties.getAccessKey(), ossCloudProperties.getSecretKey());
        }
        catch (Exception e) {
            logger.error("errorMsg:{}", (Object)e.getMessage());
            throw new HussarException(OssExceptionEnum.CLOUD_CLIENT_INIT_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_CLIENT_INIT_EXCEPTION.getMessage());
        }
    }

    public ObsClient initClient(String endpoint, String accessKey, String secretKey) throws Exception {
        return new ObsClient(accessKey, secretKey, endpoint);
    }

    @Override
    public boolean doesBucketExist(String bucketName) throws Exception {
        try {
            return this.obsClient.headBucket(bucketName);
        }
        catch (ObsException e) {
            logger.error("HTTP Code: " + e.getResponseCode());
            logger.error("Error Code:" + e.getErrorCode());
            logger.error("Error Message: " + e.getErrorMessage());
            logger.error("Request ID:" + e.getErrorRequestId());
            logger.error("Host ID:" + e.getErrorHostId());
            throw e;
        }
    }

    @Override
    public void createBucket(String bucketName) throws Exception {
        try {
            String endpoint = this.ossCloudProperties.getEndpoint();
            if (HussarUtils.isEmpty((Object)endpoint)) {
                throw new HussarException(OssExceptionEnum.CLOUD_CHECK_BUCKET_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_CHECK_BUCKET_EXCEPTION.getMessage());
            }
            String[] strs = endpoint.split("\\.");
            if (strs.length < 2) {
                throw new HussarException(OssExceptionEnum.CLOUD_CHECK_BUCKET_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_CHECK_BUCKET_EXCEPTION.getMessage());
            }
            String region = strs[1];
            CreateBucketRequest request = new CreateBucketRequest();
            request.setBucketName(bucketName);
            request.setLocation(region);
            this.obsClient.createBucket(request);
        }
        catch (ObsException e) {
            logger.error("HTTP Code: " + e.getResponseCode());
            logger.error("Error Code:" + e.getErrorCode());
            logger.error("Error Message: " + e.getErrorMessage());
            logger.error("Request ID:" + e.getErrorRequestId());
            logger.error("Host ID:" + e.getErrorHostId());
            throw e;
        }
    }

    @Override
    public void upload(String bucketName, String path, MultipartFile file) throws Exception {
        try {
            this.obsClient.putObject(bucketName, path, file.getInputStream());
        }
        catch (ObsException e) {
            logger.error("HTTP Code: " + e.getResponseCode());
            logger.error("Error Code:" + e.getErrorCode());
            logger.error("Error Message: " + e.getErrorMessage());
            logger.error("Request ID:" + e.getErrorRequestId());
            logger.error("Host ID:" + e.getErrorHostId());
            throw e;
        }
    }

    @Override
    public void down(String bucketName, String path, OutputStream outputStream) {
        ObsObject object = null;
        try {
            object = this.obsClient.getObject(bucketName, path);
            if (HussarUtils.isEmpty((Object)object)) {
                throw new HussarException(OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getMessage());
            }
        }
        catch (ObsException e) {
            logger.error("HTTP Code: " + e.getResponseCode());
            logger.error("Error Code:" + e.getErrorCode());
            logger.error("Error Message: " + e.getErrorMessage());
            logger.error("Request ID:" + e.getErrorRequestId());
            logger.error("Host ID:" + e.getErrorHostId());
            throw e;
        }
        try (InputStream stream = object.getObjectContent();){
            if (object.getObjectContent() == null) {
                throw new HussarException("inputStream should not be null");
            }
            IoUtil.copy((InputStream)stream, (OutputStream)outputStream);
        }
        catch (Exception e) {
            logger.error("errorMsg:{}", (Object)e.getMessage());
            throw new HussarException(OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] down(String bucketName, String path) throws Exception {
        ObsObject object = null;
        try {
            object = this.obsClient.getObject(bucketName, path);
            if (HussarUtils.isEmpty((Object)object)) {
                throw new HussarException(OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getMessage());
            }
        }
        catch (ObsException e) {
            logger.error("HTTP Code: " + e.getResponseCode());
            logger.error("Error Code:" + e.getErrorCode());
            logger.error("Error Message: " + e.getErrorMessage());
            logger.error("Request ID:" + e.getErrorRequestId());
            logger.error("Host ID:" + e.getErrorHostId());
            throw e;
        }
        try (InputStream stream = object.getObjectContent();){
            if (object.getObjectContent() == null) {
                throw new HussarException("inputStream should not be null");
            }
            byte[] byArray = IoUtil.readToByteArray((InputStream)stream);
            return byArray;
        }
        catch (Exception e) {
            logger.error("errorMsg:{}", (Object)e.getMessage());
            throw new HussarException(OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getMessage());
        }
    }

    @Override
    public RangeDownloadVO rangeDown(String bucketName, String path, Long start, Long end) throws Exception {
        try {
            GetObjectRequest request = new GetObjectRequest(bucketName, path);
            request.setRangeStart(start);
            request.setRangeEnd(end);
            ObsObject obsObject = this.obsClient.getObject(request);
            if (obsObject.getObjectContent() == null) {
                throw new HussarException("inputStream should not be null");
            }
            return new RangeDownloadVO(Long.valueOf(this.getInstanceLength(obsObject.getMetadata())), IoUtil.readToByteArray((InputStream)obsObject.getObjectContent()));
        }
        catch (Exception e) {
            logger.error("\u8303\u56f4\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new HussarException(OssExceptionEnum.CLOUD_RANGE_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_RANGE_DOWN_EXCEPTION.getMessage());
        }
    }

    @Override
    public boolean delete(String bucketName, String path) throws Exception {
        try {
            this.obsClient.deleteObject(bucketName, path);
            return true;
        }
        catch (ObsException e) {
            logger.error("HTTP Code: " + e.getResponseCode());
            logger.error("Error Code:" + e.getErrorCode());
            logger.error("Error Message: " + e.getErrorMessage());
            logger.error("Request ID:" + e.getErrorRequestId());
            logger.error("Host ID:" + e.getErrorHostId());
            throw new HussarException(OssExceptionEnum.CLOUD_DELETE_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DELETE_EXCEPTION.getMessage());
        }
    }

    @Override
    public boolean doesFileExist(String bucketName, String path) throws Exception {
        try {
            return this.obsClient.doesObjectExist(bucketName, path);
        }
        catch (ObsException e) {
            logger.error("HTTP Code: " + e.getResponseCode());
            logger.error("Error Code:" + e.getErrorCode());
            logger.error("Error Message: " + e.getErrorMessage());
            logger.error("Request ID:" + e.getErrorRequestId());
            logger.error("Host ID:" + e.getErrorHostId());
            throw e;
        }
    }

    @Override
    public Long getContentLength(String bucketName, String path) throws Exception {
        ObjectMetadata metadata = this.obsClient.getObjectMetadata(bucketName, path);
        return metadata.getContentLength();
    }

    private long getInstanceLength(ObjectMetadata metadata) {
        int pos;
        String contentRange = (String)metadata.getResponseHeaders().get("Content-Range");
        if (contentRange != null && (pos = contentRange.lastIndexOf("/")) >= 0) {
            return Long.parseLong(contentRange.substring(pos + 1));
        }
        return metadata.getContentLength();
    }
}

