/*
 * Decompiled with CFR 0.152.
 */
package comjxdinfo.hussar.support.oss.plugin.cloud.support.impl;

import com.jxdinfo.hussar.platform.core.utils.IoUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.core.support.enums.OssExceptionEnum;
import com.jxdinfo.hussar.support.oss.core.support.vo.RangeDownloadVO;
import com.qcloud.cos.COS;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.region.Region;
import comjxdinfo.hussar.support.oss.plugin.cloud.properties.OssCloudProperties;
import comjxdinfo.hussar.support.oss.plugin.cloud.support.CloudService;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.multipart.MultipartFile;

public class CosCloudServiceImpl
implements CloudService {
    private static final Logger logger = LogManager.getLogger(CosCloudServiceImpl.class);
    private final OssCloudProperties ossCloudProperties;
    private final COS cos;

    public CosCloudServiceImpl(OssCloudProperties ossCloudProperties) {
        this.ossCloudProperties = ossCloudProperties;
        try {
            this.cos = this.initClient(ossCloudProperties.getEndpoint(), ossCloudProperties.getAccessKey(), ossCloudProperties.getSecretKey());
        }
        catch (Exception e) {
            logger.error("errorMsg:{}", (Object)e.getMessage());
            throw new HussarException(OssExceptionEnum.CLOUD_CLIENT_INIT_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_CLIENT_INIT_EXCEPTION.getMessage());
        }
    }

    public COS initClient(String endpoint, String accessKey, String secretKey) throws Exception {
        BasicCOSCredentials cred = new BasicCOSCredentials(accessKey, secretKey);
        Region region = new Region(endpoint);
        ClientConfig clientConfig = new ClientConfig(region);
        return new COSClient((COSCredentials)cred, clientConfig);
    }

    @Override
    public boolean doesBucketExist(String bucketName) throws Exception {
        return this.cos.doesBucketExist(bucketName);
    }

    @Override
    public void createBucket(String bucketName) throws Exception {
        this.cos.createBucket(bucketName);
    }

    @Override
    public void upload(String bucketName, String path, MultipartFile file) throws Exception {
        this.cos.putObject(bucketName, path, file.getInputStream(), null);
    }

    @Override
    public void down(String bucketName, String path, OutputStream outputStream) {
        try (COSObject object = this.cos.getObject(bucketName, path);){
            if (object.getObjectContent() == null) {
                throw new HussarException("inputStream should not be null");
            }
            IoUtil.copy((InputStream)object.getObjectContent(), (OutputStream)outputStream);
        }
        catch (Exception e) {
            logger.error("errorMsg:{}", (Object)e.getMessage());
            throw new HussarException(OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] down(String bucketName, String path) throws Exception {
        try (COSObject object = this.cos.getObject(bucketName, path);){
            if (object.getObjectContent() == null) {
                throw new HussarException("inputStream should not be null");
            }
            byte[] byArray = IoUtil.readToByteArray((InputStream)object.getObjectContent());
            return byArray;
        }
        catch (Exception e) {
            logger.error("errorMsg:{}", (Object)e.getMessage());
            throw new HussarException(OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DOWN_EXCEPTION.getMessage());
        }
    }

    @Override
    public RangeDownloadVO rangeDown(String bucketName, String path, Long start, Long end) throws Exception {
        try {
            GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, path).withRange(start.longValue(), end.longValue());
            COSObject object = this.cos.getObject(getObjectRequest);
            if (object.getObjectContent() == null) {
                throw new HussarException("inputStream should not be null");
            }
            return new RangeDownloadVO(Long.valueOf(object.getObjectMetadata().getInstanceLength()), IoUtil.readToByteArray((InputStream)object.getObjectContent()));
        }
        catch (Exception e) {
            logger.error("\u8303\u56f4\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new HussarException(OssExceptionEnum.CLOUD_RANGE_DOWN_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_RANGE_DOWN_EXCEPTION.getMessage());
        }
    }

    @Override
    public boolean delete(String bucketName, String path) throws Exception {
        try {
            this.cos.deleteObject(bucketName, path);
            return true;
        }
        catch (Exception e) {
            logger.error("errorMsg:{}", (Object)e.getMessage());
            throw new HussarException(OssExceptionEnum.CLOUD_DELETE_EXCEPTION.getExceptionCode(), OssExceptionEnum.CLOUD_DELETE_EXCEPTION.getMessage());
        }
    }

    @Override
    public boolean doesFileExist(String bucketName, String path) throws Exception {
        return this.cos.doesObjectExist(bucketName, path);
    }

    @Override
    public Long getContentLength(String bucketName, String path) throws Exception {
        ObjectMetadata metadata = this.cos.getObjectMetadata(bucketName, path);
        return metadata.getContentLength();
    }
}

