/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.nacos.datasource.plugin.common.manager;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.jxdinfo.hussar.support.nacos.datasource.plugin.common.dialect.DatabaseDialect;
import com.jxdinfo.hussar.support.nacos.datasource.plugin.common.dialect.DefaultDatabaseDialect;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseDialectManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseDialectManager.class);
    private static final DatabaseDialectManager INSTANCE = new DatabaseDialectManager();
    private static final Map<String, DatabaseDialect> SUPPORT_DIALECT_MAP = new ConcurrentHashMap<String, DatabaseDialect>();

    private DatabaseDialectManager() {
    }

    public DatabaseDialect getDialect(String databaseType) {
        DatabaseDialect databaseDialect = SUPPORT_DIALECT_MAP.get(databaseType);
        if (databaseDialect == null) {
            return new DefaultDatabaseDialect();
        }
        return databaseDialect;
    }

    public static DatabaseDialectManager getInstance() {
        return INSTANCE;
    }

    static {
        Collection dialectList = NacosServiceLoader.load(DatabaseDialect.class);
        for (DatabaseDialect dialect : dialectList) {
            SUPPORT_DIALECT_MAP.put(dialect.getType(), dialect);
        }
        if (SUPPORT_DIALECT_MAP.isEmpty()) {
            LOGGER.warn("[DatasourceDialectManager] Load DatabaseDialect fail, No DatabaseDialect implements");
        }
    }
}

