/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.protocol.stream;

import com.google.code.juds.UnixDomainSocketClient;
import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.protocol.stream.CompressedInputStream;
import com.oscar.protocol.stream.HdDecryptInputStream;
import com.oscar.protocol.stream.HdEncryptOutputStream;
import com.oscar.protocol.stream.OStream;
import com.oscar.ssl.OscarSSLSocketFactory;
import com.oscar.util.OSQLException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class OSocket
implements OStream {
    private String host;
    private int port;
    private Socket connection;
    private InputStream osr_input;
    private BufferedOutputStream osr_output;
    private String rootFile;
    private String randomFile;
    private int timeOut_MilliSecond = 0;
    private BaseConnection con;
    private boolean tcpKeepAlive = false;
    private String unixDomainPath = "";
    private UnixDomainSocketClient unixConnection;
    public static final String suppoertedCiphersSuites = "TLS_AES_256_GCM_SHA384, TLS_AES_128_GCM_SHA256, TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, TLS_DHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, TLS_DHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_DHE_RSA_WITH_AES_256_CBC_SHA256, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, TLS_DHE_RSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_DHE_RSA_WITH_AES_256_CBC_SHA,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_RSA_WITH_AES_128_CBC_SHA, TLS_RSA_WITH_AES_256_GCM_SHA384,TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA";

    public OSocket(String p_host, int p_port) {
        this.host = p_host;
        this.port = p_port;
    }

    public OSocket(String p_host, int p_port, Properties _info) {
        this.host = p_host;
        this.port = p_port;
        this.tcpKeepAlive = Boolean.valueOf(_info.getProperty("TCPKEEPALIVE", "false"));
        this.unixDomainPath = _info.getProperty("UNIXDOMAINPATH", "/tmp/");
    }

    public OSocket(String p_host, int p_port, int requestTimeOut) {
        this.host = p_host;
        this.port = p_port;
        this.timeOut_MilliSecond = requestTimeOut;
    }

    public OSocket(String p_host, int p_port, int requestTimeOut, Properties _info) {
        this.host = p_host;
        this.port = p_port;
        this.timeOut_MilliSecond = requestTimeOut;
        this.tcpKeepAlive = Boolean.valueOf(_info.getProperty("TCPKEEPALIVE", "false"));
        this.unixDomainPath = _info.getProperty("UNIXDOMAINPATH", "/tmp/");
    }

    public OSocket(String p_host, int p_port, BaseConnection con) {
        this.host = p_host;
        this.port = p_port;
        this.con = con;
    }

    public OSocket(String p_host, int p_port, BaseConnection con, Properties _info) {
        this.host = p_host;
        this.port = p_port;
        this.con = con;
        this.tcpKeepAlive = Boolean.valueOf(_info.getProperty("TCPKEEPALIVE", "false"));
        this.unixDomainPath = _info.getProperty("UNIXDOMAINPATH", "/tmp/");
    }

    public OSocket(String p_host, int p_port, int requestTimeOut, BaseConnection con) {
        this.host = p_host;
        this.port = p_port;
        this.timeOut_MilliSecond = requestTimeOut;
        this.con = con;
    }

    public OSocket(String p_host, int p_port, int requestTimeOut, BaseConnection con, Properties _info) {
        this.host = p_host;
        this.port = p_port;
        this.timeOut_MilliSecond = requestTimeOut;
        this.con = con;
        this.tcpKeepAlive = Boolean.valueOf(_info.getProperty("TCPKEEPALIVE", "false"));
        this.unixDomainPath = _info.getProperty("UNIXDOMAINPATH", "/tmp/");
    }

    @Override
    public void open() throws IOException {
        if (this.host.equalsIgnoreCase("unixsocket") || this.host.equalsIgnoreCase("memory")) {
            if (System.getProperty("os.name", "window").toLowerCase().indexOf("window") != -1) {
                throw new SocketException("loadLibrary(): Unix sockets are not supported on Windows platforms");
            }
            try {
                this.unixConnection = new UnixDomainSocketClient(this.unixDomainPath.equals("") ? "/tmp/" : this.unixDomainPath + "/" + ".s.oscar." + this.port, 1);
                if (this.timeOut_MilliSecond != 0) {
                    this.unixConnection.setTimeout(this.timeOut_MilliSecond);
                }
                this.osr_input = new BufferedInputStream(this.unixConnection.getInputStream(), 8192);
                this.osr_output = new BufferedOutputStream(this.unixConnection.getOutputStream(), 8192);
            }
            catch (Exception e) {
                Driver.writeLog(e);
                throw new IOException(e.getMessage());
            }
            catch (Throwable e) {
                Driver.writeLog(e);
                throw new IOException(e.getMessage());
            }
        } else {
            this.connection = new Socket(this.host, this.port);
            this.connection.setTcpNoDelay(true);
            this.connection.setKeepAlive(this.tcpKeepAlive);
            if (this.timeOut_MilliSecond != 0) {
                this.connection.setSoTimeout(this.timeOut_MilliSecond);
            }
            this.osr_input = new BufferedInputStream(this.connection.getInputStream(), 8192);
            this.osr_output = new BufferedOutputStream(this.connection.getOutputStream(), 8192);
        }
    }

    @Override
    public void reInitStream(boolean newProtocol) throws IOException {
        if (newProtocol) {
            this.osr_input = new CompressedInputStream(this.osr_input, this.con);
        }
    }

    @Override
    public void openWithSSL(String keyfile, String certfile, String password, String rootfile, String randomfile, String database, String ciphersSuites) throws Exception {
        this.connection = this.makeSSL(rootfile, certfile, keyfile, password, ciphersSuites);
        this.osr_input = new BufferedInputStream(this.connection.getInputStream(), 8192);
        this.osr_output = new BufferedOutputStream(this.connection.getOutputStream(), 8192);
    }

    private SSLSocket makeSSL(String rootfile, String certfile, String keyfile, String password, String ciphersSuites) throws OSQLException {
        OscarSSLSocketFactory factory = new OscarSSLSocketFactory(rootfile, certfile, keyfile, password);
        try {
            SSLSocket socket = (SSLSocket)((SSLSocketFactory)factory).createSocket(this.connection, this.host, this.port, true);
            socket.setUseClientMode(true);
            String[] suppoertedCiphersSuites = ciphersSuites.split(",");
            if (suppoertedCiphersSuites != null) {
                for (int i = 0; i < suppoertedCiphersSuites.length; ++i) {
                    String suppoertedCiphersSuite = suppoertedCiphersSuites[i];
                    suppoertedCiphersSuites[i] = suppoertedCiphersSuite.trim();
                }
                socket.setEnabledCipherSuites(suppoertedCiphersSuites);
            }
            socket.startHandshake();
            return socket;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e.getMessage().contains("PKIX path validation failed")) {
                throw new OSQLException("Connect failed, Please upgrade jre, to jre1.8.0_372 and above \nSSL error: " + e.getMessage(), "08004");
            }
            throw new OSQLException(e.getMessage(), "08004");
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.osr_input;
    }

    @Override
    public BufferedOutputStream getBufferedOutputStream() {
        return this.osr_output;
    }

    @Override
    public void close() throws IOException {
        if (this.osr_output != null) {
            this.osr_output.close();
        }
        if (this.osr_input != null) {
            this.osr_input.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public static boolean isLocalClient(String host) {
        if (null == host) {
            return false;
        }
        if ("localhost".equalsIgnoreCase(host)) {
            return true;
        }
        try {
            if (InetAddress.getLocalHost().getHostName().equalsIgnoreCase(host)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (host.startsWith("127.0.0.")) {
            try {
                String endStr = host.substring("127.0.0.".length(), host.length());
                int endNum = Integer.parseInt(endStr);
                if (endNum > 0 && endNum < 256) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        try {
            InetAddress[] localIP = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            for (int i = 0; i < localIP.length; ++i) {
                if (!localIP[i].getHostAddress().equals(host)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean checkIP(String hostName, String certName) {
        if (hostName.equalsIgnoreCase(certName)) {
            return true;
        }
        boolean hostNameLocal = OSocket.isLocalClient(hostName);
        boolean certNameLocal = OSocket.isLocalClient(certName);
        if (hostNameLocal && certNameLocal) {
            return true;
        }
        if (hostNameLocal || certNameLocal) {
            return false;
        }
        try {
            if (InetAddress.getByName(hostName).getHostName().equalsIgnoreCase(certName)) {
                return true;
            }
            InetAddress[] addresses = InetAddress.getAllByName(hostName);
            for (int i = 0; i < addresses.length; ++i) {
                if (!addresses[i].getHostAddress().equalsIgnoreCase(certName)) continue;
                return true;
            }
            return false;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public void setRootFile(String root) {
        this.rootFile = root;
    }

    public void setRandomFile(String random) {
        this.randomFile = random;
    }

    public String getRootFile() {
        return this.rootFile;
    }

    public String getRandomFile() {
        return this.randomFile;
    }

    @Override
    public Socket getSocket() throws Exception {
        return new Socket(this.host, this.port);
    }

    @Override
    public Socket getCurrentSocket() {
        return this.connection;
    }

    @Override
    public void setSocketTimeOut(int timeout) throws SocketException {
        if (this.getCurrentSocket() != null) {
            this.getCurrentSocket().setSoTimeout(timeout);
        } else if (this.unixConnection != null) {
            this.unixConnection.setTimeout(timeout);
        }
    }

    @Override
    public void wrapEncryptStream() {
        this.osr_output = new HdEncryptOutputStream((OutputStream)this.osr_output, this.con);
        this.osr_input = new HdDecryptInputStream(this.osr_input, this.con);
    }
}

