/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.BaseStatement;
import com.oscar.core.Encoding;
import com.oscar.core.Field;
import com.oscar.jdbc.EscapeProcessor;
import com.oscar.jdbc.EscapeProcessorResult;
import com.oscar.jdbc.ExceptionUtil;
import com.oscar.jdbc.OscarBfile;
import com.oscar.jdbc.OscarBlob;
import com.oscar.jdbc.OscarClob;
import com.oscar.jdbc.OscarCursorResultSet;
import com.oscar.jdbc.OscarJdbc2Connection;
import com.oscar.jdbc.OscarLob;
import com.oscar.jdbc.OscarParaMetaData;
import com.oscar.jdbc.OscarPreparedStatement;
import com.oscar.jdbc.OscarPreparedStatementV2;
import com.oscar.jdbc.OscarResultSet;
import com.oscar.jdbc.OscarSQLXML;
import com.oscar.partition.PartitionInfo;
import com.oscar.protocol.ProtocolVersion;
import com.oscar.protocol.packets.BatchProcessPacket;
import com.oscar.util.BatchDataStream;
import com.oscar.util.CommonUtil;
import com.oscar.util.OSCARbyte;
import com.oscar.util.OSQLException;
import com.oscar.util.OscarJDBCUtil;
import com.oscar.util.OscarSqlProcessor;
import com.oscar.util.OtherType;
import com.oscar.util.TypeConverter;
import com.oscar.util.Word;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;

public class OscarStatement
implements BaseStatement,
Statement {
    protected BaseConnection connection;
    protected Encoding encoding;
    protected Encoding clientEncoding;
    protected SQLWarning warnings = null;
    protected int maxrows = 0;
    protected int fetchSize = 16;
    protected int timeout = 0;
    protected boolean replaceProcessingEnabled = true;
    protected String osql;
    protected BaseResultSet result = null;
    protected StringBuffer sbuf = new StringBuffer(32);
    protected String[] m_sqlFragments;
    protected String[] m_origSqlFragments;
    int fragmentsCount = 0;
    protected String[] m_executeSqlFragments;
    protected Object[] m_binds = new Object[0];
    protected Object[] m_binds_old = new Object[0];
    protected List<String> binds_name = new ArrayList<String>();
    protected OscarLob[] m_lobs = new OscarLob[0];
    protected Hashtable<Integer, Character> tableTypes = new Hashtable();
    protected int[] m_bindTypes = new int[0];
    protected int[] m_functionTypes = new int[0];
    protected Object[] m_outValues = new Object[0];
    protected String m_statementName = null;
    protected String m_cursorName = null;
    protected boolean m_statementIsCursor = false;
    protected OscarParaMetaData pMetaData;
    protected static final AtomicInteger m_preparedCount = new AtomicInteger(1);
    public static final String cursorPrefix = "C";
    protected boolean isCallable;
    protected boolean isResultNeeded;
    protected int functionReturnType;
    protected boolean returnTypeSet;
    protected Vector<Integer> outParameterType = new Vector();
    protected Vector<Integer> outParameterIndex = new Vector();
    protected int parameterNum = 0;
    protected boolean isClosed = false;
    protected int maxFieldSize = 8000;
    protected int resultSetType = 1003;
    protected int resultSetConcurrency = 1007;
    protected boolean resultSetCanUpdateable = true;
    protected int statementType = 0;
    protected int bufSize = 102400;
    public static final int STATEMENT = 0;
    public static final int PREPAREDSTATEMENT = 1;
    public static final int CALLABLESTATEMENT = 2;
    protected boolean tidUsed = false;
    protected int autoGeneratedInfo = -1;
    protected boolean selectSql = false;
    protected boolean ddlSql = false;
    protected boolean insertSql = false;
    protected int lastIndex = 0;
    protected boolean prepareAndNotRealPrepare = false;
    protected boolean isMultiSqlSentens = false;
    protected List<String> importRows = null;
    protected int transferCount = 0;
    public static final int DB_TINYINT = 0;
    public static final int DB_SMALLINT = 0;
    public static final int DB_INT = 0;
    public static final int DB_BIGINT = 0;
    public static final int DB_FLOAT = 0;
    public static final int DB_REAL = 0;
    public static final int DB_DOUBLE = 0;
    public static final int DB_NUMERIC = 0;
    public static final int DB_DECIMAL = 0;
    public static final int DB_BOOLEAN = 0;
    public static final int DB_BIT = 0;
    public static final int DB_CHAR = 0;
    public static final int DB_VARCHAR = 0;
    public static final int DB_TEXT = 0;
    public static final int DB_BINARY = 0;
    public static final int DB_VARBINARY = 0;
    public static final int DB_LONGVARBINARY = 0;
    public static final int DB_DATE = 0;
    public static final int DB_TIME = 0;
    public static final int DB_TIMESTAMP = 0;
    public static final int DB_CLOB = -1;
    public static final int DB_BLOB = -2;
    public static final int DB_BFILE = -3;
    protected List batch = null;
    protected int fetchdirection = 1000;
    protected Calendar systemCal = Calendar.getInstance();
    protected static final int NO_AUTO_GENERATED = 0;
    protected static final int AUTO_GENERATED = 1;
    protected static final int AUTO_GENERATED_COLINDEX = 2;
    protected static final int AUTO_GENERATED_COLNAME = 3;
    protected int[] columnIndex = null;
    protected String[] columnName = null;
    protected int resultSetHoldability = 2;
    protected Vector<OscarLob> tempResource = new Vector();
    protected boolean hasEscapeChar = false;
    protected boolean addBatchUseSql = false;
    protected int updateBatchCount = 0;
    protected BatchProcessPacket batchPacket = null;
    protected boolean cursorError = false;
    public short cacheState;
    private boolean poolable = true;
    protected Field[] fields = null;
    protected boolean logFlag = Driver.getLogLevel() >= 2;
    protected boolean stLogFlag = Driver.getLogLevel() >= 1;
    protected int sessionId;
    protected int pid;
    protected int batchCount = 0;
    protected boolean useAsynBatch = false;
    protected boolean isBegin = false;
    protected BatchDataStream batchDataStream;
    protected int[] hashColIds;
    protected int buckets;
    protected boolean print = false;
    protected boolean isAnonymous = false;
    protected boolean anonymousSupportPrepare = true;
    protected boolean compatibleOracle = false;
    protected boolean supportGeneratedKey = true;
    protected boolean errorMessNeedOffset;
    protected boolean isHaveFuncReturn = false;
    protected Field firstField = null;
    private Map<String, String> generatedKeyMap = new HashMap<String, String>();
    private boolean closeOnCompletion = false;
    protected Object m_returnValue = new Object();
    protected int m_returnType = 0;
    boolean isFunc = false;
    protected static final String AT_CHARACTER_POSITION = "at character";
    protected static final String AT_END_OF_INPUT_POSITION = "at end of input";
    protected boolean useSensitiveCursor = false;
    private Map<Integer, OscarCursorResultSet> cursorResultMap = new HashMap<Integer, OscarCursorResultSet>();
    protected boolean notRealPrepare = false;
    protected Calendar localCalendar;
    private static final Constructor<?> JDBC_4_PSTMT_ARG;
    private static final Constructor<?> JDBC_4_PSTMT_ARG_V2;

    public OscarStatement(BaseConnection connection) {
        this.connection = connection;
        this.encoding = connection.getEncoding();
        this.clientEncoding = connection.getClientEncoding();
        this.resultSetType = 1003;
        this.resultSetConcurrency = 1007;
        this.batchCount = connection.getBatchCount();
        this.useAsynBatch = connection.isUseAsynBatch();
        Properties pros = connection.getConnectionProperties();
        ProtocolVersion protocolVersion = connection.getProtocolVersion();
        this.supportGeneratedKey = Boolean.valueOf(pros.getProperty("SUPPORTGENERATEDKEY", protocolVersion.isKstore() || protocolVersion.isMpp5() ? "false" : "true"));
        this.anonymousSupportPrepare = Boolean.valueOf(pros.getProperty("ANONYMOUSSUPPORTPREPARE", "true"));
        String application = pros.getProperty("APPLICATION", "");
        if (application.contains("DBStudio") || application.contains("Analyze Query SQL")) {
            this.errorMessNeedOffset = true;
        }
        this.useSensitiveCursor = Boolean.valueOf(pros.getProperty("USESENSITIVECURSOR", "true"));
        this.sessionId = connection.getSessionID();
        this.pid = connection.getPlanID();
        this.notRealPrepare = connection.isNotRealPrepare();
        this.localCalendar = connection.getCalendar();
    }

    public OscarStatement(BaseConnection connection, String o_sql) throws SQLException {
        this(connection);
        this.osql = o_sql;
        this.parseSqlStmt(o_sql);
    }

    @Override
    public boolean isHaveFuncRetrun() {
        return this.isHaveFuncReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextPreparedCount() {
        int num = m_preparedCount.getAndIncrement();
        if (num < 0) {
            Class<OscarStatement> clazz = OscarStatement.class;
            synchronized (OscarStatement.class) {
                if (m_preparedCount.get() < 0) {
                    m_preparedCount.set(1);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.getNextPreparedCount();
            }
        }
        return num;
    }

    @Override
    public void setParamInfor(Object[][] infor) {
        this.pMetaData = new OscarParaMetaData(infor, this);
    }

    @Override
    public ParameterMetaData getParamInfo() {
        return this.pMetaData;
    }

    @Override
    public int[] getHashColIds() {
        return this.hashColIds;
    }

    @Override
    public void setHashColIds(int[] hashColIds) {
        this.hashColIds = hashColIds;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getMetaData();
        }
        if (this.m_statementName == null || this.insertSql) {
            return null;
        }
        String sql = "GET ROWDESCRIPTION FOR " + this.m_statementName;
        BaseResultSet brs = this.connection.execSQL(sql);
        if (brs != null && brs.reallyResultSet()) {
            return brs.getMetaData();
        }
        return null;
    }

    @Override
    public BaseConnection getDBConnection() {
        return this.connection;
    }

    @Override
    public String getCursorName() {
        return this.m_cursorName;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    protected void parseSqlStmt(String o_sql) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", parseSqlStmt(String o_sql), \n sql: " + o_sql);
        }
        String l_sql = this.checkSqlEmptyOrTrim(o_sql);
        l_sql = this.replaceProcessing(l_sql);
        l_sql = this.subParseSqlStmt(l_sql);
        OscarSqlProcessor.ParseResult result = OscarSqlProcessor.parsingWithCheck(l_sql);
        this.isAnonymous = result.isAnonymous();
        this.selectSql = result.isSelectSql();
        this.insertSql = result.isInsertSql();
        this.ddlSql = result.isDdlSql();
        this.isMultiSqlSentens = result.getSqlCounts() > 1 && !this.isAnonymous;
        l_sql = result.getTransSql();
        if (this.isAnonymous && !l_sql.toUpperCase().startsWith("DO")) {
            this.osql = l_sql = "DO " + l_sql;
        }
        int lastParmEnd = 0;
        if (this.isNotSupportPrePare()) {
            int i;
            Vector<String> v = new Vector<String>();
            boolean inQuotes = false;
            boolean isParam = false;
            String param = "";
            for (i = 0; i < l_sql.length(); ++i) {
                char c = l_sql.charAt(i);
                if (c == '\'') {
                    boolean bl = inQuotes = !inQuotes;
                    if (isParam) {
                        isParam = false;
                        this.binds_name.add(param);
                        param = "";
                    }
                }
                if ((c == ' ' || c == ';' || c == '\'' || c == '(') && isParam) {
                    isParam = false;
                    this.binds_name.add(param);
                    param = "";
                }
                if (c == '?' && !inQuotes) {
                    this.compatibleOracle = false;
                    if (this.isHaveFuncReturn || this.isNotRealPrepare() || this.isAnonymous) {
                        v.addElement(l_sql.substring(lastParmEnd, i));
                        lastParmEnd = i + 1;
                    }
                    ++this.fragmentsCount;
                } else if (c == '&') {
                    this.compatibleOracle = true;
                    if (this.isHaveFuncReturn || this.isNotRealPrepare() || this.isAnonymous) {
                        v.addElement(l_sql.substring(lastParmEnd, i));
                        lastParmEnd = i + 1;
                    }
                    ++this.fragmentsCount;
                    isParam = true;
                    continue;
                }
                if (!isParam) continue;
                param = param + (char)c;
            }
            ++this.fragmentsCount;
            if (this.isHaveFuncReturn || this.isNotRealPrepare() || this.isAnonymous) {
                v.addElement(l_sql.substring(lastParmEnd, l_sql.length()));
                this.m_executeSqlFragments = new String[v.size()];
                for (i = 0; i < this.m_executeSqlFragments.length; ++i) {
                    this.m_executeSqlFragments[i] = (String)v.elementAt(i);
                }
            }
            this.m_sqlFragments = new String[1];
            this.m_sqlFragments[0] = l_sql;
            if (this.isCallable && this.isResultNeeded) {
                this.m_binds = new Object[this.fragmentsCount];
                this.m_binds_old = new Object[this.fragmentsCount];
                this.m_lobs = new OscarLob[this.fragmentsCount];
                this.m_bindTypes = new int[this.fragmentsCount];
                this.m_outValues = new Object[this.fragmentsCount];
                this.fields = new Field[this.fragmentsCount];
            } else {
                this.m_binds = new Object[this.fragmentsCount - 1];
                this.m_binds_old = new Object[this.fragmentsCount - 1];
                this.m_bindTypes = new int[this.fragmentsCount - 1];
                this.m_lobs = new OscarLob[this.fragmentsCount - 1];
                this.m_outValues = new Object[this.fragmentsCount - 1];
                this.fields = new Field[this.fragmentsCount - 1];
            }
        } else {
            int size = result.getQuestionMarks().size();
            this.fragmentsCount = size + 1;
            this.m_sqlFragments = new String[1];
            this.m_sqlFragments[0] = l_sql;
            if (this.isCallable && this.isResultNeeded) {
                this.m_binds = new Object[this.fragmentsCount];
                this.m_binds_old = new Object[this.fragmentsCount];
                this.m_lobs = new OscarLob[this.fragmentsCount];
                this.m_bindTypes = new int[this.fragmentsCount];
                this.m_outValues = new Object[this.fragmentsCount];
                this.fields = new Field[this.fragmentsCount];
            } else {
                this.m_binds = new Object[this.fragmentsCount - 1];
                this.m_binds_old = new Object[this.fragmentsCount - 1];
                this.m_bindTypes = new int[this.fragmentsCount - 1];
                this.m_lobs = new OscarLob[this.fragmentsCount - 1];
                this.m_outValues = new Object[this.fragmentsCount - 1];
                this.fields = new Field[this.fragmentsCount - 1];
            }
            if (!this.notRealPrepare && (this.isMultiSqlSentens || this.m_binds != null && this.m_binds.length > Short.MAX_VALUE)) {
                this.notRealPrepare = true;
            }
            if (this.isHaveFuncReturn || this.isNotRealPrepare()) {
                this.m_executeSqlFragments = new String[this.fragmentsCount];
                if (size > 0) {
                    String sql;
                    for (int i = 0; i < size; ++i) {
                        String sql2;
                        Word word = result.getQuestionMarks().get(i);
                        this.m_executeSqlFragments[i] = sql2 = l_sql.substring(lastParmEnd, word.getTokenBegin());
                        lastParmEnd = word.getTokenEnd();
                    }
                    this.m_executeSqlFragments[this.fragmentsCount - 1] = sql = l_sql.substring(lastParmEnd);
                } else {
                    this.m_executeSqlFragments[0] = l_sql;
                }
            }
        }
    }

    protected String subParseSqlStmt(String o_sql) throws SQLException {
        return o_sql;
    }

    @Override
    public ResultSet executeQuery(String o_sql) throws SQLException {
        this.checkClosed();
        if (this.stLogFlag || this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", executeQuery(String o_sql), \n sql: " + o_sql);
        }
        String l_sql = this.checkSqlEmptyOrTrim(o_sql);
        this.osql = l_sql = this.replaceProcessing(l_sql);
        OscarSqlProcessor.ParseResult parseResult = OscarSqlProcessor.parsingWithCheck(l_sql);
        this.isAnonymous = parseResult.isAnonymous();
        if (this.isAnonymous && !l_sql.toUpperCase().startsWith("DO")) {
            l_sql = "DO " + l_sql;
        }
        this.isMultiSqlSentens = parseResult.getSqlCounts() > 1 && !this.isAnonymous;
        this.selectSql = parseResult.isSelectSql();
        this.insertSql = parseResult.isInsertSql();
        this.m_sqlFragments = new String[]{l_sql};
        this.m_binds = new Object[0];
        this.m_lobs = new OscarLob[0];
        this.m_bindTypes = new int[0];
        if (this.m_statementName != null) {
            this.releasePrepareStatement();
        }
        if (!(this.selectSql || parseResult.isFenormalSelect() || this.connection.isCompatibleOracle())) {
            throw new OSQLException("OSCAR-00402", "88888", 402);
        }
        return this.executeQuery();
    }

    public ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        if (this.m_sqlFragments == null || this.m_sqlFragments.length <= 1 || this.statementType == 1) {
            // empty if block
        }
        this.executeStatement();
        this.cleanEnvTemp();
        while (this.result != null && !this.result.reallyResultSet()) {
            this.result = (BaseResultSet)this.result.getNext();
        }
        return this.result;
    }

    @Override
    public int executeUpdate(String o_sql) throws SQLException {
        return CommonUtil.convertToInt(this.executeLargeUpdate(o_sql));
    }

    @Override
    public long executeLargeUpdate(String o_sql) throws SQLException {
        this.checkClosed();
        if (this.stLogFlag || this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", executeUpdate(String o_sql), \n sql: " + o_sql);
        }
        String l_sql = this.checkSqlEmptyOrTrim(o_sql);
        this.osql = l_sql = this.replaceProcessing(l_sql);
        OscarSqlProcessor.ParseResult parseResult = OscarSqlProcessor.parsingWithCheck(l_sql);
        this.isAnonymous = parseResult.isAnonymous();
        if (this.isAnonymous && !l_sql.toUpperCase().startsWith("DO")) {
            l_sql = "DO " + l_sql;
        }
        this.selectSql = parseResult.isSelectSql();
        this.insertSql = parseResult.isInsertSql();
        if (!this.connection.isCompatibleOracle() && this.selectSql) {
            throw new OSQLException("OSCAR-00403", "88888", 403);
        }
        this.isMultiSqlSentens = parseResult.getSqlCounts() > 1 && !this.isAnonymous;
        this.m_sqlFragments = new String[]{l_sql};
        this.m_binds = new Object[0];
        this.m_lobs = new OscarLob[0];
        this.m_bindTypes = new int[0];
        if (this.m_statementName != null) {
            this.releasePrepareStatement();
        }
        return this.executeLargeUpdate();
    }

    public int executeUpdate() throws SQLException {
        return CommonUtil.convertToInt(this.executeLargeUpdate());
    }

    public long executeLargeUpdate() throws SQLException {
        this.checkClosed();
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", executeUpdate(), \n");
        }
        if (!this.connection.isCompatibleOracle() && this.selectSql) {
            throw new OSQLException("OSCAR-00403", "88888", 403);
        }
        if (this.isNotSupportPrePare()) {
            this.execute();
        } else {
            this.executeStatement();
        }
        this.cleanEnvTemp();
        return this.getLargeUpdateCount();
    }

    @Override
    public boolean execute(String o_sql) throws SQLException {
        return this.doExecute(o_sql);
    }

    private boolean doExecute(String o_sql) throws SQLException {
        this.checkClosed();
        if (this.stLogFlag || this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", execute(String o_sql), \n sql: " + o_sql);
        }
        String l_sql = this.checkSqlEmptyOrTrim(o_sql);
        this.osql = l_sql = this.replaceProcessing(l_sql);
        OscarSqlProcessor.ParseResult result = OscarSqlProcessor.parsingWithCheck(l_sql);
        this.isAnonymous = result.isAnonymous();
        if (this.isAnonymous && !l_sql.toUpperCase().startsWith("DO")) {
            l_sql = "DO " + l_sql;
        }
        this.selectSql = result.isSelectSql();
        this.insertSql = result.isInsertSql();
        this.isMultiSqlSentens = result.getSqlCounts() > 1 && !this.isAnonymous;
        this.m_sqlFragments = new String[]{l_sql};
        this.m_binds = new Object[0];
        this.m_lobs = new OscarLob[0];
        this.m_bindTypes = new int[0];
        if (this.m_statementName != null) {
            this.releasePrepareStatement();
        }
        return this.executeStatement();
    }

    public boolean execute() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", execute() ");
        }
        if (this.isNotSupportPrePare()) {
            if (this.compatibleOracle) {
                for (int i = 0; i < this.m_binds.length; ++i) {
                    this.m_sqlFragments[0] = this.m_sqlFragments[0].replace("&" + this.binds_name.get(i), String.valueOf(this.m_binds[i]));
                }
            } else {
                StringBuilder temp = new StringBuilder(this.m_executeSqlFragments[0]);
                for (int i = 0; i < this.m_binds.length; ++i) {
                    if (this.m_binds[i] instanceof String) {
                        this.m_binds[i] = ((String)this.m_binds[i]).replaceAll("'", "''");
                    }
                    if (this.m_binds[i] instanceof String || this.m_binds[i] instanceof Time || this.m_binds[i] instanceof Timestamp || this.m_binds[i] instanceof java.sql.Date || this.m_binds[i] instanceof Date) {
                        temp.append("'").append(this.m_binds[i]).append("'").append(this.m_executeSqlFragments[i + 1]);
                        continue;
                    }
                    temp.append(String.valueOf(this.m_binds[i])).append(this.m_executeSqlFragments[i + 1]);
                }
                this.m_sqlFragments[0] = temp.toString();
            }
            return this.doExecute(this.m_sqlFragments[0]);
        }
        boolean b = true;
        this.checkClosed();
        b = this.executeStatement();
        this.cleanEnvTemp();
        return b;
    }

    protected synchronized void cleanEnvTemp() throws SQLException {
        int i = 0;
        OscarLob lob = null;
        for (i = 0; i < this.tempResource.size(); ++i) {
            if (!(this.tempResource.get(i) instanceof OscarLob)) continue;
            lob = this.tempResource.get(i);
            if (lob.isTempLob()) {
                lob.freeTemporary();
                continue;
            }
            if (!lob.isTableIdLob()) continue;
            lob.freePersist();
        }
        this.tempResource.clear();
    }

    /*
     * Unable to fully structure code
     */
    protected boolean executeStatement() throws SQLException {
        this.clearWarnings();
        this.cursorError = false;
        this.m_statementIsCursor = false;
        this.m_cursorName = null;
        if (this.result != null) {
            this.releaseResources();
            this.result.close();
            this.result = null;
        }
        if (this.statementType == 0) {
            cursorIsOpen = false;
            addSqlLength = 0;
            try {
                sql = this.m_sqlFragments[0].trim();
                if (this.selectSql && (this.fetchSize == 0 || this.isMultiSqlSentens || this.checkDBLinkSql(sql))) {
                    if (this.resultSetConcurrency == 1008) {
                        this.tidUsed = true;
                    }
                    this.m_statementIsCursor = false;
                } else if (this.fetchSize > 0 && this.selectSql) {
                    cursorBasedSql = new String[this.m_sqlFragments.length];
                    statementName = "C" + this.getNextPreparedCount();
                    cursDecl = this.resultSetType == 1003 ? (this.useSensitiveCursor ? "DECLARE " + statementName + " CURSOR FOR " : "DECLARE " + statementName + " INSENSITIVE CURSOR FOR ") : (this.resultSetType == 1004 ? "DECLARE " + statementName + " INSENSITIVE SCROLL CURSOR FOR " : "DECLARE " + statementName + " SCROLL CURSOR FOR ");
                    cursOpen = "OPEN " + statementName;
                    cursFetch = " FETCH FORWARD " + this.fetchSize + " FROM " + statementName + ";";
                    if (cursorBasedSql.length > 1) {
                        throw new IllegalStateException("cursor fetches not supported with prepared statements.");
                    }
                    addSqlLength = cursDecl.length();
                    cursorBasedSql[0] = cursDecl + this.m_sqlFragments[0];
                    if (this.resultSetConcurrency == 1008) {
                        this.tidUsed = true;
                    }
                    temp = (BaseStatement)this.connection.createStatement();
                    temp.setUseTid(this.tidUsed);
                    this.connection.execSQL(cursorBasedSql[0], temp);
                    addSqlLength = 0;
                    this.m_cursorName = statementName;
                    this.m_statementIsCursor = true;
                    this.m_sqlFragments = cursorBasedSql;
                    this.connection.execSQL(cursOpen, temp);
                    cursorIsOpen = true;
                    tempWarning = ((Statement)temp).getWarnings();
                    if (tempWarning != null) {
                        this.addWarning(tempWarning);
                    }
                    cursorBasedSql[0] = cursFetch;
                }
                if (this.isAnonymous) {
                    addSqlLength = 3;
                }
                this.result = this.getDBConnection().getQueryExecutor().execute(this.m_sqlFragments, this.m_binds, this);
                addSqlLength = 0;
                if (this.result == null) ** GOTO lbl121
                this.result.setResultType(true);
            }
            catch (SQLException e) {
                if (this.errorMessNeedOffset && e instanceof OSQLException && (msg = e.getMessage()) != null && (msg.contains("at character") || msg.contains("at end of input"))) {
                    ((OSQLException)e).setJdbcOffset(addSqlLength);
                }
                this.cursorError = true;
                this.checkConnectionClosed(e);
                throw e;
            }
            finally {
                if ((this.result == null || this.cursorError) && this.m_statementIsCursor) {
                    this.cursorError = false;
                    try {
                        cursClose = cursorIsOpen == false ? "DEALLOCATE " + this.m_cursorName : "CLOSE " + this.m_cursorName + ";DEALLOCATE " + this.m_cursorName;
                        temp = (BaseStatement)this.connection.createStatement();
                        temp.setUseTid(this.tidUsed);
                        this.connection.execSQL(cursClose, temp);
                        this.connection.removeCursor(this.m_cursorName);
                    }
                    catch (Exception var12_25) {}
                }
            }
        } else {
            this.m_statementIsCursor = false;
            if (this.isCallable || this.isAnonymous && this.outParameterIndex.size() > 0) {
                temp_binds = new String[this.m_binds.length];
                for (i = 0; i < this.m_binds.length; ++i) {
                    if (this.m_binds[i] != null) {
                        if (this.outParameterIndex.indexOf(i + 1) != -1) {
                            temp_binds[i] = this.m_binds[i].toString();
                            continue;
                        }
                        temp_binds[i] = this.m_binds[i].toString();
                        continue;
                    }
                    if (this.outParameterIndex.indexOf(i + 1) != -1) {
                        temp_binds[i] = "NULL";
                        continue;
                    }
                    throw new OSQLException("OSCAR-00404", "88888", 404, i + 1);
                }
                try {
                    this.result = this.connection.getQueryExecutor().execute(this.m_sqlFragments, temp_binds, this);
                }
                catch (SQLException e) {
                    this.checkConnectionClosed(e);
                    throw e;
                }
            }
            for (i = 0; i < this.m_binds.length; ++i) {
                if (this.m_binds[i] != null) continue;
                throw new OSQLException("OSCAR-00405", "88888", 405, i + 1);
            }
            try {
                if (!this.isNotRealPrepare() && this.fetchSize > 0 && this.selectSql) {
                    this.decalreCursor();
                }
                if (this.m_sqlFragments == null && this.fetchSize == 0) {
                    this.setSqlFragments();
                }
                this.result = this.connection.getQueryExecutor().execute(this.m_sqlFragments, this.m_binds, this);
                if (this.result != null) {
                    this.result.setResultType(true);
                }
            }
            catch (SQLException e) {
                this.cursorError = true;
                this.checkConnectionClosed(e);
                throw e;
            }
            finally {
                if ((this.result == null || this.cursorError) && this.m_statementIsCursor) {
                    this.cursorError = false;
                    try {
                        cursClose = "CLOSE " + this.m_cursorName + ";DEALLOCATE " + this.m_cursorName;
                        temp = (BaseStatement)this.connection.createStatement();
                        temp.setUseTid(this.tidUsed);
                        this.connection.execSQL(cursClose, temp);
                        this.connection.removeCursor(this.m_cursorName);
                    }
                    catch (SQLException var15_29) {}
                }
            }
        }
        if (this.isCallable || this.isAnonymous && this.outParameterIndex.size() > 0) {
            if (!(this.result.getTupleCount() != 0 && this.result.reallyResultSet() || this.outParameterIndex.isEmpty())) {
                throw new OSQLException("OSCAR-00406", "88888", 406);
            }
            this.getProcedureResult();
            return this.result != null && this.result.getNext() != null;
        }
        if (this.result != null && (command = this.result.getStatusString()) != null && (command.startsWith("23") || command.startsWith("45") || command.startsWith("5D") || command.startsWith("10") || command.startsWith("48"))) {
            return this.result.reallyResultSet();
        }
        return false;
    }

    private boolean checkDBLinkSql(String sql) {
        if (this.connection.checkDBLinkSql()) {
            return sql != null && sql.contains("@");
        }
        return false;
    }

    protected void setSqlFragments() {
        if (this.m_origSqlFragments == null) {
            return;
        }
        if (!(this.isNotSupportPrePare() || this.isNotRealPrepare() || this.fetchSize > 0 && this.selectSql)) {
            this.m_executeSqlFragments = new String[this.fragmentsCount];
            this.m_executeSqlFragments[0] = "EXECUTE " + this.m_statementName;
            if (this.fragmentsCount > 1) {
                this.m_executeSqlFragments[0] = this.m_executeSqlFragments[0] + "(";
                if (this.isResultNeeded) {
                    for (int i = 1; i < this.m_binds.length - 1; ++i) {
                        this.m_executeSqlFragments[i] = ", ";
                    }
                    this.m_executeSqlFragments[this.m_binds.length - 1] = ")";
                } else {
                    for (int i = 1; i < this.m_binds.length; ++i) {
                        this.m_executeSqlFragments[i] = ", ";
                    }
                    this.m_executeSqlFragments[this.m_binds.length] = ")";
                }
            }
        }
        this.m_sqlFragments = this.m_executeSqlFragments;
    }

    protected void decalreCursor() throws SQLException {
        String cursorName = cursorPrefix + this.getNextPreparedCount();
        String prepareName = this.m_statementName;
        String cursDecl = null;
        if (this.resultSetType == 1003) {
            cursDecl = this.useSensitiveCursor ? "DECLARE " + cursorName + " CURSOR FOR " : "DECLARE " + cursorName + " INSENSITIVE CURSOR FOR ";
            cursDecl = cursDecl + prepareName;
            cursDecl = cursDecl + " For Read Only";
        } else if (this.resultSetType == 1004) {
            cursDecl = "DECLARE " + cursorName + " INSENSITIVE SCROLL CURSOR FOR ";
            cursDecl = cursDecl + prepareName;
        } else {
            cursDecl = "DECLARE " + cursorName + " SCROLL CURSOR FOR ";
            cursDecl = cursDecl + prepareName;
        }
        BaseStatement temp = (BaseStatement)((Object)this.connection.createStatement());
        if (this.resultSetConcurrency == 1008) {
            this.tidUsed = true;
        }
        temp.setUseTid(this.tidUsed);
        this.connection.execSQL(cursDecl, temp);
        this.m_cursorName = cursorName;
        this.m_statementIsCursor = true;
    }

    protected void getProcedureResult() throws SQLException {
        this.result.next();
        byte[][] row = this.result.getCurrentRow();
        this.m_functionTypes = new int[this.m_binds.length];
        int pNum = this.parameterNum;
        int rowIndex = 0;
        if (!this.isResultNeeded && this.isFunc) {
            ++pNum;
            this.m_returnValue = row[rowIndex];
            this.m_returnType = this.result.getMetaData().getColumnType(rowIndex + 1);
            ++rowIndex;
        }
        if (this.parameterNum != 0 && pNum != this.result.getColumnCount()) {
            throw new OSQLException("OSCAR-00407", "88888", 407);
        }
        for (Integer index : this.outParameterIndex) {
            int resIndex = index - 1;
            this.m_functionTypes[resIndex] = this.result.getMetaData().getColumnType(rowIndex + 1);
            this.m_outValues[resIndex] = row[rowIndex];
            ++rowIndex;
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
        this.connection.setCursorName(name);
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return false;
        }
        BaseResultSet rsTemp = (BaseResultSet)this.result.getNext();
        this.result.close();
        this.result = rsTemp;
        return this.result != null && this.result.reallyResultSet();
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkClosed();
        return this.resultSetType;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return this.resultSetConcurrency;
    }

    @Override
    public boolean getResultSetCanUpdateable() throws SQLException {
        return this.resultSetCanUpdateable;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxrows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new OSQLException("OSCAR-00408", "88888", 408);
        }
        this.maxrows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
        this.replaceProcessingEnabled = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return this.timeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkClosed();
        if (seconds < 0) {
            throw new OSQLException("OSCAR-00408", "88888", 408);
        }
        this.timeout = seconds;
    }

    @Override
    public void addWarning(String msg, String code) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(new SQLWarning(msg, code));
        } else {
            this.warnings = new SQLWarning(msg);
        }
    }

    public void addWarning(SQLWarning sw) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(sw);
        } else {
            this.warnings = sw;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw new OSQLException("OSCAR-00408", "88888", 408);
        }
        if (max < 8000) {
            this.maxFieldSize = max;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warnings = null;
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
        if (this.connection != null) {
            this.connection.cancelQuery();
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        if (this.result != null && this.result.reallyResultSet()) {
            if (this.supportGeneratedKey && this.result.getStatusString() != null && this.result.getStatusString().startsWith("21") && (this.autoGeneratedInfo == 1 || this.autoGeneratedInfo == 2 || this.autoGeneratedInfo == 3)) {
                return null;
            }
            return this.result;
        }
        return null;
    }

    protected void hardClose() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", hardClose()");
        }
        if (this.isClosed) {
            return;
        }
        if (this.result != null) {
            this.result.close();
        }
        this.result = null;
        this.cleanEnvTemp();
        if (this.statementType != 0 && this.m_statementName != null) {
            if (this.statementType == 2) {
                if (this.connection != null && !((Connection)((Object)this.connection)).isClosed()) {
                    this.connection.execSQL("DEALLOCATE PREPARE " + this.m_statementName);
                }
            } else {
                this.releasePrepareStatement();
            }
        }
        this.connection = null;
        this.encoding = null;
        this.clientEncoding = null;
        this.osql = null;
        this.outParameterType = null;
        this.outParameterIndex = null;
        this.pMetaData = null;
        this.sbuf = null;
        this.m_sqlFragments = null;
        this.m_origSqlFragments = null;
        this.m_executeSqlFragments = null;
        this.m_binds = null;
        this.m_functionTypes = null;
        this.m_outValues = null;
        this.m_returnValue = null;
        this.m_returnType = 0;
        this.isClosed = true;
    }

    @Override
    public void close() throws SQLException {
        if (this.logFlag) {
            if (this.connection != null) {
                Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", close()");
            } else {
                Driver.writeLog("conid: , " + OscarStatement.class + ", close()");
            }
        }
        if (this.isClosed) {
            return;
        }
        this.releaseResources();
        OscarJdbc2Connection conn = (OscarJdbc2Connection)this.connection;
        if (conn.getStList() != null) {
            conn.getStList().remove(this);
        }
        this.closeOrCache();
    }

    protected void closeOrCache() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", closeOrCache()");
        }
        if (this.useCache()) {
            this.cache();
        } else {
            this.hardClose();
        }
        if (this.generatedKeyMap != null) {
            this.generatedKeyMap.clear();
            this.generatedKeyMap = null;
        }
    }

    protected void cache() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", Cache()");
        }
        OscarJdbc2Connection conn = (OscarJdbc2Connection)this.connection;
        if (this instanceof OscarPreparedStatement) {
            conn.cacheImplicitStatement((OscarPreparedStatement)this, this.osql, this.statementType, this.resultSetType);
        } else {
            this.hardClose();
        }
    }

    protected boolean useCache() throws SQLException {
        if (!this.isPoolable()) {
            return false;
        }
        OscarJdbc2Connection conn = (OscarJdbc2Connection)this.connection;
        return this.statementType != 0 && this.cacheState != 3 && this.cacheState != 4 && conn.isStatementCacheInitialized() && conn.getImplicitCachingEnabled();
    }

    protected void releasePrepareStatement() throws SQLException {
        if (this.m_statementName != null) {
            this.releasePrepareStatementReally();
            this.firstField = null;
            this.m_statementName = null;
            this.m_origSqlFragments = null;
            this.m_executeSqlFragments = null;
            this.fragmentsCount = 0;
        }
    }

    protected void releasePrepareStatementReally() throws SQLException {
        if (this.connection != null && !((Connection)((Object)this.connection)).isClosed()) {
            this.connection.execSQL("DEALLOCATE PREPARE " + this.m_statementName);
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new OSQLException("OSCAR-00409", "88888", 409);
        }
    }

    protected void checkConnectionClosed(Exception e) {
        try {
            switch (ExceptionUtil.isConnectionClosed(e)) {
                case 1: 
                case 2: {
                    if (this.getConnection() != null) {
                        this.getConnection().close();
                    }
                    if (this.connection.isSlave()) {
                        this.isClosed = true;
                        break;
                    }
                    this.close();
                    break;
                }
            }
        }
        catch (SQLException e1) {
            if (this.stLogFlag) {
                Driver.writeLog("OscarStatement.class checkConnectionClosed() ::" + e1.getMessage());
            }
            this.isClosed = true;
        }
    }

    protected String replaceProcessing(String osql) throws SQLException {
        if (this.replaceProcessingEnabled) {
            Object escapedSqlResult = EscapeProcessor.escapeSQL(osql, true);
            if (escapedSqlResult instanceof String) {
                return (String)escapedSqlResult;
            }
            return ((EscapeProcessorResult)escapedSqlResult).escapedSql;
        }
        return osql;
    }

    public int getInsertRowid() throws SQLException {
        return this.result == null ? 0 : (int)this.result.getInsertRowid();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        int l_dbType;
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setNull(int parameterIndex, int sqlType),parameterIndex: " + parameterIndex + ",sqlType: " + sqlType);
        }
        this.checkClosed();
        switch (sqlType) {
            case -6: {
                l_dbType = 0;
                break;
            }
            case 5: {
                l_dbType = 0;
                break;
            }
            case 4: {
                l_dbType = 0;
                break;
            }
            case -5: {
                l_dbType = 0;
                break;
            }
            case 7: {
                l_dbType = 0;
                break;
            }
            case 6: {
                l_dbType = 0;
                break;
            }
            case 8: {
                l_dbType = 0;
                break;
            }
            case -7: 
            case 16: {
                l_dbType = 0;
                break;
            }
            case 2: 
            case 3: {
                l_dbType = 0;
                break;
            }
            case 1: {
                l_dbType = 0;
                break;
            }
            case 12: {
                l_dbType = 0;
                break;
            }
            case -1: {
                l_dbType = 0;
                break;
            }
            case 91: {
                l_dbType = 0;
                break;
            }
            case 92: {
                l_dbType = 0;
                break;
            }
            case 93: {
                l_dbType = 0;
                break;
            }
            case -2: {
                l_dbType = 0;
                break;
            }
            case -4: 
            case -3: {
                l_dbType = 0;
                break;
            }
            case 1111: {
                l_dbType = 0;
                break;
            }
            case 2005: {
                l_dbType = 51;
                break;
            }
            case 2004: {
                l_dbType = 50;
                break;
            }
            default: {
                l_dbType = 0;
            }
        }
        this.bind(parameterIndex, "null", l_dbType);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setBoolean(int parameterIndex, boolean x),parameterIndex: " + parameterIndex + ",x: " + x);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[parameterIndex - 1] = x;
        } else {
            if (this.pMetaData == null) {
                this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
            }
            if (x) {
                this.setObject(parameterIndex, (Object)"1", this.pMetaData.getParameterType(parameterIndex));
            } else {
                this.setObject(parameterIndex, (Object)"0", this.pMetaData.getParameterType(parameterIndex));
            }
        }
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setByte(int parameterIndex, byte x),parameterIndex: " + parameterIndex + ",x: " + x);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[parameterIndex - 1] = x;
        } else {
            if (this.pMetaData == null) {
                this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
            }
            this.setObject(parameterIndex, (Object)x, this.pMetaData.getParameterType(parameterIndex));
        }
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setShort(int parameterIndex, short x),parameterIndex: " + parameterIndex + ",x: " + x);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[parameterIndex - 1] = x;
        } else {
            if (this.pMetaData == null) {
                this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
            }
            this.setObject(parameterIndex, (Object)x, this.pMetaData.getParameterType(parameterIndex));
        }
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setInt(int parameterIndex, int x),parameterIndex: " + parameterIndex + ",x: " + x);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[parameterIndex - 1] = x;
        } else {
            if (this.pMetaData == null) {
                this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
            }
            this.setObject(parameterIndex, (Object)x, this.pMetaData.getParameterType(parameterIndex));
        }
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setLong(int parameterIndex, long x),parameterIndex: " + parameterIndex + ",x: " + x);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[parameterIndex - 1] = x;
        } else {
            if (this.pMetaData == null) {
                this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
            }
            this.setObject(parameterIndex, (Object)x, this.pMetaData.getParameterType(parameterIndex));
        }
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setFloat(int parameterIndex, float x),parameterIndex: " + parameterIndex + ",x: " + x);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[parameterIndex - 1] = new Float(x);
        } else {
            if (this.pMetaData == null) {
                this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
            }
            this.setObject(parameterIndex, (Object)new Float(x), this.pMetaData.getParameterType(parameterIndex));
        }
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setDouble(int parameterIndex, double x),parameterIndex: " + parameterIndex + ",x: " + x);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[parameterIndex - 1] = new Double(x);
        } else {
            if (this.pMetaData == null) {
                this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
            }
            this.setObject(parameterIndex, (Object)new Double(x), this.pMetaData.getParameterType(parameterIndex));
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setBigDecimal(int parameterIndex, BigDecimal x),parameterIndex: " + parameterIndex + ",x: " + x);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[parameterIndex - 1] = x;
        } else {
            if (this.pMetaData == null) {
                this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
            }
            if (x == null) {
                this.setNull(parameterIndex, this.pMetaData.getParameterType(parameterIndex));
            } else {
                this.setObject(parameterIndex, (Object)x, this.pMetaData.getParameterType(parameterIndex));
            }
        }
    }

    public void setString(int i, String x) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setString(int i, String x),i: " + i + ",x: " + x);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[i - 1] = x;
        } else {
            if (this.pMetaData == null) {
                this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
            }
            int paramtype = this.pMetaData.getParameterType(i);
            switch (paramtype) {
                case 2005: {
                    if (x == null) {
                        this.setObject(i, null);
                        this.m_lobs[i - 1] = null;
                    } else if (x.length() > 1000) {
                        OscarClob clob = null;
                        int tableOid = this.pMetaData.getParameterRelOid(i);
                        if (tableOid != 0) {
                            Character tableType = this.tableTypes.get(tableOid);
                            if (tableType == null) {
                                tableType = this.getRelKind(tableOid);
                                this.tableTypes.put(tableOid, tableType);
                            }
                            if (tableType.charValue() == 'r') {
                                int colIndex = this.pMetaData.getParameterRelColIndex(i);
                                clob = OscarClob.createForTable(this.getConnection(), tableOid, colIndex);
                            } else {
                                clob = ((OscarJdbc2Connection)this.connection).createClob();
                            }
                        } else {
                            clob = ((OscarJdbc2Connection)this.connection).createClob();
                        }
                        clob.setString(1L, x);
                        this.setObject(i, (Object)clob);
                        this.m_lobs[i - 1] = clob;
                    } else {
                        this.setObject(i, (Object)x, paramtype);
                        this.m_lobs[i - 1] = null;
                    }
                    if (this.m_lobs[i - 1] == null || !this.m_lobs[i - 1].isTempLob() && !this.m_lobs[i - 1].isTableIdLob()) break;
                    this.tempResource.add(this.m_lobs[i - 1]);
                    break;
                }
                default: {
                    this.setObject(i, (Object)x, paramtype);
                }
            }
        }
    }

    public void setBlobString(int parameterIndex, Object x, int type) throws SQLException {
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        if (x == null) {
            this.setObject(parameterIndex, null);
            this.m_lobs[parameterIndex - 1] = null;
        } else if (x instanceof byte[]) {
            byte[] bytes = (byte[])x;
            if (bytes.length > 4000) {
                OscarBlob blob = null;
                int tableOid = this.pMetaData.getParameterRelOid(parameterIndex);
                if (tableOid != 0) {
                    Character tableType = this.tableTypes.get(tableOid);
                    if (tableType == null) {
                        tableType = this.getRelKind(tableOid);
                        this.tableTypes.put(tableOid, tableType);
                    }
                    if (tableType.charValue() == 'r') {
                        int colIndex = this.pMetaData.getParameterRelColIndex(parameterIndex);
                        blob = OscarBlob.createForTable(this.getConnection(), tableOid, colIndex);
                    } else {
                        blob = ((OscarJdbc2Connection)this.connection).createBlob();
                    }
                } else {
                    blob = ((OscarJdbc2Connection)this.connection).createBlob();
                }
                blob.setBytes(1L, bytes);
                this.setObject(parameterIndex, (Object)blob);
                this.m_lobs[parameterIndex - 1] = blob;
            } else {
                this.setString(parameterIndex, OSCARbyte.toOSCARString((byte[])x), 0);
                this.m_lobs[parameterIndex - 1] = null;
            }
        }
        if (this.m_lobs[parameterIndex - 1] != null && (this.m_lobs[parameterIndex - 1].isTempLob() || this.m_lobs[parameterIndex - 1].isTableIdLob())) {
            this.tempResource.add(this.m_lobs[parameterIndex - 1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(int parameterIndex, String x, int type) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setString(int parameterIndex, String x, int type),parameterIndex: " + parameterIndex + ",x: " + x + ",type: " + type);
        }
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 12);
        } else {
            StringBuffer stringBuffer = this.sbuf;
            synchronized (stringBuffer) {
                this.sbuf.setLength(0);
                this.sbuf.ensureCapacity(x.length() + x.length() / 10);
                this.sbuf.append('\'');
                char c = '\u0000';
                for (int i = 0; i < x.length(); ++i) {
                    c = x.charAt(i);
                    if (this.connection.getVersion().getTransferType() == 1) {
                        if (c == '\\' || c == '\'') {
                            this.sbuf.append('\\');
                        }
                    } else if (this.connection.getVersion().getTransferType() == 2 && c == '\'') {
                        this.sbuf.append('\'');
                        if (!this.hasEscapeChar) {
                            this.hasEscapeChar = true;
                        }
                    }
                    this.sbuf.append(c);
                }
                this.sbuf.append('\'');
                this.bind(parameterIndex, this.sbuf.toString(), type);
            }
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setBytes(int parameterIndex, byte x[]),parameterIndex: " + parameterIndex + ",x: " + (x == null ? "null" : Arrays.toString(x)));
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[parameterIndex - 1] = this.clientEncoding.decode(x);
        } else {
            if (this.pMetaData == null) {
                this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
            }
            this.setObject(parameterIndex, (Object)x, this.pMetaData.getParameterType(parameterIndex));
        }
    }

    public void setDate(int parameterIndex, java.sql.Date x) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setDate(int parameterIndex, java.sql.Date x),parameterIndex: " + parameterIndex + ",x: " + x);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[parameterIndex - 1] = x.toString();
        } else {
            if (this.pMetaData == null) {
                this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
            }
            this.setObject(parameterIndex, (Object)x, this.pMetaData.getParameterType(parameterIndex));
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setTime(int parameterIndex, Time x),parameterIndex: " + parameterIndex + ",x: " + x);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[parameterIndex - 1] = x.toString();
        } else {
            if (this.pMetaData == null) {
                this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
            }
            this.setObject(parameterIndex, (Object)x, this.pMetaData.getParameterType(parameterIndex));
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setTime(int parameterIndex, Timestamp x),parameterIndex: " + parameterIndex + ",x: " + x);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[parameterIndex - 1] = x.toString();
        } else {
            if (this.pMetaData == null) {
                this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
            }
            this.setObject(parameterIndex, (Object)x, this.pMetaData.getParameterType(parameterIndex));
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        switch (this.pMetaData.getParameterType(parameterIndex)) {
            case -1: 
            case 1: 
            case 12: {
                break;
            }
            default: {
                throw new OSQLException("OSCAR-00410", "88888", 410);
            }
        }
        try {
            if (x == null) {
                this.setString(parameterIndex, null, 0);
                return;
            }
            InputStreamReader l_inStream = new InputStreamReader(x, "UTF-16BE");
            char[] l_chars = new char[length];
            int l_charsRead = l_inStream.read(l_chars, 0, length);
            this.setString(parameterIndex, new String(l_chars, 0, l_charsRead), 0);
        }
        catch (UnsupportedEncodingException l_uee) {
            throw new OSQLException("OSCAR-00303", "88888", 303, l_uee.getMessage(), l_uee);
        }
        catch (IOException l_ioe) {
            throw new OSQLException("OSCAR-00303", "88888", 303, l_ioe.getMessage(), l_ioe);
        }
    }

    public void clearParameters() throws SQLException {
        this.checkClosed();
        if (this.m_binds != null) {
            for (int i = 0; i < this.m_binds.length; ++i) {
                this.m_binds[i] = null;
                this.m_lobs[i] = null;
                this.m_bindTypes[i] = 0;
            }
        }
    }

    public void freeBindedLob(OscarLob lob, int type) throws SQLException {
        if (lob != null && (type == -2 || type == -1 || type == -3)) {
            if (lob.isTempLob()) {
                lob.freeTemporary();
            } else if (lob.isTableIdLob()) {
                lob.freePersist();
            }
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setObject(int parameterIndex, Object x, int targetSqlType, int scale),parameterIndex: " + parameterIndex + ",x: " + x + ",targetSqlType: " + targetSqlType + ",scale: " + scale);
        }
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        switch (targetSqlType) {
            case 2009: {
                if (x instanceof SQLXML) {
                    this.setSQLXML(parameterIndex, (SQLXML)x);
                    break;
                }
                this.setSQLXML(parameterIndex, (SQLXML)new OscarSQLXML(this.connection, x.toString()));
                break;
            }
            case 4: {
                if (x instanceof Integer || x instanceof Short || x instanceof Byte) {
                    this.bind(parameterIndex, x, 0);
                    break;
                }
                if (x instanceof Float) {
                    if (((Float)x).floatValue() > 2.1474836E9f || ((Float)x).floatValue() < -2.1474836E9f) {
                        throw new OSQLException("OSCAR-00703", "88888", 703);
                    }
                    this.addWarning(new DataTruncation(parameterIndex, true, false, 4, 4));
                    this.bind(parameterIndex, ((Float)x).intValue(), 0);
                    break;
                }
                if (x instanceof Double) {
                    if ((Double)x > 2.147483647E9 || (Double)x < -2.147483648E9) {
                        throw new OSQLException("OSCAR-00703", "88888", 703);
                    }
                    this.addWarning(new DataTruncation(parameterIndex, true, false, 8, 4));
                    this.bind(parameterIndex, ((Double)x).intValue(), 0);
                    break;
                }
                if (x instanceof Long) {
                    if ((Long)x > Integer.MAX_VALUE || (Long)x < Integer.MIN_VALUE) {
                        throw new OSQLException("OSCAR-00703", "88888", 703);
                    }
                    this.bind(parameterIndex, ((Long)x).intValue(), 0);
                    break;
                }
                if (x instanceof Boolean) {
                    this.bind(parameterIndex, (Boolean)x != false ? 1 : 0, 0);
                    break;
                }
                if (x instanceof BigDecimal) {
                    BigDecimal decimal = (BigDecimal)x;
                    if (decimal.doubleValue() > 2.147483647E9 || decimal.doubleValue() < -2.147483648E9) {
                        throw new OSQLException("OSCAR-00703", "88888", 703);
                    }
                    this.addWarning(new DataTruncation(parameterIndex, true, false, -1, 4));
                    this.bind(parameterIndex, (int)decimal.doubleValue(), 0);
                    break;
                }
                if (x instanceof String) {
                    if (x.toString().trim().equals("")) {
                        this.setNull(parameterIndex, targetSqlType);
                        break;
                    }
                    double d = 0.0;
                    try {
                        d = Double.parseDouble((String)x);
                    }
                    catch (Exception e) {
                        int i;
                        StringBuffer sf = new StringBuffer((String)x);
                        for (i = 0; i < sf.length() && (Character.isDigit(sf.charAt(i)) || i == 0 && (sf.charAt(i) == '-' || sf.charAt(i) == '+')); ++i) {
                        }
                        String nx = sf.substring(0, i);
                        try {
                            d = Double.parseDouble(nx);
                        }
                        catch (Exception ex) {
                            this.setString(parameterIndex, x.toString(), 0);
                            break;
                        }
                    }
                    if (d > 2.147483647E9 || d < -2.147483648E9) {
                        throw new OSQLException("OSCAR-00703", "88888", 703);
                    }
                    this.bind(parameterIndex, (int)d, 0);
                    break;
                }
                if (x instanceof Character) {
                    try {
                        this.bind(parameterIndex, Integer.valueOf(x.toString()), 0);
                        break;
                    }
                    catch (Exception e) {
                        throw new OSQLException("OSCAR-00703", "88888", 703, e);
                    }
                }
                throw new OSQLException("OSCAR-00703", "88888", 703);
            }
            case -5: {
                if (x instanceof Long || x instanceof Integer || x instanceof Short || x instanceof Byte) {
                    this.bind(parameterIndex, x, 0);
                    break;
                }
                if (x instanceof Double) {
                    if (((Double)x).longValue() >= Long.MAX_VALUE || ((Double)x).longValue() <= Long.MIN_VALUE) {
                        throw new OSQLException("OSCAR-00704", "88888", 704);
                    }
                    this.addWarning(new DataTruncation(parameterIndex, true, false, 8, 8));
                    this.bind(parameterIndex, ((Double)x).longValue(), 0);
                    break;
                }
                if (x instanceof Float) {
                    if (((Float)x).floatValue() > 9.223372E18f || ((Float)x).floatValue() < -9.223372E18f) {
                        throw new OSQLException("OSCAR-00704", "88888", 704);
                    }
                    this.addWarning(new DataTruncation(parameterIndex, true, false, 4, 8));
                    this.bind(parameterIndex, ((Float)x).longValue(), 0);
                    break;
                }
                if (x instanceof BigDecimal) {
                    BigDecimal decimal = (BigDecimal)x;
                    if (decimal.compareTo(new BigDecimal(Long.MAX_VALUE)) == 1 || decimal.compareTo(new BigDecimal(Long.MIN_VALUE)) == -1) {
                        throw new OSQLException("OSCAR-00704", "88888", 704);
                    }
                    this.addWarning(new DataTruncation(parameterIndex, true, false, -1, 8));
                    this.bind(parameterIndex, decimal.longValue(), 0);
                    break;
                }
                if (x instanceof Boolean) {
                    this.bind(parameterIndex, (Boolean)x != false ? 1L : 0L, 0);
                    break;
                }
                if (x instanceof String) {
                    if (x.toString().trim().equals("")) {
                        this.setNull(parameterIndex, targetSqlType);
                        break;
                    }
                    try {
                        BigDecimal decimal = new BigDecimal((String)x);
                        if (decimal.compareTo(new BigDecimal(Long.MAX_VALUE)) == 1 || decimal.compareTo(new BigDecimal(Long.MIN_VALUE)) == -1) {
                            throw new OSQLException("OSCAR-00704", "88888", 704);
                        }
                        this.bind(parameterIndex, decimal.longValue(), 0);
                    }
                    catch (Exception ex) {
                        this.setString(parameterIndex, x.toString(), 0);
                    }
                    break;
                }
                if (x instanceof Character) {
                    try {
                        this.bind(parameterIndex, Long.parseLong(x.toString()), 0);
                        break;
                    }
                    catch (Exception e) {
                        throw new OSQLException("OSCAR-00704", "88888", 704, e);
                    }
                }
                throw new OSQLException("OSCAR-00704", "88888", 704);
            }
            case -6: {
                if (x instanceof Integer) {
                    if ((Integer)x > 127 || (Integer)x < -128) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    this.bind(parameterIndex, x, 0);
                    break;
                }
                if (x instanceof Byte) {
                    this.bind(parameterIndex, x, 0);
                    break;
                }
                if (x instanceof Short) {
                    if (((Short)x).intValue() > 127 || ((Short)x).intValue() < -128) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    this.bind(parameterIndex, x, 0);
                    break;
                }
                if (x instanceof Float) {
                    if (((Float)x).floatValue() > 127.0f || ((Float)x).floatValue() < -128.0f) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    this.addWarning(new DataTruncation(parameterIndex, true, false, 4, 1));
                    this.bind(parameterIndex, ((Float)x).intValue(), 0);
                    break;
                }
                if (x instanceof Double) {
                    if ((Double)x > 127.0 || (Double)x < -128.0) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    this.addWarning(new DataTruncation(parameterIndex, true, false, 8, 1));
                    this.bind(parameterIndex, ((Double)x).intValue(), 0);
                    break;
                }
                if (x instanceof Long) {
                    if ((Long)x > 127L || (Long)x < -128L) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    this.bind(parameterIndex, ((Long)x).intValue(), 0);
                    break;
                }
                if (x instanceof Boolean) {
                    this.bind(parameterIndex, (Boolean)x != false ? 1 : 0, 0);
                    break;
                }
                if (x instanceof BigDecimal) {
                    BigDecimal decimal = (BigDecimal)x;
                    if (decimal.doubleValue() > 127.0 || decimal.doubleValue() < -128.0) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    this.addWarning(new DataTruncation(parameterIndex, true, false, -1, 1));
                    this.bind(parameterIndex, (int)decimal.doubleValue(), 0);
                    break;
                }
                if (x instanceof String) {
                    double d;
                    if (x.toString().trim().equals("")) {
                        this.setNull(parameterIndex, targetSqlType);
                        break;
                    }
                    try {
                        d = Double.parseDouble((String)x);
                    }
                    catch (Exception e) {
                        this.setString(parameterIndex, x.toString(), 0);
                        break;
                    }
                    if (d > 127.0 || d < -128.0) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    this.bind(parameterIndex, (int)d, 0);
                    break;
                }
                if (x instanceof Character) {
                    try {
                        this.bind(parameterIndex, Integer.valueOf(x.toString()), 0);
                        break;
                    }
                    catch (Exception e) {
                        throw new OSQLException("OSCAR-00701", "88888", 701, e);
                    }
                }
                throw new OSQLException("OSCAR-00701", "88888", 701);
            }
            case 5: {
                if (x instanceof Integer) {
                    if ((Integer)x > Short.MAX_VALUE || (Integer)x < Short.MIN_VALUE) {
                        throw new OSQLException("OSCAR-00702", "88888", 702);
                    }
                    this.bind(parameterIndex, x, 0);
                    break;
                }
                if (x instanceof Byte || x instanceof Short) {
                    this.bind(parameterIndex, x, 0);
                    break;
                }
                if (x instanceof Float) {
                    if (((Float)x).floatValue() > 32767.0f || ((Float)x).floatValue() < -32768.0f) {
                        throw new OSQLException("OSCAR-00702", "88888", 702);
                    }
                    this.addWarning(new DataTruncation(parameterIndex, true, false, 4, 2));
                    this.bind(parameterIndex, ((Float)x).intValue(), 0);
                    break;
                }
                if (x instanceof Double) {
                    if ((Double)x > 32767.0 || (Double)x < -32768.0) {
                        throw new OSQLException("OSCAR-00702", "88888", 702);
                    }
                    this.addWarning(new DataTruncation(parameterIndex, true, false, 8, 2));
                    this.bind(parameterIndex, ((Double)x).intValue(), 0);
                    break;
                }
                if (x instanceof Long) {
                    if ((Long)x > 32767L || (Long)x < -32768L) {
                        throw new OSQLException("OSCAR-00702", "88888", 702);
                    }
                    this.bind(parameterIndex, ((Long)x).intValue(), 0);
                    break;
                }
                if (x instanceof Boolean) {
                    this.bind(parameterIndex, (Boolean)x != false ? 1 : 0, 0);
                    break;
                }
                if (x instanceof BigDecimal) {
                    BigDecimal decimal = (BigDecimal)x;
                    if (decimal.doubleValue() > 32767.0 || decimal.doubleValue() < -32768.0) {
                        throw new OSQLException("OSCAR-00702", "88888", 702);
                    }
                    this.addWarning(new DataTruncation(parameterIndex, true, false, -1, 2));
                    this.bind(parameterIndex, (int)decimal.doubleValue(), 0);
                    break;
                }
                if (x instanceof String) {
                    double d;
                    if (x.toString().trim().equals("")) {
                        this.setNull(parameterIndex, targetSqlType);
                        break;
                    }
                    try {
                        d = Double.parseDouble((String)x);
                    }
                    catch (Exception e) {
                        this.setString(parameterIndex, x.toString(), 0);
                        break;
                    }
                    if (d > 32767.0 || d < -32768.0) {
                        throw new OSQLException("OSCAR-00702", "88888", 702);
                    }
                    this.bind(parameterIndex, (int)d, 0);
                    break;
                }
                if (x instanceof Character) {
                    try {
                        this.bind(parameterIndex, Integer.valueOf(x.toString()), 0);
                        break;
                    }
                    catch (Exception e) {
                        throw new OSQLException("OSCAR-00702", "88888", 702, e);
                    }
                }
                throw new OSQLException("OSCAR-00702", "88888", 702);
            }
            case 7: {
                if (x instanceof Integer || x instanceof Byte || x instanceof Short || x instanceof Long || x instanceof Float) {
                    this.bind(parameterIndex, x, 0);
                    break;
                }
                if (x instanceof Double) {
                    if ((Double)x > 3.4028234663852886E38 || (Double)x < -3.4028234663852886E38) {
                        throw new OSQLException("OSCAR-00705", "88888", 705);
                    }
                    this.bind(parameterIndex, x, 0);
                    break;
                }
                if (x instanceof Boolean) {
                    this.bind(parameterIndex, new Float((Boolean)x != false ? 1.0f : 0.0f), 0);
                    break;
                }
                if (x instanceof BigDecimal) {
                    BigDecimal decimal = (BigDecimal)x;
                    if (decimal.doubleValue() > 3.4028234663852886E38 || decimal.doubleValue() < -3.4028234663852886E38) {
                        throw new OSQLException("OSCAR-00705", "88888", 705);
                    }
                    this.bind(parameterIndex, new Float(decimal.doubleValue()), 0);
                    break;
                }
                if (x instanceof String) {
                    double d;
                    if (x.toString().trim().equals("")) {
                        this.setNull(parameterIndex, targetSqlType);
                        break;
                    }
                    try {
                        d = Double.parseDouble((String)x);
                    }
                    catch (Exception e) {
                        this.setString(parameterIndex, x.toString(), 0);
                        break;
                    }
                    if (d > 3.4028234663852886E38 || d < -3.4028234663852886E38) {
                        throw new OSQLException("OSCAR-00705", "88888", 705);
                    }
                    this.bind(parameterIndex, new Float((float)d), 0);
                    break;
                }
                if (x instanceof Character) {
                    try {
                        this.bind(parameterIndex, Float.valueOf(Float.parseFloat(x.toString())), 0);
                        break;
                    }
                    catch (Exception e) {
                        throw new OSQLException("OSCAR-00705", "88888", 705, e);
                    }
                }
                throw new OSQLException("OSCAR-00705", "88888", 705);
            }
            case 6: 
            case 8: {
                if (x instanceof Integer || x instanceof Byte || x instanceof Short || x instanceof Long || x instanceof Float || x instanceof Double) {
                    this.bind(parameterIndex, x, 0);
                    break;
                }
                if (x instanceof Boolean) {
                    this.bind(parameterIndex, new Double((Boolean)x != false ? 1.0 : 0.0), 0);
                    break;
                }
                if (x instanceof BigDecimal) {
                    BigDecimal decimal = (BigDecimal)x;
                    if (decimal.doubleValue() > Double.MAX_VALUE || decimal.doubleValue() < -1.7976931348623157E308) {
                        throw new OSQLException("OSCAR-00706", "88888", 706);
                    }
                    this.bind(parameterIndex, new Double(decimal.doubleValue()), 0);
                    break;
                }
                if (x instanceof String) {
                    double d;
                    if (x.toString().trim().equals("")) {
                        this.setNull(parameterIndex, targetSqlType);
                        break;
                    }
                    try {
                        d = Double.parseDouble((String)x);
                    }
                    catch (Exception e) {
                        this.setString(parameterIndex, x.toString(), 0);
                        break;
                    }
                    this.bind(parameterIndex, new Double(d), 0);
                    break;
                }
                if (x instanceof Character) {
                    try {
                        this.bind(parameterIndex, Double.parseDouble(x.toString()), 0);
                        break;
                    }
                    catch (Exception e) {
                        throw new OSQLException("OSCAR-00706", "88888", 706, e);
                    }
                }
                throw new OSQLException("OSCAR-00706", "88888", 706);
            }
            case 2: 
            case 3: {
                if (x instanceof Integer || x instanceof Byte || x instanceof Short || x instanceof Long || x instanceof Float || x instanceof Double || x instanceof BigInteger) {
                    if (x.toString().equals("NaN")) {
                        this.setString(parameterIndex, x.toString(), 0);
                        break;
                    }
                    if (scale == -2147483638) {
                        this.bind(parameterIndex, new BigDecimal(x.toString()), 0);
                        break;
                    }
                    this.bind(parameterIndex, new BigDecimal(x.toString()).setScale(scale, 4), 0);
                    break;
                }
                if (x instanceof Boolean) {
                    if (scale == -2147483638) {
                        this.bind(parameterIndex, new BigDecimal((Boolean)x != false ? 1 : 0), 0);
                        break;
                    }
                    if (scale < 0) {
                        throw new OSQLException("OSCAR-00707", "88888", 707);
                    }
                    this.bind(parameterIndex, new BigDecimal((Boolean)x != false ? 1 : 0).setScale(scale), 0);
                    break;
                }
                if (x instanceof BigDecimal) {
                    if (scale == -2147483638) {
                        this.bind(parameterIndex, (BigDecimal)x, 0);
                        break;
                    }
                    this.bind(parameterIndex, ((BigDecimal)x).setScale(scale, 4), 0);
                    break;
                }
                if (x instanceof String) {
                    if (x.toString().trim().equals("")) {
                        this.setNull(parameterIndex, targetSqlType);
                        break;
                    }
                    try {
                        if (scale == -2147483638) {
                            this.bind(parameterIndex, new BigDecimal(x.toString().trim()), 0);
                            break;
                        }
                        this.bind(parameterIndex, new BigDecimal(x.toString().trim()).setScale(scale, 4), 0);
                    }
                    catch (Exception e) {
                        this.setString(parameterIndex, x.toString(), 0);
                    }
                    break;
                }
                throw new OSQLException("OSCAR-00707", "88888", 707);
            }
            case -7: {
                String value = null;
                if (x instanceof Boolean) {
                    if (((Boolean)x).booleanValue()) {
                        this.setString(parameterIndex, "1", 0);
                        break;
                    }
                    this.setString(parameterIndex, "0", 0);
                    break;
                }
                if (x instanceof BigDecimal || x instanceof Integer || x instanceof Long || x instanceof Float || x instanceof Double || x instanceof Short || x instanceof String || x instanceof Character || x instanceof BigInteger) {
                    value = x.toString();
                    if (value.equalsIgnoreCase("true")) {
                        this.setString(parameterIndex, "1", 0);
                        break;
                    }
                    if (value.equalsIgnoreCase("false")) {
                        this.setString(parameterIndex, "0", 0);
                        break;
                    }
                    if (value.length() > 0 && value.charAt(0) == '\u0000') {
                        value = "";
                    }
                    this.setString(parameterIndex, value, 0);
                    break;
                }
                throw new OSQLException("OSCAR-00717", "88888", 717);
            }
            case -1: 
            case 1: 
            case 12: {
                String svalue = null;
                if (x instanceof byte[]) {
                    try {
                        svalue = this.clientEncoding.decode((byte[])x);
                    }
                    catch (Exception e) {
                        throw new OSQLException("OSCAR-00713", "88888", 713, e);
                    }
                    this.setString(parameterIndex, svalue, 0);
                    break;
                }
                if (x instanceof OscarBlob) {
                    if (this.connection.getVersion().isConvertLobLocatorByFunc()) {
                        this.bind(parameterIndex, "blob_locator('" + ((OscarBlob)x).getLocatorStr() + "')", -2);
                        break;
                    }
                    throw new OSQLException("OSCAR-00713", "88888", 713);
                }
                if (x instanceof OtherType) {
                    OtherType obj = (OtherType)x;
                    if (obj.getObj() instanceof Reader) {
                        this.setCharacterStream(parameterIndex, (Reader)obj.getObj(), obj.getLength());
                        break;
                    }
                    if (obj.getObj() instanceof InputStream) {
                        this.setAsciiStream(parameterIndex, (InputStream)obj.getObj(), obj.getLength());
                        break;
                    }
                    throw new OSQLException("OSCAR-00709", "88888", 709);
                }
                svalue = x.toString();
                if (svalue.length() > 0 && svalue.charAt(0) == '\u0000') {
                    svalue = "";
                }
                this.setString(parameterIndex, svalue, 0);
                break;
            }
            case 91: {
                if (x instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)x;
                    if (Long.MAX_VALUE == timestamp.getTime()) {
                        this.setString(parameterIndex, "infinity", 0);
                        break;
                    }
                    if (Long.MIN_VALUE == timestamp.getTime()) {
                        this.setString(parameterIndex, "-infinity", 0);
                        break;
                    }
                    this.setString(parameterIndex, x.toString().substring(0, x.toString().indexOf(" ")), 0);
                    break;
                }
                if (x instanceof java.sql.Date) {
                    java.sql.Date date = (java.sql.Date)x;
                    if (Long.MAX_VALUE == date.getTime()) {
                        this.setString(parameterIndex, "infinity");
                        break;
                    }
                    if (Long.MIN_VALUE == date.getTime()) {
                        this.setString(parameterIndex, "-infinity");
                        break;
                    }
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    this.setString(parameterIndex, format.format(date));
                    break;
                }
                if (x instanceof Date) {
                    Date date = (Date)x;
                    if (Long.MAX_VALUE == date.getTime()) {
                        this.setString(parameterIndex, "infinity", 0);
                        break;
                    }
                    if (Long.MIN_VALUE == date.getTime()) {
                        this.setString(parameterIndex, "-infinity", 0);
                        break;
                    }
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    this.setString(parameterIndex, format.format(date), 0);
                    break;
                }
                if (x instanceof String) {
                    try {
                        if ("infinity".equalsIgnoreCase((String)x) || "-infinity".equalsIgnoreCase((String)x)) {
                            this.setString(parameterIndex, (String)x, 0);
                        } else {
                            long time = Timestamp.valueOf(x.toString().trim()).getTime();
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            this.setString(parameterIndex, format.format(new Date(time)), 0);
                        }
                        return;
                    }
                    catch (Exception time) {
                        try {
                            this.setDate(parameterIndex, com.oscar.sql.Date.valueOf(x.toString().trim()));
                            break;
                        }
                        catch (Exception e) {
                            throw new OSQLException("OSCAR-00710", "88888", 710);
                        }
                    }
                }
                throw new OSQLException("OSCAR-00710", "88888", 710);
            }
            case 27: 
            case 92: {
                if (x instanceof Timestamp) {
                    this.setString(parameterIndex, x.toString().substring(x.toString().indexOf(" ") + 1), 0);
                    break;
                }
                if (x instanceof Time) {
                    this.setString(parameterIndex, x.toString(), 0);
                    break;
                }
                if (x instanceof String) {
                    try {
                        long time2 = Timestamp.valueOf(x.toString().trim()).getTime();
                        this.setString(parameterIndex, new Time(time2).toString(), 0);
                        return;
                    }
                    catch (Exception time2) {
                        try {
                            try {
                                this.setString(parameterIndex, Time.valueOf(x.toString().trim()).toString(), 0);
                                return;
                            }
                            catch (Exception time2) {
                                this.setString(parameterIndex, x.toString().trim(), 0);
                                break;
                            }
                        }
                        catch (Exception e) {
                            throw new OSQLException("OSCAR-00711", "88888", 711, e);
                        }
                    }
                }
                throw new OSQLException("OSCAR-00711", "88888", 711);
            }
            case 29: 
            case 93: {
                if (x instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)x;
                    if (Long.MAX_VALUE == timestamp.getTime()) {
                        this.setString(parameterIndex, "infinity", 0);
                        break;
                    }
                    if (Long.MIN_VALUE == timestamp.getTime()) {
                        this.setString(parameterIndex, "-infinity", 0);
                        break;
                    }
                    this.setString(parameterIndex, x.toString(), 0);
                    break;
                }
                if (x instanceof Date) {
                    Date date = (Date)x;
                    if (Long.MAX_VALUE == date.getTime()) {
                        this.setString(parameterIndex, "infinity", 0);
                        break;
                    }
                    if (Long.MIN_VALUE == date.getTime()) {
                        this.setString(parameterIndex, "-infinity", 0);
                        break;
                    }
                    this.setString(parameterIndex, new Timestamp(date.getTime()).toString(), 0);
                    break;
                }
                if (x instanceof String) {
                    try {
                        if ("infinity".equalsIgnoreCase((String)x) || "-infinity".equalsIgnoreCase((String)x)) {
                            this.setString(parameterIndex, (String)x, 0);
                        } else {
                            long time = java.sql.Date.valueOf(x.toString().trim()).getTime();
                            this.setString(parameterIndex, new Timestamp(time).toString(), 0);
                        }
                        return;
                    }
                    catch (Exception time) {
                        try {
                            try {
                                Timestamp xv = Timestamp.valueOf(x.toString().trim());
                                this.setString(parameterIndex, xv.toString(), 0);
                            }
                            catch (IllegalArgumentException e) {
                                this.setString(parameterIndex, x.toString(), 0);
                            }
                            break;
                        }
                        catch (Exception e) {
                            throw new OSQLException("OSCAR-00712", "88888", 712, e);
                        }
                    }
                }
                throw new OSQLException("OSCAR-00712", "88888", 712);
            }
            case 16: {
                if (x instanceof Boolean) {
                    if (((Boolean)x).booleanValue()) {
                        this.setString(parameterIndex, "1", 0);
                        break;
                    }
                    this.setString(parameterIndex, "0", 0);
                    break;
                }
                if (x instanceof BigDecimal || x instanceof Integer || x instanceof Long || x instanceof Float || x instanceof Double || x instanceof Short || x instanceof Byte || x instanceof String || x instanceof Character || x instanceof BigInteger) {
                    String s = x.toString();
                    if (s.length() == 1) {
                        if (s.charAt(0) == '1' || s.charAt(0) == 't' || s.charAt(0) == 'y' || s.charAt(0) == 'T' || s.charAt(0) == 'Y') {
                            this.setString(parameterIndex, "1", 0);
                            break;
                        }
                        this.setString(parameterIndex, "0", 0);
                        break;
                    }
                    if (s.length() > 1) {
                        double d;
                        if (s.equalsIgnoreCase("true")) {
                            this.setString(parameterIndex, "1", 0);
                            break;
                        }
                        if (s.equalsIgnoreCase("false")) {
                            this.setString(parameterIndex, "0", 0);
                            break;
                        }
                        if (s.equalsIgnoreCase("yes")) {
                            this.setString(parameterIndex, "1", 0);
                            break;
                        }
                        if (s.equalsIgnoreCase("no")) {
                            this.setString(parameterIndex, "0", 0);
                            break;
                        }
                        try {
                            d = Double.parseDouble(s);
                        }
                        catch (Exception e) {
                            throw new OSQLException("OSCAR-00708", "88888", 708, e);
                        }
                        if (d >= 1.0E-10 || d <= -1.0E-10) {
                            this.setString(parameterIndex, "1", 0);
                            break;
                        }
                        this.setString(parameterIndex, "0", 0);
                        break;
                    }
                    this.setString(parameterIndex, "0", 0);
                    break;
                }
                throw new OSQLException("OSCAR-00708", "88888", 708);
            }
            case -4: 
            case -3: 
            case -2: {
                if (x instanceof byte[]) {
                    String svalue;
                    if (this.connection.sendBinaryTypeAsHex()) {
                        this.setString(parameterIndex, OSCARbyte.toOSCARString((byte[])x), 0);
                        break;
                    }
                    try {
                        svalue = this.clientEncoding.decode((byte[])x);
                    }
                    catch (Exception e) {
                        throw new OSQLException("OSCAR-00713", "88888", 713, e);
                    }
                    this.setString(parameterIndex, svalue, 0);
                    break;
                }
                if (x instanceof String) {
                    if (this.connection.sendBinaryTypeAsHex()) {
                        this.setString(parameterIndex, OSCARbyte.toOSCARString(this.encoding.encode((String)x)), 0);
                        break;
                    }
                    this.setString(parameterIndex, (String)x, 0);
                    break;
                }
                if (x instanceof OtherType) {
                    OtherType object = (OtherType)x;
                    if (object.getObj() instanceof InputStream) {
                        this.setBinaryStream(parameterIndex, (InputStream)object.getObj(), object.getLength());
                        break;
                    }
                    throw new OSQLException("OSCAR-00709", "88888", 709);
                }
                throw new OSQLException("OSCAR-00709", "88888", 709);
            }
            case 2004: {
                if (x instanceof Blob) {
                    if (x instanceof OscarBlob) {
                        if (((OscarBlob)x).isEmptyLob()) {
                            this.bind(parameterIndex, "EMPTY_BLOB()", -2);
                            break;
                        }
                        if (this.connection.getVersion().isConvertLobLocatorByFunc()) {
                            this.bind(parameterIndex, "blob_locator('" + ((OscarBlob)x).getLocatorStr() + "')", -2);
                            break;
                        }
                        this.setString(parameterIndex, ((OscarBlob)x).getLocatorStr(), -2);
                        break;
                    }
                    Blob blob = (Blob)x;
                    byte[] bytes = blob.getBytes(1L, (int)blob.length());
                    this.setBlobString(parameterIndex, bytes, 2004);
                    break;
                }
                if (x instanceof byte[]) {
                    this.setBlobString(parameterIndex, (byte[])x, 0);
                    break;
                }
                if (x instanceof InputStream) {
                    this.setBinaryStream(parameterIndex, (InputStream)x);
                    break;
                }
                if (x instanceof OtherType) {
                    OtherType ot = (OtherType)x;
                    if (ot.getObj() instanceof InputStream) {
                        this.setBinaryStream(parameterIndex, (InputStream)ot.getObj(), ot.getLength());
                        break;
                    }
                    throw new OSQLException("OSCAR-00709", "88888", 709);
                }
                throw new OSQLException("OSCAR-00714", "88888", 714);
            }
            case 2005: {
                String cvalue = "";
                if (x instanceof Clob) {
                    if (x instanceof OscarClob) {
                        if (((OscarClob)x).isEmptyLob()) {
                            this.bind(parameterIndex, "EMPTY_CLOB()", -1);
                            break;
                        }
                        if (this.connection.getVersion().isConvertLobLocatorByFunc()) {
                            this.bind(parameterIndex, "clob_locator('" + ((OscarClob)x).getLocatorStr() + "')", -1);
                            break;
                        }
                        this.setString(parameterIndex, ((OscarClob)x).getLocatorStr(), -1);
                        break;
                    }
                    String clob2String = this.clob2String((Clob)x);
                    if (clob2String.length() > 0 && clob2String.charAt(0) == '\u0000') {
                        clob2String = "";
                    }
                    this.bind(parameterIndex, clob2String, 24);
                    break;
                }
                if (x instanceof String) {
                    cvalue = x.toString();
                    if (cvalue.length() > 0 && cvalue.charAt(0) == '\u0000') {
                        cvalue = "";
                    }
                    this.setString(parameterIndex, cvalue, 0);
                    break;
                }
                if (x instanceof byte[]) {
                    cvalue = this.clientEncoding.decode((byte[])x);
                    this.setString(parameterIndex, cvalue, 0);
                    break;
                }
                if (x instanceof Reader) {
                    this.setCharacterStream(parameterIndex, (Reader)x);
                    break;
                }
                if (x instanceof OtherType) {
                    OtherType ot = (OtherType)x;
                    if (ot.getObj() instanceof Reader) {
                        this.setCharacterStream(parameterIndex, (Reader)ot.getObj(), ot.getLength());
                        break;
                    }
                    if (ot.getObj() instanceof InputStream) {
                        this.setAsciiStream(parameterIndex, (InputStream)ot.getObj(), ot.getLength());
                        break;
                    }
                    throw new OSQLException("OSCAR-00709", "88888", 709);
                }
                throw new OSQLException("OSCAR-00715", "88888", 715);
            }
            case -11: {
                if (x instanceof OscarBfile) {
                    if (this.connection.getVersion().isConvertLobLocatorByFunc()) {
                        this.bind(parameterIndex, "bfile_locator('" + ((OscarBfile)x).getLocatorStr() + "')", -3);
                        break;
                    }
                    this.setString(parameterIndex, ((OscarBfile)x).getLocatorStr(), -3);
                    break;
                }
                throw new OSQLException("OSCAR-00716", "88888", 716);
            }
            case 1111: {
                this.setString(parameterIndex, x.toString(), 0);
                break;
            }
            case 2003: {
                this.setString(parameterIndex, this.getArrayToString(x), 0);
                break;
            }
            default: {
                throw new OSQLException("OSCAR-00411", "88888", 411);
            }
        }
    }

    public String clob2String(Clob clob) throws SQLException {
        if (clob == null) {
            return null;
        }
        try {
            Reader reader = clob.getCharacterStream();
            if (reader != null) {
                StringBuilder sBuilder = new StringBuilder();
                char[] cbuf = new char[1024];
                int readLength = -1;
                while ((readLength = reader.read(cbuf)) != -1) {
                    sBuilder.append(cbuf, 0, readLength);
                }
                return sBuilder.toString();
            }
            return null;
        }
        catch (Exception e) {
            throw new OSQLException("OSCAR-00712", "88888", 712, e);
        }
    }

    protected String getArrayToString(Object x) {
        int i;
        StringBuffer temp = new StringBuffer();
        if (x instanceof int[]) {
            temp.append("{");
            for (i = 0; i < ((int[])x).length; ++i) {
                temp.append(((int[])x)[i]);
                if (i >= ((int[])x).length - 1) continue;
                temp.append(",");
            }
            temp.append("}");
        }
        if (x instanceof int[][]) {
            temp.append("{");
            for (i = 0; i < ((int[][])x).length; ++i) {
                temp.append("{");
                for (int j = 0; j < ((int[][])x)[i].length; ++j) {
                    temp.append(((int[][])x)[i][j]);
                    if (j >= ((int[][])x)[i].length - 1) continue;
                    temp.append(",");
                }
                temp.append("}");
                if (i >= ((int[][])x).length - 1) continue;
                temp.append(",");
            }
            temp.append("}");
        } else if (x instanceof double[]) {
            temp.append("{");
            for (i = 0; i < ((double[])x).length; ++i) {
                temp.append(((double[])x)[i]);
                if (i >= ((double[])x).length - 1) continue;
                temp.append(",");
            }
            temp.append("}");
        } else if (x instanceof double[][]) {
            temp.append("{");
            for (i = 0; i < ((double[][])x).length; ++i) {
                temp.append("{");
                for (int j = 0; j < ((double[][])x)[i].length; ++j) {
                    temp.append(((double[][])x)[i][j]);
                    if (j >= ((double[][])x)[i].length - 1) continue;
                    temp.append(",");
                }
                temp.append("}");
                if (i >= ((double[][])x).length - 1) continue;
                temp.append(",");
            }
            temp.append("}");
        } else if (x instanceof byte[]) {
            temp.append("{");
            for (i = 0; i < ((byte[])x).length; ++i) {
                temp.append("\"").append(((byte[])x)[i]).append("\"");
                if (i >= ((byte[])x).length - 1) continue;
                temp.append(",");
            }
            temp.append("}");
        } else if (x instanceof byte[][]) {
            temp.append("{");
            for (i = 0; i < ((byte[][])x).length; ++i) {
                temp.append("{");
                for (int j = 0; j < ((byte[][])x)[i].length; ++j) {
                    temp.append("\"").append(((byte[][])x)[i][j]).append("\"");
                    if (j >= ((byte[][])x)[i].length - 1) continue;
                    temp.append(",");
                }
                temp.append("}");
                if (i >= ((byte[][])x).length - 1) continue;
                temp.append(",");
            }
            temp.append("}");
        } else if (x instanceof Object[][]) {
            temp.append("{");
            for (i = 0; i < ((Object[][])x).length; ++i) {
                temp.append("{");
                for (int j = 0; j < ((Object[][])x)[i].length; ++j) {
                    temp.append("\"").append(((Object[][])x)[i][j]).append("\"");
                    if (j >= ((Object[][])x)[i].length - 1) continue;
                    temp.append(",");
                }
                temp.append("}");
                if (i >= ((Object[][])x).length - 1) continue;
                temp.append(",");
            }
            temp.append("}");
        } else if (x instanceof Object[]) {
            temp.append("{");
            for (i = 0; i < ((Object[])x).length; ++i) {
                temp.append("\"").append(((Object[])x)[i]).append("\"");
                if (i >= ((Object[])x).length - 1) continue;
                temp.append(",");
            }
            temp.append("}");
        } else {
            temp.append(x.toString());
        }
        return temp.toString();
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, -2147483638);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setObject(int parameterIndex, Object x), parameterIndex: " + parameterIndex + ", x: " + x);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[parameterIndex - 1] = x == null ? "null" : x.toString();
        } else {
            if (this.pMetaData == null) {
                this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
            }
            this.setObject(parameterIndex, x, this.pMetaData.getParameterType(parameterIndex));
        }
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.checkClosed();
        if (!this.isCallable && !this.isAnonymous) {
            throw new OSQLException("OSCAR-00412", "88888", 412);
        }
        if (this.isResultNeeded && parameterIndex == 1) {
            this.functionReturnType = sqlType;
            this.returnTypeSet = true;
            this.m_binds[0] = null;
            this.m_bindTypes[0] = 23;
            this.isHaveFuncReturn = true;
        } else if (this.m_binds[parameterIndex - 1] == null) {
            this.setNull(parameterIndex, sqlType);
            this.m_binds[parameterIndex - 1] = null;
        }
        int found = this.outParameterIndex.indexOf(parameterIndex);
        if (found != -1) {
            this.outParameterIndex.remove(found);
            this.outParameterType.remove(found);
            --this.parameterNum;
        } else {
            this.fields[parameterIndex - 1] = new Field();
        }
        this.outParameterIndex.add(this.parameterNum, parameterIndex);
        Collections.sort(this.outParameterIndex);
        int index = this.outParameterIndex.indexOf(parameterIndex);
        this.outParameterType.insertElementAt(sqlType, index);
        ++this.parameterNum;
    }

    public boolean wasNull() throws SQLException {
        if (this.lastIndex == 0) {
            throw new OSQLException("OSCAR-00425", "88888", 425);
        }
        return this.m_outValues[this.lastIndex - 1] == null;
    }

    public String getString(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -1, "String");
        return this.getFixedString(parameterIndex);
    }

    protected String getFixedString(int parameterIndex) throws SQLException {
        this.checkOutParameter(parameterIndex);
        if (this.checkNullValue(parameterIndex - 1)) {
            return null;
        }
        return this.encoding.decode((byte[])this.m_outValues[parameterIndex - 1]);
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 16, "Boolean");
        return TypeConverter.toBoolean(this.getFixedString(parameterIndex), this.m_functionTypes[parameterIndex - 1]);
    }

    public byte getByte(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -6, "byte");
        int type = this.m_functionTypes[parameterIndex - 1];
        if (type == 6 || type == 8) {
            this.addWarning(new DataTruncation(parameterIndex, true, true, 8, 1));
        } else if (type == 7) {
            this.addWarning(new DataTruncation(parameterIndex, true, true, 4, 1));
        } else if (type == 2 || type == 3) {
            this.addWarning(new DataTruncation(parameterIndex, true, true, -1, 1));
        }
        return TypeConverter.toByte(this.getFixedString(parameterIndex), type);
    }

    public short getShort(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 5, "short");
        int type = this.m_functionTypes[parameterIndex - 1];
        if (type == 6 || type == 8) {
            this.addWarning(new DataTruncation(parameterIndex, true, true, 8, 2));
        } else if (type == 7) {
            this.addWarning(new DataTruncation(parameterIndex, true, true, 4, 2));
        } else if (type == 2 || type == 3) {
            this.addWarning(new DataTruncation(parameterIndex, true, true, -1, 2));
        }
        return TypeConverter.toShort(this.getFixedString(parameterIndex), type);
    }

    public int getInt(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 4, "int");
        int type = this.m_functionTypes[parameterIndex - 1];
        if (type == 6 || type == 8) {
            this.addWarning(new DataTruncation(parameterIndex, true, true, 8, 4));
        } else if (type == 7) {
            this.addWarning(new DataTruncation(parameterIndex, true, true, 4, 4));
        } else if (type == 2 || type == 3) {
            this.addWarning(new DataTruncation(parameterIndex, true, true, -1, 4));
        }
        return TypeConverter.toInt(this.getFixedString(parameterIndex), type);
    }

    public long getLong(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -5, "long");
        int type = this.m_functionTypes[parameterIndex - 1];
        if (type == 6 || type == 8) {
            this.addWarning(new DataTruncation(parameterIndex, true, true, 8, 8));
        } else if (type == 7) {
            this.addWarning(new DataTruncation(parameterIndex, true, true, 4, 8));
        } else if (type == 2 || type == 3) {
            this.addWarning(new DataTruncation(parameterIndex, true, true, -1, 8));
        }
        return TypeConverter.toLong(this.getFixedString(parameterIndex), type);
    }

    public float getFloat(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 7, "Float");
        return TypeConverter.toFloat(this.getFixedString(parameterIndex), this.m_functionTypes[parameterIndex - 1]);
    }

    public double getDouble(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 8, "Double");
        return TypeConverter.toDouble(this.getFixedString(parameterIndex), this.m_functionTypes[parameterIndex - 1]);
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 3, "BigDecimal");
        return TypeConverter.toBigDecimal(this.getFixedString(parameterIndex), this.m_functionTypes[parameterIndex - 1], scale);
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkOutParameter(parameterIndex);
        this.checkIndex(parameterIndex, -3, "Bytes");
        if (this.checkNullValue(parameterIndex - 1)) {
            return null;
        }
        byte[] ret = (byte[])this.m_outValues[parameterIndex - 1];
        if (this.clientEncoding.equals(this.encoding)) {
            return TypeConverter.toBytes(this.connection, ret, this.m_functionTypes[parameterIndex - 1]);
        }
        return TypeConverter.toBytes(this.connection, this.clientEncoding.encode(this.encoding.decode(ret)), this.m_functionTypes[parameterIndex - 1]);
    }

    public java.sql.Date getDate(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 91, "Date");
        return TypeConverter.toDate(this.getFixedString(parameterIndex), this.m_functionTypes[parameterIndex - 1]);
    }

    public Time getTime(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 92, "Time");
        return TypeConverter.toTime(this.getFixedString(parameterIndex), this.m_functionTypes[parameterIndex - 1], this.localCalendar);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 93, "Timestamp");
        return TypeConverter.toTimestamp(this.getFixedString(parameterIndex), this.m_functionTypes[parameterIndex - 1], this.localCalendar);
    }

    public ResultSet getCursorResult(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, -10, "Refcursor");
        if (this.cursorResultMap.containsKey(parameterIndex)) {
            return this.cursorResultMap.get(parameterIndex);
        }
        OscarCursorResultSet cursorRs = new OscarCursorResultSet(this.getFixedString(parameterIndex), this.fetchSize, this.connection);
        this.cursorResultMap.put(parameterIndex, cursorRs);
        return cursorRs;
    }

    public Object getObject(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkProcedure(parameterIndex);
        this.checkOutParameter(parameterIndex);
        if (this.checkNullValue(parameterIndex - 1)) {
            this.setLastParameterIndex(parameterIndex);
            return null;
        }
        int index = this.outParameterIndex.indexOf(parameterIndex);
        int type = this.outParameterType.get(index);
        switch (type) {
            case -6: {
                return (int)this.getByte(parameterIndex);
            }
            case 5: {
                return (int)this.getShort(parameterIndex);
            }
            case 4: {
                return this.getInt(parameterIndex);
            }
            case -5: {
                return this.getLong(parameterIndex);
            }
            case 7: {
                return new Float(this.getFloat(parameterIndex));
            }
            case 6: 
            case 8: {
                return new Double(this.getDouble(parameterIndex));
            }
            case 2: 
            case 3: {
                this.checkIndex(parameterIndex, 3, "Decimal");
                return TypeConverter.toBigDecimal(this.getFixedString(parameterIndex), this.m_functionTypes[parameterIndex - 1]);
            }
            case -7: 
            case 16: {
                return this.getBoolean(parameterIndex);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(parameterIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(parameterIndex);
            }
            case 91: {
                return this.getDate(parameterIndex);
            }
            case 92: {
                return this.getTime(parameterIndex);
            }
            case 93: {
                return this.getTimestamp(parameterIndex);
            }
            case 2004: {
                return this.connection.getBlobInstance(new String((byte[])this.m_outValues[parameterIndex - 1]));
            }
            case 2005: {
                return this.connection.getClobInstance(new String((byte[])this.m_outValues[parameterIndex - 1]));
            }
            case -11: {
                return this.connection.getBfileInstance(new String((byte[])this.m_outValues[parameterIndex - 1]));
            }
            case -10: {
                return this.getCursorResult(parameterIndex);
            }
            case 2003: {
                return this.getStringArray(parameterIndex);
            }
        }
        return this.getFixedString(parameterIndex);
    }

    public String[] getStringArray(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, 2003, "String");
        return this.getFixedStringArray(parameterIndex);
    }

    protected String[] getFixedStringArray(int parameterIndex) throws SQLException {
        this.checkOutParameter(parameterIndex);
        if (this.checkNullValue(parameterIndex - 1)) {
            return null;
        }
        String tempString = this.encoding.decode((byte[])this.m_outValues[parameterIndex - 1]);
        return tempString.substring(1, tempString.length() - 1).split(",");
    }

    public String toString() {
        if (this.m_sqlFragments == null) {
            return super.toString();
        }
        StringBuffer tempBuf = new StringBuffer(32);
        for (int i = 0; i < this.m_binds.length; ++i) {
            tempBuf.append(this.m_sqlFragments[i]);
            if (this.m_binds[i] == null) {
                tempBuf.append('?');
                continue;
            }
            tempBuf.append(this.m_binds[i]);
        }
        tempBuf.append(this.m_sqlFragments[this.m_binds.length]);
        return tempBuf.toString();
    }

    protected void bind(int paramIndex, Object s, int type) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.m_binds.length) {
            throw new OSQLException("OSCAR-00305", "88888", 305);
        }
        if (paramIndex == 1 && this.isResultNeeded) {
            throw new OSQLException("OSCAR-00413", "88888", 413);
        }
        this.m_binds[paramIndex - 1] = s;
        this.m_binds_old[paramIndex - 1] = s;
        this.m_bindTypes[paramIndex - 1] = type;
    }

    protected void checkIndex(int parameterIndex, int type, String getName) throws SQLException {
        int checkType;
        this.checkProcedure(parameterIndex);
        if (this.isResultNeeded && parameterIndex == 1) {
            checkType = this.functionReturnType;
        } else {
            this.checkOutParameter(parameterIndex);
            int index = this.outParameterIndex.indexOf(parameterIndex);
            checkType = this.outParameterType.get(index);
        }
        if (!(type == checkType || type == -1 || type == 8 && checkType == 6 || type == 7 && checkType == 6 || type == -3 && (checkType == -2 || checkType == -4) || (type == 3 || type == -5 || type == 4 || type == 5 || type == 8 || type == -6) && checkType == 2 || type == 16 && checkType == -7 || type == 4 && checkType == 16)) {
            throw new OSQLException("OSCAR-00415", "88888", 415, new Object[]{checkType, type});
        }
        this.setLastParameterIndex(parameterIndex);
    }

    protected void checkProcedure(int parameterIndex) throws SQLException {
        if (!this.isCallable && !this.isAnonymous) {
            throw new SQLException("OSCAR-00416", "88888", 416);
        }
    }

    protected void checkOutParameter(int parameterIndex) throws SQLException {
        if (parameterIndex <= 0 || parameterIndex > this.m_functionTypes.length) {
            throw new OSQLException("OSCAR-00305", "88888", 305);
        }
        if (this.m_functionTypes[parameterIndex - 1] == 0) {
            throw new OSQLException("OSCAR-00417", "88888", 417);
        }
    }

    protected void setLastParameterIndex(int parameterIndex) {
        this.lastIndex = parameterIndex;
    }

    @Override
    public boolean useTid() {
        return this.tidUsed;
    }

    @Override
    public void setUseTid(boolean used) {
        this.tidUsed = used;
    }

    @Override
    public boolean isDDLSql() {
        return this.ddlSql;
    }

    @Override
    public boolean isPrepareAndNotRealPrepare() {
        return this.prepareAndNotRealPrepare;
    }

    @Override
    public void setPrepareAndNotRealPrepare(boolean prepareAndNotRealPrepare) {
        this.prepareAndNotRealPrepare = prepareAndNotRealPrepare;
    }

    @Override
    public void resetDDLSql(boolean ddl) {
        this.ddlSql = ddl;
    }

    @Override
    public int getAutoGeneratedInfo() {
        return this.autoGeneratedInfo;
    }

    @Override
    public void importValues(List<String> rows) {
        this.importRows = rows;
    }

    @Override
    public List<String> getImportValues() {
        return this.importRows;
    }

    @Override
    public void setTransferRowCount(int count) {
        this.transferCount = count;
    }

    @Override
    public int getTransferRowCount() {
        return this.transferCount;
    }

    @Override
    public boolean isResultNeeded() {
        return this.isCallable && this.isResultNeeded;
    }

    @Override
    public boolean isCursorUsed() {
        return this.m_statementIsCursor;
    }

    @Override
    public void addBatch(String o_sql) throws SQLException {
        if (this.stLogFlag || this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", addBatch(String o_sql), \n sql: " + o_sql);
        }
        this.checkClosed();
        if (this.batch == null) {
            this.batch = new LinkedList();
        }
        Object[] l_statement = new Object[]{new String[]{o_sql}, new Object[0], new String[0]};
        this.batch.add(l_statement);
        if (!this.addBatchUseSql) {
            this.addBatchUseSql = true;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed();
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", clearBatch()");
        }
        this.batch = null;
        this.hasEscapeChar = false;
        this.addBatchUseSql = false;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return CommonUtil.convertToInt(this.executeLargeBatch());
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkClosed();
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", executeBatch()");
        }
        if (this.useAsynBatch) {
            if (this.batchDataStream != null) {
                this.batchDataStream.finshed();
            }
            this.isBegin = false;
            return null;
        }
        if (this.batch == null) {
            return new long[0];
        }
        int size = this.batch.size();
        if (this.statementType == 2 && !this.outParameterType.isEmpty()) {
            throw new BatchUpdateException("oscar.call.outparam", "HY065", 1, new int[0]);
        }
        if (this.result != null) {
            this.result.close();
            this.result = null;
        }
        this.updateBatchCount = 0;
        long[] resultSize = new long[size];
        int i = 0;
        try {
            if (size > 0) {
                if (this.addBatchUseSql) {
                    String[] l_origSqlFragments = this.m_sqlFragments;
                    Object[] l_origBinds = this.m_binds;
                    for (Object[] l_statement : this.batch) {
                        this.m_sqlFragments = (String[])l_statement[0];
                        this.m_binds = (Object[])l_statement[1];
                        if (this.m_sqlFragments != null && this.m_sqlFragments.length == 1) {
                            OscarSqlProcessor.ParseResult parseResult = OscarSqlProcessor.parsingWithCheck(this.m_sqlFragments[0]);
                            this.selectSql = parseResult.isSelectSql();
                            this.insertSql = parseResult.isInsertSql();
                            this.isAnonymous = parseResult.isAnonymous();
                            if (this.isAnonymous && !this.m_sqlFragments[0].substring(0, 2).equalsIgnoreCase("DO")) {
                                this.m_sqlFragments[0] = "DO " + this.m_sqlFragments[0];
                            }
                        }
                        resultSize[i] = this.executeUpdate();
                        ++i;
                    }
                    this.m_sqlFragments = l_origSqlFragments;
                    this.m_binds = l_origBinds;
                } else {
                    if (this.m_bindTypes.length == 0) {
                        this.execute();
                        resultSize[0] = this.getUpdateCount();
                    } else {
                        if (this.batchPacket != null) {
                            this.batchPacket.init(this.batch, this.m_statementName, this.connection.getEncoding(), this.connection.getBatchBufferSize());
                        } else {
                            this.batchPacket = new BatchProcessPacket(this.batch, this.m_statementName, this.connection.getEncoding(), this.connection.getBatchBufferSize());
                        }
                        this.batchPacket.setConnection(this.connection);
                        this.getDBConnection().getQueryExecutor().executeBatch(this.batchPacket, (BaseStatement)this, resultSize);
                    }
                    if (this.result != null && this.result.reallyResultSet() && !this.isCallable && this.autoGeneratedInfo == -1) {
                        throw new OSQLException("OSCAR-00403", "88888", 403);
                    }
                }
            }
        }
        catch (SQLException e) {
            long[] resultSucceeded = null;
            if (this.addBatchUseSql) {
                resultSucceeded = new long[i];
                if (i > 1) {
                    System.arraycopy(resultSize, 0, resultSucceeded, 0, i);
                }
            } else {
                resultSucceeded = new long[this.updateBatchCount];
                System.arraycopy(resultSize, 0, resultSucceeded, 0, this.updateBatchCount);
            }
            this.checkConnectionClosed(e);
            throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), CommonUtil.convertToInt(resultSucceeded));
        }
        finally {
            if (this.batch != null) {
                this.batch.clear();
            }
            this.cleanEnvTemp();
        }
        this.addBatchUseSql = false;
        this.warnings = null;
        return resultSize;
    }

    public void executeBatchAsyn(List asynBatch) throws SQLException {
        this.checkClosed();
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", executeBatchAsyn(List asynBatch)");
        }
        if (asynBatch == null) {
            return;
        }
        int size = asynBatch.size();
        if (this.statementType == 2 && !this.outParameterType.isEmpty()) {
            throw new BatchUpdateException("oscar.call.outparam", "HY065", 1, new int[0]);
        }
        long[] resultSize = new long[asynBatch.size()];
        try {
            if (size > 0) {
                if (this.batchPacket != null) {
                    this.batchPacket.init(asynBatch, this.m_statementName, this.connection.getEncoding(), this.connection.getBatchBufferSize());
                } else {
                    this.batchPacket = new BatchProcessPacket(asynBatch, this.m_statementName, this.connection.getEncoding(), this.connection.getBatchBufferSize());
                }
                this.batchPacket.setConnection(this.connection);
                this.getDBConnection().getQueryExecutor().executeBatch(this.batchPacket, (BaseStatement)this, resultSize);
                if (this.result != null && this.result.reallyResultSet() && !this.isCallable && this.autoGeneratedInfo == -1) {
                    throw new OSQLException("OSCAR-00403", "88888", 403);
                }
            }
        }
        catch (SQLException e) {
            long[] resultSucceeded = new long[asynBatch.size()];
            System.arraycopy(resultSize, 0, resultSucceeded, 0, asynBatch.size());
            this.checkConnectionClosed(e);
            throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), CommonUtil.convertToInt(resultSucceeded));
        }
        finally {
            asynBatch.clear();
            this.cleanEnvTemp();
        }
        this.result = null;
        this.warnings = null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return (Connection)((Object)this.connection);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchdirection;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new OSQLException("OSCAR-00418", "88888", 418);
        }
        if (this.resultSetType == 1003 && direction != 1000) {
            throw new OSQLException("OSCAR-00418", "88888", 418);
        }
        this.fetchdirection = direction;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setFetchSize(int rows), fetchSize: " + rows);
        }
        if (rows < 0) {
            throw new OSQLException("OSCAR-00307", "88888", 307);
        }
        this.fetchSize = rows;
    }

    public void setResultSetConcurrency(int value) throws SQLException {
        this.resultSetConcurrency = value;
    }

    public void setResultSetType(int value) throws SQLException {
        this.resultSetType = value;
    }

    @Override
    public void setResultSetCanUpdateable(boolean value) throws SQLException {
        this.resultSetCanUpdateable = value;
    }

    public void addBatch() throws SQLException {
        this.checkClosed();
        Object[] l_newBinds = new Object[this.m_binds.length];
        int[] l_newBindTypes = new int[this.m_bindTypes.length];
        System.arraycopy(this.m_binds, 0, l_newBinds, 0, this.m_binds.length);
        System.arraycopy(this.m_bindTypes, 0, l_newBindTypes, 0, this.m_bindTypes.length);
        BatchRowData data = new BatchRowData(l_newBinds, l_newBindTypes, this.hasEscapeChar);
        if (this.useAsynBatch) {
            if (!this.isBegin) {
                this.isBegin = true;
                if (this.batchDataStream == null) {
                    this.batchDataStream = new BatchDataStream(this);
                } else {
                    this.batchDataStream.reInit();
                }
            }
            this.batchDataStream.addBatchData(data);
        } else {
            if (this.batch == null) {
                this.batch = new LinkedList();
            }
            this.batch.add(data);
            this.hasEscapeChar = false;
            if (this.addBatchUseSql) {
                this.addBatchUseSql = false;
            }
        }
        if (this.m_binds != null) {
            for (int i = 0; i < this.m_binds.length; ++i) {
                this.m_binds[i] = null;
                this.m_lobs[i] = null;
            }
        }
    }

    public void setArray(int i, Array x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(i, 12);
        } else {
            this.setString(i, x.toString());
        }
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.setObject(i, (Object)x);
    }

    public void setBfile(int i, OscarBfile x) throws SQLException {
        this.setObject(i, (Object)x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setAsciiStream(parameterIndex, x, Long.parseLong(String.valueOf(length)));
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, Long.parseLong(String.valueOf(length)));
    }

    public void setCharacterStream(int i, Reader x, int length) throws SQLException {
        this.setCharacterStream(i, x, Long.parseLong(String.valueOf(length)));
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.setObject(i, (Object)x);
    }

    public void setNull(int i, int t, String s) throws SQLException {
        this.setNull(i, t);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented();
    }

    public void setDate(int i, java.sql.Date d, Calendar cal) throws SQLException {
        this.checkClosed();
        if (cal == null) {
            this.setDate(i, d);
        } else {
            if (d == null) {
                this.setDate(i, null);
                return;
            }
            long user = cal.get(15) + cal.get(16);
            long system = this.systemCal.get(15) + this.systemCal.get(16);
            this.setDate(i, new java.sql.Date(d.getTime() + (system - user)));
        }
    }

    public void setTime(int i, Time t, Calendar cal) throws SQLException {
        this.checkClosed();
        if (cal == null) {
            this.setTime(i, t);
        } else {
            if (t == null) {
                this.setTime(i, null);
                return;
            }
            long user = cal.get(15) + cal.get(16);
            long system = this.systemCal.get(15) + this.systemCal.get(16);
            this.setTime(i, new Time(t.getTime() + (system - user)));
        }
    }

    public void setTimestamp(int i, Timestamp t, Calendar cal) throws SQLException {
        if (cal == null) {
            this.setTimestamp(i, t);
        } else {
            if (t == null) {
                this.setTimestamp(i, null);
                return;
            }
            long user = cal.get(15) + cal.get(16);
            long system = this.systemCal.get(15) + this.systemCal.get(16);
            Timestamp temp = new Timestamp(t.getTime() - (system - user));
            temp.setNanos(t.getNanos());
            this.setTimestamp(i, temp);
        }
    }

    public Array getArray(int i) throws SQLException {
        this.checkClosed();
        int found = this.outParameterIndex.indexOf(i) + 1;
        return this.result.getArray(found);
    }

    public OscarBfile getBfile(int parameterIndex) throws SQLException {
        this.checkOutParameter(parameterIndex);
        this.checkIndex(parameterIndex, -11, "bfile");
        if (this.m_functionTypes[parameterIndex - 1] != -11) {
            throw new OSQLException("OSCAR-00714", "88888", 714);
        }
        if (this.checkNullValue(parameterIndex - 1)) {
            return null;
        }
        return this.connection.getBfileInstance(new String((byte[])this.m_outValues[parameterIndex - 1]));
    }

    protected boolean checkNullValue(int index) {
        return this.m_outValues[index] == null;
    }

    public Blob getBlob(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkOutParameter(parameterIndex);
        this.checkIndex(parameterIndex, 2004, "blob");
        if (this.m_functionTypes[parameterIndex - 1] != 2004) {
            throw new OSQLException("OSCAR-00714", "88888", 714);
        }
        if (this.checkNullValue(parameterIndex - 1)) {
            return null;
        }
        return this.connection.getBlobInstance(new String((byte[])this.m_outValues[parameterIndex - 1]));
    }

    public Clob getClob(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkOutParameter(parameterIndex);
        this.checkIndex(parameterIndex, 2005, "clob");
        if (this.m_functionTypes[parameterIndex - 1] != 2005) {
            throw new OSQLException("OSCAR-00715", "88888", 715);
        }
        if (this.checkNullValue(parameterIndex - 1)) {
            return null;
        }
        return this.connection.getClobInstance(new String((byte[])this.m_outValues[parameterIndex - 1]));
    }

    public Object getObject(int i, Map map) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented();
    }

    public Ref getRef(int i) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented();
    }

    public java.sql.Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 91, "Date");
        return TypeConverter.toDate(this.getFixedString(parameterIndex), this.m_functionTypes[parameterIndex - 1], cal, this.systemCal);
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 92, "Time");
        return TypeConverter.toTime(this.getFixedString(parameterIndex), this.m_functionTypes[parameterIndex - 1], cal, this.systemCal);
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 93, "Timestamp");
        return TypeConverter.toTimestamp(this.getFixedString(parameterIndex), this.m_functionTypes[parameterIndex - 1], cal, this.systemCal);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented();
    }

    protected void setStatementType(int i) {
        this.statementType = i;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return false;
        }
        BaseResultSet rsTemp = (BaseResultSet)this.result.getNext();
        switch (current) {
            case 1: {
                this.result.close();
                break;
            }
            case 3: {
                this.result.close();
                this.result = (BaseResultSet)this.result.getPrevious();
                while (this.result != null) {
                    this.result.close();
                    this.result = (BaseResultSet)this.result.getPrevious();
                }
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new OSQLException("OSCAR-00419", "88888", 419);
            }
        }
        this.result = rsTemp;
        return this.result != null && this.result.reallyResultSet();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkClosed();
        try {
            return this.doGeneratedKeys();
        }
        catch (SQLException e) {
            this.checkConnectionClosed(e);
            throw e;
        }
    }

    public ResultSet doGeneratedKeys() throws SQLException {
        if (this.autoGeneratedInfo == -1) {
            throw new OSQLException("OSCAR-00420", "88888", 420);
        }
        if (this.result == null) {
            return null;
        }
        if (this.result.getStatusString() != null && !this.result.getStatusString().startsWith("21")) {
            return this.createResultSet(new Field[0], new ArrayList<byte[][]>(), null, 0L, 0L);
        }
        if (this.supportGeneratedKey && (this.autoGeneratedInfo == 3 || this.autoGeneratedInfo == 2 || this.autoGeneratedInfo == 1)) {
            if (this.autoGeneratedInfo == 1) {
                boolean isNull = false;
                List<byte[][]> datas = this.result.getTuples();
                for (int i = 0; i < datas.size(); ++i) {
                    byte[][] data = datas.get(i);
                    if (data instanceof byte[][]) {
                        if (data.length == 1 && data[0] == null) {
                            isNull = true;
                            break;
                        }
                        isNull = false;
                        continue;
                    }
                    isNull = false;
                }
                if (isNull) {
                    this.result.reInit(this.result.getFields(), new ArrayList<byte[][]>(), this.result.getStatusString(), 0L, this.result.getInsertRowid());
                }
            }
            this.result.setType(1004);
            return this.result;
        }
        Field field = this.result.getTidField();
        if (field == null) {
            if (this.firstField != null) {
                Driver.writeLog("Filed\u4e3a\u7a7a\u4e86,\u524d\u4e00\u4e2aField\u4e0d\u4e3a\u7a7a");
                field = this.firstField;
            } else {
                throw new OSQLException("OSCAR-00318", "88888", 318);
            }
        }
        String schemaName = field.getSchemaName();
        String tableName = field.getTableName();
        if (schemaName == null || tableName == null) {
            Driver.writeLog("schemaName\u6216\u8005tableName\u4e3a\u7a7a");
            if (this.firstField != null) {
                schemaName = this.firstField.getSchemaName();
                tableName = this.firstField.getTableName();
            } else {
                throw new OSQLException("OSCAR-00318", "88888", 318);
            }
        }
        StringBuffer sql = new StringBuffer(128);
        StringBuffer temp = new StringBuffer(64);
        long insertOID = this.result.getInsertRowid();
        temp.append("ROWID = ").append(insertOID);
        if (this.autoGeneratedInfo == 0) {
            sql.append("SELECT ROWID FROM " + OscarStatement.getFullName(schemaName, tableName) + " WHERE 1 = 0");
        } else if (this.autoGeneratedInfo == 1) {
            String mapKey = schemaName + "." + tableName;
            String generatedKey = this.generatedKeyMap.get(mapKey);
            if (generatedKey == null) {
                String tmp = "SELECT B.ATTNAME FROM INFO_SCHEM.V_SYS_ATTRIBUTE B WHERE B.ATTISAUTO=TRUE AND B.ATTRELID=(SELECT GETRELOID('" + schemaName + "','" + tableName + "'))";
                BaseResultSet rs = null;
                try {
                    rs = this.connection.execSQL(tmp.toString());
                }
                catch (SQLException e) {
                    if (e.getMessage().contains("ATTAUTOINC\" not found")) {
                        throw new OSQLException("OSCAR-00431", "88888", 431);
                    }
                    throw e;
                }
                if (rs.next()) {
                    generatedKey = rs.getString(1);
                    this.generatedKeyMap.put(mapKey, generatedKey);
                } else {
                    return this.createResultSet(new Field[0], new ArrayList<byte[][]>(), null, 0L, 0L);
                }
            }
            sql.append("SELECT \"" + generatedKey + "\" FROM " + OscarStatement.getFullName(schemaName, tableName) + " WHERE ");
            sql.append(temp);
        } else if (this.autoGeneratedInfo == 2) {
            int i;
            BaseResultSet base = this.connection.execSQL("SELECT * FROM " + OscarStatement.getFullName(schemaName, tableName) + " WHERE 1 = 0");
            Field[] fields = base.getFields();
            String[] fieldNames = new String[this.columnIndex.length];
            for (i = 0; i < fieldNames.length; ++i) {
                try {
                    fieldNames[i] = fields[this.columnIndex[i] - 1].getName();
                    continue;
                }
                catch (Exception e) {
                    throw new OSQLException("OSCAR-00304", "88888", 304);
                }
            }
            sql.append("SELECT ");
            for (i = 0; i < this.columnIndex.length; ++i) {
                if (i == 0) {
                    sql.append("\"" + fieldNames[i] + "\"");
                    continue;
                }
                sql.append(",");
                sql.append("\"" + fieldNames[i] + "\"");
            }
            sql.append(" FROM " + OscarStatement.getFullName(schemaName, tableName) + " WHERE ");
            sql.append(temp);
        } else {
            sql.append("SELECT ");
            for (int i = 0; i < this.columnName.length; ++i) {
                if (i == 0) {
                    sql.append(this.columnName[i]);
                    continue;
                }
                sql.append(",");
                sql.append(this.columnName[i]);
            }
            sql.append(" FROM " + OscarStatement.getFullName(schemaName, tableName) + " WHERE ");
            sql.append(temp);
        }
        return this.connection.execSQL(sql.toString());
    }

    private static String getFullName(String schemaName, String tableName) {
        return "\"" + schemaName + "\".\"" + tableName + "\"";
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return CommonUtil.convertToInt(this.getLargeUpdateCount());
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return -1L;
        }
        if (this.result.reallyResultSet()) {
            if (this.result.getStatusString() != null && this.result.getStatusString().startsWith("21")) {
                return this.result.getResultCount();
            }
            if (!this.connection.isCompatibleOracle()) {
                return -1L;
            }
            if (this.result.next()) {
                try {
                    return this.result.getLong(1);
                }
                catch (SQLException e) {
                    return -1L;
                }
            }
            return -1L;
        }
        return this.result.getResultCount();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return CommonUtil.convertToInt(this.executeLargeUpdate(sql, autoGeneratedKeys));
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.stLogFlag || this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", executeUpdate(String sql, int autoGeneratedKeys), \n sql: " + sql + ", autoGeneratedKeys: " + autoGeneratedKeys);
        }
        if (autoGeneratedKeys == 2) {
            this.autoGeneratedInfo = 0;
        } else if (autoGeneratedKeys == 1) {
            this.autoGeneratedInfo = 1;
        } else {
            throw new OSQLException("OSCAR-00210", "88888", 210);
        }
        return this.executeLargeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return CommonUtil.convertToInt(this.executeLargeUpdate(sql, columnIndexes));
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (this.stLogFlag || this.logFlag) {
            StringBuilder sb = new StringBuilder(30);
            sb.append(OscarStatement.class).append(", executeUpdate(String sql, int columnIndexes[]), \n sql: ");
            sb.append(sql).append(", columnIndexes: ");
            if (columnIndexes == null) {
                sb.append("null");
            } else {
                for (int i = 0; i < columnIndexes.length; ++i) {
                    sb.append(columnIndexes[i]).append(" ");
                }
            }
            Driver.writeLog(this.sessionId, this.pid, sb.toString());
        }
        this.autoGeneratedInfo = 2;
        if (columnIndexes != null) {
            this.columnIndex = new int[columnIndexes.length];
            for (int i = 0; i < columnIndexes.length; ++i) {
                this.columnIndex[i] = columnIndexes[i];
            }
        }
        return this.executeLargeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return CommonUtil.convertToInt(this.executeLargeUpdate(sql, columnNames));
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        if (this.stLogFlag || this.logFlag) {
            StringBuilder sb = new StringBuilder(20);
            sb.append(OscarStatement.class).append(", executeUpdate(String sql, String columnNames[]), \n sql: ");
            sb.append(sql).append(", columnNames: ");
            if (columnNames == null) {
                sb.append("null");
            } else {
                for (int i = 0; i < columnNames.length; ++i) {
                    sb.append(columnNames[i]).append(" ");
                }
            }
            Driver.writeLog(this.sessionId, this.pid, sb.toString());
        }
        this.autoGeneratedInfo = 3;
        if (columnNames != null) {
            this.columnName = new String[columnNames.length];
            for (int i = 0; i < columnNames.length; ++i) {
                this.columnName[i] = columnNames[i];
            }
        }
        return this.executeLargeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.stLogFlag || this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", execute(String sql, int autoGeneratedKeys), \n sql: " + sql + ", autoGeneratedKeys: " + autoGeneratedKeys);
        }
        if (autoGeneratedKeys == 2) {
            this.autoGeneratedInfo = 0;
        } else if (autoGeneratedKeys == 1) {
            this.autoGeneratedInfo = 1;
        } else {
            throw new OSQLException("OSCAR-00210", "88888", 210);
        }
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (this.stLogFlag || this.logFlag) {
            StringBuilder sb = new StringBuilder(20);
            sb.append(OscarStatement.class).append(", execute(String sql, int columnIndexes[]), \n sql: ");
            sb.append(sql).append(", columnIndexes: ");
            if (columnIndexes == null) {
                sb.append("null");
            } else {
                for (int i = 0; i < columnIndexes.length; ++i) {
                    sb.append(columnIndexes[i]).append(" ");
                }
            }
            Driver.writeLog(this.sessionId, this.pid, sb.toString());
        }
        this.autoGeneratedInfo = 2;
        if (columnIndexes != null) {
            this.columnIndex = new int[columnIndexes.length];
            for (int i = 0; i < columnIndexes.length; ++i) {
                this.columnIndex[i] = columnIndexes[i];
            }
        }
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (this.stLogFlag || this.logFlag) {
            StringBuilder sb = new StringBuilder(20);
            sb.append(OscarStatement.class).append(", execute(String sql, String columnNames[]), \n sql: ");
            sb.append(sql).append(", columnNames: ");
            if (columnNames == null) {
                sb.append("null");
            } else {
                for (int i = 0; i < columnNames.length; ++i) {
                    sb.append(columnNames[i]).append(" ");
                }
            }
            Driver.writeLog(this.sessionId, this.pid, sb.toString());
        }
        this.autoGeneratedInfo = 3;
        if (columnNames != null) {
            this.columnName = new String[columnNames.length];
            for (int i = 0; i < columnNames.length; ++i) {
                this.columnName[i] = columnNames[i];
            }
        }
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkClosed();
        return this.resultSetHoldability;
    }

    public void setResultSetHoldability(int holdability) throws SQLException {
        this.resultSetHoldability = holdability;
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        if (this.m_statementName == null) {
            throw new OSQLException("OSCAR-00421", "88888", 421);
        }
        if (this.pMetaData != null) {
            return this.pMetaData;
        }
        throw new OSQLException("OSCAR-00421", "88888", 421);
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.registerOutParameter(index, sqlType);
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.registerOutParameter(index, sqlType, typeName);
    }

    public URL getURL(int parameterIndex) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented();
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setURL(index, val);
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setNull(index, sqlType);
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setBoolean(index, x);
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setByte(index, x);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setShort(index, x);
    }

    public void setInt(String parameterName, int x) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setInt(index, x);
    }

    public void setLong(String parameterName, long x) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setLong(index, x);
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setFloat(index, x);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setDouble(index, x);
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setBigDecimal(index, x);
    }

    public void setString(String parameterName, String x) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setString(index, x);
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setBytes(index, x);
    }

    public void setDate(String parameterName, java.sql.Date x) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setDate(index, x);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setTime(index, x);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setTimestamp(index, x);
    }

    public void setAsciiStream(String parameterName, InputStream inputStream, int length) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setAsciiStream(index, inputStream, length);
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setBinaryStream(index, x, length);
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setObject(index, x, targetSqlType, scale);
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setObject(index, x, targetSqlType);
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setObject(index, x);
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setCharacterStream(index, reader, length);
    }

    public void setDate(String parameterName, java.sql.Date x, Calendar cal) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setDate(index, x, cal);
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setTime(index, x, cal);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setTimestamp(index, x, cal);
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setNull(index, sqlType, typeName);
    }

    public String getString(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getString(index);
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getBoolean(index);
    }

    public byte getByte(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getByte(index);
    }

    public short getShort(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getShort(index);
    }

    public int getInt(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getInt(index);
    }

    public long getLong(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getLong(index);
    }

    public float getFloat(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getFloat(index);
    }

    public double getDouble(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getDouble(index);
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getBytes(index);
    }

    public java.sql.Date getDate(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getDate(index);
    }

    public Time getTime(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getTime(index);
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getTimestamp(index);
    }

    public Object getObject(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getObject(index);
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getObject(index, map);
    }

    public Ref getRef(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getRef(index);
    }

    public OscarBfile getBfile(String parameterName) throws SQLException {
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getBfile(index);
    }

    public Blob getBlob(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getBlob(index);
    }

    public Clob getClob(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getClob(index);
    }

    public Array getArray(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getArray(index);
    }

    public java.sql.Date getDate(String parameterName, Calendar cal) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getDate(index, cal);
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getTime(index, cal);
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getTimestamp(index, cal);
    }

    public URL getURL(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getURL(index);
    }

    protected void setAutoGeneratedInfo(int info) {
        this.autoGeneratedInfo = info;
    }

    protected void setAutoGeneratedIndexes(int[] indexes) {
        this.columnIndex = indexes;
    }

    protected void setAutoGeneratedNames(String[] names) {
        this.columnName = names;
    }

    @Override
    public BaseResultSet createResultSet(Field[] fields, List<byte[][]> tuples, String status, long updateCount, long insertOID) throws SQLException {
        return OscarResultSet.getInstance(this, fields, tuples, status, updateCount, insertOID, this.fetchSize, this.maxrows);
    }

    @Override
    public BaseResultSet createResultSet(Field[] fields, List<byte[][]> tuples, String status, long updateCount, long insertOID, int dataKind) throws SQLException {
        return OscarResultSet.getInstanceDataKind(this, fields, tuples, status, updateCount, insertOID, dataKind, this.maxrows, dataKind);
    }

    @Override
    public int getStatementType() {
        return this.statementType;
    }

    @Override
    public void setResultSet(BaseResultSet resultset) {
        this.result = resultset;
    }

    @Override
    public void setUpdateBatchSize(int updateBatchSize) {
        this.updateBatchCount = updateBatchSize;
    }

    public byte[] backupKstore(String queryStr) throws SQLException {
        return this.getDBConnection().getQueryExecutor().backupKstore(queryStr, this);
    }

    public byte[] getNextPhysicalDataRow() throws SQLException {
        return this.getDBConnection().getQueryExecutor().getNextPhysicalDataRow(this);
    }

    public void restoreKstore(String queryStr, byte[] metaData, byte[] physicalData) throws SQLException {
        this.getDBConnection().getQueryExecutor().restoreKstore(queryStr, metaData, physicalData, this);
    }

    public PartitionInfo getPartitionInfo(String tableName) throws SQLException {
        String partType1;
        String version;
        PartitionInfo partitionInfo = new PartitionInfo();
        String queryStr = "select TABLE_TYPE from tables where TABLE_NAME = '" + tableName + "'";
        ResultSet rs = this.executeQuery(queryStr);
        if (rs.next()) {
            String tableType = rs.getString("TABLE_TYPE");
            if (tableType != null && tableType.equalsIgnoreCase("KSTORE")) {
                partitionInfo.setTableType(1);
            } else {
                partitionInfo.setTableType(0);
            }
        }
        rs.close();
        queryStr = "select version()";
        rs = this.executeQuery(queryStr);
        boolean isNewVersion = true;
        boolean hasSubPartition = false;
        if (rs.next() && (version = rs.getString("VERSION")) != null && !"".equals(version) && version.startsWith("ShenTong KSTORE")) {
            isNewVersion = false;
        }
        rs.close();
        if (isNewVersion) {
            queryStr = "select PARTTYPE1, PARTTYPE2 from v_sys_PART_TABLES where relname='" + tableName + "' order by OID";
            rs = this.executeQuery(queryStr);
            if (rs.next()) {
                partType1 = rs.getString("PARTTYPE1");
                partitionInfo.setPartType(this.parsePartType(partType1));
                String partType2 = rs.getString("PARTTYPE2");
                partitionInfo.setSubPartType(this.parsePartType(partType2));
                rs.close();
                queryStr = "select PARTNAME from v_sys_tab_partitions where relname='" + tableName + "' order by OID";
                rs = this.executeQuery(queryStr);
                ArrayList<String> partNamesArr = new ArrayList<String>();
                while (rs.next()) {
                    partNamesArr.add(rs.getString("PARTNAME"));
                }
                partitionInfo.setPartNames(partNamesArr);
                rs.close();
                if (partType2 != null && !"".equals(partType2) && partNamesArr.size() > 0) {
                    Hashtable subPartNames = new Hashtable();
                    for (int i = 0; i < partNamesArr.size(); ++i) {
                        String partName = ((String)partNamesArr.get(i)).toString();
                        ArrayList<String> subPartNamesArr = new ArrayList<String>();
                        queryStr = "select SUBPARTNAME from v_sys_tab_subpartitions where relname='" + tableName + "' and partname='" + partName + "' order by OID";
                        rs = this.executeQuery(queryStr);
                        while (rs.next()) {
                            subPartNamesArr.add(rs.getString("SUBPARTNAME"));
                            if (hasSubPartition) continue;
                            hasSubPartition = true;
                        }
                        subPartNames.put(partName, subPartNamesArr);
                    }
                    partitionInfo.setSubPartNames(subPartNames);
                }
                rs.close();
            }
        } else {
            queryStr = "select TABLE_ID, PARTITION_TYPE from v_sys_PART_TABLES where TABLE_NAME='" + tableName + "' order by TABLE_ID";
            rs = this.executeQuery(queryStr);
            if (rs.next()) {
                partType1 = rs.getString("PARTITION_TYPE");
                partitionInfo.setPartType(partType1);
                String tableId = rs.getString("TABLE_ID");
                rs.close();
                queryStr = "select PARTITION_NAME from v_sys_tab_partitions where TABLE_ID=" + tableId + " order by TABLE_ID";
                rs = this.executeQuery(queryStr);
                ArrayList<String> partNamesArr = new ArrayList<String>();
                while (rs.next()) {
                    partNamesArr.add(rs.getString("PARTITION_NAME"));
                }
                partitionInfo.setPartNames(partNamesArr);
                rs.close();
                if (partNamesArr.size() > 0) {
                    Hashtable subPartNames = new Hashtable();
                    String subPartType = "";
                    for (int i = 0; i < partNamesArr.size(); ++i) {
                        String partName = ((String)partNamesArr.get(i)).toString();
                        ArrayList<String> subPartNamesArr = new ArrayList<String>();
                        queryStr = " select PARTITION_NAME, PARTITION_TYPE from v_sys_tab_partitions t where t.table_id=(select table_id from v_sys_part_tables where table_name='" + partName + "') order by TABLE_ID";
                        rs = this.executeQuery(queryStr);
                        while (rs.next()) {
                            subPartNamesArr.add(rs.getString("PARTITION_NAME"));
                            subPartType = rs.getString("PARTITION_TYPE");
                            if (hasSubPartition) continue;
                            hasSubPartition = true;
                        }
                        subPartNames.put(partName, subPartNamesArr);
                        rs.close();
                    }
                    partitionInfo.setSubPartType(subPartType);
                    partitionInfo.setSubPartNames(subPartNames);
                }
            }
        }
        if (hasSubPartition) {
            partitionInfo.setPartitionLevel(2);
        } else if (partitionInfo.getPartNames() != null && partitionInfo.getPartNames().size() > 0) {
            partitionInfo.setPartitionLevel(1);
        }
        return partitionInfo;
    }

    protected Character getRelKind(int tableOid) throws SQLException {
        char relKind = 'r';
        String queryStr = "select relkind from v_sys_class where oid = " + tableOid;
        BaseResultSet rSet = this.connection.execSQL(queryStr);
        if (rSet != null && rSet.next()) {
            relKind = rSet.getString(1).charAt(0);
        }
        if (rSet != null) {
            rSet.close();
        }
        return Character.valueOf(relKind);
    }

    private String parsePartType(String srcType) {
        if (srcType != null && !"".equals(srcType.trim())) {
            if (srcType.equals("1")) {
                return "RANGE";
            }
            if (srcType.equals("2")) {
                return "LIST";
            }
            if (srcType.equals("3")) {
                return "HASH";
            }
            if (srcType.equals("4")) {
                return "INTERVAL";
            }
        }
        return null;
    }

    @Override
    public Field[] getFields() {
        return null;
    }

    @Override
    public void setFields(Field[] fields) {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkClosed();
        return this.poolable;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkClosed();
        this.poolable = poolable;
    }

    public void setBatchCount(int batchCount) {
        this.batchCount = batchCount;
    }

    public int getBatchCount() {
        return this.batchCount;
    }

    public void setUseAsynBatch(boolean useAsynBatch) {
        this.useAsynBatch = useAsynBatch;
    }

    public boolean isUseAsynBatch() {
        return this.useAsynBatch;
    }

    @Override
    public int getBuckets() {
        return this.buckets;
    }

    @Override
    public void setBuckets(int buckets) {
        this.buckets = buckets;
    }

    public String getSql() {
        return this.osql;
    }

    @Override
    public void setPrint(boolean print) {
        this.print = print;
    }

    @Override
    public boolean isPrint() {
        return this.print;
    }

    @Override
    public String getSQL() {
        return this.osql;
    }

    @Override
    public boolean isNotRealPrepare() {
        return this.notRealPrepare;
    }

    protected boolean isNotSupportPrePare() {
        return this.isAnonymous && !this.anonymousSupportPrepare;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkClosed();
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public void setRowId(int paramInt, RowId paramRowId) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setClob(int parameterIndex, Reader paramReader, long length) throws SQLException {
        this.checkClosed();
        if (paramReader == null) {
            this.setNull(parameterIndex, 2005);
            return;
        }
        if (length < 0L) {
            throw new SQLException("Invalid stream length " + Long.valueOf(length));
        }
        this.setCharacterStream(parameterIndex, paramReader, length);
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkClosed();
        if (inputStream == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        if (length < 0L) {
            throw new SQLException("Invalid stream length " + Long.valueOf(length));
        }
        this.setBinaryStream(parameterIndex, inputStream, length);
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.checkClosed();
        if (xmlObject == null) {
            this.setNull(parameterIndex, 2009);
        } else {
            String data = xmlObject.getString();
            if (data == null) {
                this.setNull(parameterIndex, 2009);
            } else {
                this.setString(parameterIndex, data, 24);
            }
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        switch (this.pMetaData.getParameterType(parameterIndex)) {
            case -1: 
            case 1: 
            case 12: {
                try {
                    if (x == null) {
                        this.setString(parameterIndex, null);
                        break;
                    }
                    int len = -1;
                    len = length > Integer.MAX_VALUE || length == -1L ? 8001 : (int)length;
                    InputStreamReader l_inStream = new InputStreamReader(x, "US-ASCII");
                    char[] l_chars = new char[len];
                    int l_charsRead = l_inStream.read(l_chars, 0, len);
                    this.setString(parameterIndex, new String(l_chars, 0, l_charsRead), 0);
                    break;
                }
                catch (UnsupportedEncodingException l_uee) {
                    throw new OSQLException("OSCAR-00302", "88888", 302, l_uee.getMessage(), l_uee);
                }
                catch (IOException l_ioe) {
                    throw new OSQLException("OSCAR-00302", "88888", 302, l_ioe.getMessage(), l_ioe);
                }
            }
            case 2005: {
                if (x == null) {
                    this.setObject(parameterIndex, null);
                    this.m_lobs[parameterIndex - 1] = null;
                } else {
                    OscarClob clob = null;
                    if (this.pMetaData.getParameterRelOid(parameterIndex) != 0) {
                        int tableOid = this.pMetaData.getParameterRelOid(parameterIndex);
                        int colIndex = this.pMetaData.getParameterRelColIndex(parameterIndex);
                        clob = OscarClob.createForTable(this.getConnection(), tableOid, colIndex);
                    } else {
                        clob = ((OscarJdbc2Connection)this.connection).createClob();
                    }
                    if (length > 0L && length <= Integer.MAX_VALUE) {
                        try {
                            clob.write(1L, x, length);
                        }
                        catch (Exception ex) {
                            this.m_lobs[parameterIndex - 1] = null;
                        }
                    } else {
                        OutputStream ostream = clob.setAsciiStream(1L);
                        try {
                            byte[] buf = new byte[this.bufSize];
                            int readLen = 0;
                            while ((readLen = x.read(buf, 0, this.bufSize)) > 0) {
                                ostream.write(buf, 0, readLen);
                            }
                            ostream.flush();
                            ostream.close();
                        }
                        catch (Exception ex) {
                            this.m_lobs[parameterIndex - 1] = null;
                        }
                    }
                    this.setObject(parameterIndex, (Object)clob);
                    this.m_lobs[parameterIndex - 1] = clob;
                }
                if (this.m_lobs[parameterIndex - 1] == null || !this.m_lobs[parameterIndex - 1].isTempLob() && !this.m_lobs[parameterIndex - 1].isTableIdLob()) break;
                this.tempResource.add(this.m_lobs[parameterIndex - 1]);
                break;
            }
            default: {
                throw new OSQLException("OSCAR-00410", "88888", 410);
            }
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int type = this.pMetaData.getParameterType(parameterIndex);
        switch (type) {
            case -4: 
            case -3: 
            case -2: {
                int l_bytesRead;
                int len = -1;
                len = length > Integer.MAX_VALUE || length == -1L ? 8001 : (int)length;
                byte[] l_bytes = new byte[len];
                try {
                    if (x == null) {
                        this.setBytes(parameterIndex, null);
                        return;
                    }
                    l_bytesRead = x.read(l_bytes, 0, len);
                }
                catch (IOException l_ioe) {
                    throw new OSQLException("OSCAR-00410", "88888", 410, l_ioe.getMessage(), l_ioe);
                }
                if ((long)l_bytesRead == length) {
                    this.setBytes(parameterIndex, l_bytes);
                    break;
                }
                byte[] l_bytes2 = new byte[l_bytesRead];
                System.arraycopy(l_bytes, 0, l_bytes2, 0, l_bytesRead);
                this.setBytes(parameterIndex, l_bytes2);
                break;
            }
            case 2004: {
                OscarBlob blob = null;
                int tableOid = this.pMetaData.getParameterRelOid(parameterIndex);
                if (tableOid != 0) {
                    Character tableType = this.tableTypes.get(tableOid);
                    if (tableType == null) {
                        tableType = this.getRelKind(tableOid);
                        this.tableTypes.put(tableOid, tableType);
                    }
                    if (tableType.charValue() == 'r') {
                        int colIndex = this.pMetaData.getParameterRelColIndex(parameterIndex);
                        blob = OscarBlob.createForTable(this.getConnection(), tableOid, colIndex);
                    } else {
                        blob = ((OscarJdbc2Connection)this.connection).createBlob();
                    }
                } else {
                    blob = ((OscarJdbc2Connection)this.connection).createBlob();
                }
                if (length > 0L && length <= Integer.MAX_VALUE) {
                    try {
                        blob.write(1L, x, length);
                    }
                    catch (SQLException ex) {
                        this.m_lobs[parameterIndex - 1] = null;
                        throw ex;
                    }
                }
                OutputStream ostream = blob.setBinaryStream(1L);
                try {
                    byte[] buf = new byte[this.bufSize];
                    int readLen = 0;
                    while ((readLen = x.read(buf, 0, this.bufSize)) > 0) {
                        ostream.write(buf, 0, readLen);
                    }
                    ostream.flush();
                    ostream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.m_lobs[parameterIndex - 1] = null;
                }
                this.setObject(parameterIndex, (Object)blob);
                this.m_lobs[parameterIndex - 1] = blob;
                if (this.m_lobs[parameterIndex - 1] == null || !this.m_lobs[parameterIndex - 1].isTempLob() && !this.m_lobs[parameterIndex - 1].isTableIdLob()) break;
                this.tempResource.add(this.m_lobs[parameterIndex - 1]);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                try {
                    int readLength = (int)length;
                    byte[] bytes = new byte[readLength];
                    x.read(bytes, 0, readLength);
                    this.setString(parameterIndex, OSCARbyte.toOSCARString(bytes), 0);
                    break;
                }
                catch (Exception e) {
                    throw new OSQLException("OSCAR-00410", "88888", 410);
                }
            }
            default: {
                throw new OSQLException("OSCAR-00410", "88888", 410);
            }
        }
    }

    public void setCharacterStream(int i, Reader x, long length) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        switch (this.pMetaData.getParameterType(i)) {
            case -1: 
            case 1: 
            case 12: {
                try {
                    if (x == null) {
                        this.setString(i, null);
                        break;
                    }
                    if (length == -1L) {
                        int n;
                        char[] l_chars = new char[1024];
                        StringBuffer data = new StringBuffer(200);
                        int max_length = 0x1000000;
                        for (int l_charsRead = 0; (n = x.read(l_chars)) != -1 && l_charsRead < max_length; l_charsRead += n) {
                            data.append(new String(l_chars, 0, n));
                        }
                        this.setString(i, data.toString());
                        break;
                    }
                    int len = (int)length;
                    char[] l_chars = new char[len];
                    int l_charsRead = x.read(l_chars, 0, len);
                    this.setString(i, new String(l_chars, 0, l_charsRead));
                    break;
                }
                catch (IOException l_ioe) {
                    throw new OSQLException("OSCAR-00311", "88888", 311, l_ioe.getMessage(), l_ioe);
                }
            }
            case 2005: {
                if (x == null) {
                    this.setObject(i, null);
                    this.m_lobs[i - 1] = null;
                } else {
                    OscarClob clob = null;
                    int tableOid = this.pMetaData.getParameterRelOid(i);
                    if (tableOid != 0) {
                        Character tableType = this.tableTypes.get(tableOid);
                        if (tableType == null) {
                            tableType = this.getRelKind(tableOid);
                            this.tableTypes.put(tableOid, tableType);
                        }
                        if (tableType.charValue() == 'r') {
                            int colIndex = this.pMetaData.getParameterRelColIndex(i);
                            clob = OscarClob.createForTable(this.getConnection(), tableOid, colIndex);
                        } else {
                            clob = ((OscarJdbc2Connection)this.connection).createClob();
                        }
                    } else {
                        clob = ((OscarJdbc2Connection)this.connection).createClob();
                    }
                    if (length > 0L && length < Integer.MAX_VALUE) {
                        try {
                            clob.write(1L, x, length);
                        }
                        catch (Exception e) {
                            this.m_lobs[i - 1] = null;
                        }
                    } else {
                        Writer ostream = clob.setCharacterStream(1L);
                        try {
                            char[] buf = new char[this.bufSize];
                            int readLen = 0;
                            while ((readLen = x.read(buf, 0, this.bufSize)) > 0) {
                                ostream.write(buf, 0, readLen);
                            }
                            ostream.flush();
                            ostream.close();
                        }
                        catch (Exception ex) {
                            this.m_lobs[i - 1] = null;
                        }
                    }
                    this.setObject(i, (Object)clob);
                    this.m_lobs[i - 1] = clob;
                }
                if (this.m_lobs[i - 1] == null || !this.m_lobs[i - 1].isTempLob() && !this.m_lobs[i - 1].isTableIdLob()) break;
                this.tempResource.add(this.m_lobs[i - 1]);
                break;
            }
            default: {
                throw new OSQLException("OSCAR-00410", "88888", 410);
            }
        }
    }

    public void setAsciiStream(int paramInt, InputStream paramInputStream) throws SQLException {
        this.setAsciiStream(paramInt, paramInputStream, -1);
    }

    public void setBinaryStream(int paramInt, InputStream paramInputStream) throws SQLException {
        this.setBinaryStream(paramInt, paramInputStream, -1);
    }

    public void setCharacterStream(int paramInt, Reader paramReader) throws SQLException {
        this.setCharacterStream(paramInt, paramReader, -1);
    }

    public void setClob(int paramInt, Reader paramReader) throws SQLException {
        this.setCharacterStream(paramInt, paramReader);
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setBinaryStream(parameterIndex, inputStream, -1);
    }

    public RowId getRowId(int paramInt) throws SQLException {
        throw Driver.notImplemented();
    }

    public RowId getRowId(String paramString) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setRowId(String paramString, RowId paramRowId) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setClob(String parameterName, Reader paramReader, long paramLong) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setClob(index, paramReader, paramLong);
    }

    public void setBlob(String parameterName, InputStream paramInputStream, long paramLong) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setBlob(index, paramInputStream, paramLong);
    }

    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setSQLXML(index, xmlObject);
    }

    public SQLXML getSQLXML(int paramInt) throws SQLException {
        this.checkClosed();
        this.checkIndex(paramInt, 2009, "String");
        String data = this.getFixedString(paramInt);
        if (data == null) {
            return null;
        }
        return new OscarSQLXML(this.connection, data);
    }

    public SQLXML getSQLXML(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getSQLXML(index);
    }

    public Reader getCharacterStream(int i) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        switch (this.pMetaData.getParameterType(i)) {
            case -1: 
            case 1: 
            case 12: {
                return new StringReader(this.getFixedString(i));
            }
            case 2005: {
                return this.getClob(i).getCharacterStream();
            }
        }
        throw new OSQLException("OSCAR-00410", "88888", 410);
    }

    public Reader getCharacterStream(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getCharacterStream(index);
    }

    public void setBlob(String parameterName, Blob paramBlob) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setBlob(index, paramBlob);
    }

    public void setClob(String parameterName, Clob paramClob) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setClob(index, paramClob);
    }

    public void setAsciiStream(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setAsciiStream(index, inputStream, length);
    }

    public void setBinaryStream(String parameterName, InputStream paramInputStream, long paramLong) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setBinaryStream(index, paramInputStream, paramLong);
    }

    public void setCharacterStream(String parameterName, Reader paramReader, long paramLong) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setCharacterStream(index, paramReader, paramLong);
    }

    public void setAsciiStream(String paramString, InputStream paramInputStream) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(paramString);
        this.setAsciiStream(index, paramInputStream);
    }

    public void setBinaryStream(String parameterName, InputStream paramInputStream) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setBinaryStream(index, paramInputStream);
    }

    public void setCharacterStream(String parameterName, Reader paramReader) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setCharacterStream(index, paramReader);
    }

    public void setClob(String parameterName, Reader paramReader) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setClob(index, paramReader);
    }

    public void setBlob(String parameterName, InputStream paramInputStream) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setBlob(index, paramInputStream);
    }

    public void setNClob(String paramString, Reader paramReader) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkClosed();
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkClosed();
        return this.closeOnCompletion;
    }

    @Override
    public void checkAndPerformCloseOnCompletionAction() throws SQLException {
        if (this.isCloseOnCompletion() && (this.result == null || this.result.isClosed())) {
            this.close();
        }
    }

    protected static OscarPreparedStatement getPreparedInstance(OscarJdbc2Connection connection, String sql) throws SQLException {
        if (OscarJDBCUtil.isEqualOrGreaterJdbc42()) {
            return (OscarPreparedStatement)OscarJDBCUtil.handleNewInstance(JDBC_4_PSTMT_ARG, new Object[]{connection, sql});
        }
        return new OscarPreparedStatement(connection, sql);
    }

    protected static OscarPreparedStatementV2 getPreparedInstanceV2(OscarJdbc2Connection connection, String sql) throws SQLException {
        if (OscarJDBCUtil.isEqualOrGreaterJdbc42()) {
            return (OscarPreparedStatementV2)OscarJDBCUtil.handleNewInstance(JDBC_4_PSTMT_ARG_V2, new Object[]{connection, sql});
        }
        return new OscarPreparedStatementV2(connection, sql);
    }

    protected void releaseResources() {
        if (this.isCallable && this.result != null) {
            this.releaseRetrunResources();
            if (this.outParameterIndex.size() > 0) {
                for (int i = 0; i < this.outParameterIndex.size(); ++i) {
                    this.releaseOutResources(Integer.parseInt(this.outParameterIndex.get(i).toString()));
                }
                this.cursorResultMap.clear();
            }
        }
    }

    private void releaseRetrunResources() {
        if (!this.isResultNeeded && this.isFunc) {
            this.releaseOutResources(0);
        }
    }

    private void releaseOutResources(int parameterIndex) {
        int index = this.outParameterIndex.indexOf(parameterIndex);
        Object value = null;
        int type = 0;
        if (this.isFunc && !this.isResultNeeded) {
            ++index;
            if (parameterIndex == 0) {
                if (this.m_returnValue != null) {
                    value = this.m_returnValue;
                    type = this.m_returnType;
                }
            } else {
                value = this.m_outValues[index - 1];
                type = this.m_functionTypes[index - 1];
            }
        } else {
            value = this.m_outValues[parameterIndex - 1];
            type = this.m_functionTypes[parameterIndex - 1];
        }
        try {
            if (value != null && type != 0) {
                Driver.writeLog(this.sessionId, this.pid, "\u51c6\u5907\u91ca\u653e\u4e34\u65f6lob\u6216\u8005\u6e38\u6807");
                OscarLob lob = null;
                if (type == 50 || type == 2004) {
                    lob = this.connection.getBlobInstance(new String((byte[])value));
                } else if (type == 51 || type == 2005) {
                    lob = this.connection.getClobInstance(new String((byte[])value));
                } else {
                    String outValue = this.getFixedString(parameterIndex);
                    if (outValue != null && outValue.startsWith("<UNNAMED CURSOR ")) {
                        ResultSet rs = null;
                        rs = this.cursorResultMap.containsKey(parameterIndex) ? (ResultSet)this.cursorResultMap.remove(parameterIndex) : new OscarCursorResultSet(outValue, this.fetchSize, this.connection);
                        rs.close();
                    }
                }
                if (lob != null) {
                    lob.setTempLob(true);
                    lob.freeTemporary();
                }
            }
        }
        catch (SQLException e) {
            Driver.writeLog(e);
        }
    }

    protected void checkConnClose() throws SQLException {
        if (this.connection == null || this.connection.getProtocol() == null || ((Connection)((Object)this.connection)).isClosed()) {
            throw new OSQLException("OSCAR-00211", "08003", 211);
        }
    }

    protected void initParams() {
        this.batchPacket = null;
    }

    @Override
    public String generatedKeySqlTransform(String sql) {
        if (this.supportGeneratedKey && this.insertSql) {
            if (this.autoGeneratedInfo == 1) {
                sql = OscarSqlProcessor.makeSqlEndWithReturnGeneratedKeys(sql);
            } else if (this.autoGeneratedInfo == 3) {
                sql = OscarSqlProcessor.makeSqlEndWithReturnGeneratedKeys(sql);
                if (this.columnName != null && this.columnName.length > 0) {
                    sql = sql.concat(" ");
                    StringBuilder temp = new StringBuilder(sql);
                    for (int index = 0; index < this.columnName.length; ++index) {
                        temp.append(this.columnName[index]);
                        if (index + 1 >= this.columnName.length) continue;
                        temp.append(",");
                    }
                    sql = temp.toString();
                } else {
                    sql = sql + " NULL";
                }
            } else if (this.autoGeneratedInfo == 2) {
                sql = OscarSqlProcessor.makeSqlEndWithReturnGeneratedKeys(sql);
                if (this.columnIndex != null && this.columnIndex.length > 0) {
                    sql = sql.concat(" ");
                    StringBuilder temp = new StringBuilder(sql);
                    for (int index = 0; index < this.columnIndex.length; ++index) {
                        temp.append(this.columnIndex[index]);
                        if (index + 1 >= this.columnIndex.length) continue;
                        temp.append(",");
                    }
                    sql = temp.toString();
                } else {
                    sql = sql + " NULL";
                }
            }
        }
        return sql;
    }

    protected String checkSqlEmptyOrTrim(String sql) throws OSQLException {
        String sqltrim = sql;
        if (sqltrim == null || (sqltrim = sqltrim.trim()).length() == 0) {
            throw new OSQLException("OSCAR-00433", "88888", 433);
        }
        return sqltrim;
    }

    static {
        if (OscarJDBCUtil.isEqualOrGreaterJdbc4()) {
            try {
                String jdbc4ClassNameV2 = OscarJDBCUtil.isEqualOrGreaterJdbc42() ? "com.oscar.jdbc.Oscar42PreparedStatementV2" : "com.oscar.jdbc.OscarPreparedStatementV2";
                JDBC_4_PSTMT_ARG_V2 = Class.forName(jdbc4ClassNameV2, false, OscarStatement.class.getClassLoader()).getConstructor(BaseConnection.class, String.class);
                String jdbc4ClassName = OscarJDBCUtil.isEqualOrGreaterJdbc42() ? "com.oscar.jdbc.Oscar42PreparedStatement" : "com.oscar.jdbc.OscarPreparedStatement";
                JDBC_4_PSTMT_ARG = Class.forName(jdbc4ClassName, false, OscarStatement.class.getClassLoader()).getConstructor(BaseConnection.class, String.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            JDBC_4_PSTMT_ARG = null;
            JDBC_4_PSTMT_ARG_V2 = null;
        }
    }

    public static class BatchRowData {
        private Object[] data;
        private int[] types;
        private boolean hasEscapeChar = false;

        public BatchRowData(Object[] o, int[] types, boolean hasEscapeChar) {
            this.data = o;
            this.types = types;
            this.hasEscapeChar = hasEscapeChar;
        }

        public boolean hasEscapeChar() {
            return this.hasEscapeChar;
        }

        public Object[] getData() {
            return this.data;
        }

        public int[] getTypes() {
            return this.types;
        }
    }
}

