/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis.util;

import com.oscar.gis.util.GeometryTokenizer;
import com.oscar.gis.util.Point;
import com.oscar.gis.util.PointComposedGeom;
import java.sql.SQLException;
import java.util.List;

public class LinearRing
extends PointComposedGeom {
    private static final long serialVersionUID = 256L;

    public LinearRing(Point[] points) {
        super(0, points);
    }

    public LinearRing(String value) throws SQLException {
        this(value, false);
    }

    protected LinearRing(String value, boolean haveM) throws SQLException {
        super(0);
        String valueNoParans = GeometryTokenizer.removeLeadingAndTrailingStrings(value.trim(), "(", ")");
        List<String> tokens = GeometryTokenizer.tokenize(valueNoParans, ',');
        int npoints = tokens.size();
        Point[] points = new Point[npoints];
        for (int p = 0; p < npoints; ++p) {
            points[p] = new Point(tokens.get(p), haveM);
        }
        this.dimension = points[0].dimension;
        this.haveMeasure = points[0].haveMeasure;
        this.subgeoms = points;
    }
}

