/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis;

import com.oscar.gis.OscarLseg;
import com.oscar.gis.OscarObject;
import com.oscar.gis.OscarPoint;
import com.oscar.util.OscarTokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class OscarLine
extends OscarObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -664131953262651275L;
    private double a;
    private double b;
    private double c;

    public OscarLine(double a, double b, double c) {
        this();
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public OscarLine(double x1, double y1, double x2, double y2) {
        this();
        if (x1 == x2) {
            this.a = -1.0;
            this.b = 0.0;
        } else {
            this.a = (y2 - y1) / (x2 - x1);
            this.b = -1.0;
        }
        this.c = y1 - this.a * x1;
    }

    public OscarLine(OscarPoint p1, OscarPoint p2) {
        this(p1.x, p1.y, p2.x, p2.y);
    }

    public OscarLine(OscarLseg lseg) {
        this(lseg.getPoint()[0], lseg.getPoint()[1]);
    }

    public OscarLine(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public OscarLine() {
        this.setType("line");
    }

    @Override
    public void setValue(String s) throws SQLException {
        if (s.trim().startsWith("{")) {
            OscarTokenizer t = new OscarTokenizer(OscarTokenizer.removeCurlyBrace(s), ',');
            if (t.getSize() != 3) {
                throw new SQLException("Conversion to type " + this.type + " failed: " + s);
            }
            this.a = Double.parseDouble(t.getToken(0));
            this.b = Double.parseDouble(t.getToken(1));
            this.c = Double.parseDouble(t.getToken(2));
        } else if (s.trim().startsWith("[")) {
            OscarTokenizer t = new OscarTokenizer(OscarTokenizer.removeBox(s), ',');
            if (t.getSize() != 2) {
                throw new SQLException("Conversion to type " + this.type + " failed: " + s);
            }
            OscarPoint point1 = new OscarPoint(t.getToken(0));
            OscarPoint point2 = new OscarPoint(t.getToken(1));
            this.a = point2.x - point1.x;
            this.b = point2.y - point1.y;
            this.c = point1.y;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        OscarLine OscarLine2 = (OscarLine)obj;
        return Double.compare(OscarLine2.a, this.a) == 0 && Double.compare(OscarLine2.b, this.b) == 0 && Double.compare(OscarLine2.c, this.c) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.a);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.b);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.c);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public String getValue() {
        return "{" + this.a + "," + this.b + "," + this.c + "}";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

