/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis;

import com.oscar.gis.OscarObject;
import com.oscar.gis.OscarPoint;
import com.oscar.util.OscarTokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class OscarBox
extends OscarObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8909836498867598265L;
    private OscarPoint[] point = new OscarPoint[2];

    public OscarBox(double x1, double y1, double x2, double y2) {
        this();
        this.point[0] = new OscarPoint(x1, y1);
        this.point[1] = new OscarPoint(x2, y2);
    }

    public OscarBox(OscarPoint p1, OscarPoint p2) {
        this();
        this.point[0] = p1;
        this.point[1] = p2;
    }

    public OscarBox(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public OscarBox() {
        this.setType("box");
    }

    @Override
    public void setValue(String value) throws SQLException {
        OscarTokenizer t = new OscarTokenizer(value, ',');
        if (t.getSize() != 2) {
            throw new SQLException("Conversion to type + " + this.type + " failed: " + value);
        }
        this.point[0] = new OscarPoint(t.getToken(0));
        this.point[1] = new OscarPoint(t.getToken(1));
    }

    public void setByteValue(byte[] b, int offset) {
        this.point[0] = new OscarPoint();
        this.point[0].setByteValue(b, offset);
        this.point[1] = new OscarPoint();
        this.point[1].setByteValue(b, offset + this.point[0].lengthInBytes());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OscarBox) {
            OscarBox p = (OscarBox)obj;
            if (p.point[0].equals(this.point[0]) && p.point[1].equals(this.point[1])) {
                return true;
            }
            if (p.point[0].equals(this.point[1]) && p.point[1].equals(this.point[0])) {
                return true;
            }
            if (p.point[0].x == this.point[0].x && p.point[0].y == this.point[1].y && p.point[1].x == this.point[1].x && p.point[1].y == this.point[0].y) {
                return true;
            }
            if (p.point[0].x == this.point[1].x && p.point[0].y == this.point[0].y && p.point[1].x == this.point[0].x && p.point[1].y == this.point[1].y) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.point[0].hashCode() ^ this.point[1].hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        OscarBox newOscarBox = (OscarBox)super.clone();
        if (newOscarBox.point != null) {
            newOscarBox.point = (OscarPoint[])newOscarBox.point.clone();
            for (int i = 0; i < newOscarBox.point.length; ++i) {
                if (newOscarBox.point[i] == null) continue;
                newOscarBox.point[i] = (OscarPoint)newOscarBox.point[i].clone();
            }
        }
        return newOscarBox;
    }

    @Override
    public String getValue() {
        return this.point[0].toString() + "," + this.point[1].toString();
    }

    public int lengthInBytes() {
        return this.point[0].lengthInBytes() + this.point[1].lengthInBytes();
    }

    public void toBytes(byte[] bytes, int offset) {
        this.point[0].toBytes(bytes, offset);
        this.point[1].toBytes(bytes, offset + this.point[0].lengthInBytes());
    }
}

