/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.dispatcher.executor;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.dispatcher.core.ConnectionMangerV2;
import com.oscar.dispatcher.entity.DispatchConnection;
import com.oscar.dispatcher.executor.AbstractExecuteCommand;
import com.oscar.dispatcher.executor.DispatchAbstractStatement;
import com.oscar.dispatcher.executor.command.StatmentCommand;
import com.oscar.jdbc.OscarStatement;
import com.oscar.util.OSQLException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.util.Arrays;

public class DispatchStatementV2
extends DispatchAbstractStatement
implements Statement {
    public DispatchStatementV2(DispatchConnection con) {
        super(con);
        this.createCommand = new StatmentCommand();
    }

    public DispatchStatementV2(DispatchConnection con, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(con);
        this.createCommand = new StatmentCommand(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public DispatchStatementV2(DispatchConnection con, int resultSetType, int resultSetConcurrency) {
        super(con);
        this.createCommand = new StatmentCommand(resultSetType, resultSetConcurrency);
    }

    @Override
    public ResultSet executeQuery(final String sql) throws SQLException {
        int dispatchType = this.getExecuteType(sql);
        DispatchAbstractStatement.RealExecuteCommand<ResultSet> ec = new DispatchAbstractStatement.RealExecuteCommand<ResultSet>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeQuery(" + sql + ")";
            }

            @Override
            public ResultSet execute(Statement t) throws SQLException {
                BaseResultSet brs;
                BaseConnection conn = (BaseConnection)((Object)t.getConnection());
                ResultSet rs = t.executeQuery(sql);
                if (conn.isSlave() && DispatchStatementV2.this.dispatchConnection.isZeroResend() && (brs = (BaseResultSet)rs).getTupleCount() == 0) {
                    rs.close();
                    throw new OSQLException(888888, "0A502", "resultSet size is 0 ,try to switch to main");
                }
                return rs;
            }
        };
        return this.executeTemplet(ec, dispatchType);
    }

    @Override
    public int executeUpdate(final String sql) throws SQLException {
        int dispatchType = this.getExecuteType(sql);
        DispatchAbstractStatement.RealExecuteCommand<Integer> ec = new DispatchAbstractStatement.RealExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + sql + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.executeUpdate(sql);
            }
        };
        return this.executeTemplet(ec, dispatchType);
    }

    @Override
    public void close() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(ConnectionMangerV2.printSlaveAccessCount());
        }
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.close()";
            }

            @Override
            public Object execute(Statement t) throws SQLException {
                t.close();
                return null;
            }
        };
        this.executeTemplet(ec, 3);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getMaxFieldSize()";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getMaxFieldSize();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public void setMaxFieldSize(final int max) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setMaxFieldSize(" + max + ")";
            }

            @Override
            public Object execute(Statement t) throws SQLException {
                t.setMaxFieldSize(max);
                DispatchStatementV2.this.maxFieldSize = max;
                return null;
            }
        };
        this.executeTemplet(ec, 3);
    }

    @Override
    public int getMaxRows() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getMaxRows();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public void setMaxRows(final int max) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.setMaxRows(max);
                DispatchStatementV2.this.maxrows = max;
                return null;
            }
        };
        this.executeTemplet(ec, 3);
    }

    @Override
    public void setEscapeProcessing(final boolean enable) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.setEscapeProcessing(enable);
                DispatchStatementV2.this.replaceProcessingEnabled = enable;
                return null;
            }
        };
        this.executeTemplet(ec, 3);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getQueryTimeout();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public void setQueryTimeout(final int seconds) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.setQueryTimeout(seconds);
                DispatchStatementV2.this.timeout = seconds;
                return null;
            }
        };
        this.executeTemplet(ec, 3);
    }

    @Override
    public void cancel() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.cancel();
                return null;
            }
        };
        this.executeTemplet(ec, this.getCurrentExecuteType());
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        AbstractExecuteCommand<SQLWarning> ec = new AbstractExecuteCommand<SQLWarning>(){

            @Override
            public SQLWarning execute(Statement t) throws SQLException {
                return t.getWarnings();
            }
        };
        return this.executeTemplet(ec, this.getCurrentExecuteType());
    }

    @Override
    public void clearWarnings() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.clearWarnings();
                return null;
            }
        };
        this.executeTemplet(ec, 3);
    }

    @Override
    public void setCursorName(final String name) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.setCursorName(name);
                DispatchStatementV2.this.cursor = name;
                return null;
            }
        };
        this.executeTemplet(ec, this.getCurrentExecuteType());
    }

    @Override
    public boolean execute(final String sql) throws SQLException {
        int dispatchType = this.getExecuteType(sql);
        DispatchAbstractStatement.RealExecuteCommand<Boolean> ec = new DispatchAbstractStatement.RealExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.execute(" + sql + ")";
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.execute(sql);
            }
        };
        return this.executeTemplet(ec, dispatchType);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        AbstractExecuteCommand<ResultSet> ec = new AbstractExecuteCommand<ResultSet>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getResultSet()";
            }

            @Override
            public ResultSet execute(Statement t) throws SQLException {
                return t.getResultSet();
            }
        };
        return this.executeTemplet(ec, this.getCurrentExecuteType());
    }

    @Override
    public int getUpdateCount() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getUpdateCount()";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getUpdateCount();
            }
        };
        return this.executeTemplet(ec, this.getCurrentExecuteType());
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getMoreResults()";
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.getMoreResults();
            }
        };
        return this.executeTemplet(ec, this.getCurrentExecuteType());
    }

    @Override
    public void setFetchDirection(final int direction) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.setFetchDirection(direction);
                DispatchStatementV2.this.fetchdirection = direction;
                return null;
            }
        };
        this.executeTemplet(ec, 3);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getFetchDirection();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public void setFetchSize(final int rows) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.setFetchSize(rows);
                DispatchStatementV2.this.fetchSize = rows;
                return null;
            }
        };
        this.executeTemplet(ec, 3);
    }

    @Override
    public int getFetchSize() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getFetchSize();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getResultSetConcurrency();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public int getResultSetType() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getResultSetType();
            }
        };
        return this.executeTemplet(ec, this.getCurrentExecuteType());
    }

    @Override
    public void addBatch(final String sql) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.addBatch(" + sql + ")";
            }

            @Override
            public Object execute(Statement t) throws SQLException {
                t.addBatch(sql);
                return null;
            }
        };
        this.executeTemplet(ec, 0);
    }

    @Override
    public void clearBatch() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                t.clearBatch();
                return null;
            }
        };
        this.executeTemplet(ec, 0);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        AbstractExecuteCommand<int[]> ec = new AbstractExecuteCommand<int[]>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeBatch()";
            }

            @Override
            public int[] execute(Statement t) throws SQLException {
                return t.executeBatch();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dispatchConnection;
    }

    @Override
    public boolean getMoreResults(final int current) throws SQLException {
        AbstractExecuteCommand<Boolean> ec = new AbstractExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getMoreResults()";
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.getMoreResults(current);
            }
        };
        return this.executeTemplet(ec, this.getCurrentExecuteType());
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        AbstractExecuteCommand<ResultSet> ec = new AbstractExecuteCommand<ResultSet>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.getGeneratedKeys()";
            }

            @Override
            public ResultSet execute(Statement t) throws SQLException {
                return t.getGeneratedKeys();
            }
        };
        return this.executeTemplet(ec, this.getCurrentExecuteType());
    }

    @Override
    public int executeUpdate(final String sql, final int autoGeneratedKeys) throws SQLException {
        DispatchAbstractStatement.RealExecuteCommand<Integer> ec = new DispatchAbstractStatement.RealExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + sql + "," + autoGeneratedKeys + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.executeUpdate(sql, autoGeneratedKeys);
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public int executeUpdate(final String sql, final int[] columnIndexes) throws SQLException {
        DispatchAbstractStatement.RealExecuteCommand<Integer> ec = new DispatchAbstractStatement.RealExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + sql + "," + Arrays.toString(columnIndexes) + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.executeUpdate(sql, columnIndexes);
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public int executeUpdate(final String sql, final String[] columnNames) throws SQLException {
        DispatchAbstractStatement.RealExecuteCommand<Integer> ec = new DispatchAbstractStatement.RealExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + sql + "," + Arrays.toString(columnNames) + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.executeUpdate(sql, columnNames);
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    public boolean execute(final String sql, final int autoGeneratedKeys) throws SQLException {
        int dispatchType = this.getExecuteType(sql);
        DispatchAbstractStatement.RealExecuteCommand<Boolean> ec = new DispatchAbstractStatement.RealExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.executeUpdate(" + sql + "," + autoGeneratedKeys + ")";
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.execute(sql, autoGeneratedKeys);
            }
        };
        return this.executeTemplet(ec, dispatchType);
    }

    @Override
    public boolean execute(final String sql, final int[] columnIndexes) throws SQLException {
        int dispatchType = this.getExecuteType(sql);
        DispatchAbstractStatement.RealExecuteCommand<Boolean> ec = new DispatchAbstractStatement.RealExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.execute(" + sql + "," + Arrays.toString(columnIndexes) + ")";
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.execute(sql, columnIndexes);
            }
        };
        return this.executeTemplet(ec, dispatchType);
    }

    @Override
    public boolean execute(final String sql, final String[] columnNames) throws SQLException {
        int dispatchType = this.getExecuteType(sql);
        DispatchAbstractStatement.RealExecuteCommand<Boolean> ec = new DispatchAbstractStatement.RealExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.execute(" + sql + "," + Arrays.toString(columnNames) + ")";
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                return t.execute(sql, columnNames);
            }
        };
        return this.executeTemplet(ec, dispatchType);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        AbstractExecuteCommand<Integer> ec = new AbstractExecuteCommand<Integer>(){

            @Override
            public Integer execute(Statement t) throws SQLException {
                return t.getResultSetHoldability();
            }
        };
        return this.executeTemplet(ec, 0);
    }

    @Override
    protected void initStatement(Statement statement) throws SQLException {
        if (this.maxFieldSize != null) {
            statement.setMaxFieldSize(this.maxFieldSize);
        }
        if (this.fetchSize != null) {
            statement.setFetchSize(this.fetchSize);
        }
        if (this.maxrows != null) {
            statement.setMaxRows(this.maxrows);
        }
        if (this.replaceProcessingEnabled != null) {
            statement.setEscapeProcessing(this.replaceProcessingEnabled);
        }
        if (this.fetchdirection != null) {
            statement.setFetchDirection(this.fetchdirection);
        }
        if (this.timeout != null) {
            statement.setQueryTimeout(this.timeout);
        }
        if (this.cursor != null) {
            statement.setCursorName(this.cursor);
        }
    }

    @Override
    protected boolean expectionHandler(SQLException e, Statement slave) throws SQLException {
        boolean changeSuccess;
        block4: {
            if (slave == null) {
                return true;
            }
            changeSuccess = this.handleException(e, slave, this.getMainStatement());
            if (this.isDisconnected(e)) {
                this.dispatchConnection.removeSlaveConnection(this.slaveConnectionKey);
                try {
                    slave.close();
                }
                catch (SQLException e1) {
                    if (!this.logFlag) break block4;
                    Driver.writeLog("warning:" + e1);
                }
            }
        }
        return changeSuccess;
    }

    protected boolean handleException(SQLException e, Statement slave, Statement master) throws SQLException {
        return this.getErrorCode(e);
    }

    @Override
    public <T> T unwrap(Class<T> paramClass) throws SQLException {
        if (paramClass.isAssignableFrom(this.getClass())) {
            return paramClass.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + paramClass.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> paramClass) throws SQLException {
        return paramClass.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.getMainStatement().isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.getMainStatement().isPoolable();
    }

    public void setRowId(int paramInt, RowId paramRowId) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setNString(int paramInt, String paramString) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setNCharacterStream(int paramInt, Reader paramReader, long paramLong) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setNClob(int paramInt, NClob paramNClob) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setClob(final int paramInt, final Reader paramReader, final long paramLong) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setClob(" + paramInt + "," + paramReader + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setClob(paramInt, paramReader, paramLong);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    public void setBlob(final int paramInt, final InputStream paramInputStream, final long paramLong) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setBlob(" + paramInt + "," + paramInputStream + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setBlob(paramInt, paramInputStream, paramLong);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    public void setNClob(int paramInt, Reader paramReader, long paramLong) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setSQLXML(final int paramInt, final SQLXML paramSQLXML) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setSQLXML(" + paramInt + "," + paramSQLXML + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setSQLXML(paramInt, paramSQLXML);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    public void setAsciiStream(final int paramInt, final InputStream paramInputStream, final long paramLong) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setAsciiStream(" + paramInt + "," + paramInputStream + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setAsciiStream(paramInt, paramInputStream, paramLong);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    public void setBinaryStream(final int paramInt, final InputStream paramInputStream, final long paramLong) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setBinaryStream(" + paramInt + "," + paramInputStream + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setBinaryStream(paramInt, paramInputStream, paramLong);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    public void setCharacterStream(final int paramInt, final Reader paramReader, final long paramLong) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setCharacterStream(" + paramInt + "," + paramReader + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setCharacterStream(paramInt, paramReader, paramLong);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    public void setAsciiStream(int paramInt, InputStream paramInputStream) throws SQLException {
        this.setAsciiStream(paramInt, paramInputStream, -1L);
    }

    public void setBinaryStream(int paramInt, InputStream paramInputStream) throws SQLException {
        this.setBinaryStream(paramInt, paramInputStream, -1L);
    }

    public void setCharacterStream(int paramInt, Reader paramReader) throws SQLException {
        this.setCharacterStream(paramInt, paramReader, -1L);
    }

    public void setNCharacterStream(int paramInt, Reader paramReader) throws SQLException {
        this.setNCharacterStream(paramInt, paramReader, -1L);
    }

    public void setClob(final int paramInt, final Reader paramReader) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setClob(" + paramInt + "," + paramReader + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setClob(paramInt, paramReader);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    public void setBlob(final int paramInt, final InputStream paramInputStream) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setBlob(" + paramInt + "," + paramInputStream + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setBlob(paramInt, paramInputStream);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    public void setNClob(int paramInt, Reader paramReader) throws SQLException {
        this.setNClob(paramInt, paramReader, -1L);
    }

    public void setRowId(String paramString, RowId paramRowId) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setNString(String paramString1, String paramString2) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setNCharacterStream(String paramString, Reader paramReader, long paramLong) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setNClob(String paramString, NClob paramNClob) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setClob(final String paramString, final Reader paramReader, final long paramLong) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setClob(" + paramString + "," + paramReader + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((CallableStatement)t).setClob(paramString, paramReader, paramLong);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    public void setBlob(final String paramString, final InputStream paramInputStream, final long paramLong) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setBlob(" + paramString + "," + paramInputStream + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((CallableStatement)t).setBlob(paramString, paramInputStream, paramLong);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    public void setNClob(String paramString, Reader paramReader, long paramLong) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setSQLXML(final String paramString, final SQLXML paramSQLXML) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setSQLXML(" + paramString + "," + paramSQLXML + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((CallableStatement)t).setSQLXML(paramString, paramSQLXML);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    public void setBlob(final String paramString, final Blob paramBlob) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setBlob(" + paramString + "," + paramBlob + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((CallableStatement)t).setBlob(paramString, paramBlob);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    public void setClob(final String paramString, final Clob paramClob) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setClob(" + paramString + "," + paramClob + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((CallableStatement)t).setClob(paramString, paramClob);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    public void setAsciiStream(final String paramString, final InputStream paramInputStream, final long paramLong) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setAsciiStream(" + paramString + "," + paramInputStream + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((CallableStatement)t).setAsciiStream(paramString, paramInputStream, paramLong);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    public void setBinaryStream(final String paramString, final InputStream paramInputStream, final long paramLong) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setBinaryStream(" + paramString + "," + paramInputStream + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((CallableStatement)t).setBinaryStream(paramString, paramInputStream, paramLong);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    public void setCharacterStream(final String paramString, final Reader paramReader, final long paramLong) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setCharacterStream(" + paramString + "," + paramReader + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((CallableStatement)t).setCharacterStream(paramString, paramReader, paramLong);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    public void setAsciiStream(String paramString, InputStream paramInputStream) throws SQLException {
        this.setAsciiStream(paramString, paramInputStream, -1L);
    }

    public void setBinaryStream(String paramString, InputStream paramInputStream) throws SQLException {
        this.setBinaryStream(paramString, paramInputStream, -1L);
    }

    public void setCharacterStream(String paramString, Reader paramReader) throws SQLException {
        this.setCharacterStream(paramString, paramReader, -1L);
    }

    public void setNCharacterStream(String paramString, Reader paramReader) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setClob(final String paramString, final Reader paramReader) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setClob(" + paramString + "," + paramReader + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((CallableStatement)t).setClob(paramString, paramReader);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    public void setBlob(final String paramString, final InputStream paramInputStream) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchStatementV2.setBlob(" + paramString + "," + paramInputStream + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((CallableStatement)t).setBlob(paramString, paramInputStream);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    public void setNClob(String paramString, Reader paramReader) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void setPoolable(boolean paramBoolean) throws SQLException {
        this.getMainStatement().setPoolable(paramBoolean);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public Object execute(Statement t) throws SQLException {
                ((OscarStatement)t).closeOnCompletion();
                return null;
            }
        };
        this.executeTemplet(ec, 3);
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return ((OscarStatement)this.getMainStatement()).isCloseOnCompletion();
    }
}

