/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.dispatcher.core;

import com.oscar.Driver;
import com.oscar.dispatcher.entity.DispatchConnection;
import com.oscar.jdbc.OscarJdbc2Connection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ConnectionMangerV2 {
    public static final ConcurrentHashMap<String, String> rates = new ConcurrentHashMap();
    public static final ConcurrentHashMap<String, AtomicInteger> hostAcount = new ConcurrentHashMap();
    public static final ConcurrentHashMap<String, AtomicInteger> totalAcount = new ConcurrentHashMap();
    public static final ConcurrentHashMap<String, AtomicLong> lastSlaveID = new ConcurrentHashMap();
    protected static final boolean logFlag = Driver.getLogLevel() >= 2;
    public static final Map<String, AtomicLong> SLAVE_ACCESS_COUNT = new ConcurrentHashMap<String, AtomicLong>();

    public static synchronized DispatchConnection createConnection(OscarJdbc2Connection con, String passward, String dbName, Properties props, Map<String, Map<String, String>> slaveConnInfo) {
        if (logFlag) {
            Driver.writeLog(con.sessionID, con.getPlanID(), ConnectionMangerV2.class + ", createConnection()");
        }
        props.setProperty("HOSTLOADRATE", props.getProperty("HOSTLOADRATE", "0"));
        DispatchConnection conn = new DispatchConnection(con, passward, dbName, props, slaveConnInfo);
        rates.putIfAbsent(conn.url, props.getProperty("HOSTLOADRATE"));
        hostAcount.putIfAbsent(conn.url, new AtomicInteger(0));
        totalAcount.putIfAbsent(conn.url, new AtomicInteger(0));
        lastSlaveID.putIfAbsent(conn.url, new AtomicLong(0L));
        if (slaveConnInfo != null && logFlag) {
            if (SLAVE_ACCESS_COUNT.get("slavetomain") == null) {
                SLAVE_ACCESS_COUNT.put("slavetomain", new AtomicLong(0L));
            }
            for (String key : slaveConnInfo.keySet()) {
                if (SLAVE_ACCESS_COUNT.get(key) != null) continue;
                SLAVE_ACCESS_COUNT.put(key, new AtomicLong(0L));
            }
        }
        return conn;
    }

    public static DispatchConnection createConnection(OscarJdbc2Connection con, String passward, String dbName, Properties props) {
        return ConnectionMangerV2.createConnection(con, passward, dbName, props, null);
    }

    public static String printSlaveAccessCount() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("Count of requests sent\uff1a ");
        for (Map.Entry<String, AtomicLong> entrys : SLAVE_ACCESS_COUNT.entrySet()) {
            String key = entrys.getKey();
            sb.append(key + "-" + entrys.getValue().get() + "  ");
        }
        return sb.toString();
    }
}

