/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.ssl;

import com.oscar.Config;
import com.oscar.util.OSQLException;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.Provider;
import java.sql.SQLException;

public class BouncyCastlePrivateKeyFactory {
    public static Provider initBouncyCastleProvider() throws SQLException {
        String bouncyCastle = "org.bouncycastle.jce.provider.BouncyCastleProvider";
        try {
            Class<?> bouncyCastleProvider = Class.forName(bouncyCastle);
            Object bcObj = bouncyCastleProvider.newInstance();
            return (Provider)bcObj;
        }
        catch (Exception exception) {
            try {
                Provider provider = BouncyCastlePrivateKeyFactory.loadProvider(bouncyCastle);
                if (provider == null) {
                    throw new OSQLException("Could not found bouncycastle provider, please load bcprov-jdk15on jar package manually", "");
                }
                return provider;
            }
            catch (Exception e) {
                throw new OSQLException("Could not found bouncycastle provider, please load bcprov-jdk15on jar package manually", "");
            }
        }
    }

    private static Provider loadProvider(String bouncyCastle) throws Exception {
        File[] files;
        String path = null;
        try {
            URL url = Config.class.getProtectionDomain().getCodeSource().getLocation();
            path = new URI(url.getProtocol(), url.getHost(), url.getPath(), url.getQuery(), null).getPath();
            path = URLDecoder.decode(path, "utf-8");
        }
        catch (Exception e) {
            path = ".";
        }
        String jarPath = null;
        if (path != null) {
            if (path.endsWith("/") || path.endsWith("\\")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.endsWith(".jar")) {
                int index = path.lastIndexOf("/");
                if (index != -1) {
                    path = path.substring(0, index);
                }
                jarPath = path;
            } else {
                jarPath = path + File.separator + "..";
            }
        }
        if (jarPath != null && (files = new File(jarPath).listFiles()) != null) {
            for (File file : files) {
                if (!file.getName().startsWith("bcprov-jdk15on")) continue;
                return BouncyCastlePrivateKeyFactory.dynamicLoadJdbc(file.getAbsolutePath(), bouncyCastle);
            }
        }
        return null;
    }

    private static Provider dynamicLoadJdbc(String jdbcDriverPath, String bouncyCastle) throws Exception {
        URL url = new File(jdbcDriverPath).toURI().toURL();
        URLClassLoader classLoader = new URLClassLoader(new URL[]{url});
        Class<?> bouncyCastleProvider = classLoader.loadClass(bouncyCastle);
        Object bcObj = bouncyCastleProvider.newInstance();
        return (Provider)bcObj;
    }
}

