/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.protocol;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.BaseStatement;
import com.oscar.core.Field;
import com.oscar.protocol.OSCARProtocol;
import com.oscar.protocol.Packet;
import com.oscar.protocol.packets.AsciiRowPacketV2;
import com.oscar.protocol.packets.BasePacket;
import com.oscar.protocol.packets.BatchProcessPacketV2;
import com.oscar.protocol.packets.CompleteResponsePacket;
import com.oscar.protocol.packets.CursorResponsePacket;
import com.oscar.protocol.packets.EmptyQueryResponsePacket;
import com.oscar.protocol.packets.ErrorResponsePacket;
import com.oscar.protocol.packets.ExecutePacket;
import com.oscar.protocol.packets.FetchMorePacket;
import com.oscar.protocol.packets.FetchPacket;
import com.oscar.protocol.packets.FunctionCallPacketV2;
import com.oscar.protocol.packets.FunctionResponsePacket;
import com.oscar.protocol.packets.ImportExportResponsePacket;
import com.oscar.protocol.packets.ImportPacket;
import com.oscar.protocol.packets.NewImportPacket;
import com.oscar.protocol.packets.NoticeResponsePacket;
import com.oscar.protocol.packets.ParamInforPacket;
import com.oscar.protocol.packets.PlanIDPacket;
import com.oscar.protocol.packets.QueryPacketV2;
import com.oscar.protocol.packets.ReadyForQueryPacket;
import com.oscar.protocol.packets.RowDescriptionPacket;
import com.oscar.protocol.packets.TerminatePacketV2;
import com.oscar.protocol.packets.assist.OscarCursorType;
import com.oscar.protocol.stream.OStream;
import com.oscar.util.OSQLException;
import com.oscar.util.converter.RowidConverter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;

public class OSCARProtocolV2
extends OSCARProtocol {
    protected InputStream osr_input;
    protected BufferedOutputStream osr_output;
    private byte[] planID = null;
    private OscarCursorType cursorType;
    private int columnCount = 0;

    public OSCARProtocolV2(BaseConnection con, String _host, int _port, String _database, String user, String _password, Properties _info, OStream oStream) {
        super(con, _host, _port, _database, user, _password, _info, oStream);
        this.osr_input = oStream.getInputStream();
        this.osr_output = oStream.getBufferedOutputStream();
        this.cursorType = new OscarCursorType(_info);
    }

    public BaseResultSet fetchMore(String query, String prepareName, int[] m_bindTypes, Object[] m_bindDatas, byte[] planID, int fetchSize, int maxRows, boolean finished, boolean isPrepare, BaseStatement stmt, boolean bindTypeChanged) throws SQLException {
        return this.fetchMore(query, prepareName, m_bindTypes, m_bindDatas, planID, fetchSize, maxRows, finished, isPrepare, stmt, (BaseResultSet)stmt.getResultSet(), bindTypeChanged, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseResultSet fetchMore(String query, String prepareName, int[] m_bindTypes, Object[] m_bindDatas, byte[] planID, int fetchSize, int maxRows, boolean finished, boolean isPrepare, BaseStatement stmt, BaseResultSet res, boolean bindTypeChanged, int resultSetType) throws SQLException {
        if (this.logFlag) {
            int i;
            StringBuffer sb = new StringBuffer();
            sb.append(OSCARProtocolV2.class).append(", fetchMore, paras: ").append("\n");
            sb.append(" sql: ").append(query).append(", ");
            sb.append(" prepareName:").append(prepareName).append(", ");
            sb.append(" bindTypes: ");
            if (m_bindTypes == null) {
                sb.append("null");
            } else {
                for (i = 0; i < m_bindTypes.length; ++i) {
                    sb.append(m_bindTypes[i]).append(" ");
                }
            }
            if (m_bindDatas != null) {
                sb.append(" bindDatas: ");
                for (int i2 = 0; i2 < m_bindDatas.length; ++i2) {
                    byte[] tmp = (byte[])m_bindDatas[i2];
                    if (tmp == null) {
                        sb.append("null ");
                        continue;
                    }
                    for (int j = 0; j < tmp.length; ++j) {
                        sb.append(tmp[j]).append(" ");
                    }
                }
            }
            sb.append(" planID: ");
            if (planID != null) {
                for (i = 0; i < planID.length; ++i) {
                    sb.append(planID[i]).append(" ");
                }
            } else {
                sb.append("null");
            }
            sb.append(" fetchSize: ").append(fetchSize);
            sb.append(" maxRows: ").append(maxRows);
            sb.append(" fetch close: ").append(finished);
            sb.append(" isprepare: ").append(isPrepare);
            sb.append(" bindTypeChanged: ").append(bindTypeChanged);
            Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), sb.toString());
        }
        OSCARProtocolV2 oSCARProtocolV2 = this;
        synchronized (oSCARProtocolV2) {
            OSQLException exception = null;
            this.statement = stmt;
            this.status = 0;
            this.resultset = res;
            if (this.resultset != null && !this.resultset.isCursorUsed()) {
                this.resultset = null;
            }
            try {
                boolean encodingFlag;
                int marked = 0;
                boolean bl = encodingFlag = this.connection.getEncoding() == null;
                if (this.statement.isDDLSql()) {
                    marked = 3;
                    this.statement.resetDDLSql(false);
                } else if (this.statement.isPrepareAndNotRealPrepare()) {
                    marked = 4;
                } else if (this.statement.getAutoGeneratedInfo() != -1) {
                    String sql;
                    marked = 2;
                    if (query != null && !(sql = this.statement.generatedKeySqlTransform(query)).equals(query)) {
                        query = sql;
                        marked = 0;
                    }
                } else if (this.statement.useTid()) {
                    marked = 1;
                }
                BasePacket qp = null;
                qp = planID == null ? new FetchPacket(query == null ? null : this.connection.getEncoding().encode(query), prepareName == null ? null : this.connection.getEncoding().encode(prepareName), m_bindTypes, m_bindDatas, fetchSize, isPrepare, marked, bindTypeChanged, this.connection.getProtocolVersion().getProtocolType(), this.cursorType.getOscarCursorType(resultSetType)) : new FetchMorePacket(fetchSize, planID, finished);
                qp.setConnection(this.connection);
                ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
                boolean resultTid = false;
                ArrayList<byte[]> tidList = null;
                Field[] fields = this.statement.getFields();
                long update_count = -2L;
                long insert_tid = 0L;
                Field tidField = null;
                this.sendMessage(this.osr_output, qp);
                do {
                    boolean timeout = true;
                    int getMessageTimes = 0;
                    do {
                        try {
                            this.bk = this.getMessage(this.osr_input);
                            timeout = false;
                        }
                        catch (Throwable e) {
                            if (this.isSocketConnectionError(e)) {
                                timeout = false;
                                this.status = -1;
                                throw new OSQLException("OSCAR-00901", "08003", 901, e);
                            }
                            if (this.ping(this.oStream)) {
                                if (e instanceof SocketTimeoutException || !this.needRetry(++getMessageTimes)) {
                                    timeout = false;
                                    this.status = -1;
                                    throw (SocketTimeoutException)e;
                                }
                                timeout = true;
                                continue;
                            }
                            timeout = false;
                            this.status = -1;
                            throw new OSQLException("OSCAR-00901", "08003", 901, e);
                        }
                    } while (timeout);
                    if (this.bk instanceof PlanIDPacket) {
                        this.getMessage(this.osr_input, this.bk);
                        planID = ((PlanIDPacket)this.bk).getPlanID();
                        this.planID = planID;
                        continue;
                    }
                    if (this.bk instanceof RowDescriptionPacket) {
                        this.getMessage(this.osr_input, this.bk);
                        Field[] tempFields = ((RowDescriptionPacket)this.bk).getFields();
                        this.columnCount = tempFields.length;
                        if (this.columnCount > 0) {
                            if ((this.statement.useTid() || this.statement.getAutoGeneratedInfo() != -1) && tempFields[0].getAliasName().equalsIgnoreCase("ROWID")) {
                                resultTid = true;
                                tidField = tempFields[0];
                                tidList = new ArrayList<byte[]>();
                                if (this.columnCount != 1) {
                                    fields = new Field[this.columnCount - 1];
                                    for (int i = 0; i < this.columnCount - 1; ++i) {
                                        fields[i] = tempFields[i + 1];
                                    }
                                }
                            } else {
                                fields = tempFields;
                            }
                        } else {
                            fields = new Field[]{};
                        }
                        this.statement.setFields(fields);
                        continue;
                    }
                    if (this.bk instanceof AsciiRowPacketV2) {
                        ((AsciiRowPacketV2)this.bk).initTuple(this.columnCount, fields);
                        this.getMessage(this.osr_input, this.bk);
                        byte[][] tempTuple = ((AsciiRowPacketV2)this.bk).getTuple();
                        Object tuple = null;
                        if (this.columnCount <= 0 || maxRows != 0 && tuples.size() >= maxRows) continue;
                        if (resultTid && tempTuple.length > 0) {
                            tidList.add(tempTuple[0]);
                            tuple = new byte[tempTuple.length - 1][];
                            for (int i = 0; i < tempTuple.length - 1; ++i) {
                                tuple[i] = tempTuple[i + 1];
                            }
                        } else {
                            tuple = tempTuple;
                        }
                        tuples.add((byte[][])tuple);
                        continue;
                    }
                    if (this.bk instanceof CompleteResponsePacket) {
                        this.getMessage(this.osr_input, this.bk);
                        String command = this.connection.getEncoding().decode(((CompleteResponsePacket)this.bk).getCommand());
                        if (command.length() < 2) continue;
                        char tag1 = command.charAt(0);
                        char tag2 = command.charAt(1);
                        if (tag1 == '5' && tag2 == '0') {
                            char tag3 = command.charAt(3);
                            if (tag3 == '0') {
                                this.statement.setResultSetCanUpdateable(false);
                            } else if (tag3 == '1') {
                                this.statement.setResultSetCanUpdateable(true);
                            }
                        } else if (tag1 == '3') {
                            if (tag2 == '0') {
                                this.connection.setInTranscation(true);
                            } else if (tag2 == '1' || tag2 == '2' || tag2 == '3') {
                                this.connection.setInTranscation(false);
                            }
                        } else if (tag1 == '0' && tag2 != '6' && tag2 <= 'S' || tag1 == '1' && (tag2 == '0' || tag2 == '1') || tag1 == '2' && tag2 != '2' || tag1 == '5' && tag2 == '5' || tag1 == '4' && tag2 == '0' || tag1 == '4' && tag2 == '5' || tag1 == '4' && tag2 == '8' || tag1 == '5' && tag2 == '6' || tag1 == '5' && tag2 == 'D') {
                            int updateCountOffset;
                            if (tag1 == '0' && tag2 != '6' && tag2 <= 'S') {
                                update_count = 0L;
                            }
                            if (tag1 == '4' && tag2 == '0') {
                                update_count = 0L;
                            }
                            byte[] cmd = ((CompleteResponsePacket)this.bk).getCommand();
                            if (tag1 == '2' && (tag2 == '0' || tag2 == '5')) {
                                updateCountOffset = this.getFirstBlankPosition(cmd, 0);
                                update_count = RowidConverter.convertToRowID(cmd, updateCountOffset + 1);
                            }
                            if (tag1 == '2' && tag2 == '1') {
                                updateCountOffset = this.getFirstBlankPosition(cmd, 0);
                                HashMap<String, Long> map = RowidConverter.convertToUpdateCount(cmd, updateCountOffset + 1);
                                update_count = map.get("updatecount");
                                int insertTidOffset = map.get("tidoffset").intValue();
                                insert_tid = insertTidOffset <= updateCountOffset ? 0L : RowidConverter.convertToRowID(cmd, insertTidOffset + 1);
                            }
                            if (this.resultset == null) {
                                this.resultset = this.statement.createResultSet(fields, tuples, command, update_count, insert_tid);
                                int index = this.connection.checkPlanID(planID);
                                if (planID != null && tuples != null && tuples.size() >= fetchSize) {
                                    if (index == -1) {
                                        this.resultset.setPlanID(planID);
                                        this.connection.addPlanID(planID);
                                    }
                                } else {
                                    if (index > -1) {
                                        this.connection.removePlanID(index);
                                    }
                                    this.resultset.setPlanID(null);
                                }
                                if (resultTid) {
                                    this.resultset.setTidValues(tidField, tidList);
                                }
                                if (tag1 == '1' && tag2 == '0' && this.statement.isCursorUsed()) {
                                    this.resultset.setCursorUsed(true);
                                }
                            } else {
                                if (tag1 == '1' && tag2 == '0' && this.statement.isCursorUsed()) {
                                    this.resultset.setCursorUsed(true);
                                } else if (tag1 == '1' && tag2 == '1' && this.statement.isCursorUsed()) {
                                    this.resultset.setCursorUsed(true);
                                } else {
                                    this.resultset.setCursorUsed(false);
                                }
                                if (this.resultset.isCursorUsed()) {
                                    int moveSize = 0;
                                    moveSize = Integer.parseInt(command.substring(1 + command.indexOf(32)));
                                    if (tag1 == '1' && tag2 == '0') {
                                        this.resultset.reInit(fields, tuples, command, update_count, insert_tid);
                                        if (resultTid) {
                                            this.resultset.setTidValues(tidField, tidList);
                                        }
                                        this.resultset.setCursorMoveSize(moveSize);
                                        int index = this.connection.checkPlanID(planID);
                                        if (planID != null && tuples != null && tuples.size() >= fetchSize) {
                                            if (index == -1) {
                                                this.resultset.setPlanID(planID);
                                                this.connection.addPlanID(planID);
                                            }
                                        } else {
                                            if (index > -1) {
                                                this.connection.removePlanID(index);
                                            }
                                            this.resultset.setPlanID(null);
                                        }
                                    } else if (tag1 == '1' && tag2 == '1') {
                                        this.resultset.setCursorMoveSize(moveSize);
                                    }
                                } else if (this.resultset.isClosed()) {
                                    this.resultset.reInit(fields, tuples, command, update_count, insert_tid);
                                    if (resultTid) {
                                        this.resultset.setTidValues(tidField, tidList);
                                    }
                                } else {
                                    BaseResultSet rs = this.statement.createResultSet(fields, tuples, command, update_count, insert_tid);
                                    if (resultTid) {
                                        this.resultset.setTidValues(tidField, tidList);
                                    }
                                    this.resultset.append(rs);
                                }
                            }
                        }
                        tuples = new ArrayList();
                        resultTid = false;
                        tidList = null;
                        fields = null;
                        update_count = -2L;
                        insert_tid = 0L;
                        continue;
                    }
                    if (this.bk instanceof ParamInforPacket) {
                        this.getMessage(this.osr_input, this.bk);
                        this.statement.setParamInfor(((ParamInforPacket)this.bk).getParamInfo());
                        continue;
                    }
                    if (this.bk instanceof EmptyQueryResponsePacket) {
                        this.getMessage(this.osr_input, this.bk);
                        continue;
                    }
                    if (this.bk instanceof CursorResponsePacket) {
                        this.getMessage(this.osr_input, this.bk);
                        continue;
                    }
                    if (this.bk instanceof ErrorResponsePacket) {
                        this.status = -1;
                        this.getMessage(this.osr_input, this.bk);
                        ErrorResponsePacket errorPacket = (ErrorResponsePacket)this.bk;
                        if (encodingFlag) {
                            if (exception == null) {
                                exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage()));
                                continue;
                            }
                            exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage())));
                            continue;
                        }
                        if (exception == null) {
                            exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage()));
                            continue;
                        }
                        exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage())));
                        continue;
                    }
                    if (this.bk instanceof NoticeResponsePacket) {
                        this.getMessage(this.osr_input, this.bk);
                        if (encodingFlag) {
                            this.statement.addWarning(this.connection.getClientEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), new String(((NoticeResponsePacket)this.bk).getSQLState()));
                            continue;
                        }
                        this.statement.addWarning(this.connection.getEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), new String(((NoticeResponsePacket)this.bk).getSQLState()));
                        continue;
                    }
                    if (this.bk instanceof ImportPacket) {
                        ((ImportPacket)this.bk).setEncoding(this.statement.getDBConnection().getEncoding());
                        ((ImportPacket)this.bk).setImportValues(this.statement.getImportValues());
                        this.sendMessage(this.osr_output, this.bk);
                        this.statement.importValues(null);
                        continue;
                    }
                    if (this.bk instanceof ImportExportResponsePacket) {
                        this.getMessage(this.osr_input, this.bk);
                        this.statement.setTransferRowCount(((ImportExportResponsePacket)this.bk).getAmount());
                        continue;
                    }
                    if (this.bk instanceof ReadyForQueryPacket) {
                        this.status = 1;
                        this.getMessage(this.osr_input, this.bk);
                        continue;
                    }
                    this.status = -1;
                    OSQLException e = new OSQLException("OSCAR-00109", "08003", 109);
                    if (this.logFlag) {
                        Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + e.getMessage());
                    }
                    throw e;
                } while (!(this.bk instanceof ReadyForQueryPacket));
                if (exception != null) {
                    if (this.logFlag) {
                        Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + exception.getMessage());
                    }
                    throw exception;
                }
            }
            catch (SocketTimeoutException e) {
                if (this.logFlag) {
                    Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + e.getMessage());
                }
                this.closePlanID(planID);
                this.status = -1;
                throw new SQLRecoverableException("IO Error: " + e.getMessage(), e);
            }
            catch (IOException e) {
                if (this.logFlag) {
                    Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + e.getMessage());
                }
                this.closePlanID(planID);
                this.status = -1;
                throw new OSQLException("OSCAR-00109", "08003", 109, e);
            }
            catch (OSQLException e) {
                this.closePlanID(planID);
                throw e;
            }
            catch (Exception e) {
                if (this.logFlag) {
                    Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + e.getMessage());
                }
                this.closePlanID(planID);
                this.status = -1;
                throw new OSQLException("OSCAR-00318", "08003", 318, e);
            }
            return this.resultset;
        }
    }

    private void closePlanID(byte[] planID) {
        if (this.resultset == null && planID != null) {
            int index = this.connection.checkPlanID(planID);
            if (index > -1) {
                try {
                    this.fetchMore(null, null, null, null, planID, 0, 0, true, false, this.statement, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (index > -1) {
                this.connection.removePlanID(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseResultSet execute(String prepareSQL, String statementName, int[] bindTypes, Object[] m_binds, int maxRows, BaseStatement stmt, boolean bindTypeChanged) throws SQLException {
        if (this.logFlag) {
            StringBuffer sb = new StringBuffer();
            sb.append(OSCARProtocolV2.class).append(", execute, paras: ").append("\n");
            sb.append(" sql: ").append(prepareSQL).append(", ");
            sb.append(" prepareName:").append(statementName).append(", ");
            sb.append(" bindTypes: ");
            if (bindTypes == null) {
                sb.append("null");
            } else {
                for (int i = 0; i < bindTypes.length; ++i) {
                    sb.append(bindTypes[i]).append(" ");
                }
            }
            if (m_binds != null) {
                sb.append(" bindDatas: ");
                for (int i = 0; i < m_binds.length; ++i) {
                    byte[] tmp = (byte[])m_binds[i];
                    if (tmp == null) {
                        sb.append("null").append(" ");
                        continue;
                    }
                    for (int j = 0; j < tmp.length; ++j) {
                        sb.append(tmp[j]).append(" ");
                    }
                }
                sb.append("\n");
            }
            sb.append(" maxRows: ").append(maxRows);
            sb.append(" bindTypeChanged: ").append(bindTypeChanged);
            Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), sb.toString());
        }
        OSCARProtocolV2 oSCARProtocolV2 = this;
        synchronized (oSCARProtocolV2) {
            OSQLException exception = null;
            this.statement = stmt;
            this.status = 0;
            this.resultset = (BaseResultSet)stmt.getResultSet();
            if (this.resultset != null && !this.resultset.isCursorUsed()) {
                this.resultset = null;
            }
            try {
                boolean encodingFlag;
                int marked = 0;
                boolean bl = encodingFlag = this.connection.getEncoding() == null;
                if (this.statement.isDDLSql()) {
                    marked = 3;
                    this.statement.resetDDLSql(false);
                } else if (this.statement.isPrepareAndNotRealPrepare()) {
                    marked = 4;
                } else if (this.statement.getAutoGeneratedInfo() != -1) {
                    String sql;
                    marked = 2;
                    if (prepareSQL != null && !(sql = this.statement.generatedKeySqlTransform(prepareSQL)).equals(prepareSQL)) {
                        prepareSQL = sql;
                        marked = 0;
                    }
                } else if (this.statement.useTid()) {
                    marked = 1;
                }
                ExecutePacket qp = new ExecutePacket(this.connection.getEncoding(), prepareSQL, statementName, bindTypes, m_binds, marked, bindTypeChanged, this.statement.isHaveFuncRetrun(), this.connection.getProtocolVersion().getProtocolType());
                qp.setConnection(this.connection);
                ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
                boolean resultTid = false;
                ArrayList<byte[]> tidList = null;
                Field[] fields = this.statement.getFields();
                long update_count = -2L;
                long insert_tid = 0L;
                Field[] tmpFields = this.statement.getFields();
                Field tidField = null;
                int columnCount = 0;
                this.sendMessage(this.osr_output, qp);
                do {
                    int i;
                    boolean timeout = true;
                    int getMessageTimes = 0;
                    do {
                        try {
                            this.bk = this.getMessage(this.osr_input);
                            timeout = false;
                        }
                        catch (Throwable e) {
                            if (this.isSocketConnectionError(e)) {
                                timeout = false;
                                this.status = -1;
                                throw new OSQLException("OSCAR-00901", "08003", 901, e);
                            }
                            if (this.ping(this.oStream)) {
                                if (e instanceof SocketTimeoutException || !this.needRetry(++getMessageTimes)) {
                                    timeout = false;
                                    this.status = -1;
                                    throw (SocketTimeoutException)e;
                                }
                                timeout = true;
                                continue;
                            }
                            timeout = false;
                            this.status = -1;
                            throw new OSQLException("OSCAR-00901", "08003", 901, e);
                        }
                    } while (timeout);
                    if (this.bk instanceof RowDescriptionPacket) {
                        this.getMessage(this.osr_input, this.bk);
                        Field[] tempFields = ((RowDescriptionPacket)this.bk).getFields();
                        columnCount = tempFields.length;
                        if (columnCount > 0) {
                            if ((this.statement.useTid() || this.statement.getAutoGeneratedInfo() != -1) && tempFields[0].getAliasName().equalsIgnoreCase("ROWID")) {
                                resultTid = true;
                                tidField = tempFields[0];
                                tidList = new ArrayList<byte[]>();
                                if (columnCount != 1) {
                                    fields = new Field[columnCount - 1];
                                    for (int i2 = 0; i2 < columnCount - 1; ++i2) {
                                        fields[i2] = tempFields[i2 + 1];
                                    }
                                }
                            } else {
                                fields = tempFields;
                            }
                        } else {
                            fields = new Field[]{};
                        }
                        if (tmpFields != null && fields.length != tmpFields.length && tmpFields.length > fields.length) {
                            for (int j = 0; j < fields.length; ++j) {
                                for (i = 0; i < tmpFields.length; ++i) {
                                    if (tmpFields[i] == null) continue;
                                    tmpFields[i] = fields[j];
                                }
                            }
                            this.statement.setFields(tempFields);
                            continue;
                        }
                        this.statement.setFields(fields);
                        continue;
                    }
                    if (this.bk instanceof AsciiRowPacketV2) {
                        columnCount = fields.length;
                        ((AsciiRowPacketV2)this.bk).initTuple(columnCount, fields);
                        this.getMessage(this.osr_input, this.bk);
                        byte[][] tempTuple = ((AsciiRowPacketV2)this.bk).getTuple();
                        Object tuple = null;
                        if (columnCount <= 0 || maxRows != 0 && tuples.size() >= maxRows) continue;
                        if (resultTid && tempTuple.length > 0) {
                            tidList.add(tempTuple[0]);
                            tuple = new byte[tempTuple.length - 1][];
                            for (i = 0; i < tempTuple.length - 1; ++i) {
                                tuple[i] = tempTuple[i + 1];
                            }
                        } else {
                            tuple = tempTuple;
                        }
                        tuples.add((byte[][])tuple);
                        continue;
                    }
                    if (this.bk instanceof CompleteResponsePacket) {
                        this.getMessage(this.osr_input, this.bk);
                        String command = this.connection.getEncoding().decode(((CompleteResponsePacket)this.bk).getCommand());
                        if (command.length() < 2) continue;
                        char tag1 = command.charAt(0);
                        char tag2 = command.charAt(1);
                        if (tag1 == '5' && tag2 == '0') {
                            char tag3 = command.charAt(3);
                            if (tag3 == '0') {
                                this.statement.setResultSetCanUpdateable(false);
                            } else if (tag3 == '1') {
                                this.statement.setResultSetCanUpdateable(true);
                            }
                        } else if (tag1 == '3') {
                            if (tag2 == '0') {
                                this.connection.setInTranscation(true);
                            } else if (tag2 == '1' || tag2 == '2' || tag2 == '3') {
                                this.connection.setInTranscation(false);
                            }
                        } else if (tag1 == '0' && tag2 != '6' && tag2 <= 'S' || tag1 == '1' && (tag2 == '0' || tag2 == '1') || tag1 == '2' && tag2 != '2' || tag1 == '5' && tag2 == '5' || tag1 == '4' && tag2 == '0' || tag1 == '4' && tag2 == '5' || tag1 == '4' && tag2 == '8' || tag1 == '5' && tag2 == '6' || tag1 == '5' && tag2 == 'D') {
                            int updateCountOffset;
                            if (tag1 == '0' && tag2 != '6' && tag2 <= 'S') {
                                update_count = 0L;
                            }
                            if (tag1 == '4' && tag2 == '0') {
                                update_count = 0L;
                            }
                            byte[] cmd = ((CompleteResponsePacket)this.bk).getCommand();
                            if (tag1 == '2' && (tag2 == '0' || tag2 == '5')) {
                                updateCountOffset = this.getFirstBlankPosition(cmd, 0);
                                update_count = RowidConverter.convertToRowID(cmd, updateCountOffset + 1);
                            }
                            if (tag1 == '2' && tag2 == '1') {
                                updateCountOffset = this.getFirstBlankPosition(cmd, 0);
                                HashMap<String, Long> map = RowidConverter.convertToUpdateCount(cmd, updateCountOffset + 1);
                                update_count = map.get("updatecount");
                                int insertTidOffset = map.get("tidoffset").intValue();
                                insert_tid = insertTidOffset <= updateCountOffset ? 0L : RowidConverter.convertToRowID(cmd, insertTidOffset + 1);
                            }
                            if (this.resultset == null) {
                                this.resultset = this.statement.createResultSet(fields, tuples, command, update_count, insert_tid);
                                if (resultTid) {
                                    this.resultset.setTidValues(tidField, tidList);
                                }
                                if (tag1 == '1' && tag2 == '0' && this.statement.isCursorUsed()) {
                                    this.resultset.setCursorUsed(true);
                                }
                                this.connection.addCursor(this.resultset.getCursorName());
                            } else {
                                if (tag1 == '1' && tag2 == '0' && this.statement.isCursorUsed()) {
                                    this.resultset.setCursorUsed(true);
                                } else if (tag1 == '1' && tag2 == '1' && this.statement.isCursorUsed()) {
                                    this.resultset.setCursorUsed(true);
                                } else {
                                    this.resultset.setCursorUsed(false);
                                }
                                if (this.resultset.isCursorUsed()) {
                                    int moveSize = 0;
                                    moveSize = Integer.parseInt(command.substring(1 + command.indexOf(32)));
                                    if (tag1 == '1' && tag2 == '0') {
                                        this.resultset.reInit(fields, tuples, command, update_count, insert_tid);
                                        if (resultTid) {
                                            this.resultset.setTidValues(tidField, tidList);
                                        }
                                        this.resultset.setCursorMoveSize(moveSize);
                                    } else if (tag1 == '1' && tag2 == '1') {
                                        this.resultset.setCursorMoveSize(moveSize);
                                    }
                                } else if (this.resultset.isClosed()) {
                                    this.resultset.reInit(fields, tuples, command, update_count, insert_tid);
                                    if (resultTid) {
                                        this.resultset.setTidValues(tidField, tidList);
                                    }
                                    this.connection.addCursor(this.resultset.getCursorName());
                                } else {
                                    BaseResultSet rs = this.statement.createResultSet(fields, tuples, command, update_count, insert_tid);
                                    if (resultTid) {
                                        this.resultset.setTidValues(tidField, tidList);
                                    }
                                    this.resultset.append(rs);
                                    this.connection.addCursor(rs.getCursorName());
                                }
                            }
                        }
                        tuples = new ArrayList();
                        resultTid = false;
                        tidList = null;
                        fields = null;
                        update_count = -2L;
                        insert_tid = 0L;
                        continue;
                    }
                    if (this.bk instanceof ParamInforPacket) {
                        this.getMessage(this.osr_input, this.bk);
                        this.statement.setParamInfor(((ParamInforPacket)this.bk).getParamInfo());
                        continue;
                    }
                    if (this.bk instanceof EmptyQueryResponsePacket) {
                        this.getMessage(this.osr_input, this.bk);
                        continue;
                    }
                    if (this.bk instanceof CursorResponsePacket) {
                        this.getMessage(this.osr_input, this.bk);
                        continue;
                    }
                    if (this.bk instanceof ErrorResponsePacket) {
                        this.status = -1;
                        this.getMessage(this.osr_input, this.bk);
                        ErrorResponsePacket errorPacket = (ErrorResponsePacket)this.bk;
                        if (encodingFlag) {
                            if (exception == null) {
                                exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage()));
                                continue;
                            }
                            exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage())));
                            continue;
                        }
                        if (exception == null) {
                            exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage()));
                            continue;
                        }
                        exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage())));
                        continue;
                    }
                    if (this.bk instanceof NoticeResponsePacket) {
                        this.getMessage(this.osr_input, this.bk);
                        if (encodingFlag) {
                            this.statement.addWarning(this.connection.getClientEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), new String(((NoticeResponsePacket)this.bk).getSQLState()));
                            continue;
                        }
                        this.statement.addWarning(this.connection.getEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), new String(((NoticeResponsePacket)this.bk).getSQLState()));
                        continue;
                    }
                    if (this.bk instanceof ImportPacket) {
                        ((ImportPacket)this.bk).setEncoding(this.statement.getDBConnection().getEncoding());
                        ((ImportPacket)this.bk).setImportValues(this.statement.getImportValues());
                        this.sendMessage(this.osr_output, this.bk);
                        this.statement.importValues(null);
                        continue;
                    }
                    if (this.bk instanceof ImportExportResponsePacket) {
                        this.getMessage(this.osr_input, this.bk);
                        this.statement.setTransferRowCount(((ImportExportResponsePacket)this.bk).getAmount());
                        continue;
                    }
                    if (this.bk instanceof ReadyForQueryPacket) {
                        this.status = 1;
                        this.getMessage(this.osr_input, this.bk);
                        continue;
                    }
                    this.status = -1;
                    OSQLException e = new OSQLException("OSCAR-00109", "08003", 109);
                    if (this.logFlag) {
                        Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), e.getMessage());
                    }
                    throw e;
                } while (!(this.bk instanceof ReadyForQueryPacket));
                if (exception != null) {
                    if (this.logFlag) {
                        Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + exception.getMessage());
                    }
                    throw exception;
                }
            }
            catch (SocketTimeoutException e) {
                if (this.logFlag) {
                    Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + e.getMessage());
                }
                this.status = -1;
                throw new OSQLException("OSCAR-00901", "08003", 901, e);
            }
            catch (IOException e) {
                if (this.logFlag) {
                    Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + e.getMessage());
                }
                this.status = -1;
                throw new OSQLException("OSCAR-00109", "08003", 109, e);
            }
            catch (OSQLException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.logFlag) {
                    Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + e.getMessage());
                }
                this.status = -1;
                throw new OSQLException("OSCAR-00318", "08003", 318, e);
            }
            return this.resultset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseResultSet query(String queryStr, int maxRows, BaseStatement stmt, BaseResultSet res) throws SQLException {
        if (this.logFlag) {
            StringBuffer sb = new StringBuffer();
            sb.append(OSCARProtocolV2.class).append(", query, paras: ").append("\n");
            sb.append(" sql: ").append(queryStr).append(", ");
            sb.append(" maxRows: ").append(maxRows);
            Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), sb.toString());
        }
        OSCARProtocolV2 oSCARProtocolV2 = this;
        synchronized (oSCARProtocolV2) {
            OSQLException exception = null;
            this.statement = stmt;
            this.status = 0;
            boolean encodingFlag = this.connection.getEncoding() == null;
            this.resultset = res;
            if (this.resultset != null && !this.resultset.isCursorUsed()) {
                this.resultset = null;
            }
            try {
                int marked = 0;
                if (this.statement.isDDLSql()) {
                    marked = 0;
                    this.statement.resetDDLSql(false);
                } else if (this.statement.isPrepareAndNotRealPrepare()) {
                    marked = 4;
                } else if (this.statement.getAutoGeneratedInfo() != -1) {
                    String sql;
                    marked = 2;
                    if (queryStr != null && !(sql = this.statement.generatedKeySqlTransform(queryStr)).equals(queryStr)) {
                        queryStr = sql;
                        marked = 0;
                    }
                } else if (this.statement.useTid()) {
                    marked = 1;
                }
                QueryPacketV2 qp = null;
                qp = encodingFlag ? new QueryPacketV2(this.connection.getClientEncoding().encode(queryStr), marked) : new QueryPacketV2(this.connection.getEncoding().encode(queryStr), marked);
                qp.setConnection(this.connection);
                ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
                boolean resultTid = false;
                ArrayList<byte[]> tidList = null;
                Field[] fields = null;
                long update_count = -2L;
                long insert_tid = 0L;
                Field[] tempFields = null;
                Field tidField = null;
                int columnCount = 0;
                this.sendMessage(this.osr_output, qp);
                do {
                    boolean timeout = true;
                    int getMessageTimes = 0;
                    do {
                        try {
                            this.bk = this.getMessage(this.osr_input);
                            timeout = false;
                        }
                        catch (Throwable e) {
                            if (this.isSocketConnectionError(e)) {
                                timeout = false;
                                this.status = -1;
                                throw new OSQLException("OSCAR-00901", "08003", 901, e);
                            }
                            if (this.ping(this.oStream)) {
                                if (e instanceof SocketTimeoutException || !this.needRetry(++getMessageTimes)) {
                                    timeout = false;
                                    this.status = -1;
                                    throw (SocketTimeoutException)e;
                                }
                                timeout = true;
                                continue;
                            }
                            timeout = false;
                            this.status = -1;
                            throw new OSQLException("OSCAR-00901", "08003", 901, e);
                        }
                    } while (timeout);
                    if (this.bk instanceof RowDescriptionPacket) {
                        this.getMessage(this.osr_input, this.bk);
                        tempFields = ((RowDescriptionPacket)this.bk).getFields();
                        columnCount = tempFields.length;
                        if (columnCount > 0) {
                            if ((this.statement.useTid() || this.statement.getAutoGeneratedInfo() != -1) && tempFields[0].getAliasName().equalsIgnoreCase("ROWID")) {
                                resultTid = true;
                                tidField = tempFields[0];
                                tidList = new ArrayList<byte[]>();
                                if (columnCount != 1) {
                                    fields = new Field[columnCount - 1];
                                    for (int i = 0; i < columnCount - 1; ++i) {
                                        fields[i] = tempFields[i + 1];
                                    }
                                }
                            } else {
                                fields = tempFields;
                            }
                        } else {
                            fields = new Field[]{};
                        }
                        this.statement.setFields(fields);
                        continue;
                    }
                    if (this.bk instanceof AsciiRowPacketV2) {
                        if (resultTid) {
                            ((AsciiRowPacketV2)this.bk).initTuple(columnCount, tempFields);
                        } else {
                            ((AsciiRowPacketV2)this.bk).initTuple(columnCount, fields);
                        }
                        this.getMessage(this.osr_input, this.bk);
                        byte[][] tempTuple = ((AsciiRowPacketV2)this.bk).getTuple();
                        Object tuple = null;
                        if (columnCount <= 0 || maxRows != 0 && tuples.size() >= maxRows) continue;
                        if (resultTid && tempTuple.length > 0) {
                            tidList.add(tempTuple[0]);
                            tuple = new byte[tempTuple.length - 1][];
                            for (int i = 0; i < tempTuple.length - 1; ++i) {
                                tuple[i] = tempTuple[i + 1];
                            }
                        } else {
                            tuple = tempTuple;
                        }
                        tuples.add((byte[][])tuple);
                        continue;
                    }
                    if (this.bk instanceof CompleteResponsePacket) {
                        this.getMessage(this.osr_input, this.bk);
                        String command = null;
                        command = encodingFlag ? this.connection.getClientEncoding().decode(((CompleteResponsePacket)this.bk).getCommand()) : this.connection.getEncoding().decode(((CompleteResponsePacket)this.bk).getCommand());
                        if (command.length() < 2) continue;
                        char tag1 = command.charAt(0);
                        char tag2 = command.charAt(1);
                        if (tag1 == '5' && tag2 == '0') {
                            char tag3 = command.charAt(3);
                            if (tag3 == '0') {
                                this.statement.setResultSetCanUpdateable(false);
                            } else if (tag3 == '1') {
                                this.statement.setResultSetCanUpdateable(true);
                            }
                        } else if (tag1 == '3') {
                            if (tag2 == '0') {
                                this.connection.setInTranscation(true);
                            } else if (tag2 == '1' || tag2 == '2' || tag2 == '3') {
                                this.connection.setInTranscation(false);
                            }
                        } else if (tag1 == '0' && tag2 != '6' && tag2 <= 'S' || tag1 == '1' && (tag2 == '0' || tag2 == '1') || tag1 == '2' && tag2 != '2' || tag1 == '5' && tag2 == '5' || tag1 == '4' && tag2 == '0' || tag1 == '4' && tag2 == '5' || tag1 == '4' && tag2 == '8' || tag1 == '5' && tag2 == '6' || tag1 == '5' && tag2 == 'D') {
                            int updateCountOffset;
                            if (tag1 == '0' && tag2 != '6' && tag2 <= 'S') {
                                update_count = 0L;
                            }
                            if (tag1 == '4' && tag2 == '0') {
                                update_count = 0L;
                            }
                            byte[] cmd = ((CompleteResponsePacket)this.bk).getCommand();
                            if (tag1 == '2' && (tag2 == '0' || tag2 == '5')) {
                                updateCountOffset = this.getFirstBlankPosition(cmd, 0);
                                update_count = RowidConverter.convertToRowID(cmd, updateCountOffset + 1);
                            }
                            if (tag1 == '2' && tag2 == '1') {
                                updateCountOffset = this.getFirstBlankPosition(cmd, 0);
                                HashMap<String, Long> map = RowidConverter.convertToUpdateCount(cmd, updateCountOffset + 1);
                                update_count = map.get("updatecount");
                                int insertTidOffset = map.get("tidoffset").intValue();
                                insert_tid = insertTidOffset <= updateCountOffset ? 0L : RowidConverter.convertToRowID(cmd, insertTidOffset + 1);
                            }
                            if (this.resultset == null) {
                                this.resultset = this.statement.createResultSet(fields, tuples, command, update_count, insert_tid);
                                if (resultTid) {
                                    this.resultset.setTidValues(tidField, tidList);
                                }
                                if (tag1 == '1' && tag2 == '0' && this.statement.isCursorUsed()) {
                                    this.resultset.setCursorUsed(true);
                                }
                                this.connection.addCursor(this.resultset.getCursorName());
                            } else {
                                if (tag1 == '1' && tag2 == '0' && this.statement.isCursorUsed()) {
                                    this.resultset.setCursorUsed(true);
                                } else if (tag1 == '1' && tag2 == '1' && this.statement.isCursorUsed()) {
                                    this.resultset.setCursorUsed(true);
                                } else {
                                    this.resultset.setCursorUsed(false);
                                }
                                if (this.resultset.isCursorUsed()) {
                                    int moveSize = 0;
                                    moveSize = Integer.parseInt(command.substring(1 + command.indexOf(32)));
                                    if (tag1 == '1' && tag2 == '0') {
                                        this.resultset.reInit(fields, tuples, command, update_count, insert_tid);
                                        if (resultTid) {
                                            this.resultset.setTidValues(tidField, tidList);
                                        }
                                        this.resultset.setCursorMoveSize(moveSize);
                                    } else if (tag1 == '1' && tag2 == '1') {
                                        this.resultset.setCursorMoveSize(moveSize);
                                    }
                                } else if (this.resultset.isClosed()) {
                                    this.resultset.reInit(fields, tuples, command, update_count, insert_tid);
                                    if (resultTid) {
                                        this.resultset.setTidValues(tidField, tidList);
                                    }
                                    this.connection.addCursor(this.resultset.getCursorName());
                                } else {
                                    BaseResultSet rs = this.statement.createResultSet(fields, tuples, command, update_count, insert_tid);
                                    if (resultTid) {
                                        this.resultset.setTidValues(tidField, tidList);
                                    }
                                    this.resultset.append(rs);
                                    this.connection.addCursor(rs.getCursorName());
                                }
                            }
                        }
                        if (this.resultset == null) {
                            this.resultset = this.statement.createResultSet(new Field[0], new ArrayList<byte[][]>(), null, 0L, 0L);
                        }
                        tuples = new ArrayList();
                        resultTid = false;
                        tidList = null;
                        fields = null;
                        update_count = -2L;
                        insert_tid = 0L;
                        continue;
                    }
                    if (this.bk instanceof ParamInforPacket) {
                        this.getMessage(this.osr_input, this.bk);
                        this.statement.setParamInfor(((ParamInforPacket)this.bk).getParamInfo());
                        continue;
                    }
                    if (this.bk instanceof EmptyQueryResponsePacket) {
                        this.getMessage(this.osr_input, this.bk);
                        continue;
                    }
                    if (this.bk instanceof CursorResponsePacket) {
                        this.getMessage(this.osr_input, this.bk);
                        continue;
                    }
                    if (this.bk instanceof ErrorResponsePacket) {
                        this.status = -1;
                        this.getMessage(this.osr_input, this.bk);
                        ErrorResponsePacket errorPacket = (ErrorResponsePacket)this.bk;
                        if (encodingFlag) {
                            if (exception == null) {
                                exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage()));
                                continue;
                            }
                            exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage())));
                            continue;
                        }
                        if (exception == null) {
                            exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage()));
                            continue;
                        }
                        exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage())));
                        continue;
                    }
                    if (this.bk instanceof NoticeResponsePacket) {
                        this.getMessage(this.osr_input, this.bk);
                        if (encodingFlag) {
                            this.statement.addWarning(this.connection.getClientEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), new String(((NoticeResponsePacket)this.bk).getSQLState()));
                            continue;
                        }
                        this.statement.addWarning(this.connection.getEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), new String(((NoticeResponsePacket)this.bk).getSQLState()));
                        continue;
                    }
                    if (this.bk instanceof ImportPacket) {
                        if (encodingFlag) {
                            ((ImportPacket)this.bk).setEncoding(this.statement.getDBConnection().getClientEncoding());
                        } else {
                            ((ImportPacket)this.bk).setEncoding(this.statement.getDBConnection().getEncoding());
                        }
                        ((ImportPacket)this.bk).setImportValues(this.statement.getImportValues());
                        this.sendMessage(this.osr_output, this.bk);
                        this.statement.importValues(null);
                        continue;
                    }
                    if (this.bk instanceof ImportExportResponsePacket) {
                        this.getMessage(this.osr_input, this.bk);
                        this.statement.setTransferRowCount(((ImportExportResponsePacket)this.bk).getAmount());
                        continue;
                    }
                    if (this.bk instanceof ReadyForQueryPacket) {
                        this.status = 1;
                        this.getMessage(this.osr_input, this.bk);
                        continue;
                    }
                    if (this.bk instanceof NewImportPacket) {
                        this.status = -1;
                        OSQLException e = new OSQLException("OSCAR-00436", "88888", 436);
                        if (this.logFlag) {
                            Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + e.getMessage());
                        }
                        throw e;
                    }
                    this.status = -1;
                    OSQLException e = new OSQLException("OSCAR-00109", "08003", 109);
                    if (this.logFlag) {
                        Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + e.getMessage());
                    }
                    throw e;
                } while (!(this.bk instanceof ReadyForQueryPacket));
                if (exception != null) {
                    if (this.logFlag) {
                        Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + exception.getMessage());
                    }
                    throw exception;
                }
            }
            catch (SocketTimeoutException e) {
                if (this.logFlag) {
                    Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + e.getMessage());
                }
                this.status = -1;
                throw new OSQLException("OSCAR-00901", "08003", 901, e);
            }
            catch (IOException e) {
                if (this.logFlag) {
                    Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + e.getMessage());
                }
                this.status = -1;
                throw new OSQLException("OSCAR-00109", "08003", 109, e);
            }
            catch (OSQLException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.logFlag) {
                    Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + e.getMessage());
                }
                this.status = -1;
                throw new OSQLException("OSCAR-00318", "08003", 318, e);
            }
            return this.resultset;
        }
    }

    private int getFirstBlankPosition(byte[] value, int offset) {
        if (value == null || offset >= value.length) {
            return -1;
        }
        for (int i = offset; i < value.length; ++i) {
            if (value[i] != 32) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] functionCall(int funcOID, int paraCount, int[] paraLenth, Object[] paraValue) throws SQLException {
        if (this.logFlag) {
            int i;
            StringBuffer sb = new StringBuffer();
            sb.append(OSCARProtocolV2.class).append(", functionCall, paras: ").append("\n");
            sb.append(" funcOID: ").append(funcOID).append(", ");
            sb.append(" paraCount: ").append(paraCount);
            sb.append(" funcOID: ").append(funcOID);
            if (paraLenth != null) {
                sb.append("paraLenth: ");
                for (i = 0; i < paraLenth.length; ++i) {
                    sb.append(paraLenth[i]).append(" ");
                }
            }
            if (paraLenth != null) {
                sb.append("paraValue: ");
                for (i = 0; i < paraValue.length; ++i) {
                    if (paraValue[i] instanceof byte[]) {
                        sb.append(Arrays.toString((byte[])paraValue[i]));
                        continue;
                    }
                    sb.append(paraValue[i]).append(" ");
                }
            }
            Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), sb.toString());
        }
        FunctionCallPacketV2 fcp = new FunctionCallPacketV2(funcOID, paraCount, paraLenth, paraValue);
        fcp.setConnection(this.connection);
        Object[] result = new Object[3];
        boolean encodingFlag = this.connection.getEncoding() == null;
        OSCARProtocolV2 oSCARProtocolV2 = this;
        synchronized (oSCARProtocolV2) {
            OSQLException exception;
            block31: {
                exception = null;
                this.status = 0;
                try {
                    this.sendMessage(this.osr_output, fcp);
                }
                catch (IOException e) {
                    if (this.logFlag) {
                        Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), e.getMessage());
                    }
                    throw new OSQLException("OSCAR-00108", "88888", 108, e.getMessage());
                }
                try {
                    do {
                        this.bk = this.getMessage(this.osr_input);
                        if (this.bk instanceof ErrorResponsePacket) {
                            this.status = -1;
                            this.getMessage(this.osr_input, this.bk);
                            ErrorResponsePacket errorPacket = (ErrorResponsePacket)this.bk;
                            if (encodingFlag) {
                                if (exception == null) {
                                    exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage()));
                                    continue;
                                }
                                exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage())));
                                continue;
                            }
                            if (exception == null) {
                                exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage()));
                                continue;
                            }
                            exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage())));
                            continue;
                        }
                        if (this.bk instanceof NoticeResponsePacket) {
                            this.getMessage(this.osr_input, this.bk);
                            if (encodingFlag) {
                                this.statement.addWarning(this.connection.getClientEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), new String(((NoticeResponsePacket)this.bk).getSQLState()));
                                continue;
                            }
                            this.statement.addWarning(this.connection.getEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), new String(((NoticeResponsePacket)this.bk).getSQLState()));
                            continue;
                        }
                        if (this.bk instanceof FunctionResponsePacket) {
                            this.getMessage(this.osr_input, this.bk);
                            result[0] = ((FunctionResponsePacket)this.bk).isNull();
                            result[1] = ((FunctionResponsePacket)this.bk).getResultSize();
                            result[2] = ((FunctionResponsePacket)this.bk).getResult();
                            continue;
                        }
                        if (this.bk instanceof ReadyForQueryPacket) {
                            this.status = 1;
                            this.getMessage(this.osr_input, this.bk);
                            continue;
                        }
                        this.status = -1;
                        throw new OSQLException("OSCAR-00109", "08003", 109);
                    } while (!(this.bk instanceof ReadyForQueryPacket));
                }
                catch (SocketTimeoutException e) {
                    if (this.logFlag) {
                        Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + e.getMessage());
                    }
                    this.status = -1;
                    throw new OSQLException("OSCAR-00901", "08003", 901, e);
                }
                catch (IOException e) {
                    if (this.logFlag) {
                        Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + e.getMessage());
                    }
                    this.status = -1;
                    throw new OSQLException("OSCAR-00109", "08003", 109, e);
                }
                catch (OSQLException e) {
                    if (this.logFlag) {
                        Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + e.getMessage());
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (!this.logFlag) break block31;
                    Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + e.getMessage());
                }
            }
            if (exception != null) {
                if (this.logFlag) {
                    Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + exception.getMessage());
                }
                throw exception;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchProcess(BatchProcessPacketV2 batchPacket, BaseStatement stmt, long[] updateCounts) throws SQLException {
        if (this.logFlag) {
            StringBuffer sb = new StringBuffer();
            sb.append(OSCARProtocolV2.class).append(", batchProcess");
            Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), sb.toString());
        }
        OSCARProtocolV2 oSCARProtocolV2 = this;
        synchronized (oSCARProtocolV2) {
            this.statement = stmt;
            int size = batchPacket.size();
            int position = 0;
            int lastPosition = 0;
            int columnCount = 0;
            Field tidField = null;
            try {
                int j = 0;
                for (j = 0; j < size; ++j) {
                    batchPacket.writeRow();
                    if (!batchPacket.checkBuffer()) continue;
                    batchPacket.sendBatch(this.osr_output);
                    this.receiveBatchResult(position, updateCounts, columnCount, tidField);
                    batchPacket.reInit();
                    lastPosition = this.reInitUpdateCounts(updateCounts, lastPosition, position);
                    position = j + 1;
                    this.statement.setUpdateBatchSize(position);
                }
                if (position != j) {
                    batchPacket.sendBatch(this.osr_output);
                    this.receiveBatchResult(position, updateCounts, columnCount, tidField);
                    this.reInitUpdateCounts(updateCounts, lastPosition, position);
                    this.statement.setUpdateBatchSize(j);
                }
                if (batchPacket.hasPrepareSQL()) {
                    batchPacket.setPrepareSQL(null);
                }
            }
            catch (IOException ex) {
                if (this.logFlag) {
                    Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + ex.getMessage());
                }
                throw new OSQLException("OSCAR-00109", "08003", 109, ex);
            }
            catch (OSQLException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.logFlag) {
                    Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + e.getMessage());
                }
                throw new OSQLException("OSCAR-00318", "08003", 318, e);
            }
        }
    }

    private int reInitUpdateCounts(long[] updateCounts, int lastPosition, int position) {
        if ((long)lastPosition + updateCounts[position] <= (long)updateCounts.length) {
            long count = updateCounts[position];
            int i = 0;
            while ((long)i < count) {
                updateCounts[lastPosition++] = 1L;
                ++i;
            }
            return lastPosition;
        }
        return lastPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException, SQLException {
        if (this.logFlag) {
            StringBuffer sb = new StringBuffer();
            sb.append(OSCARProtocolV2.class).append(", close");
            Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), sb.toString());
        }
        TerminatePacketV2 tp = new TerminatePacketV2();
        tp.setConnection(this.connection);
        if (this.oStream != null) {
            OSCARProtocolV2 oSCARProtocolV2 = this;
            synchronized (oSCARProtocolV2) {
                try {
                    this.sendMessage(this.osr_output, tp);
                    int flag = 1;
                    this.oStream.setSocketTimeOut(1000);
                    while (flag != -1) {
                        try {
                            flag = this.oStream.getInputStream().read();
                        }
                        catch (IOException e) {
                            // empty catch block
                            break;
                        }
                    }
                }
                catch (IOException ioex) {
                    if (this.logFlag) {
                        Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + ioex.getMessage());
                    }
                    throw ioex;
                }
                catch (SQLException sqlEx) {
                    if (this.logFlag) {
                        Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + sqlEx.getMessage());
                    }
                    throw sqlEx;
                }
                catch (Exception e) {
                    if (this.logFlag) {
                        Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + e.getMessage());
                    }
                    throw new OSQLException("OSCAR-00318", "08003", 318, e);
                }
                finally {
                    this.oStream.close();
                }
            }
        }
        tp = null;
        this.oStream = null;
        this.connection = null;
        this.host = "ErrorIP";
        this.database = null;
        this.db_user = null;
        this.db_passwd = null;
        this.statement = null;
        this.resultset = null;
        this.bk = null;
        this.pk = new Packet();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void receiveBatchResult(int position, long[] updateCounts, int columnCount, Field tidField) throws IOException, SQLException {
        if (this.logFlag) {
            sb = new StringBuffer();
            sb.append(OSCARProtocolV2.class).append(", receiveBatchResult");
            Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), sb.toString());
        }
        p = position;
        exception = null;
        this.resultset = (BaseResultSet)this.statement.getResultSet();
        encodingFlag = this.connection.getEncoding() == null;
        tuples = new ArrayList<byte[][]>();
        resultTid = false;
        tidList = null;
        fields = null;
        update_count = -2L;
        insert_tid = 0L;
        do {
            this.bk = this.getMessage(this.osr_input);
            if (!(this.bk instanceof RowDescriptionPacket)) ** GOTO lbl37
            this.getMessage(this.osr_input, this.bk);
            tempFields = ((RowDescriptionPacket)this.bk).getFields();
            columnCount = tempFields.length;
            if (columnCount <= 0) ** GOTO lbl35
            if ((this.statement.useTid() || this.statement.getAutoGeneratedInfo() != -1) && tempFields[0].getAliasName().equalsIgnoreCase("ROWID")) {
                resultTid = true;
                tidField = tempFields[0];
                tidList = new ArrayList<byte[]>();
                if (columnCount == 1) continue;
                fields = new Field[columnCount - 1];
                for (i = 0; i < columnCount - 1; ++i) {
                    fields[i] = tempFields[i + 1];
                }
            } else {
                fields = tempFields;
                continue;
lbl35:
                // 1 sources

                fields = new Field[]{};
                continue;
lbl37:
                // 1 sources

                if (this.bk instanceof AsciiRowPacketV2) {
                    ((AsciiRowPacketV2)this.bk).initTuple(columnCount, fields);
                    this.getMessage(this.osr_input, this.bk);
                    tempTuple = ((AsciiRowPacketV2)this.bk).getTuple();
                    tuple /* !! */  = null;
                    if (columnCount <= 0) continue;
                    if (resultTid && tempTuple.length > 0) {
                        tidList.add(tempTuple[0]);
                        tuple /* !! */  = new byte[tempTuple.length - 1][];
                        for (i = 0; i < tempTuple.length - 1; ++i) {
                            tuple /* !! */ [i] = tempTuple[i + 1];
                        }
                    } else {
                        tuple /* !! */  = tempTuple;
                    }
                    tuples.add(tuple /* !! */ );
                    continue;
                }
                if (this.bk instanceof CompleteResponsePacket) {
                    this.getMessage(this.osr_input, this.bk);
                    command = this.connection.getEncoding().decode(((CompleteResponsePacket)this.bk).getCommand());
                    if (command.length() < 2) continue;
                    tag1 = command.charAt(0);
                    tag2 = command.charAt(1);
                    if (tag1 == '5' && tag2 == '0') {
                        tag3 = command.charAt(3);
                        if (tag3 == '0') {
                            this.statement.setResultSetCanUpdateable(false);
                        } else if (tag3 == '1') {
                            this.statement.setResultSetCanUpdateable(true);
                        }
                    } else if (tag1 == '3') {
                        if (tag2 == '0') {
                            this.connection.setInTranscation(true);
                        } else if (tag2 == '1' || tag2 == '2' || tag2 == '3') {
                            this.connection.setInTranscation(false);
                        }
                    } else if (tag1 == '0' && tag2 != '6' && tag2 <= 'S' || tag1 == '1' && (tag2 == '0' || tag2 == '1') || tag1 == '2' && tag2 != '2' || tag1 == '5' && tag2 == '5' || tag1 == '4' && tag2 == '0' || tag1 == '4' && tag2 == '5' || tag1 == '4' && tag2 == '8' || tag1 == '5' && tag2 == '6' || tag1 == '5' && tag2 == 'D') {
                        if (tag1 == '0' && tag2 != '6' && tag2 <= 'S') {
                            update_count = 0L;
                        }
                        if (tag1 == '4' && tag2 == '0') {
                            update_count = 0L;
                        }
                        cmd = ((CompleteResponsePacket)this.bk).getCommand();
                        if (tag1 == '2' && (tag2 == '0' || tag2 == '5')) {
                            updateCountOffset = this.getFirstBlankPosition(cmd, 0);
                            update_count = RowidConverter.convertToRowID(cmd, updateCountOffset + 1);
                            if (this.logFlag) {
                                sb = new StringBuffer();
                                sb.append("updatecount: ").append(update_count);
                                Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), sb.toString());
                            }
                        }
                        if (tag1 == '2' && tag2 == '1') {
                            updateCountOffset = this.getFirstBlankPosition(cmd, 0);
                            map = RowidConverter.convertToUpdateCount(cmd, updateCountOffset + 1);
                            update_count = map.get("updatecount");
                            insertTidOffset = map.get("tidoffset").intValue();
                            insert_tid = insertTidOffset <= updateCountOffset ? 0L : RowidConverter.convertToRowID(cmd, insertTidOffset + 1);
                            if (this.logFlag) {
                                sb = new StringBuffer();
                                sb.append("updatecount: ").append(update_count).append(", rowid: ").append(insert_tid);
                                Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), sb.toString());
                            }
                        }
                        if (this.resultset == null) {
                            this.resultset = this.statement.createResultSet(fields, tuples, command, update_count, insert_tid);
                            updateCounts[p++] = update_count;
                            if (resultTid) {
                                this.resultset.setTidValues(tidField, tidList);
                            }
                            if (tag1 == '1' && tag2 == '0' && this.statement.isCursorUsed()) {
                                this.resultset.setCursorUsed(true);
                            }
                            this.connection.addCursor(this.resultset.getCursorName());
                            this.statement.setResultSet(this.resultset);
                        } else if (this.resultset.isCursorUsed()) {
                            moveSize = 0;
                            commands = command.split(" ");
                            moveSize = Integer.parseInt(commands[1]);
                            if (tag1 == '1' && tag2 == '0') {
                                this.resultset.reInit(fields, tuples, command, update_count, insert_tid);
                                if (resultTid) {
                                    this.resultset.setTidValues(tidField, tidList);
                                }
                                this.resultset.setCursorMoveSize(moveSize);
                            } else if (tag1 == '1' && tag2 == '1') {
                                this.resultset.setCursorMoveSize(moveSize);
                            }
                        } else {
                            updateCounts[p++] = update_count;
                        }
                    }
                    tuples = new ArrayList<E>();
                    resultTid = false;
                    tidList = null;
                    fields = null;
                    update_count = -2L;
                    insert_tid = 0L;
                    continue;
                }
                if (this.bk instanceof ParamInforPacket) {
                    this.getMessage(this.osr_input, this.bk);
                    this.statement.setParamInfor(((ParamInforPacket)this.bk).getParamInfo());
                    continue;
                }
                if (this.bk instanceof EmptyQueryResponsePacket) {
                    this.getMessage(this.osr_input, this.bk);
                    continue;
                }
                if (this.bk instanceof CursorResponsePacket) {
                    this.getMessage(this.osr_input, this.bk);
                    command = this.connection.getEncoding().decode(((CursorResponsePacket)this.bk).getCursorName());
                    continue;
                }
                if (this.bk instanceof ErrorResponsePacket) {
                    this.status = -1;
                    this.getMessage(this.osr_input, this.bk);
                    errorPacket = (ErrorResponsePacket)this.bk;
                    if (encodingFlag) {
                        if (exception == null) {
                            exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage()));
                            continue;
                        }
                        exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getClientEncoding().decode(errorPacket.getSQLState()), this.connection.getClientEncoding().decode(errorPacket.getErrorMessage())));
                        continue;
                    }
                    if (exception == null) {
                        exception = new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage()));
                        continue;
                    }
                    exception.setNextException(new OSQLException(errorPacket.getErrorCode(), this.connection.getEncoding().decode(errorPacket.getSQLState()), this.connection.getEncoding().decode(errorPacket.getErrorMessage())));
                    continue;
                }
                if (this.bk instanceof NoticeResponsePacket) {
                    this.getMessage(this.osr_input, this.bk);
                    if (encodingFlag) {
                        this.statement.addWarning(this.connection.getClientEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), new String(((NoticeResponsePacket)this.bk).getSQLState()));
                        continue;
                    }
                    this.statement.addWarning(this.connection.getEncoding().decode(((NoticeResponsePacket)this.bk).getNoticeMessage()), new String(((NoticeResponsePacket)this.bk).getSQLState()));
                    continue;
                }
                if (this.bk instanceof ImportPacket) {
                    ((ImportPacket)this.bk).setEncoding(this.statement.getDBConnection().getEncoding());
                    ((ImportPacket)this.bk).setImportValues(this.statement.getImportValues());
                    this.sendMessage(this.osr_output, this.bk);
                    this.statement.importValues(null);
                    continue;
                }
                if (this.bk instanceof ImportExportResponsePacket) {
                    this.getMessage(this.osr_input, this.bk);
                    this.statement.setTransferRowCount(((ImportExportResponsePacket)this.bk).getAmount());
                    continue;
                }
                if (this.bk instanceof ReadyForQueryPacket) {
                    this.status = 1;
                    this.getMessage(this.osr_input, this.bk);
                    continue;
                }
                this.status = -1;
                throw new OSQLException("OSCAR-00109", "08003", 109);
            }
        } while (!(this.bk instanceof ReadyForQueryPacket));
        if (exception != null) {
            if (this.logFlag) {
                Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), "error: " + exception.getMessage());
            }
            throw exception;
        }
    }

    public byte[] getPlanID() {
        return this.planID;
    }

    public void setPlanID(byte[] planID) {
        this.planID = planID;
    }
}

