/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.Field;
import com.oscar.util.Convert;
import com.oscar.util.OSQLException;
import com.oscar.util.converter.DateConverter;
import com.oscar.util.converter.NumberConverter;
import com.oscar.util.converter.TimeConverter;
import com.oscar.util.converter.TimestampConverter;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;

public abstract class OscarArray
implements java.sql.Array {
    protected boolean free = false;
    protected String rawString = null;

    public void checkFree() throws OSQLException {
        if (this.free) {
            throw new OSQLException("OSCAR-001001", "88888", 1001);
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return null;
    }

    @Override
    public int getBaseType() throws SQLException {
        return 0;
    }

    @Override
    public Object getArray() throws SQLException {
        return null;
    }

    @Override
    public Object getArray(Map<String, Class<?>> paramMap) throws SQLException {
        return null;
    }

    @Override
    public Object getArray(long paramLong, int paramInt) throws SQLException {
        return null;
    }

    @Override
    public Object getArray(long paramLong, int paramInt, Map<String, Class<?>> paramMap) throws SQLException {
        return null;
    }

    public short[] getShortArray() throws SQLException {
        Object array = this.getArray();
        if (array instanceof short[] || array == null) {
            return (short[])array;
        }
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            short[] shorts = new short[length];
            for (int i = 0; i < length; ++i) {
                shorts[i] = Convert.toShort(Array.get(array, i));
            }
            return shorts;
        }
        throw new OSQLException("RESULT is NOT ARRAY", "");
    }

    public int[] getIntArray() throws SQLException {
        Object array = this.getArray();
        if (array instanceof int[] || array == null) {
            return (int[])array;
        }
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            int[] ints = new int[length];
            for (int i = 0; i < length; ++i) {
                ints[i] = Convert.toInt(Array.get(array, i));
            }
            return ints;
        }
        throw new OSQLException("Result is not array", "");
    }

    public long[] getLongArray() throws SQLException {
        Object array = this.getArray();
        if (array instanceof long[] || array == null) {
            return (long[])array;
        }
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            long[] longs = new long[length];
            for (int i = 0; i < length; ++i) {
                longs[i] = Convert.toLong(Array.get(array, i));
            }
            return longs;
        }
        throw new OSQLException("Result is not array", "");
    }

    public float[] getFloatArray() throws SQLException {
        Object array = this.getArray();
        if (array instanceof float[] || array == null) {
            return (float[])array;
        }
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            float[] floats = new float[length];
            for (int i = 0; i < length; ++i) {
                floats[i] = Convert.toFloat(Array.get(array, i)).floatValue();
            }
            return floats;
        }
        throw new OSQLException("Result is not array", "");
    }

    public double[] getDoubleArray() throws SQLException {
        Object array = this.getArray();
        if (array instanceof double[] || array == null) {
            return (double[])array;
        }
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            double[] doubles = new double[length];
            for (int i = 0; i < length; ++i) {
                doubles[i] = Convert.toDouble(Array.get(array, i));
            }
            return doubles;
        }
        throw new OSQLException("Result is not array", "");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> paramMap) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getResultSet(long paramLong, int paramInt) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getResultSet(long paramLong, int paramInt, Map<String, Class<?>> paramMap) throws SQLException {
        return null;
    }

    @Override
    public void free() throws SQLException {
        this.free = true;
    }

    protected ResultSet getResultSetV1(BaseConnection conn, long index, int count, Map map) throws SQLException {
        Object array = this.getArray(index, count, map);
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        Field[] fields = new Field[2];
        fields[0] = new Field(conn, "INDEX", conn.getDBTypeOid("INT2"), 2);
        switch (this.getBaseType()) {
            case -7: {
                String[] bitArray = (String[])array;
                if (fields[1] == null) {
                    fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("BIT"), -1);
                }
                for (int i = 0; i < bitArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = conn.getEncoding().encode(Integer.toString((int)index + i));
                    tuple[1] = conn.getEncoding().encode(bitArray[i]);
                    rows.add(tuple);
                }
                break;
            }
            case 5: {
                fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("INT2"), 2);
                break;
            }
            case 4: {
                Integer[] intArray = (Integer[])array;
                if (fields[1] == null) {
                    fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("INT4"), 4);
                }
                for (int i = 0; i < intArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = conn.getEncoding().encode(Integer.toString((int)index + i));
                    rows.add(tuple);
                }
                break;
            }
            case -5: {
                Long[] longArray = (Long[])array;
                fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("INT8"), 8);
                for (int i = 0; i < longArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = conn.getEncoding().encode(Integer.toString((int)index + i));
                    tuple[1] = conn.getEncoding().encode(Long.toString(longArray[i]));
                    rows.add(tuple);
                }
                break;
            }
            case 2: {
                BigDecimal[] bdArray = (BigDecimal[])array;
                fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("NUMERIC"), -1);
                for (int i = 0; i < bdArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = conn.getEncoding().encode(Integer.toString((int)index + i));
                    tuple[1] = conn.getEncoding().encode(bdArray[i].toString());
                    rows.add(tuple);
                }
                break;
            }
            case 7: {
                Float[] floatArray = (Float[])array;
                fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("FLOAT4"), 4);
                for (int i = 0; i < floatArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = conn.getEncoding().encode(Integer.toString((int)index + i));
                    tuple[1] = conn.getEncoding().encode(Float.toString(floatArray[i].floatValue()));
                    rows.add(tuple);
                }
                break;
            }
            case 8: {
                Double[] doubleArray = (Double[])array;
                fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("FLOAT8"), 8);
                for (int i = 0; i < doubleArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = conn.getEncoding().encode(Integer.toString((int)index + i));
                    tuple[1] = conn.getEncoding().encode(Double.toString(doubleArray[i]));
                    rows.add(tuple);
                }
                break;
            }
            case 1: {
                fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("CHAR"), 1);
                break;
            }
            case 12: {
                String[] strArray = (String[])array;
                if (fields[1] == null) {
                    fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("VARCHAR"), -1);
                }
                for (int i = 0; i < strArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = conn.getEncoding().encode(Integer.toString((int)index + i));
                    tuple[1] = conn.getEncoding().encode(strArray[i]);
                    rows.add(tuple);
                }
                break;
            }
            case 91: {
                Date[] dateArray = (Date[])array;
                fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("DATE"), 4);
                for (int i = 0; i < dateArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = conn.getEncoding().encode(Integer.toString((int)index + i));
                    tuple[1] = conn.getEncoding().encode(dateArray[i].toString());
                    rows.add(tuple);
                }
                break;
            }
            case 92: {
                Time[] timeArray = (Time[])array;
                fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("TIME"), 8);
                for (int i = 0; i < timeArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = conn.getEncoding().encode(Integer.toString((int)index + i));
                    tuple[1] = conn.getEncoding().encode(timeArray[i].toString());
                    rows.add(tuple);
                }
                break;
            }
            case 93: {
                Timestamp[] timestampArray = (Timestamp[])array;
                fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("TIMESTAMP"), 8);
                for (int i = 0; i < timestampArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = conn.getEncoding().encode(Integer.toString((int)index + i));
                    tuple[1] = conn.getEncoding().encode(timestampArray[i].toString());
                    rows.add(tuple);
                }
                break;
            }
            default: {
                throw Driver.notImplemented();
            }
        }
        return conn.getDefaultStatement().createResultSet(fields, rows, "OK", 1L, 0L);
    }

    protected ResultSet getResultSetV2(BaseConnection conn, long index, int count, Map map) throws SQLException {
        Object array = this.getArray(index, count, map);
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        Field[] fields = new Field[2];
        fields[0] = new Field(conn, "INDEX", conn.getDBTypeOid("INT2"), 2);
        Calendar localCalendar = conn.getCalendar();
        switch (this.getBaseType()) {
            case -7: {
                String[] bitArray = (String[])array;
                if (fields[1] == null) {
                    fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("BIT"), -1);
                }
                for (int i = 0; i < bitArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = NumberConverter.convertIntToBytes((int)index + i);
                    tuple[1] = conn.getEncoding().encode(bitArray[i]);
                    rows.add(tuple);
                }
                break;
            }
            case 5: {
                fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("INT2"), 2);
                break;
            }
            case 4: {
                Integer[] intArray = (Integer[])array;
                if (fields[1] == null) {
                    fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("INT4"), 4);
                }
                for (int i = 0; i < intArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = NumberConverter.convertIntToBytes((int)index + i);
                    tuple[1] = NumberConverter.convertIntToBytes(intArray[i]);
                    rows.add(tuple);
                }
                break;
            }
            case -5: {
                Long[] longArray = (Long[])array;
                fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("INT8"), 8);
                for (int i = 0; i < longArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = NumberConverter.convertIntToBytes((int)index + i);
                    tuple[1] = NumberConverter.convertLongToBytes(longArray[i]);
                    rows.add(tuple);
                }
                break;
            }
            case 2: {
                BigDecimal[] bdArray = (BigDecimal[])array;
                fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("NUMERIC"), -1);
                for (int i = 0; i < bdArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = NumberConverter.convertIntToBytes((int)index + i);
                    tuple[1] = conn.getEncoding().encode(bdArray[i].toString());
                    rows.add(tuple);
                }
                break;
            }
            case 7: {
                Float[] floatArray = (Float[])array;
                fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("FLOAT4"), 4);
                for (int i = 0; i < floatArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = NumberConverter.convertIntToBytes((int)index + i);
                    tuple[1] = NumberConverter.convertDoubleToBytes(Double.parseDouble(Float.toString(floatArray[i].floatValue())));
                    rows.add(tuple);
                }
                break;
            }
            case 8: {
                Double[] doubleArray = (Double[])array;
                fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("FLOAT8"), 8);
                for (int i = 0; i < doubleArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = NumberConverter.convertIntToBytes((int)index + i);
                    tuple[1] = NumberConverter.convertDoubleToBytes(doubleArray[i]);
                    rows.add(tuple);
                }
                break;
            }
            case 1: {
                fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("CHAR"), 1);
                break;
            }
            case 12: {
                String[] strArray = (String[])array;
                if (fields[1] == null) {
                    fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("VARCHAR"), -1);
                }
                for (int i = 0; i < strArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = NumberConverter.convertIntToBytes((int)index + i);
                    tuple[1] = conn.getEncoding().encode(strArray[i]);
                    rows.add(tuple);
                }
                break;
            }
            case 91: {
                Date[] dateArray = (Date[])array;
                fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("DATE"), 4);
                for (int i = 0; i < dateArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = NumberConverter.convertIntToBytes((int)index + i);
                    tuple[1] = DateConverter.convertDateToBytes(dateArray[i], localCalendar);
                    rows.add(tuple);
                }
                break;
            }
            case 92: {
                Time[] timeArray = (Time[])array;
                fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("TIME"), 8);
                for (int i = 0; i < timeArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = NumberConverter.convertIntToBytes((int)index + i);
                    tuple[1] = TimeConverter.convertTimeToBytes(timeArray[i], localCalendar);
                    rows.add(tuple);
                }
                break;
            }
            case 93: {
                Timestamp[] timestampArray = (Timestamp[])array;
                fields[1] = new Field(conn, "VALUE", conn.getDBTypeOid("TIMESTAMP"), 8);
                for (int i = 0; i < timestampArray.length; ++i) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = NumberConverter.convertIntToBytes((int)index + i);
                    tuple[1] = TimestampConverter.convertTimestampToBytes(timestampArray[i], localCalendar);
                    rows.add(tuple);
                }
                break;
            }
            default: {
                throw Driver.notImplemented();
            }
        }
        return conn.getDefaultStatement().createResultSet(fields, rows, "OK", 1L, 0L);
    }

    public String toString() {
        if (this.rawString != null) {
            return this.rawString;
        }
        return super.toString();
    }
}

