/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis;

import com.oscar.gis.OscarObject;
import com.oscar.gis.OscarPoint;
import com.oscar.util.OscarTokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class OscarPolygon
extends OscarObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5596122553333897668L;
    private OscarPoint[] points;

    public OscarPolygon(OscarPoint[] points) {
        this();
        this.points = points;
    }

    public OscarPolygon(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public OscarPolygon() {
        this.setType("polygon");
    }

    @Override
    public void setValue(String s) throws SQLException {
        OscarTokenizer t = new OscarTokenizer(OscarTokenizer.removePara(s), ',');
        int npoints = t.getSize();
        this.points = new OscarPoint[npoints];
        for (int p = 0; p < npoints; ++p) {
            this.points[p] = new OscarPoint(t.getToken(p));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OscarPolygon) {
            OscarPolygon p = (OscarPolygon)obj;
            if (p.points.length != this.points.length) {
                return false;
            }
            for (int i = 0; i < this.points.length; ++i) {
                if (this.points[i].equals(p.points[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.points.length && i < 5; ++i) {
            hash ^= this.points[i].hashCode();
        }
        return hash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        OscarPolygon newOscarPolygon = (OscarPolygon)super.clone();
        if (newOscarPolygon.points != null) {
            newOscarPolygon.points = (OscarPoint[])newOscarPolygon.points.clone();
            for (int i = 0; i < newOscarPolygon.points.length; ++i) {
                if (newOscarPolygon.points[i] == null) continue;
                newOscarPolygon.points[i] = (OscarPoint)newOscarPolygon.points[i].clone();
            }
        }
        return newOscarPolygon;
    }

    @Override
    public String getValue() {
        StringBuilder b = new StringBuilder();
        b.append("(");
        for (int p = 0; p < this.points.length; ++p) {
            if (p > 0) {
                b.append(",");
            }
            b.append(this.points[p].toString());
        }
        b.append(")");
        return b.toString();
    }
}

