/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.dispatcher.oscarParser.sql;

import com.oscar.dispatcher.entity.DispatchConnection;
import com.oscar.dispatcher.parser.ParseException;
import com.oscar.dispatcher.parser.statement.BeginStatement;
import com.oscar.dispatcher.parser.statement.EndStatement;
import com.oscar.dispatcher.parser.statement.OtherStatement;
import com.oscar.dispatcher.parser.statement.SelectStatement;
import com.oscar.dispatcher.parser.statement.SetStatement;
import com.oscar.dispatcher.parser.statement.Statement;
import com.oscar.dispatcher.parser.statement.TransactionStatement;
import com.oscar.util.OSQLException;
import com.oscar.util.OscarSqlProcessor;
import com.oscar.util.Word;
import java.sql.SQLException;
import java.util.List;

public class OscarParser {
    private String commandText = "";
    private OscarSqlProcessor.ParseResult pr;

    public OscarParser(String sql) {
        this.commandText = sql.trim().endsWith(";") ? sql.trim().substring(0, sql.trim().length() - 1) : sql.trim();
        try {
            this.pr = OscarSqlProcessor.parsing(this.commandText, true);
        }
        catch (OSQLException e) {
            this.pr = new OscarSqlProcessor.ParseResult();
        }
    }

    public boolean isSelectSql() {
        return this.pr.isSelectSql();
    }

    public Statement doParse(DispatchConnection dispatchConnection, String strategyValue) throws ParseException {
        try {
            Statement statement = this.parse(dispatchConnection, strategyValue);
            statement.setCommandText(this.commandText);
            return statement;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public final Statement parse(DispatchConnection dispatchConnection, String strategyValue) throws SQLException {
        if (this.pr.isFenormalSelect() || this.pr.isDdlSql() || this.pr.isDmlSql() || this.pr.isSelectForUpdate()) {
            return new OtherStatement();
        }
        List<Word> allWords = this.pr.getAllWords();
        String firstWordText = allWords.get(0).getTokentext();
        if ("begin".equalsIgnoreCase(firstWordText)) {
            return new BeginStatement();
        }
        if ("commit".equalsIgnoreCase(firstWordText) || "rollback".equalsIgnoreCase(firstWordText)) {
            return new EndStatement();
        }
        if ("set".equalsIgnoreCase(firstWordText) || "reset".equalsIgnoreCase(firstWordText)) {
            return new SetStatement();
        }
        boolean autoCommit = dispatchConnection.getAutoCommit();
        if (autoCommit) {
            if (this.pr.isSelectSql()) {
                if (this.pr.hasAggFunctionInSelect() && !dispatchConnection.isDispatchAggFunction()) {
                    return new OtherStatement();
                }
                return new SelectStatement();
            }
            return new OtherStatement();
        }
        if (dispatchConnection.isHasUpdate()) {
            return new TransactionStatement();
        }
        if ("2".equals(strategyValue)) {
            if (this.pr.isSelectSql()) {
                if (this.pr.hasAggFunctionInSelect() && !dispatchConnection.isDispatchAggFunction()) {
                    return new TransactionStatement();
                }
                return new SelectStatement();
            }
            if (this.pr.isFenormalSelect()) {
                return new TransactionStatement();
            }
            return new TransactionStatement();
        }
        return new TransactionStatement();
    }
}

