/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.dispatcher.executor;

import com.oscar.Driver;
import com.oscar.dispatcher.core.ConnectionMangerV2;
import com.oscar.dispatcher.entity.DispatchConnection;
import com.oscar.dispatcher.entity.FakeConnection;
import com.oscar.dispatcher.executor.command.StatementCreateCommand;
import com.oscar.dispatcher.oscarParser.sql.OscarParser;
import com.oscar.dispatcher.parser.statement.EndStatement;
import com.oscar.dispatcher.parser.statement.Statement;
import com.oscar.jdbc.OscarJdbc2Connection;
import com.oscar.util.OSQLException;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class DispatchAbstractStatement {
    protected boolean logFlag = Driver.getLogLevel() >= 2;
    public static final int DISPATCH_TYPE_MAIN = 0;
    public static final int DISPATCH_TYPE_SLAVE = 1;
    public static final int DISPATCH_TYPE_ALL = 2;
    public static final int DISPATCH_TYPE_ALL_CURRENT = 3;
    public static final int DISPATCH_TYPE_DIRECT_SLAVE = 4;
    public static final int DISPATCH_TYPE_DIRECT_MAIN = 5;
    protected DispatchConnection dispatchConnection;
    protected java.sql.Statement mainStatement;
    protected java.sql.Statement slaveStatement;
    protected Boolean replaceProcessingEnabled = null;
    protected Integer maxFieldSize = null;
    protected Integer fetchSize = null;
    protected Integer maxrows = null;
    protected Integer fetchdirection = null;
    protected Integer timeout = null;
    protected String cursor = null;
    protected StatementCreateCommand<? extends java.sql.Statement> createCommand = null;
    protected String strategyValue = null;
    protected volatile int dispatchType = 0;
    protected volatile int currentDispatchType = 0;
    private static SecureRandom SECURE_RANDOM = null;
    private static final int SELECT_TO_MAIN_TYPE_NULL = 0;
    private static final int SELECT_TO_MAIN_TYPE_ALL = 1;
    protected int selectToMainType = -1;
    protected Statement sqlStmt = null;
    private boolean isSelectSql = false;
    protected String slaveConnectionKey;

    public DispatchAbstractStatement(DispatchConnection con) {
        this.dispatchConnection = con;
        this.strategyValue = this.dispatchConnection.props.getProperty("TRANSACTIONDISPATCHSTRATEGY", "2");
        String[] strs = con.getDirectToMainArray();
        if (strs == null || strs.length == 0) {
            this.selectToMainType = 0;
        } else if ("*".equals(strs[0])) {
            this.selectToMainType = 1;
        }
    }

    public java.sql.Statement getMainStatement() throws SQLException {
        if (this.mainStatement == null) {
            this.mainStatement = this.createCommand.getStatement(this.dispatchConnection.getMainConn());
            this.initStatement(this.mainStatement);
        }
        return this.mainStatement;
    }

    public List<java.sql.Statement> getAllStatement() throws SQLException {
        ArrayList<java.sql.Statement> result = new ArrayList<java.sql.Statement>();
        result.add(this.getMainStatement());
        java.sql.Statement slaveStatement = this.getSlaveStatement();
        if (slaveStatement != null) {
            result.add(slaveStatement);
        }
        return result;
    }

    public java.sql.Statement getSlaveStatement() throws SQLException {
        if (this.slaveStatement == null) {
            this.slaveStatement = this.createSlaveStatement();
        } else {
            java.sql.Statement newStatement;
            boolean isStatementValid = true;
            try {
                Connection conn = this.slaveStatement.getConnection();
                isStatementValid = conn != null && !conn.isClosed();
            }
            catch (SQLException e1) {
                isStatementValid = false;
            }
            if (!isStatementValid && (newStatement = this.createSlaveStatement()) != null) {
                try {
                    this.bind(this.slaveStatement, newStatement);
                }
                catch (Exception e) {
                    throw new SQLException(e.toString());
                }
                this.slaveStatement = newStatement;
            }
        }
        return this.slaveStatement;
    }

    protected java.sql.Statement createSlaveStatement() throws SQLException {
        if (!this.dispatchConnection.hasAvailableSlaveConnection()) {
            return null;
        }
        long baseNum = ConnectionMangerV2.lastSlaveID.get(this.dispatchConnection.url).incrementAndGet();
        int idx = 0;
        if (this.dispatchConnection.slaveCount > 1) {
            String slaveAllocation = this.dispatchConnection.getConnectionProperties().getProperty("SLAVEALLOCATION", "1");
            idx = "2".equals(slaveAllocation) ? (int)(baseNum % (long)this.dispatchConnection.slaveCount) : (SECURE_RANDOM != null ? SECURE_RANDOM.nextInt(this.dispatchConnection.slaveCount) : (int)(baseNum % (long)this.dispatchConnection.slaveCount));
        }
        return this.createSlaveStatement(idx);
    }

    private java.sql.Statement createSlaveStatement(int index) throws SQLException {
        if (!this.dispatchConnection.hasAvailableSlaveConnection()) {
            return null;
        }
        int idx = index % this.dispatchConnection.slaveCount;
        String key = "slave" + idx;
        Connection conn = this.dispatchConnection.getSlaveConnection(key);
        if (conn == null || conn instanceof FakeConnection) {
            return this.createSlaveStatement(index + 1);
        }
        if (this.logFlag) {
            ConnectionMangerV2.SLAVE_ACCESS_COUNT.get(key).incrementAndGet();
        }
        try {
            java.sql.Statement slaveStatement = this.createCommand.getStatement(conn);
            this.initStatement(slaveStatement);
            this.slaveConnectionKey = key;
            return slaveStatement;
        }
        catch (SQLException e) {
            if (this.isDisconnected(e) && conn.isClosed()) {
                this.dispatchConnection.removeSlaveConnection(key);
                return this.createSlaveStatement(index + 1);
            }
            throw e;
        }
    }

    protected abstract void initStatement(java.sql.Statement var1) throws SQLException;

    public List<java.sql.Statement> getAllCurrentStatement() throws SQLException {
        ArrayList<java.sql.Statement> result = new ArrayList<java.sql.Statement>();
        if (this.mainStatement != null) {
            result.add(this.mainStatement);
        }
        if (this.slaveStatement != null) {
            result.add(this.slaveStatement);
        }
        return result;
    }

    protected int getExecuteType(String sql) {
        if (sql == null) {
            this.currentDispatchType = 0;
            return 0;
        }
        if (this.dispatchConnection.slaveCount == 0) {
            this.currentDispatchType = 0;
            if (this.logFlag) {
                Driver.writeLog(this.dispatchConnection.getMainConn().sessionID, this.dispatchConnection.getMainConn().getPlanID(), DispatchAbstractStatement.class + ", getExecuteType(String sql), sql:" + sql + ", slaveCount=0 ");
            }
            return this.currentDispatchType;
        }
        OscarParser oscarParser = new OscarParser(sql);
        this.isSelectSql = oscarParser.isSelectSql();
        if (this.isSelectSql) {
            String[] directToSlaveArray = this.dispatchConnection.getDirectToSlaveArray();
            if (directToSlaveArray != null && directToSlaveArray.length != 0) {
                for (String dirSQL : directToSlaveArray) {
                    if (sql.indexOf(dirSQL) < 0) continue;
                    this.currentDispatchType = 4;
                    if (this.logFlag) {
                        Driver.writeLog(this.dispatchConnection.getMainConn().sessionID, this.dispatchConnection.getMainConn().getPlanID(), DispatchAbstractStatement.class + ", getExecuteType(String sql), sql:" + sql + ",directSlaveSQL= " + dirSQL);
                    }
                    return this.currentDispatchType;
                }
            }
            switch (this.selectToMainType) {
                case 0: {
                    break;
                }
                case 1: {
                    this.currentDispatchType = 5;
                    if (this.logFlag) {
                        Driver.writeLog(this.dispatchConnection.getMainConn().sessionID, this.dispatchConnection.getMainConn().getPlanID(), DispatchAbstractStatement.class + ", getExecuteType(String sql), sql:" + sql + ",directSQL= *");
                    }
                    return this.currentDispatchType;
                }
                default: {
                    for (String dirSQL : this.dispatchConnection.getDirectToMainArray()) {
                        if (sql.indexOf(dirSQL) < 0) continue;
                        this.currentDispatchType = 5;
                        if (this.logFlag) {
                            Driver.writeLog(this.dispatchConnection.getMainConn().sessionID, this.dispatchConnection.getMainConn().getPlanID(), DispatchAbstractStatement.class + ", getExecuteType(String sql), sql:" + sql + ",directSQL= " + dirSQL);
                        }
                        return this.currentDispatchType;
                    }
                }
            }
        }
        int result = 0;
        try {
            this.sqlStmt = oscarParser.doParse(this.dispatchConnection, this.strategyValue);
            String sqlType = null;
            int type = this.sqlStmt.getSQLType();
            switch (type) {
                case 0: {
                    result = 0;
                    sqlType = "in transaction";
                    this.add();
                    break;
                }
                case 2: {
                    result = 1;
                    sqlType = "select";
                    break;
                }
                case 5: {
                    result = 2;
                    sqlType = "set or reset";
                    this.add();
                    break;
                }
                default: {
                    result = 0;
                    sqlType = "insert or delete or update";
                    this.add();
                }
            }
            if (this.logFlag) {
                Driver.writeLog(this.dispatchConnection.getMainConn().sessionID, this.dispatchConnection.getMainConn().getPlanID(), DispatchAbstractStatement.class + ", getExecuteType(String sql), sql:" + sql + ", sqlType:" + sqlType);
            }
        }
        catch (Exception e) {
            Driver.writeLog("prase " + e.getMessage());
        }
        this.currentDispatchType = result;
        return result;
    }

    protected int getExecuteType() {
        return this.dispatchType;
    }

    protected int getCurrentExecuteType() {
        return this.currentDispatchType;
    }

    /*
     * Unable to fully structure code
     */
    protected <R> R executeTemplet(ExecuteCommand<R> command, int dispatchType) throws SQLException {
        if (dispatchType == 1 && !this.dispatchConnection.hasAvailableSlaveConnection()) {
            Driver.writeLog("slave connection init false " + command.getFunctionName());
            dispatchType = 0;
        }
        if (this.currentDispatchType != dispatchType) {
            this.currentDispatchType = dispatchType;
        }
        r = null;
        sql = null;
        if (this.logFlag) {
            sql = new StringBuilder(200);
            sql.append("Main conid: ").append(this.dispatchConnection.getMainConn().sessionID).append(", /*Session").append(this.dispatchConnection.getMainConn().getPlanID()).append("*/ ").append(DispatchAbstractStatement.class).append(", executeTemplet()" + command.getFunctionName() + " ,dispatchType :").append(dispatchType + " ");
        }
        switch (dispatchType) {
            case 0: 
            case 5: {
                mst = this.getMainStatement();
                if (dispatchType == 5 || !command.isExecuteFunction() || !this.isSelectSql || this.dispatchConnection.isHasUpdate() || (slaveSt = this.getSlaveStatement()) == null) ** GOTO lbl30
                try {
                    this.bind(mst, slaveSt);
                    if (this.logFlag) {
                        sql.append(", not in transaction selectsql send to slave conid:").append(((OscarJdbc2Connection)slaveSt.getConnection()).sessionID).append(", /*Session").append(((OscarJdbc2Connection)slaveSt.getConnection()).getPlanID()).append("*/ ").append("url:").append(((OscarJdbc2Connection)slaveSt.getConnection()).getURL() + " slaveSt " + slaveSt);
                        Driver.writeLog(sql.toString());
                    }
                    r = command.execute(slaveSt);
                    this.currentDispatchType = 4;
                    break;
                }
                catch (Exception e) {
                    if (!this.logFlag) ** GOTO lbl30
                    Driver.writeLog(e);
                    sql.append("send to slave error");
                }
lbl30:
                // 3 sources

                if (this.logFlag) {
                    sql.append(", send to master conid:").append(((OscarJdbc2Connection)mst.getConnection()).sessionID).append(", /*Session").append(((OscarJdbc2Connection)mst.getConnection()).getPlanID()).append("*/ ").append("url:").append(((OscarJdbc2Connection)mst.getConnection()).getURL() + " st:" + mst);
                    Driver.writeLog(sql.toString());
                }
                mainConnection = (OscarJdbc2Connection)mst.getConnection();
                try {
                    r = command.execute(mst);
                    break;
                }
                catch (SQLException e) {
                    if (this.dispatchConnection.isAutoReconnect()) {
                        if (e.getErrorCode() == 109 || e.getErrorCode() == 108 || e.getErrorCode() == 104 || e.getErrorCode() == 211 || e.getErrorCode() == 103 || e.getMessage() != null && e.getMessage().contains("system closing")) {
                            current = System.currentTimeMillis();
                            num = 0;
                            while (true) {
                                if (num > 20) {
                                    throw e;
                                }
                                execute = System.currentTimeMillis();
                                if (num > 20 || execute - current <= 3000L) continue;
                                try {
                                    ++num;
                                    testConnection = new OscarJdbc2Connection();
                                    props = mainConnection.getConnectionProperties();
                                    host = props.getProperty("DBHOST", "localhost");
                                    port = Integer.parseInt(props.getProperty("DBPORT", "2003"));
                                    database = props.getProperty("DBNAME", "");
                                    socketTimeout = props.getProperty("SOCKETTIMEOUT");
                                    if (socketTimeout != null) {
                                        timeout = Integer.parseInt(socketTimeout);
                                        if (timeout <= 0) {
                                            props.setProperty("SOCKETTIMEOUT", "10000");
                                        }
                                    } else {
                                        props.setProperty("SOCKETTIMEOUT", "10000");
                                    }
                                    testConnection.openConnection(host, port, props, database, mainConnection.getURL(), mainConnection.getDriver());
                                    this.dispatchConnection.setMainConn(testConnection);
                                    if (socketTimeout != null) {
                                        props.setProperty("SOCKETTIMEOUT", socketTimeout);
                                    }
                                    this.mainStatement = null;
                                    mst_new = this.getMainStatement();
                                    try {
                                        this.bind(mst, mst_new);
                                    }
                                    catch (Exception e1) {
                                        if (!this.logFlag) break;
                                        Driver.writeLog(e1);
                                        break;
                                    }
                                    mst = mst_new;
                                }
                                catch (SQLException ex) {
                                    ex.printStackTrace();
                                    current = System.currentTimeMillis();
                                    continue;
                                }
                                break;
                            }
                            r = command.execute(mst);
                            break;
                        }
                        throw e;
                    }
                    throw e;
                }
            }
            case 1: 
            case 4: {
                st = null;
                isMainDoing = false;
                try {
                    st = this.getSlaveStatement();
                    if (st == null || this.dispatchConnection.getSlaveDelayTime() > 0L && st.getConnection() instanceof OscarJdbc2Connection && System.currentTimeMillis() < ((OscarJdbc2Connection)st.getConnection()).getSleepEndTime()) {
                        isMainDoing = true;
                        mainSt = this.getMainStatement();
                        if (this.logFlag) {
                            sql.append(", error ,send to master conid:").append(((OscarJdbc2Connection)mainSt.getConnection()).sessionID).append(", /*Session").append(((OscarJdbc2Connection)mainSt.getConnection()).getPlanID()).append("*/ ").append("url:").append(((OscarJdbc2Connection)mainSt.getConnection()).getURL() + " st: " + mainSt);
                            Driver.writeLog(sql.toString());
                        }
                        r = command.execute(mainSt);
                        this.currentDispatchType = 0;
                        break;
                    }
                    if (dispatchType != 4 && command.isExecuteFunction() && this.dispatchConnection.isHasUpdate()) {
                        isMainDoing = true;
                        mainSt = this.getMainStatement();
                        this.bind(st, mainSt);
                        if (this.logFlag) {
                            sql.append(", In transaction master update ,send to master conid:").append(((OscarJdbc2Connection)mainSt.getConnection()).sessionID).append(", /*Session").append(((OscarJdbc2Connection)mainSt.getConnection()).getPlanID()).append("*/ ").append("url:").append(((OscarJdbc2Connection)mainSt.getConnection()).getURL() + " mainSt " + mainSt);
                            Driver.writeLog(sql.toString());
                        }
                        r = command.execute(mainSt);
                        this.currentDispatchType = 0;
                        break;
                    }
                    if (this.logFlag) {
                        sql.append(", send to slave conid:").append(((OscarJdbc2Connection)st.getConnection()).sessionID).append(", /*Session").append(((OscarJdbc2Connection)st.getConnection()).getPlanID()).append("*/ ").append("url:").append(((OscarJdbc2Connection)st.getConnection()).getURL() + " st" + st);
                        Driver.writeLog(sql.toString());
                    }
                    if (Boolean.valueOf(this.dispatchConnection.props.getProperty("USESLAVESYNCREAD", "false")).booleanValue() && ((OscarJdbc2Connection)st.getConnection()).getProtocolVersion().getProtocolType() >= 3 && command.isExecuteFunction()) {
                        lv = this.dispatchConnection.getLsnVo();
                        slaveCurrentLsn = lv.sendLsn(st);
                        r = command.execute(st);
                        if (slaveCurrentLsn <= 0L) break;
                        ((OscarJdbc2Connection)st.getConnection()).setLsnValue(slaveCurrentLsn);
                        break;
                    }
                    r = command.execute(st);
                    break;
                }
                catch (Exception e) {
                    if (this.logFlag) {
                        Driver.writeLog(e);
                    }
                    isSqlException = e instanceof SQLException;
                    if (!isMainDoing && isSqlException && this.expectionHandler((SQLException)e, st)) {
                        try {
                            if (this.dispatchConnection.getSlaveDelayTime() > 0L && st != null && st.getConnection() instanceof OscarJdbc2Connection) {
                                ((OscarJdbc2Connection)st.getConnection()).setSleepEndTime(System.currentTimeMillis() + this.dispatchConnection.getSlaveDelayTime());
                            }
                            mainst = this.getMainStatement();
                            if (this.logFlag) {
                                ConnectionMangerV2.SLAVE_ACCESS_COUNT.get("slavetomain").incrementAndGet();
                                sql.append(", ===========error============== ,send to master conid:").append(((OscarJdbc2Connection)mainst.getConnection()).sessionID).append(", /*Session").append(((OscarJdbc2Connection)mainst.getConnection()).getPlanID()).append("*/ ").append("url:").append(((OscarJdbc2Connection)mainst.getConnection()).getURL() + " st: " + mainst);
                                Driver.writeLog(sql.toString());
                            }
                            r = command.execute(mainst);
                            this.dispatchType = 0;
                            this.currentDispatchType = 0;
                            if (!"0A502".equals(((SQLException)e).getSQLState()) || !"2".equals(this.strategyValue)) break;
                            this.dispatchConnection.setHasUpdate(true);
                            break;
                        }
                        catch (SQLException ei) {
                            Driver.writeLog("============failure swtich to main=========SQLException");
                            Driver.writeLog(ei);
                            throw ei;
                        }
                        catch (Exception ei) {
                            Driver.writeLog("============failure swtich to main=========Exception:");
                            Driver.writeLog(ei);
                            throw new OSQLException("failure swtich to main", "08001", 121, ei);
                        }
                    }
                    if (isSqlException) {
                        Driver.writeLog("============failure swtich to main=========currentDispatchType :" + this.currentDispatchType + " dispatchType: " + dispatchType + " this.dispatchType:" + this.dispatchType);
                        throw (SQLException)e;
                    }
                    Driver.writeLog("============failure swtich to main=========currentDispatchType :" + this.currentDispatchType + " dispatchType: " + dispatchType + " this.dispatchType:" + this.dispatchType);
                    throw new SQLException(e);
                }
            }
            case 2: {
                list = this.getAllStatement();
                if (this.logFlag) {
                    sql.append(", send to all: ");
                    for (java.sql.Statement t : this.getAllStatement()) {
                        if (t == null) continue;
                        sql.append("conid : ").append(((OscarJdbc2Connection)t.getConnection()).sessionID).append(", /*Session").append(((OscarJdbc2Connection)t.getConnection()).getPlanID()).append("*/ ").append("url:").append(((OscarJdbc2Connection)t.getConnection()).getURL() + " st: " + t).append(" , ");
                    }
                    Driver.writeLog(sql.toString());
                }
                for (java.sql.Statement t : list) {
                    if (t == null) continue;
                    r = command.execute(t);
                }
                break;
            }
            case 3: {
                lis = this.getAllCurrentStatement();
                if (this.logFlag) {
                    sql.append(", send to current:");
                    for (java.sql.Statement t : lis) {
                        conn = (OscarJdbc2Connection)t.getConnection();
                        if (conn == null || conn.isClosed()) {
                            sql.append(t.toString() + "\u53ef\u80fd\u5df2\u7ecf\u5173\u95ed");
                            continue;
                        }
                        sql.append("conid : ").append(conn.sessionID).append(", /*Session").append(conn.getPlanID()).append("*/ ").append("url:").append(conn.getURL() + " st: " + t).append(" , ");
                    }
                    Driver.writeLog(sql.toString());
                }
                for (java.sql.Statement t : lis) {
                    r = command.execute(t);
                }
                break;
            }
        }
        command.setMainTransactionUpdateState();
        return r;
    }

    protected boolean getErrorCode(SQLException e) {
        boolean flag = false;
        if (e.getSQLState().equals("0A502") || e.getSQLState().equals("08003") || e.getSQLState().equals("08001")) {
            flag = true;
        }
        return flag;
    }

    protected boolean isDisconnected(SQLException e) {
        return "08003".equals(e.getSQLState());
    }

    private Integer changeExecuteType() {
        int result = 1;
        String rate = this.dispatchConnection.props.getProperty("HOSTLOADRATE");
        if (Integer.parseInt(rate) > 0) {
            String url = this.dispatchConnection.url;
            ConnectionMangerV2.totalAcount.get(url).incrementAndGet();
            if (ConnectionMangerV2.hostAcount.get(url).get() > 0) {
                BigDecimal hostRate = new BigDecimal(ConnectionMangerV2.hostAcount.get(url).get()).divide(new BigDecimal(ConnectionMangerV2.totalAcount.get(url).get()), 2, 1);
                if (hostRate.multiply(new BigDecimal(100)).compareTo(new BigDecimal(rate)) == -1) {
                    result = 0;
                    ConnectionMangerV2.hostAcount.get(url).incrementAndGet();
                }
            } else {
                result = 0;
                ConnectionMangerV2.hostAcount.get(url).incrementAndGet();
            }
        }
        return result;
    }

    public void add() {
        if (Integer.parseInt(this.dispatchConnection.props.getProperty("HOSTLOADRATE")) > 0) {
            String url = this.dispatchConnection.url;
            ConnectionMangerV2.totalAcount.get(url).incrementAndGet();
            ConnectionMangerV2.hostAcount.get(url).incrementAndGet();
        }
    }

    protected StatementCreateCommand<? extends java.sql.Statement> getCommand() {
        return this.createCommand;
    }

    protected abstract boolean expectionHandler(SQLException var1, java.sql.Statement var2) throws SQLException;

    protected void bind(java.sql.Statement slave, java.sql.Statement master) throws Exception {
    }

    static {
        try {
            SECURE_RANDOM = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        SECURE_RANDOM.nextInt();
    }

    public abstract class RealExecuteCommand<R>
    implements ExecuteCommand<R> {
        @Override
        public boolean isExecuteFunction() {
            return true;
        }

        @Override
        public void setMainTransactionUpdateState() {
            if ("2".equals(DispatchAbstractStatement.this.strategyValue)) {
                if (DispatchAbstractStatement.this.sqlStmt != null && DispatchAbstractStatement.this.sqlStmt instanceof EndStatement) {
                    DispatchAbstractStatement.this.dispatchConnection.setHasUpdate(false);
                } else if (!DispatchAbstractStatement.this.isSelectSql && DispatchAbstractStatement.this.currentDispatchType == 0) {
                    DispatchAbstractStatement.this.dispatchConnection.setHasUpdate(true);
                }
            }
        }
    }

    protected static interface ExecuteCommand<R> {
        public boolean isExecuteFunction();

        public String getFunctionName();

        public R execute(java.sql.Statement var1) throws SQLException;

        public void setMainTransactionUpdateState();
    }
}

