/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.cluster;

import com.oscar.Driver;
import com.oscar.cluster.ClusterImportHandler;
import com.oscar.cluster.INodeImportStream;
import com.oscar.cluster.core.DataImportStream;
import com.oscar.cluster.core.ImportStrategy;
import com.oscar.util.OSQLException;
import com.oscar.util.ShareImportStream;
import java.sql.SQLException;

public class NodeImportStreamOverflow
extends ShareImportStream
implements INodeImportStream {
    private ImportStrategy strategy;
    private ClusterImportHandler handler;
    private volatile long sendSizeBeforeExecute;

    public NodeImportStreamOverflow(ClusterImportHandler handler, ImportStrategy strategy) {
        super(handler);
        this.handler = handler;
        this.strategy = strategy;
    }

    @Override
    public void sendMessage(ShareImportStream.Cache cache) throws SQLException {
        if (cache.getCacheData() != null) {
            this.sendSizeBeforeExecute += (long)cache.getCacheData().length;
        }
        this.sendMessage(cache.getCacheData());
    }

    @Override
    public void sendMessage(byte[] data) throws SQLException {
        if (!this.handler.isHasBulk()) {
            try {
                Driver.writeLog("new modify import node and bulk together");
                this.handler.initImportNodes();
                this.strategy.setImportNodes(this.handler.getImportNodes());
                this.handler.getCluster().importBegin(this.handler);
            }
            catch (SQLException e) {
                this.handler.closeImportNodes();
                throw e;
            }
            this.handler.setHasBulk(true);
        }
        DataImportStream node = null;
        node = this.handler.rowCount.get() >= 10000 ? this.strategy.nextStream() : this.strategy.currentStream();
        try {
            node.importData(data);
        }
        catch (SQLException e) {
            this.handler.closeImportNodes();
            if (e.getMessage() != null && e.getMessage().contains("From JDBC:")) {
                throw e;
            }
            throw new OSQLException("OSCAR-01001", e.getSQLState(), 1001);
        }
        this.handler.rowCount.set(0);
    }

    @Override
    public void reStrategy(ImportStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public void finished() {
        super.finished();
        this.sendSizeBeforeExecute = 0L;
    }

    @Override
    public boolean needExecute() {
        if (this.handler.getExecuteBufferSize() > 0) {
            return this.sendSizeBeforeExecute + (long)this.position >= (long)this.handler.getExecuteBufferSize();
        }
        return false;
    }
}

