/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util.converter;

import com.oscar.util.converter.CharacterSet;

public class CharacterSetByte
extends CharacterSet {
    @Override
    public byte[] encode(String value) {
        if (value == null) {
            return null;
        }
        if ("".equals(value)) {
            return new byte[0];
        }
        int strLength = value.length();
        char[] chars = new char[strLength];
        value.getChars(0, strLength, chars, 0);
        return CharacterSetByte.charsToBytes(chars, (byte)0);
    }

    public static byte[] charsToBytes(char[] chars, byte replacement) {
        byte[] bytes = new byte[chars.length];
        for (int x = 0; x < chars.length; ++x) {
            if (chars[x] > '\u6bcf') {
                bytes[x] = replacement;
                if (replacement == 0) continue;
                continue;
            }
            bytes[x] = (byte)chars[x];
        }
        return bytes;
    }

    @Override
    public String decode(byte[] value) {
        if (value == null || value.length == 0) {
            return null;
        }
        return this.decode(value, 0, value.length, '\u0000');
    }

    public String decode(byte[] value, int offset, int count, char replacement) {
        if (value == null || value.length == 0) {
            return null;
        }
        try {
            return new String(value, offset, count, "ASCII");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

