/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public class TimeUtil {
    public static SimpleDateFormat getSimpleDateFormat(SimpleDateFormat cachedSimpleDateFormat, String pattern, TimeZone tz) {
        SimpleDateFormat sdf;
        SimpleDateFormat simpleDateFormat = sdf = cachedSimpleDateFormat != null && cachedSimpleDateFormat.toPattern().equals(pattern) ? cachedSimpleDateFormat : new SimpleDateFormat(pattern, Locale.US);
        if (tz != null) {
            sdf.setTimeZone(tz);
        }
        return sdf;
    }

    public static Timestamp adjustNanosPrecision(Timestamp ts, int fsp, boolean serverRoundFracSecs) {
        int nanos;
        if (fsp < 0 || fsp > 6) {
            throw new RuntimeException("fsp value must be in 0 to 6 range.");
        }
        Timestamp res = (Timestamp)ts.clone();
        double tail = Math.pow(10.0, 9 - fsp);
        int n = nanos = serverRoundFracSecs ? (int)Math.round((double)res.getNanos() / tail) * (int)tail : (int)((double)res.getNanos() / tail) * (int)tail;
        if (nanos > 999999999) {
            nanos %= 1000000000;
            res.setTime(res.getTime() + 1000L);
        }
        res.setNanos(nanos);
        return res;
    }

    public static String formatNanos(int nanos, int fsp) {
        return TimeUtil.formatNanos(nanos, fsp, true);
    }

    public static String formatNanos(int nanos, int fsp, boolean truncateTrailingZeros) {
        if (nanos < 0 || nanos > 999999999) {
            throw new RuntimeException("nanos value must be in 0 to 999999999 range but was " + nanos);
        }
        if (fsp < 0 || fsp > 6) {
            throw new RuntimeException("fsp value must be in 0 to 6 range but was " + fsp);
        }
        if (fsp == 0 || nanos == 0) {
            return "0";
        }
        if ((nanos = (int)((double)nanos / Math.pow(10.0, 9 - fsp))) == 0) {
            return "0";
        }
        String nanosString = Integer.toString(nanos);
        String zeroPadding = "000000000";
        nanosString = "000000000".substring(0, fsp - nanosString.length()) + nanosString;
        if (truncateTrailingZeros) {
            int pos = fsp - 1;
            while (nanosString.charAt(pos) == '0') {
                --pos;
            }
            nanosString = nanosString.substring(0, pos + 1);
        }
        return nanosString;
    }
}

