/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.org.bouncycastle.crypto.digests.SM3Digest;
import com.oscar.Driver;
import com.oscar.util.HdEncrypt;
import java.security.MessageDigest;
import java.sql.SQLException;

public class MD5Digest {
    private MD5Digest() {
    }

    public static byte[] encode(byte[] user, byte[] password, byte[] salt) {
        byte[] hex_digest = new byte[35];
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(password);
            md.update(user);
            byte[] temp_digest = md.digest();
            MD5Digest.bytesToHex(temp_digest, hex_digest, 0);
            md.update(hex_digest, 0, 32);
            md.update(salt);
            byte[] pass_digest = md.digest();
            MD5Digest.bytesToHex(pass_digest, hex_digest, 3);
            hex_digest[0] = 109;
            hex_digest[1] = 100;
            hex_digest[2] = 53;
        }
        catch (Exception e) {
            Driver.writeLog(e);
        }
        return hex_digest;
    }

    public static byte[] encodeWithHdEncrypt(byte[] user, byte[] password, byte[] salt) {
        byte[] userAndPwd = new byte[user.length + password.length];
        System.arraycopy(password, 0, userAndPwd, 0, password.length);
        System.arraycopy(user, 0, userAndPwd, password.length, user.length);
        byte[] tempDigest = HdEncrypt.instance().hdSM3Hash(userAndPwd);
        byte[] hexDigest = new byte[67];
        try {
            MD5Digest.bytesToHex32(tempDigest, hexDigest, 0);
            int bytelen = 64;
            byte[] passDigest = new byte[64 + salt.length];
            System.arraycopy(hexDigest, 0, passDigest, 0, 64);
            System.arraycopy(salt, 0, passDigest, 64, salt.length);
            passDigest = HdEncrypt.instance().hdSM3Hash(passDigest);
            MD5Digest.bytesToHex32(passDigest, hexDigest, 3);
            hexDigest[0] = 115;
            hexDigest[1] = 109;
            hexDigest[2] = 51;
        }
        catch (Exception e) {
            Driver.writeLog(e);
        }
        return hexDigest;
    }

    public static byte[] encodeWithSM3(byte[] user, byte[] password, byte[] salt) throws SQLException {
        byte[] userAndPwd = new byte[user.length + password.length];
        System.arraycopy(password, 0, userAndPwd, 0, password.length);
        System.arraycopy(user, 0, userAndPwd, password.length, user.length);
        SM3Digest sm3Digest = new SM3Digest();
        sm3Digest.update(userAndPwd, 0, userAndPwd.length);
        byte[] tempDigest = new byte[sm3Digest.getDigestSize()];
        sm3Digest.doFinal(tempDigest, 0);
        byte[] hexDigest = new byte[67];
        try {
            MD5Digest.bytesToHex32(tempDigest, hexDigest, 0);
            int bytelen = 64;
            byte[] passDigest = new byte[64 + salt.length];
            System.arraycopy(hexDigest, 0, passDigest, 0, 64);
            System.arraycopy(salt, 0, passDigest, 64, salt.length);
            sm3Digest.update(passDigest, 0, passDigest.length);
            sm3Digest.doFinal(passDigest, 0);
            MD5Digest.bytesToHex32(passDigest, hexDigest, 3);
            hexDigest[0] = 115;
            hexDigest[1] = 109;
            hexDigest[2] = 51;
        }
        catch (Exception e) {
            Driver.writeLog(e);
        }
        return hexDigest;
    }

    private static void bytesToHex(byte[] bytes, byte[] hex, int offset) {
        char[] lookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int pos = offset;
        for (int i = 0; i < 16; ++i) {
            int c = bytes[i] & 0xFF;
            int j = c >> 4;
            hex[pos++] = (byte)lookup[j];
            j = c & 0xF;
            hex[pos++] = (byte)lookup[j];
        }
    }

    private static void bytesToHex32(byte[] bytes, byte[] hex, int offset) {
        char[] lookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int pos = offset;
        for (int i = 0; i < 32; ++i) {
            int c = bytes[i] & 0xFF;
            int j = c >> 4;
            hex[pos++] = (byte)lookup[j];
            j = c & 0xF;
            hex[pos++] = (byte)lookup[j];
        }
    }
}

