/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.ssl;

import com.oscar.ssl.LazyKeyManager;
import com.oscar.ssl.WrappedFactory;
import com.oscar.util.OSQLException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class OscarSSLSocketFactory
extends WrappedFactory {
    public OscarSSLSocketFactory(String rootfile, String certfile, String keyfile, String password) throws OSQLException {
        try {
            FileInputStream fis;
            KeyStore ks;
            SSLContext ctx = SSLContext.getInstance("TLS");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
            try {
                ks = KeyStore.getInstance("jks");
            }
            catch (KeyStoreException e) {
                throw new NoSuchAlgorithmException("jks KeyStore not available");
            }
            try {
                fis = new FileInputStream(rootfile);
            }
            catch (FileNotFoundException ex) {
                throw new OSQLException("Could not open SSL root certificate file " + rootfile, "");
            }
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Certificate[] certs = cf.generateCertificates(fis).toArray(new Certificate[0]);
                ks.load(null, null);
                for (int i = 0; i < certs.length; ++i) {
                    ks.setCertificateEntry("cert" + i, certs[i]);
                }
                tmf.init(ks);
            }
            catch (IOException ioex) {
                throw new OSQLException("Could not read SSL root certificate file " + rootfile, "");
            }
            catch (GeneralSecurityException gsex) {
                throw new OSQLException("Loading the SSL root certificate " + rootfile + " into a TrustManager failed.", "");
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            TrustManager[] tm = tmf.getTrustManagers();
            try {
                LazyKeyManager km = new LazyKeyManager(certfile, keyfile, password, false);
                ctx.init(new KeyManager[]{km}, tm, null);
            }
            catch (KeyManagementException ex) {
                throw new OSQLException("Could not initialize SSL context.", "");
            }
            this.factory = ctx.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            throw new OSQLException("No such algorithm exception ", "", -1, e);
        }
    }
}

