/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.ssl;

import com.oscar.util.OSQLException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.net.Socket;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.sql.SQLException;
import java.util.Collection;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;
import sun.misc.BASE64Decoder;

public class LazyKeyManager
implements X509KeyManager {
    private X509Certificate[] cert = null;
    private PrivateKey key = null;
    private final String certfile;
    private final String keyfile;
    private final boolean defaultfile;
    private OSQLException error = null;
    private final String password;

    public LazyKeyManager(String certfile, String keyfile, String password, boolean defaultfile) {
        this.certfile = certfile;
        this.keyfile = keyfile;
        this.defaultfile = defaultfile;
        this.password = password;
    }

    public void throwKeyManagerException() throws OSQLException {
        if (this.error != null) {
            throw this.error;
        }
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        if (this.certfile == null) {
            return null;
        }
        if (issuers == null || issuers.length == 0) {
            return "user";
        }
        X509Certificate[] certchain = this.getCertificateChain("user");
        if (certchain == null) {
            return null;
        }
        X509Certificate cert = certchain[certchain.length - 1];
        X500Principal ourissuer = cert.getIssuerX500Principal();
        String certKeyType = cert.getPublicKey().getAlgorithm();
        boolean keyTypeFound = false;
        boolean found = false;
        if (keyType != null && keyType.length > 0) {
            for (String kt : keyType) {
                if (!kt.equalsIgnoreCase(certKeyType)) continue;
                keyTypeFound = true;
            }
        } else {
            keyTypeFound = true;
        }
        if (keyTypeFound) {
            for (Principal issuer : issuers) {
                if (!ourissuer.equals(issuer)) continue;
                found = keyTypeFound;
            }
        }
        return found ? "user" : null;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        if (this.cert == null && this.certfile != null) {
            Collection<? extends Certificate> certs;
            CertificateFactory cf;
            try {
                cf = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException ex) {
                this.error = new OSQLException("Could not find a java cryptographic algorithm: X.509 CertificateFactory not available.", "", -1, ex);
                return null;
            }
            FileInputStream certfileStream = null;
            try {
                certfileStream = new FileInputStream(this.certfile);
                certs = cf.generateCertificates(certfileStream);
            }
            catch (FileNotFoundException ioex) {
                if (!this.defaultfile) {
                    this.error = new OSQLException("Could not open SSL certificate file " + this.certfile, "", -1, ioex);
                }
                X509Certificate[] x509CertificateArray = null;
                return x509CertificateArray;
            }
            catch (CertificateException gsex) {
                this.error = new OSQLException("Loading the SSL certificate " + this.certfile + " into a KeyManager failed.", "", -1, gsex);
                X509Certificate[] x509CertificateArray = null;
                return x509CertificateArray;
            }
            finally {
                block21: {
                    if (certfileStream != null) {
                        try {
                            certfileStream.close();
                        }
                        catch (IOException ioex) {
                            if (this.defaultfile) break block21;
                            this.error = new OSQLException("Could not close SSL certificate file " + this.certfile, "", -1, ioex);
                        }
                    }
                }
            }
            this.cert = certs.toArray(new X509Certificate[0]);
        }
        return this.cert;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        String[] stringArray;
        String alias = this.chooseClientAlias(new String[]{keyType}, issuers, null);
        if (alias == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = alias;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFileFully(String path) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(path, "r");){
            byte[] ret = new byte[(int)raf.length()];
            raf.readFully(ret);
            byte[] byArray = ret;
            return byArray;
        }
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        block11: {
            try {
                byte[] keydata;
                if (this.key != null || this.keyfile == null) break block11;
                X509Certificate[] cert = this.getCertificateChain("user");
                if (cert == null || cert.length == 0) {
                    return null;
                }
                try {
                    keydata = LazyKeyManager.readFileFully(this.keyfile);
                }
                catch (FileNotFoundException ex) {
                    if (!this.defaultfile) {
                        throw ex;
                    }
                    return null;
                }
                String encrypted = new String(keydata);
                encrypted = encrypted.replaceFirst("-----BEGIN.*-----", "").replaceFirst("-----END.*-----", "").replaceAll("\\s", "");
                byte[] keyDER = new BASE64Decoder().decodeBuffer(encrypted);
                KeyFactory kf = KeyFactory.getInstance(cert[0].getPublicKey().getAlgorithm());
                try {
                    PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyDER);
                    this.key = kf.generatePrivate(pkcs8KeySpec);
                }
                catch (InvalidKeySpecException ex) {
                    EncryptedPrivateKeyInfo ePKInfo = new EncryptedPrivateKeyInfo(keyDER);
                    try {
                        String algName = this.loadAlgName(ePKInfo);
                        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algName);
                        SecretKey secretKey = keyFactory.generateSecret(new PBEKeySpec(this.password.toCharArray()));
                        Cipher cipher = Cipher.getInstance(algName);
                        cipher.init(2, (Key)secretKey, ePKInfo.getAlgParameters());
                        this.key = kf.generatePrivate(ePKInfo.getKeySpec(cipher));
                    }
                    catch (Exception e) {
                        this.error = new OSQLException("Could not read SSL key file " + this.keyfile + ". Cause: " + e.toString(), "", -1, e);
                    }
                }
            }
            catch (IOException ioex) {
                this.error = new OSQLException("Could not read SSL key file " + this.keyfile, "", -1, ioex);
            }
            catch (NoSuchAlgorithmException ex) {
                this.error = new OSQLException("Could not find a java cryptographic algorithm: " + ex.getMessage(), "", -1, ex);
            }
        }
        return this.key;
    }

    private String loadAlgName(EncryptedPrivateKeyInfo eki) throws Exception {
        if (eki.getAlgName().equals("PBEWithHmacSHA1AndAES_256")) {
            return eki.getAlgName();
        }
        if (!eki.getAlgName().equals("1.2.840.113549.1.5.13") && !eki.getAlgName().equals("PBES2")) {
            throw new SQLException("not PBES2 , algName is " + eki.getAlgName(), "");
        }
        AlgorithmParameters top = eki.getAlgParameters();
        Class<?> clazz = top.getClass();
        Object spi = LazyKeyManager.access(clazz, "paramSpi").get(top);
        clazz = Class.forName("com.sun.crypto.provider.PBES2Parameters", true, ClassLoader.getSystemClassLoader());
        String spiname = (String)LazyKeyManager.access(clazz, "pbes2AlgorithmName").get(spi);
        return spiname;
    }

    static Field access(Class<?> clazz, String name) throws Exception {
        Field f = clazz.getDeclaredField(name);
        f.setAccessible(true);
        return f;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return new String[0];
    }
}

