/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.rac.executor;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.jdbc.ExceptionUtil;
import com.oscar.jdbc.OscarJdbc2RacConnection;
import com.oscar.jdbc.OscarStatementV2;
import java.sql.SQLException;

public class RacStatementV2
extends OscarStatementV2 {
    private boolean hasConnect = false;

    public RacStatementV2(BaseConnection connection) {
        super(connection);
    }

    public RacStatementV2(BaseConnection connection, String sql) throws SQLException {
        super(connection, sql);
    }

    @Override
    protected boolean executeStatement() throws SQLException {
        try {
            return super.executeStatement();
        }
        catch (SQLException e) {
            if (this.connection.getAutoCommit() && this.hasConnect) {
                return this.executeStatement();
            }
            throw e;
        }
    }

    @Override
    protected void checkConnectionClosed(Exception e) {
        switch (ExceptionUtil.isConnectionClosed(e)) {
            case 1: 
            case 2: {
                try {
                    this.hasConnect = false;
                    this.reConnect();
                    this.hasConnect = true;
                }
                catch (Exception ex) {
                    Driver.writeLog("rac change connection fail:" + ex.getMessage());
                }
                break;
            }
            default: {
                this.hasConnect = false;
            }
        }
    }

    private void reConnect() throws SQLException {
        ((OscarJdbc2RacConnection)this.connection).reConnect(this.connection.getConnectionProperties());
        this.initParams();
    }
}

