/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.protocol.packets;

import com.oscar.Driver;
import com.oscar.core.Field;
import com.oscar.protocol.packets.BasePacket;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class RowDescriptionPacket
extends BasePacket {
    protected static final int SM_COLCOUNT = 2;
    protected static final int SM_COLOID = 4;
    protected static final int SM_TYPESIZE = 2;
    protected static final int SM_TYPEDES = 4;
    protected static final int SM_TYPEOID = 4;
    private static final char tag = 'T';
    protected Field[] fields = null;

    public Field[] getFields() {
        return this.fields;
    }

    @Override
    public void sendTo(BufferedOutputStream stream) throws IOException, SQLException {
    }

    @Override
    public void receiveFrom(InputStream stream) throws IOException, SQLException {
        StringBuffer sb = new StringBuffer();
        if (this.logFlag) {
            sb.delete(0, sb.length());
            sb.append("***********************************************************").append("\n");
            sb.append("conid: ").append(this.conn.getSessionID()).append(", /*Session ").append(this.conn.getPlanID()).append("*/ ");
            sb.append("receive RowDescriptionPacket 'T': ").append("\n");
        }
        int columnCount = BasePacket.ReceiveIntegerR(stream, 2);
        if (this.logFlag) {
            sb.append("columnCount: ").append(columnCount).append(", columns: ").append("\n");
        }
        byte attr = 0;
        this.fields = new Field[columnCount];
        byte[] name = null;
        byte[] aliasName = null;
        byte[] tableName = null;
        byte[] schemaName = null;
        int typeOid = 0;
        int typeLength = 0;
        int typeModifier = 0;
        for (int i = 0; i < columnCount; ++i) {
            attr = (byte)BasePacket.ReceiveChar(stream);
            if (this.conn.isReceiveStringByLen()) {
                name = BasePacket.ReceiveStringByLen(stream);
                aliasName = BasePacket.ReceiveStringByLen(stream);
                tableName = BasePacket.ReceiveStringByLen(stream);
                schemaName = BasePacket.ReceiveStringByLen(stream);
            } else {
                name = BasePacket.ReceiveString(stream);
                aliasName = BasePacket.ReceiveString(stream);
                tableName = BasePacket.ReceiveString(stream);
                schemaName = BasePacket.ReceiveString(stream);
            }
            typeOid = BasePacket.ReceiveIntegerR(stream, 4);
            typeLength = BasePacket.ReceiveIntegerR(stream, 2);
            typeModifier = BasePacket.ReceiveIntegerR(stream, 4);
            if (this.logFlag) {
                sb.append("nullAndUpdateAbleFlag: ").append(attr).append(", name: ");
                this.append(sb, name);
                sb.append(", aliasName");
                this.append(sb, aliasName);
                sb.append(", tableName");
                this.append(sb, tableName);
                sb.append(", schemaName");
                this.append(sb, schemaName);
                sb.append(", typeOid").append(typeOid);
                sb.append(", typeLength: ").append(typeLength);
                sb.append(", typeModifier: ").append(typeModifier).append("\n");
            }
            this.fields[i] = new Field(this.conn, name, typeOid, typeLength, typeModifier, aliasName, tableName, schemaName, attr);
        }
        if (this.logFlag) {
            sb.append("\n").append("***********************************************************");
            Driver.writeLog(sb.toString());
        }
    }

    @Override
    public char getTag() {
        return 'T';
    }
}

