/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.BaseStatement;
import com.oscar.core.Field;
import com.oscar.jdbc.OscarResultSet;
import com.oscar.jdbc.OscarStatement;
import com.oscar.jdbc.OscarStatementV2;
import com.oscar.jdbc.ae.ParameterEncryptionDesc;
import com.oscar.jdbc.ae.valuehandler.BoolValueHandler;
import com.oscar.jdbc.ae.valuehandler.ByteValueHandler;
import com.oscar.jdbc.ae.valuehandler.BytesValueHandler;
import com.oscar.jdbc.ae.valuehandler.DateValueHandler;
import com.oscar.jdbc.ae.valuehandler.DoubleValueHandler;
import com.oscar.jdbc.ae.valuehandler.StringValueHandler;
import com.oscar.jdbc.ae.valuehandler.TimeValueHandler;
import com.oscar.jdbc.ae.valuehandler.TimestampValueHandler;
import com.oscar.jdbc.ae.valuehandler.ValueHandler;
import com.oscar.protocol.packets.BatchProcessPacketV2;
import com.oscar.util.BatchDataStream;
import com.oscar.util.CommonUtil;
import com.oscar.util.EscapeTools;
import com.oscar.util.OSQLException;
import com.oscar.util.OscarSqlProcessor;
import com.oscar.util.converter.BindConverter;
import java.io.Reader;
import java.sql.BatchUpdateException;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class OscarPreparedStatementV2
extends OscarStatementV2
implements PreparedStatement {
    private final int compatableDbms;
    private static volatile Map<Integer, ValueHandler<?>> TYPE_NEED_ENCRYPT_MAP = null;
    private Map<Integer, ParameterEncryptionDesc> encryptionParameterMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OscarPreparedStatementV2(BaseConnection connection, String sql) throws SQLException {
        super(connection, sql);
        this.setStatementType(1);
        this.compatableDbms = Integer.parseInt(connection.getConnectionProperties().getProperty("COMPATABLE_DBMS", "0"));
        if (!connection.enableCe() || TYPE_NEED_ENCRYPT_MAP != null) return;
        Class<OscarPreparedStatementV2> clazz = OscarPreparedStatementV2.class;
        synchronized (OscarPreparedStatementV2.class) {
            if (TYPE_NEED_ENCRYPT_MAP != null) return;
            HashMap typeNeedEncryptMap = new HashMap();
            typeNeedEncryptMap.put(24, new StringValueHandler());
            typeNeedEncryptMap.put(33, new BoolValueHandler());
            typeNeedEncryptMap.put(23, new DoubleValueHandler());
            typeNeedEncryptMap.put(2003, new BytesValueHandler());
            typeNeedEncryptMap.put(35, new ByteValueHandler());
            typeNeedEncryptMap.put(25, new DateValueHandler());
            typeNeedEncryptMap.put(28, new TimestampValueHandler());
            typeNeedEncryptMap.put(26, new TimeValueHandler());
            TYPE_NEED_ENCRYPT_MAP = typeNeedEncryptMap;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public BaseResultSet createResultSet(Field[] fields, List<byte[][]> tuples, String status, long updateCount, long insertOID) throws SQLException {
        BaseResultSet rSet = OscarResultSet.getInstanceV2(this, this.connection, this.netDataByStr, this.numericKeepPrecision, this.resultSetType, this.resultSetConcurrency, this.resultSetCanUpdateable, this.fetchdirection, this.encoding, this.m_cursorName, fields, tuples, status, updateCount, insertOID, this.fetchSize, this.maxrows);
        return this.wrapUpResultSetIfCe(rSet, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws SQLException {
        if (this.ddlSql) {
            this.m_prepareSqlStatement = this.m_sqlFragments[0];
            this.m_executeSqlFragments = new String[this.fragmentsCount];
            this.m_executeSqlFragments[0] = this.m_sqlFragments[0];
        } else {
            this.m_statementName = "J" + this.getNextPreparedCount();
            this.m_origSqlFragments = new String[this.m_sqlFragments.length];
            System.arraycopy(this.m_sqlFragments, 0, this.m_origSqlFragments, 0, this.m_sqlFragments.length);
            this.setSqlFragments();
            StringBuffer stringBuffer = this.sbuf;
            synchronized (stringBuffer) {
                this.sbuf.setLength(0);
                this.sbuf.append("PREPARE ");
                this.sbuf.append(this.m_statementName);
                this.sbuf.append(" AS ");
                this.sbuf.append(this.m_origSqlFragments[0]);
                this.m_prepareSqlStatement = this.sbuf.toString();
            }
        }
        if (this.connection.getVersion().isSendQueryNumForNotRealPrepare() && this.isNotRealPrepare() && !this.ddlSql) {
            this.setPrepareAndNotRealPrepare(true);
        }
        this.setPrepareAndNotRealPrepare(false);
        this.m_sqlFragments = this.m_executeSqlFragments;
    }

    public void exitImplicitCacheToClose() throws SQLException {
        this.cacheState = (short)3;
        this.hardClose();
    }

    public void exitImplicitCacheToActive() throws SQLException {
        this.cacheState = 1;
        this.isClosed = false;
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null) {
            List<StatementEventListener> listeners = this.connection.getStatementListeners();
            StatementEvent evt = null;
            StatementEventListener[] local = listeners.toArray(new StatementEventListener[listeners.size()]);
            for (int i = 0; i < local.length; ++i) {
                StatementEventListener listener = local[i];
                if (evt == null) {
                    evt = new StatementEvent(this.connection.getPc(), this);
                }
                listener.statementClosed(evt);
            }
        }
        super.close();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.setClob(parameterIndex, (Clob)value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setClob(parameterIndex, reader);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return CommonUtil.convertToInt(this.executeLargeBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatementV2.class + ", executeBatch()");
        }
        this.checkClosed();
        this.checkConnClose();
        if (this.useAsynBatch) {
            if (this.batchDataStream != null) {
                this.batchDataStream.finshed();
            }
            this.isBegin = false;
            return null;
        }
        if (this.batch == null) {
            return new long[0];
        }
        if (this.m_bindTypes != null) {
            int bindLength = this.m_bindTypes.length;
            int protocolType = this.connection.getProtocolVersion().getProtocolType();
            if (bindLength >= 256 && protocolType < 4) {
                throw new OSQLException("OSCAR-00430", "88888", 430);
            }
            if (this.m_bindTypes.length > Short.MAX_VALUE && protocolType >= 4) {
                throw new OSQLException("OSCAR-00434", "88888", 430);
            }
        }
        int size = this.batch.size();
        if (this.statementType == 2 && !this.outParameterType.isEmpty()) {
            throw new BatchUpdateException("oscar.call.outparam", "HY065", 1, new int[0]);
        }
        if (this.result != null) {
            this.result.close();
            this.result = null;
        }
        this.updateBatchCount = 0;
        long[] resultSize = new long[size];
        int i = 0;
        try {
            if (size > 0) {
                if (this.addBatchUseSql) {
                    String[] l_origSqlFragments = this.m_sqlFragments;
                    Object[] l_origBinds = this.m_binds;
                    for (Object[] l_statement : this.batch) {
                        this.m_sqlFragments = (String[])l_statement[0];
                        this.m_binds = (Object[])l_statement[1];
                        if (this.m_sqlFragments != null && this.m_sqlFragments.length == 1) {
                            OscarSqlProcessor.ParseResult parseResult = OscarSqlProcessor.parsingWithCheck(this.m_sqlFragments[0]);
                            this.selectSql = parseResult.isSelectSql();
                            this.insertSql = parseResult.isInsertSql();
                        }
                        resultSize[i] = this.executeUpdate();
                        ++i;
                    }
                    this.m_sqlFragments = l_origSqlFragments;
                    this.m_binds = l_origBinds;
                } else {
                    if (this.m_bindTypes.length == 0) {
                        this.execute();
                        resultSize[0] = this.getUpdateCount();
                    } else {
                        int marked = 0;
                        if (this.isDDLSql()) {
                            marked = 3;
                            this.resetDDLSql(false);
                        } else if (this.isPrepareAndNotRealPrepare()) {
                            marked = 4;
                        } else if (this.getAutoGeneratedInfo() != -1) {
                            String sql;
                            marked = 2;
                            if (this.m_prepareSqlStatement != null && !(sql = this.generatedKeySqlTransform(this.m_prepareSqlStatement)).equals(this.m_prepareSqlStatement)) {
                                this.m_prepareSqlStatement = sql;
                                marked = 0;
                            }
                        } else if (this.useTid()) {
                            marked = 1;
                        }
                        boolean bindTypeChanged = this.checkBindTypes();
                        if (!this.bindTypeBackuped) {
                            if (this.m_preBindTypes.length != this.m_bindTypes.length) {
                                this.m_preBindTypes = new int[this.m_bindTypes.length];
                            }
                            System.arraycopy(this.m_bindTypes, 0, this.m_preBindTypes, 0, this.m_bindTypes.length);
                            this.bindTypeBackuped = true;
                        }
                        if (this.batchPacketV2 != null) {
                            this.batchPacketV2.init(this.batch, this.m_statementName, this.connection.getEncoding(), this.connection.getBatchBufferSize(), this.m_prepareSqlStatement, marked, bindTypeChanged);
                        } else {
                            this.batchPacketV2 = new BatchProcessPacketV2(this.batch, this.m_statementName, this.connection.getEncoding(), this.connection.getBatchBufferSize(), this.m_prepareSqlStatement, marked, bindTypeChanged, this.connection, this.localCalendar);
                        }
                        this.markPrepared(false);
                        this.getDBConnection().getQueryExecutor().executeBatch(this.batchPacketV2, (BaseStatement)this, resultSize);
                        this.markPrepared(true);
                        if (this.m_prepareSqlStatement != null) {
                            this.m_prepareSqlStatement = null;
                        }
                        if (this.compatableDbms == 1) {
                            for (int j = 0; j < resultSize.length; ++j) {
                                resultSize[j] = -2L;
                            }
                        }
                    }
                    if (this.result != null && this.result.reallyResultSet() && !this.isCallable && this.autoGeneratedInfo == -1) {
                        throw new OSQLException("OSCAR-00403", "88888", 403);
                    }
                }
            }
        }
        catch (SQLException e) {
            long[] resultSucceeded = null;
            if (this.addBatchUseSql) {
                resultSucceeded = new long[i];
                if (i > 1) {
                    System.arraycopy(resultSize, 0, resultSucceeded, 0, i);
                }
            } else {
                resultSucceeded = new long[this.updateBatchCount];
                System.arraycopy(resultSize, 0, resultSucceeded, 0, this.updateBatchCount);
            }
            if (this.logFlag) {
                Driver.writeLog(this.sessionId, this.pid, e.getMessage());
            }
            this.checkConnectionClosed(e);
            throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), CommonUtil.convertToInt(resultSucceeded));
        }
        catch (Exception e) {
            if (this.logFlag) {
                Driver.writeLog(this.sessionId, this.pid, e.getMessage());
            }
        }
        finally {
            this.handleBatch();
            this.cleanEnvTemp();
        }
        this.addBatchUseSql = false;
        this.warnings = null;
        return resultSize;
    }

    public void handleBatch() {
        if (this.batch != null) {
            this.batch.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBatchAsyn(List asynBatch) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatementV2.class + ", executeBatchAsyn(List asynBatch)");
        }
        this.checkClosed();
        if (asynBatch == null) {
            return;
        }
        int size = asynBatch.size();
        if (this.statementType == 2 && !this.outParameterType.isEmpty()) {
            throw new BatchUpdateException("oscar.call.outparam", "HY065", 1, new int[0]);
        }
        long[] resultSize = new long[size];
        try {
            if (size > 0) {
                int marked = 0;
                if (this.isDDLSql()) {
                    marked = 3;
                    this.resetDDLSql(false);
                } else if (this.isPrepareAndNotRealPrepare()) {
                    marked = 4;
                } else if (this.getAutoGeneratedInfo() != -1) {
                    String sql;
                    marked = 2;
                    if (this.m_prepareSqlStatement != null && !(sql = this.generatedKeySqlTransform(this.m_prepareSqlStatement)).equals(this.m_prepareSqlStatement)) {
                        this.m_prepareSqlStatement = sql;
                        marked = 0;
                    }
                } else if (this.useTid()) {
                    marked = 1;
                }
                boolean bindTypeChanged = this.checkBindTypes();
                if (!this.bindTypeBackuped) {
                    if (this.m_preBindTypes.length != this.m_bindTypes.length) {
                        this.m_preBindTypes = new int[this.m_bindTypes.length];
                    }
                    System.arraycopy(this.m_bindTypes, 0, this.m_preBindTypes, 0, this.m_bindTypes.length);
                    this.bindTypeBackuped = true;
                }
                if (this.batchPacketV2 != null) {
                    this.batchPacketV2.init(asynBatch, this.m_statementName, this.connection.getEncoding(), this.connection.getBatchBufferSize(), this.m_prepareSqlStatement, marked, bindTypeChanged);
                } else {
                    this.batchPacketV2 = new BatchProcessPacketV2(asynBatch, this.m_statementName, this.connection.getEncoding(), this.connection.getBatchBufferSize(), this.m_prepareSqlStatement, marked, bindTypeChanged, this.connection, this.localCalendar);
                }
                this.markPrepared(false);
                this.getDBConnection().getQueryExecutor().executeBatch(this.batchPacketV2, (BaseStatement)this, resultSize);
                this.markPrepared(true);
                if (this.m_prepareSqlStatement != null) {
                    this.m_prepareSqlStatement = null;
                }
                if (this.result != null && this.result.reallyResultSet() && !this.isCallable && this.autoGeneratedInfo == -1) {
                    throw new OSQLException("OSCAR-00403", "88888", 403);
                }
            }
        }
        catch (SQLException e) {
            int[] resultSucceeded = null;
            resultSucceeded = new int[size];
            if (this.logFlag) {
                Driver.writeLog(this.sessionId, this.pid, e.getMessage());
            }
            this.checkConnectionClosed(e);
            throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), resultSucceeded);
        }
        catch (Exception e) {
            if (this.logFlag) {
                Driver.writeLog(this.sessionId, this.pid, e.getMessage());
            }
        }
        finally {
            asynBatch.clear();
            this.cleanEnvTemp();
        }
        this.result = null;
        this.warnings = null;
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarPreparedStatementV2.class + ", addBatch()");
        }
        this.checkClosed();
        this.updateBatchBindType();
        Object[] m_binds_backup = new Object[this.m_binds.length];
        System.arraycopy(this.m_binds, 0, m_binds_backup, 0, this.m_binds.length);
        int[] l_newBindTypes = new int[this.m_bindTypes.length];
        System.arraycopy(this.m_bindTypes, 0, l_newBindTypes, 0, this.m_bindTypes.length);
        if (this.useAsynBatch) {
            this.convertBindDatas(false);
            Object[] l_newBinds = new Object[this.m_binds.length];
            System.arraycopy(this.m_binds, 0, l_newBinds, 0, this.m_binds.length);
            OscarStatement.BatchRowData data = new OscarStatement.BatchRowData(l_newBinds, l_newBindTypes, this.hasEscapeChar);
            this.m_binds = m_binds_backup;
            m_binds_backup = null;
            if (!this.isBegin) {
                this.isBegin = true;
                if (this.batchDataStream == null) {
                    this.batchDataStream = new BatchDataStream(this);
                } else {
                    this.batchDataStream.reInit();
                }
            }
            this.batchDataStream.addBatchData(data);
        } else {
            OscarStatement.BatchRowData data = new OscarStatement.BatchRowData(m_binds_backup, l_newBindTypes, this.hasEscapeChar);
            if (this.batch == null) {
                this.batch = new LinkedList();
            }
            this.batch.add(data);
            this.hasEscapeChar = false;
            if (this.addBatchUseSql) {
                this.addBatchUseSql = false;
            }
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        String sql;
        BaseResultSet brs;
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getMetaData();
        }
        if (this.m_statementName == null || this.insertSql) {
            return null;
        }
        if (this.m_prepareSqlStatement != null && !this.isMarkPrepared()) {
            try {
                this.markPrepared(false);
                this.connection.execSQL(this.m_prepareSqlStatement, this);
                this.markPrepared(true);
            }
            catch (SQLException sqle) {
                this.m_statementName = null;
                throw sqle;
            }
        }
        if ((brs = this.connection.execSQL(sql = "GET ROWDESCRIPTION FOR " + this.m_statementName)) != null && brs.reallyResultSet()) {
            return brs.getMetaData();
        }
        return null;
    }

    private void updateBatchBindType() throws SQLException {
        if (this.batch != null && this.batch.size() > 0) {
            StringBuilder sb = null;
            OscarStatement.BatchRowData firstRowValue = (OscarStatement.BatchRowData)this.batch.get(0);
            for (int index = 0; index < this.m_bindTypes.length; ++index) {
                boolean hasLob;
                int type = this.m_bindTypes[index];
                if (this.logFlag) {
                    sb = new StringBuilder(200);
                    sb.append(OscarStatementV2.class + ", bind(int paramIndex, Object s, int type) ,param: " + (index + 1) + ", type: " + type);
                }
                int firstBindType = firstRowValue.getTypes()[index];
                if (this.logFlag) {
                    sb.append(", pre type: " + firstBindType);
                }
                boolean bl = hasLob = firstBindType == 50 || type == 50 || firstBindType == 51 || type == 51;
                if (type != firstBindType && !hasLob) {
                    if (!(type != 23 && type != 28 || firstBindType != 24 && firstBindType != 34)) {
                        type = firstBindType;
                    } else {
                        firstRowValue.getTypes()[index] = type;
                        Object before = firstRowValue.getData()[index];
                        firstRowValue.getData()[index] = BindConverter.convertBindValueByType(before, firstBindType, type);
                    }
                    this.m_bindTypes[index] = type;
                }
                if (!this.logFlag) continue;
                if (this.m_binds[index] == null) {
                    sb.append(",data: null");
                } else {
                    sb.append(", data: " + this.m_binds[index].toString());
                }
                Driver.writeLog(this.sessionId, this.pid, sb.toString());
            }
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        throw new OSQLException("OSCAR_00435", "88888", 435);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkClosed();
        throw new OSQLException("OSCAR_00435", "88888", 435);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkClosed();
        throw new OSQLException("OSCAR_00435", "88888", 435);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
        throw new OSQLException("OSCAR_00435", "88888", 435);
    }

    @Override
    protected void bind(int paramIndex, Object value, int type) throws SQLException {
        if (value == null) {
            super.bind(paramIndex, null, type);
            return;
        }
        if (this.connection.enableCe() && TYPE_NEED_ENCRYPT_MAP.get(type) != null) {
            this.getParameterEncryptionMetadata();
            ParameterEncryptionDesc desc = this.encryptionParameterMap.get(paramIndex - 1);
            if (desc != null) {
                try {
                    value = TYPE_NEED_ENCRYPT_MAP.get(type).encrypt(desc, value, type);
                }
                catch (Exception e) {
                    if (this.logFlag) {
                        Driver.writeLog(e);
                    }
                    throw new SQLException(e);
                }
                type = 24;
            }
        }
        super.bind(paramIndex, value, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getParameterEncryptionMetadata() throws SQLException {
        if (this.encryptionParameterMap != null) {
            return;
        }
        OscarPreparedStatementV2 oscarPreparedStatementV2 = this;
        synchronized (oscarPreparedStatementV2) {
            String afterSql = EscapeTools.toSingleQuotationMarks(this.m_prepareSqlStatement);
            String encryptParameterDescSQL = "EXEC INFO_SCHEM.PARSE_ENCRYPTED_PREPARE(" + afterSql + ")";
            Statement statement = null;
            ResultSet cSet = null;
            try {
                statement = this.getConnection().createStatement();
                statement.execute(encryptParameterDescSQL);
                cSet = statement.getResultSet();
                HashMap<Integer, ParameterEncryptionDesc> local = new HashMap<Integer, ParameterEncryptionDesc>();
                while (cSet.next()) {
                    ParameterEncryptionDesc parameterEncryptionDesc = new ParameterEncryptionDesc();
                    parameterEncryptionDesc.setCekAlgorithm(cSet.getString("CEKENCMOD"));
                    parameterEncryptionDesc.setCekEncryptedValue(cSet.getBytes("CEKENCVALUE"));
                    parameterEncryptionDesc.setCekOid(cSet.getLong("CEKOID"));
                    parameterEncryptionDesc.setCekVersion(cSet.getInt("CEKVERSION"));
                    parameterEncryptionDesc.setCmkKeyStoreName(cSet.getString("CMKKEYSTORENAME"));
                    parameterEncryptionDesc.setCmkPath(cSet.getString("CMKKEYPATH"));
                    parameterEncryptionDesc.setEncryptMode(cSet.getString("ENCMOD"));
                    parameterEncryptionDesc.setEncryptType(cSet.getInt("ENCTYPE"));
                    parameterEncryptionDesc.setParameterIndex(cSet.getInt("PARAMNUM"));
                    local.put(parameterEncryptionDesc.getParameterIndex(), parameterEncryptionDesc);
                }
                this.encryptionParameterMap = local;
            }
            finally {
                if (cSet != null) {
                    cSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }
}

