/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.Field;
import com.oscar.jdbc.OscarParaMetaData;
import com.oscar.jdbc.OscarPreparedStatementV2;
import com.oscar.jdbc.OscarResultSet;
import com.oscar.jdbc.entity.ParamInfo;
import com.oscar.jdbc.handler.NClobInvocationHandler;
import com.oscar.util.OSQLException;
import com.oscar.util.OscarSqlProcessor;
import com.oscar.util.TypeConverter;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OscarCallableStatementV2
extends OscarPreparedStatementV2
implements CallableStatement {
    private HashMap<Integer, Integer> outParameterScale = null;
    OscarSqlProcessor.ParseFunctionResult pr;

    public OscarCallableStatementV2(BaseConnection connection, String sql) throws SQLException {
        super(connection, sql);
        this.setStatementType(2);
    }

    public BaseResultSet createResultSet(Field[] fields, List tuples, String status, long updateCount, long insertOID) throws SQLException {
        return OscarResultSet.getInstanceV2CallableStatement(this, fields, tuples, status, updateCount, insertOID, this.fetchSize, this.maxrows);
    }

    @Override
    protected String subParseSqlStmt(String sql) throws SQLException {
        OscarSqlProcessor.ParseFunctionResult pr = OscarSqlProcessor.modifyJdbcCall(sql, this.connection);
        this.isCallable = pr.isCallable();
        this.isAnonymous = pr.isAnonymous();
        this.isFunc = pr.isFunc();
        this.isResultNeeded = pr.isResultNeeded();
        this.isHaveFuncReturn = pr.haveFuncReturn();
        this.pr = pr;
        return pr.getAfterSql();
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.isAnonymous && this.outParameterIndex.size() > 0 && !this.anonymousSupportPrepare) {
            throw new SQLException("PL registerOutParameter must anonymousSupportPrepare=true");
        }
        return super.execute();
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setString(index, value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setCharacterStream(index, value, length);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setClob(index, (Clob)value);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setClob(index, reader, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.setClob(index, value);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        Clob clob = this.getClob(columnIndex);
        if (clob == null) {
            return null;
        }
        return (NClob)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{NClob.class}, (InvocationHandler)new NClobInvocationHandler(clob));
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getNClob(index);
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        return this.getString(parameterIndex);
    }

    @Override
    public String getNString(String paramString) throws SQLException {
        return this.getString(paramString);
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        return this.getCharacterStream(parameterIndex);
    }

    @Override
    public Reader getNCharacterStream(String paramString) throws SQLException {
        return this.getCharacterStream(paramString);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.checkClosed();
        if (type == null) {
            throw new SQLException("Type parameter can not be null");
        }
        if (type.equals(String.class)) {
            return (T)this.getString(columnIndex);
        }
        if (type.equals(BigDecimal.class)) {
            return (T)this.getBigDecimal(columnIndex);
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(this.getBoolean(columnIndex));
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(this.getInt(columnIndex));
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return (T)Long.valueOf(this.getLong(columnIndex));
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return (T)Float.valueOf(this.getFloat(columnIndex));
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return (T)Double.valueOf(this.getDouble(columnIndex));
        }
        if (type.equals(byte[].class)) {
            return (T)this.getBytes(columnIndex);
        }
        if (type.equals(Date.class)) {
            return (T)this.getDate(columnIndex);
        }
        if (type.equals(Time.class)) {
            return (T)this.getTime(columnIndex);
        }
        if (type.equals(Timestamp.class)) {
            return (T)this.getTimestamp(columnIndex);
        }
        if (type.equals(Clob.class)) {
            return (T)this.getClob(columnIndex);
        }
        if (type.equals(Blob.class)) {
            return (T)this.getBlob(columnIndex);
        }
        if (type.equals(Array.class)) {
            return (T)this.getArray(columnIndex);
        }
        if (type.equals(Ref.class)) {
            return (T)this.getRef(columnIndex);
        }
        if (type.equals(URL.class)) {
            return (T)this.getURL(columnIndex);
        }
        if (type.equals(Struct.class)) {
            throw Driver.notImplemented();
        }
        if (type.equals(RowId.class)) {
            return (T)this.getRowId(columnIndex);
        }
        if (type.equals(NClob.class)) {
            return (T)this.getNClob(columnIndex);
        }
        if (type.equals(SQLXML.class)) {
            return (T)this.getSQLXML(columnIndex);
        }
        return (T)this.getObject(columnIndex);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getObject(index, type);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        this.registerOutParameter(index, sqlType, scale);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
        if (this.outParameterScale == null) {
            this.outParameterScale = new HashMap();
        }
        this.outParameterScale.put(parameterIndex, scale);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 3, "BigDecimal");
        BigDecimal value = TypeConverter.toBigDecimal(this.getFixedString(parameterIndex), this.m_functionTypes[parameterIndex - 1]);
        if (value != null && this.outParameterScale != null && this.outParameterScale.containsKey(parameterIndex)) {
            value = value.setScale((int)this.outParameterScale.get(parameterIndex), 4);
        }
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int index = this.pMetaData.getIndex(parameterName);
        return this.getBigDecimal(index);
    }

    @Override
    public void closeOrCache() throws SQLException {
        super.closeOrCache();
        if (this.outParameterScale != null) {
            this.outParameterScale.clear();
            this.outParameterScale = null;
        }
    }

    @Override
    protected void getProcedureResult() throws SQLException {
        if (this.outParameterIndex.size() <= 0) {
            return;
        }
        BaseResultSet proRs = this.result.getLastResult();
        if (proRs == null) {
            proRs = this.result;
        }
        proRs.next();
        byte[][] row = proRs.getCurrentRow();
        this.m_functionTypes = new int[this.m_binds.length];
        int pNum = this.parameterNum;
        int rowIndex = 0;
        if (!this.isResultNeeded && this.isFunc) {
            ++pNum;
            this.m_returnValue = row[rowIndex];
            this.m_returnType = proRs.getMetaData().getColumnType(rowIndex + 1);
            ++rowIndex;
        }
        if (pNum != proRs.getColumnCount()) {
            Map<String, ParamInfo> paramsMap = this.pr.getParams();
            if (paramsMap == null) {
                OscarSqlProcessor.initObjectInfo(this.pr, this.connection);
                paramsMap = this.pr.getParams();
            }
            if (paramsMap != null) {
                Collection<ParamInfo> valueParams = paramsMap.values();
                HashMap newMap = new HashMap();
                long selectOid = -1L;
                for (ParamInfo paramInfo : valueParams) {
                    long objectId = paramInfo.getOid();
                    if (newMap.containsKey(objectId)) {
                        ((List)newMap.get(objectId)).add(paramInfo);
                        continue;
                    }
                    ArrayList<ParamInfo> paramList = new ArrayList<ParamInfo>();
                    paramList.add(paramInfo);
                    newMap.put(objectId, paramList);
                }
                for (Map.Entry entry : newMap.entrySet()) {
                    Long newKey = (Long)entry.getKey();
                    if (((List)entry.getValue()).size() != this.fragmentsCount - 1) continue;
                    selectOid = newKey;
                    break;
                }
                if (selectOid == -1L) {
                    throw new OSQLException("OSCAR-00407", "88888", 407);
                }
                List paramInfos = (List)newMap.get(selectOid);
                if (paramInfos != null) {
                    for (ParamInfo info : paramInfos) {
                        int inOut;
                        int key = info.getSequence();
                        if (this.outParameterIndex.contains(key) || (inOut = info.getInout()) != 2 && inOut != 3) continue;
                        this.outParameterIndex.add(this.parameterNum++, key);
                        Collections.sort(this.outParameterIndex);
                        int index = this.outParameterIndex.indexOf(key);
                        this.outParameterType.insertElementAt(this.connection.getSQLType(info.getType()), index);
                    }
                }
            }
        }
        for (Object index : this.outParameterIndex) {
            int resIndex = (Integer)index - 1;
            this.m_functionTypes[resIndex] = proRs.getMetaData().getColumnType(rowIndex + 1);
            this.m_outValues[resIndex] = row[rowIndex];
            ++rowIndex;
        }
    }
}

