/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.ImportHandler;
import com.oscar.jdbc.OscarJdbc2BulkConnection;
import com.oscar.util.CommonUtil;
import com.oscar.util.OSQLException;
import com.oscar.util.OscarSqlProcessor;
import com.oscar.util.TableNameParser;
import com.oscar.util.Word;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OscarBulkInsertPrepareStatement
implements PreparedStatement {
    private OscarJdbc2BulkConnection connection = null;
    private ImportHandler bulkHandler = null;
    private String tableName = null;
    private String[] fieldName = null;
    private String fieldNameStr = null;
    protected boolean isClosed = false;
    private boolean poolable = true;
    protected int maxfieldSize = 0;
    protected int fetchSize = 16;
    private HashMap<Integer, String> constantMap = new HashMap();
    private HashMap<Integer, Integer> variableMap = new HashMap();
    protected int maxrows = 0;
    protected int timeout = 0;
    protected SQLWarning warnings = null;
    protected int resultSetHoldability = 2;
    protected int fetchdirection = 1000;
    protected int resultSetType = 1003;
    protected int resultSetConcurrency = 1007;
    private String schemaName = null;

    OscarBulkInsertPrepareStatement(OscarJdbc2BulkConnection connection, String sql, int rsType, int rsConcurrency, int rsHoldability, OscarSqlProcessor.ParseResult pResult, String tempSql) throws SQLException {
        this.connection = connection;
        this.parseSQL(sql, pResult, tempSql);
        this.bulkHandler = this.schemaName != null ? connection.createImportHandler(this.schemaName, this.tableName) : connection.createImportHandler(this.tableName);
        this.bulkHandler.setBufferSize(connection.getBufferSize());
        if (this.fieldNameStr != null) {
            this.bulkHandler.setColumnOrder(this.fieldNameStr);
        }
        this.resultSetHoldability = rsHoldability;
        this.resultSetType = rsType;
        this.resultSetConcurrency = rsConcurrency;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSQL(String sql, OscarSqlProcessor.ParseResult pResult, String tmpSql) throws SQLException {
        Pattern p = Pattern.compile("INSERT\\s+INTO\\s+((\".*?(|\"\").*?\")|(\\w|[\u4e00-\u9fa5])+)\\s*((\\.)\\s*(((\".*\")|(\"\"))|(\\w|[\u4e00-\u9fa5])+))?(\\s+|\\(+)", 2);
        Pattern pI = Pattern.compile("INSERT\\s+INTO", 2);
        Matcher matcher = p.matcher(tmpSql);
        String tempSplit = null;
        int valuesPreLength = 0;
        if (!matcher.find()) throw new SQLException("Parsing grammarerror, your sql is: " + sql);
        String temp = matcher.group();
        Matcher mI = pI.matcher(temp);
        if (mI.find()) {
            this.tableName = temp.endsWith("(") ? temp.substring(mI.group().length(), temp.length() - 1).trim() : temp.substring(mI.group().length(), temp.length()).trim();
            String[] names = TableNameParser.parserToDbNames(this.tableName);
            this.schemaName = names[0];
            this.tableName = names[1];
        }
        if (temp.endsWith("(")) {
            tempSplit = tmpSql.substring(temp.length() - 1, tmpSql.length());
            valuesPreLength = temp.length() - 1;
        } else {
            tempSplit = tmpSql.substring(temp.length(), tmpSql.length());
            valuesPreLength = temp.length();
        }
        String firstPartStr = null;
        String secondPartStr = null;
        if (pResult != null && pResult.getValuesWordIndex() > 0) {
            Word valuesWord = pResult.getAllWords().get(pResult.getValuesWordIndex());
            firstPartStr = tmpSql.substring(valuesPreLength, valuesWord.getTokenBegin());
            secondPartStr = tmpSql.substring(valuesWord.getTokenEnd(), tmpSql.length());
        } else {
            Pattern pAfter = Pattern.compile("\\((\\s*(('.*?[^\\\\]')|(\\w|[\u4e00-\u9fa5])+|\\?)\\s*)(,\\s*(('.*?[^\\\\]')|(\\w|[\u4e00-\u9fa5])+|\\?)\\s*)*\\)", 2);
            Matcher matcherAfter = pAfter.matcher(tempSplit);
            if (tempSplit.trim().toUpperCase().startsWith("VALUES")) {
                if (!matcherAfter.find()) throw new SQLException("Parsing grammarerror, your sql is: " + sql);
                secondPartStr = matcherAfter.group();
            } else {
                Pattern pBefore = Pattern.compile("\\((\\s*((\".*?[^\\\\]\")|(\\w|[\u4e00-\u9fa5])+|\\?)\\s*)(,\\s*((\".*?[^\\\\]\")|(\\w|[\u4e00-\u9fa5])+|\\?)\\s*)*\\)", 2);
                Matcher matcherBefore = pBefore.matcher(tempSplit);
                if (!matcherBefore.find()) {
                    throw new SQLException("Parsing grammarerror, your sql is: " + sql);
                }
                firstPartStr = matcherBefore.group();
                if (!matcherAfter.find(firstPartStr.length())) throw new SQLException("Parsing grammarerror, your sql is: " + sql);
                secondPartStr = matcherAfter.group();
            }
        }
        Pattern pColumn = Pattern.compile("\\s*((\".*?[^\\\\]\")|(\\w|[\u4e00-\u9fa5])+|\\?)\\s*", 2);
        if (null != firstPartStr) {
            Matcher matcherFirst = pColumn.matcher(firstPartStr);
            ArrayList<String> splitFirst = new ArrayList<String>();
            while (matcherFirst.find()) {
                splitFirst.add(matcherFirst.group());
            }
            String[] splitFieldNameArray = new String[splitFirst.size()];
            for (int j = 0; j < splitFirst.size(); ++j) {
                splitFieldNameArray[j] = (String)splitFirst.get(j);
            }
            if (splitFieldNameArray != null && splitFieldNameArray.length > 0) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < splitFieldNameArray.length; ++i) {
                    String temp2 = splitFieldNameArray[i].trim();
                    splitFieldNameArray[i] = temp2.length() > 2 && temp2.startsWith("\"") && temp2.endsWith("\"") ? temp2.substring(1, temp2.length() - 1) : temp2.toUpperCase();
                    sb.append(splitFieldNameArray[i]).append(",");
                }
                this.fieldNameStr = sb.substring(0, sb.length() - 1);
                this.fieldName = splitFieldNameArray;
            }
        }
        Pattern pParam = Pattern.compile("\\s*(('.*?[^\\\\]')|\\w+|\\?)\\s*", 2);
        Matcher matcherSecond = pParam.matcher(secondPartStr);
        ArrayList<String> splitSecond = new ArrayList<String>();
        while (matcherSecond.find()) {
            splitSecond.add(matcherSecond.group());
        }
        String[] splitQuestionMarkArray = new String[splitSecond.size()];
        for (int j = 0; j < splitSecond.size(); ++j) {
            splitQuestionMarkArray[j] = (String)splitSecond.get(j);
        }
        if (splitQuestionMarkArray == null || splitQuestionMarkArray.length <= 0 || this.fieldName != null && splitQuestionMarkArray.length != this.fieldName.length) {
            throw new SQLException("The total number of question marks must be the same as the total number of column names, your sql is: " + sql);
        }
        int index = 0;
        for (int i = 0; i < splitQuestionMarkArray.length; ++i) {
            splitQuestionMarkArray[i] = splitQuestionMarkArray[i].trim();
            if ("?".equals(splitQuestionMarkArray[i])) {
                this.variableMap.put(++index, i + 1);
                continue;
            }
            if ("null".equalsIgnoreCase(splitQuestionMarkArray[i])) {
                this.constantMap.put(i + 1, null);
                continue;
            }
            if (splitQuestionMarkArray[i].matches("^'.*'$")) {
                splitQuestionMarkArray[i] = splitQuestionMarkArray[i].substring(1, splitQuestionMarkArray[i].length() - 1);
            }
            this.constantMap.put(i + 1, splitQuestionMarkArray[i]);
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.bulkHandler != null) {
            this.bulkHandler.close();
            this.bulkHandler = null;
        }
        this.isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return this.maxfieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        this.maxfieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxrows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new OSQLException("OSCAR-00408", "88888", 408);
        }
        this.maxrows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.timeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.timeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        this.connection.cancelQuery();
    }

    public void addWarning(SQLWarning warn) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(warn);
        } else {
            this.warnings = warn;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkClosed();
        this.clearWarnings();
        if (this.bulkHandler != null) {
            return this.bulkHandler.execute();
        }
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        return CommonUtil.convertToInt(this.bulkHandler.getCurrentUpdateCount());
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new OSQLException("OSCAR-00418", "88888", 418);
        }
        if (this.resultSetType == 1003 && direction != 1000) {
            throw new OSQLException("OSCAR-00418", "88888", 418);
        }
        this.fetchdirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchdirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw new OSQLException("OSCAR-00307", "88888", 307);
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkClosed();
        return this.resultSetType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.execute();
        int[] resultSize = null;
        int size = CommonUtil.convertToInt(this.bulkHandler.getCurrentUpdateCount());
        if (size > 0) {
            resultSize = new int[size];
            for (int i = 0; i < size; ++i) {
                resultSize[i] = 1;
            }
        } else {
            resultSize = new int[1];
        }
        return resultSize;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.execute();
        return CommonUtil.convertToInt(this.bulkHandler.getCurrentUpdateCount());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setByte(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setShort(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setLong(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setFloat(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setDouble(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setString(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setBytes(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setDate(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setUnicodeStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setObject(parameterIndex, x);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.bulkHandler.execute();
    }

    @Override
    public void addBatch() throws SQLException {
        for (Map.Entry<Integer, String> entry : this.constantMap.entrySet()) {
            this.bulkHandler.setString((int)entry.getKey(), entry.getValue());
        }
        this.bulkHandler.endRow();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        i = this.reIndex(i);
        this.bulkHandler.setBlob(i, x);
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        i = this.reIndex(i);
        this.bulkHandler.setClob(i, x);
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        i = this.reIndex(i);
        this.bulkHandler.setArray(i, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        paramIndex = this.reIndex(paramIndex);
        this.bulkHandler.setNull(paramIndex, sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new OSQLException("OSCAR-00409", "00409", 118);
        }
    }

    private int reIndex(int x) throws OSQLException {
        Integer index = this.variableMap.get(x);
        if (index == null) {
            throw new OSQLException("OSCAR-00305", "88888", 305);
        }
        return index;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean paramBoolean) throws SQLException {
        this.checkClosed();
        this.poolable = paramBoolean;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.poolable;
    }

    @Override
    public <T> T unwrap(Class<T> paramClass) throws SQLException {
        if (paramClass.isAssignableFrom(this.getClass())) {
            return paramClass.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + paramClass.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> paramClass) throws SQLException {
        return paramClass.isAssignableFrom(this.getClass());
    }

    @Override
    public void setRowId(int paramInt, RowId paramRowId) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void setNString(int paramInt, String paramString) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void setNCharacterStream(int paramInt, Reader paramReader, long paramLong) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void setNClob(int paramInt, NClob paramNClob) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void setClob(int i, Reader x, long length) throws SQLException {
        i = this.reIndex(i);
        this.bulkHandler.setCharacterStream(i, x, length);
    }

    @Override
    public void setBlob(int i, InputStream x, long paramLong) throws SQLException {
        i = this.reIndex(i);
        this.bulkHandler.setBlob(i, x, paramLong);
    }

    @Override
    public void setNClob(int paramInt, Reader paramReader, long paramLong) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.checkClosed();
        if (xmlObject == null || xmlObject.getString() == null) {
            this.setNull(parameterIndex, 2009);
        } else {
            this.setString(parameterIndex, xmlObject.getString());
        }
    }

    @Override
    public void setAsciiStream(int i, InputStream x, long length) throws SQLException {
        i = this.reIndex(i);
        this.bulkHandler.setBlob(i, x, length);
    }

    @Override
    public void setBinaryStream(int i, InputStream x, long length) throws SQLException {
        i = this.reIndex(i);
        this.bulkHandler.setBinaryStream(i, x, length);
    }

    @Override
    public void setCharacterStream(int i, Reader x, long length) throws SQLException {
        i = this.reIndex(i);
        this.bulkHandler.setCharacterStream(i, x, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        parameterIndex = this.reIndex(parameterIndex);
        this.bulkHandler.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int i, InputStream x) throws SQLException {
        i = this.reIndex(i);
        this.bulkHandler.setBinaryStream(i, x);
    }

    @Override
    public void setCharacterStream(int i, Reader x) throws SQLException {
        i = this.reIndex(i);
        this.bulkHandler.setCharacterStream(i, x);
    }

    @Override
    public void setNCharacterStream(int paramInt, Reader paramReader) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void setClob(int i, Reader x) throws SQLException {
        i = this.reIndex(i);
        this.bulkHandler.setCharacterStream(i, x);
    }

    @Override
    public void setBlob(int i, InputStream x) throws SQLException {
        i = this.reIndex(i);
        this.bulkHandler.setBinaryStream(i, x);
    }

    @Override
    public void setNClob(int paramInt, Reader paramReader) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }
}

