/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.jdbc.OscarArray;
import com.oscar.util.OSQLException;
import com.oscar.util.TypeConverter;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class ConnectionArray
extends OscarArray {
    private String typeName;
    private BaseConnection conn;
    private Object[] elements;
    private Calendar localCalendar;

    public ConnectionArray(BaseConnection conn, String typeName, Object[] elements) {
        this.typeName = typeName;
        this.conn = conn;
        this.elements = elements;
        StringBuffer sb = new StringBuffer();
        this.appendArray(sb, elements);
        this.rawString = sb.toString();
        this.localCalendar = conn.getCalendar();
    }

    private void appendArray(StringBuffer sb, Object elements) {
        sb.append('{');
        int nElements = Array.getLength(elements);
        for (int i = 0; i < nElements; ++i) {
            Object o;
            if (i > 0) {
                sb.append(',');
            }
            if ((o = Array.get(elements, i)) == null) {
                sb.append("NULL");
                continue;
            }
            if (o.getClass().isArray()) {
                this.appendArray(sb, o);
                continue;
            }
            String s = o.toString();
            this.escapeArrayElement(sb, s);
        }
        sb.append('}');
    }

    private void escapeArrayElement(StringBuffer b, String s) {
        b.append('\"');
        for (int j = 0; j < s.length(); ++j) {
            char c = s.charAt(j);
            if (c == '\"' || c == '\\') {
                b.append('\\');
            }
            b.append(c);
        }
        b.append('\"');
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.typeName;
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.conn.getSQLType(this.getBaseTypeName());
    }

    @Override
    public Object getArray() throws SQLException {
        if (this.elements != null) {
            return this.getArray(1L, this.elements.length, null);
        }
        return this.getArray(1L, 0, null);
    }

    @Override
    public Object getArray(Map<String, Class<?>> paramMap) throws SQLException {
        return this.getArray(1L, 0, paramMap);
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        return this.getArray(index, count, null);
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        this.checkFree();
        if (map != null) {
            throw Driver.notImplemented();
        }
        if (index < 1L) {
            throw new OSQLException("OSCAR-00304", "88888", 304);
        }
        if (--index + (long)count > (long)this.elements.length) {
            throw new OSQLException("OSCAR-00304", "888880", 304);
        }
        Object[] retVal = null;
        int i = 0;
        switch (this.getBaseType()) {
            case -7: 
            case 16: {
                retVal = new Boolean[count];
                while (count > 0) {
                    ((Boolean[])retVal)[i++] = TypeConverter.toBoolean(this.elements[(int)index++].toString(), -7);
                    --count;
                }
                break;
            }
            case 4: 
            case 5: {
                retVal = new Integer[count];
                while (count > 0) {
                    ((Integer[])retVal)[i++] = TypeConverter.toInt(this.elements[(int)index++].toString(), 4);
                    --count;
                }
                break;
            }
            case -5: {
                retVal = new Long[count];
                while (count > 0) {
                    ((Long[])retVal)[i++] = TypeConverter.toLong(this.elements[(int)index++].toString(), -5);
                    --count;
                }
                break;
            }
            case 2: 
            case 3: {
                retVal = new BigDecimal[count];
                while (count > 0) {
                    ((BigDecimal[])retVal)[i++] = TypeConverter.toBigDecimal(this.elements[(int)index++].toString(), 2);
                    --count;
                }
                break;
            }
            case 7: {
                retVal = new Float[count];
                while (count > 0) {
                    ((Float[])retVal)[i++] = Float.valueOf(TypeConverter.toFloat(this.elements[(int)index++].toString(), 7));
                    --count;
                }
                break;
            }
            case 8: {
                retVal = new Double[count];
                while (count > 0) {
                    ((Double[])retVal)[i++] = TypeConverter.toDouble(this.elements[(int)index++].toString(), 8);
                    --count;
                }
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                retVal = new String[count];
                while (count > 0) {
                    ((String[])retVal)[i++] = this.elements[(int)index++].toString();
                    --count;
                }
                break;
            }
            case 91: {
                retVal = new Date[count];
                while (count > 0) {
                    ((Date[])retVal)[i++] = TypeConverter.toDate(this.elements[(int)index++].toString(), 91);
                    --count;
                }
                break;
            }
            case 92: {
                retVal = new Time[count];
                while (count > 0) {
                    ((Time[])retVal)[i++] = TypeConverter.toTime(this.elements[(int)index++].toString(), 92, this.localCalendar);
                    --count;
                }
                break;
            }
            case 93: {
                retVal = new Timestamp[count];
                while (count > 0) {
                    ((Timestamp[])retVal)[i++] = TypeConverter.toTimestamp(this.elements[(int)index++].toString(), 93, this.localCalendar);
                    --count;
                }
                break;
            }
            default: {
                throw Driver.notImplemented();
            }
        }
        return retVal;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(1L, 0, null);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> paramMap) throws SQLException {
        return this.getResultSet(1L, 0, paramMap);
    }

    @Override
    public ResultSet getResultSet(long paramLong, int paramInt) throws SQLException {
        return this.getResultSet(paramLong, paramInt, null);
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        this.checkFree();
        ResultSet rs = null;
        rs = 2 == this.conn.getProtocolVersion().getProtocolType() ? this.getResultSetV2(this.conn, index, count, map) : this.getResultSetV1(this.conn, index, count, map);
        return rs;
    }

    @Override
    public void free() throws SQLException {
        this.typeName = null;
        this.elements = null;
        this.free = true;
    }
}

