/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis.util;

import com.oscar.gis.binary.BinaryParser;
import com.oscar.gis.util.Geometry;
import com.oscar.gis.util.GeometryCollection;
import com.oscar.gis.util.LineString;
import com.oscar.gis.util.MultiLineString;
import com.oscar.gis.util.MultiPoint;
import com.oscar.gis.util.MultiPolygon;
import com.oscar.gis.util.Point;
import com.oscar.gis.util.Polygon;
import java.sql.SQLException;

public class GeometryBuilder {
    public static final String SRIDPREFIX = "SRID=";

    public static Geometry geomFromString(String value) throws SQLException {
        return GeometryBuilder.geomFromString(value, false);
    }

    public static Geometry geomFromString(String value, boolean haveM) throws SQLException {
        BinaryParser bp = new BinaryParser();
        return GeometryBuilder.geomFromString(value, bp, haveM);
    }

    public static Geometry geomFromString(String value, BinaryParser bp) throws SQLException {
        return GeometryBuilder.geomFromString(value, bp, false);
    }

    public static Geometry geomFromString(String value, BinaryParser bp, boolean haveM) throws SQLException {
        Geometry result;
        value = value.trim();
        int srid = 0;
        if (value.startsWith(SRIDPREFIX)) {
            String[] parts = GeometryBuilder.splitSRID(value);
            value = parts[1].trim();
            srid = Geometry.parseSRID(Integer.parseInt(parts[0].substring(5)));
        }
        if (value.startsWith("00") || value.startsWith("01")) {
            result = bp.parse(value);
        } else if (value.endsWith("EMPTY")) {
            result = new GeometryCollection();
        } else if (value.startsWith("MULTIPOLYGON")) {
            result = new MultiPolygon(value, haveM);
        } else if (value.startsWith("MULTILINESTRING")) {
            result = new MultiLineString(value, haveM);
        } else if (value.startsWith("MULTIPOINT")) {
            result = new MultiPoint(value, haveM);
        } else if (value.startsWith("POLYGON")) {
            result = new Polygon(value, haveM);
        } else if (value.startsWith("LINESTRING")) {
            result = new LineString(value, haveM);
        } else if (value.startsWith("POINT")) {
            result = new Point(value, haveM);
        } else if (value.startsWith("GEOMETRYCOLLECTION")) {
            result = new GeometryCollection(value, haveM);
        } else {
            throw new SQLException("Unknown type: " + value);
        }
        if (srid != 0) {
            result.setSrid(srid);
        }
        return result;
    }

    public static String[] splitSRID(String whole) throws SQLException {
        int index = whole.indexOf(59, 5);
        if (index == -1) {
            throw new SQLException("Error parsing Geometry - SRID not delimited with ';' ");
        }
        return new String[]{whole.substring(0, index), whole.substring(index + 1)};
    }
}

