/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis;

import com.oscar.gis.OscarObject;
import com.oscar.gis.OscarPoint;
import com.oscar.util.OscarTokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class OscarLseg
extends OscarObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7701782820391772306L;
    private OscarPoint[] point = new OscarPoint[2];

    public OscarLseg(double x1, double y1, double x2, double y2) {
        this(new OscarPoint(x1, y1), new OscarPoint(x2, y2));
    }

    public OscarLseg(OscarPoint p1, OscarPoint p2) {
        this();
        this.point[0] = p1;
        this.point[1] = p2;
    }

    public OscarLseg(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public OscarLseg() {
        this.setType("lseg");
    }

    @Override
    public void setValue(String s) throws SQLException {
        OscarTokenizer t = new OscarTokenizer(OscarTokenizer.removeBox(s), ',');
        if (t.getSize() != 2) {
            throw new SQLException("Conversion to type " + this.type + " failed: " + s);
        }
        this.point[0] = new OscarPoint(t.getToken(0));
        this.point[1] = new OscarPoint(t.getToken(1));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OscarLseg) {
            OscarLseg p = (OscarLseg)obj;
            return p.point[0].equals(this.point[0]) && p.point[1].equals(this.point[1]) || p.point[0].equals(this.point[1]) && p.point[1].equals(this.point[0]);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.point[0].hashCode() ^ this.point[1].hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        OscarLseg newOscarLseg = (OscarLseg)super.clone();
        if (newOscarLseg.point != null) {
            newOscarLseg.point = (OscarPoint[])newOscarLseg.point.clone();
            for (int i = 0; i < newOscarLseg.point.length; ++i) {
                if (newOscarLseg.point[i] == null) continue;
                newOscarLseg.point[i] = (OscarPoint)newOscarLseg.point[i].clone();
            }
        }
        return newOscarLseg;
    }

    @Override
    public String getValue() {
        return "[" + this.point[0] + "," + this.point[1] + "]";
    }

    public OscarPoint[] getPoint() {
        return this.point;
    }
}

