/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.dispatcher.executor;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.dispatcher.entity.DispatchConnection;
import com.oscar.dispatcher.executor.AbstractExecuteCommand;
import com.oscar.dispatcher.executor.DispatchAbstractStatement;
import com.oscar.dispatcher.executor.DispatchStatementV2;
import com.oscar.dispatcher.executor.command.PrepareStCommand;
import com.oscar.dispatcher.executor.command.PrepareStIncreaseCommand;
import com.oscar.dispatcher.executor.command.PrepareStIndexCommand;
import com.oscar.dispatcher.executor.command.PrepareStNamesCommand;
import com.oscar.jdbc.OscarStatement;
import com.oscar.util.OSQLException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;

public class DispatchPreparedStatementV2
extends DispatchStatementV2
implements PreparedStatement {
    public DispatchPreparedStatementV2(DispatchConnection conn) {
        super(conn);
    }

    public DispatchPreparedStatementV2(DispatchConnection conn, String sql) {
        super(conn);
        this.dispatchType = this.getExecuteType(sql);
        this.createCommand = new PrepareStCommand(sql);
    }

    public DispatchPreparedStatementV2(DispatchConnection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(conn);
        this.dispatchType = this.getExecuteType(sql);
        this.createCommand = new PrepareStCommand(sql, resultSetType, resultSetHoldability);
    }

    public DispatchPreparedStatementV2(DispatchConnection conn, String sql, int resultSetType, int resultSetConcurrency) {
        super(conn);
        this.dispatchType = this.getExecuteType(sql);
        this.createCommand = new PrepareStCommand(sql, resultSetType, resultSetConcurrency);
    }

    public DispatchPreparedStatementV2(DispatchConnection conn, String sql, int autoGeneratedKeys) {
        super(conn);
        this.dispatchType = this.getExecuteType(sql);
        this.createCommand = new PrepareStIncreaseCommand(sql, autoGeneratedKeys);
    }

    public DispatchPreparedStatementV2(DispatchConnection conn, String sql, String[] columnNames) {
        super(conn);
        this.dispatchType = this.getExecuteType(sql);
        this.createCommand = new PrepareStNamesCommand(sql, columnNames);
    }

    public DispatchPreparedStatementV2(DispatchConnection conn, String sql, int[] columnIndexes) {
        super(conn);
        this.dispatchType = this.getExecuteType(sql);
        this.createCommand = new PrepareStIndexCommand(sql, columnIndexes);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        DispatchAbstractStatement.RealExecuteCommand<ResultSet> ec = new DispatchAbstractStatement.RealExecuteCommand<ResultSet>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.executeQuery()";
            }

            @Override
            public ResultSet execute(Statement t) throws SQLException {
                BaseResultSet brs;
                BaseConnection conn = (BaseConnection)((Object)t.getConnection());
                ResultSet rs = ((PreparedStatement)t).executeQuery();
                if (conn.isSlave() && DispatchPreparedStatementV2.this.dispatchConnection.isZeroResend() && (brs = (BaseResultSet)rs).getTupleCount() == 0) {
                    rs.close();
                    throw new OSQLException(888888, "0A502", "resultSet size is 0 ,try to switch to main");
                }
                return rs;
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public int executeUpdate() throws SQLException {
        DispatchAbstractStatement.RealExecuteCommand<Integer> ec = new DispatchAbstractStatement.RealExecuteCommand<Integer>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.executeUpdate()";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                return ((PreparedStatement)t).executeUpdate();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setNull(final int parameterIndex, final int sqlType) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setNull(" + parameterIndex + "," + sqlType + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setNull(parameterIndex, sqlType);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBoolean(final int parameterIndex, final boolean x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBoolean(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setBoolean(parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setByte(final int parameterIndex, final byte x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setByte(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setByte(parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setShort(final int parameterIndex, final short x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setShort(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setShort(parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setInt(final int parameterIndex, final int x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setInt(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setInt(parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setLong(final int parameterIndex, final long x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setLong(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setLong(parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setFloat(final int parameterIndex, final float x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setFloat(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setFloat(parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setDouble(final int parameterIndex, final double x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setDouble(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setDouble(parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBigDecimal(final int parameterIndex, final BigDecimal x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBigDecimal(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setBigDecimal(parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setString(final int parameterIndex, final String x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setString(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setString(parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBytes(final int parameterIndex, final byte[] x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBytes(" + parameterIndex + "," + Arrays.toString(x) + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setBytes(parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setDate(final int parameterIndex, final Date x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setDate(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setDate(parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setTime(final int parameterIndex, final Time x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setTime(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setTime(parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setTimestamp(final int parameterIndex, final Timestamp x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setTimestamp(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setTimestamp(parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setAsciiStream(final int parameterIndex, final InputStream x, final int length) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setAsciiStream(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setAsciiStream(parameterIndex, x, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setUnicodeStream(final int parameterIndex, final InputStream x, final int length) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setUnicodeStream(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setUnicodeStream(parameterIndex, x, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBinaryStream(final int parameterIndex, final InputStream x, final int length) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBinaryStream(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setBinaryStream(parameterIndex, x, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void clearParameters() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.clearParameters()";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).clearParameters();
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setObject(final int parameterIndex, final Object x, final int targetSqlType, final int scale) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setObject(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setObject(parameterIndex, x, targetSqlType, scale);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setObject(final int parameterIndex, final Object x, final int targetSqlType) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setObject(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setObject(parameterIndex, x, targetSqlType);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setObject(final int parameterIndex, final Object x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setObject(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setObject(parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public boolean execute() throws SQLException {
        DispatchAbstractStatement.RealExecuteCommand<Boolean> ec = new DispatchAbstractStatement.RealExecuteCommand<Boolean>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.execute()";
            }

            @Override
            public Boolean execute(Statement t) throws SQLException {
                BaseResultSet brs;
                BaseConnection conn = (BaseConnection)((Object)t.getConnection());
                Boolean result = ((PreparedStatement)t).execute();
                if (conn.isSlave() && DispatchPreparedStatementV2.this.dispatchConnection.isZeroResend() && result.booleanValue() && (brs = (BaseResultSet)t.getResultSet()).getTupleCount() == 0) {
                    Driver.writeLog(">>>>DispatchPreparedStatementV2.execute() " + ((OscarStatement)t).getSql());
                    brs.close();
                    throw new OSQLException(888888, "0A502", "resultSet size is 0 ,try to switch to main");
                }
                return result;
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void addBatch() throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.addBatch()";
            }

            @Override
            public Object execute(Statement t) throws SQLException {
                ((PreparedStatement)t).addBatch();
                return null;
            }
        };
        this.executeTemplet(ec, 0);
        this.add();
    }

    @Override
    public void setCharacterStream(final int parameterIndex, final Reader reader, final int length) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setCharacterStream(" + parameterIndex + "," + reader + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setCharacterStream(parameterIndex, reader, length);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setRef(final int i, final Ref x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setRef(" + i + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setRef(i, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setBlob(final int i, final Blob x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setBlob(" + i + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setBlob(i, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setClob(final int i, final Clob x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setClob(" + i + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setClob(i, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setArray(final int i, final Array x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setArray(" + i + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setArray(i, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        AbstractExecuteCommand<ResultSetMetaData> ec = new AbstractExecuteCommand<ResultSetMetaData>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.getMetaData()";
            }

            @Override
            public ResultSetMetaData execute(Statement t) throws SQLException {
                return ((PreparedStatement)t).getMetaData();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setDate(final int parameterIndex, final Date x, final Calendar cal) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setArray(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setDate(parameterIndex, x, cal);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setTime(final int parameterIndex, final Time x, final Calendar cal) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setTime(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setTime(parameterIndex, x, cal);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setTimestamp(final int parameterIndex, final Timestamp x, final Calendar cal) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setTimestamp(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setTimestamp(parameterIndex, x, cal);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setNull(final int paramIndex, final int sqlType, final String typeName) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setNull(" + paramIndex + "," + sqlType + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setNull(paramIndex, sqlType, typeName);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public void setURL(final int parameterIndex, final URL x) throws SQLException {
        AbstractExecuteCommand<Object> ec = new AbstractExecuteCommand<Object>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.setURL(" + parameterIndex + "," + x + ")";
            }

            @Override
            public Integer execute(Statement t) throws SQLException {
                ((PreparedStatement)t).setURL(parameterIndex, x);
                return null;
            }
        };
        this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        AbstractExecuteCommand<ParameterMetaData> ec = new AbstractExecuteCommand<ParameterMetaData>(){

            @Override
            public String getFunctionName() {
                return "DispatchPreparedStatementV2.getParameterMetaData()";
            }

            @Override
            public ParameterMetaData execute(Statement t) throws SQLException {
                return ((PreparedStatement)t).getParameterMetaData();
            }
        };
        return this.executeTemplet(ec, this.getExecuteType());
    }

    @Override
    protected void bind(Statement source, Statement target) throws Exception {
        Class<OscarStatement> clz = OscarStatement.class;
        Field field_m_binds = clz.getDeclaredField("m_binds");
        field_m_binds.setAccessible(true);
        Object[] m_binds = (Object[])field_m_binds.get(source);
        Field field_m_binds_old = clz.getDeclaredField("m_binds_old");
        field_m_binds_old.setAccessible(true);
        Object[] m_binds_old = (Object[])field_m_binds_old.get(source);
        Field field_m_bindTypes = clz.getDeclaredField("m_bindTypes");
        field_m_bindTypes.setAccessible(true);
        int[] m_bindTypes = (int[])field_m_bindTypes.get(source);
        Class<OscarStatement> clzMaster = OscarStatement.class;
        Field field_m_binds_master = clzMaster.getDeclaredField("m_binds");
        field_m_binds_master.setAccessible(true);
        System.arraycopy(m_binds, 0, (Object[])field_m_binds_master.get(target), 0, m_binds.length);
        Field field_m_binds_old_master = clzMaster.getDeclaredField("m_binds_old");
        field_m_binds_old_master.setAccessible(true);
        System.arraycopy(m_binds_old, 0, (Object[])field_m_binds_old_master.get(target), 0, m_binds_old.length);
        Field field_m_bindTypes_master = clzMaster.getDeclaredField("m_bindTypes");
        field_m_bindTypes_master.setAccessible(true);
        System.arraycopy(m_bindTypes, 0, (int[])field_m_bindTypes_master.get(target), 0, m_bindTypes.length);
        ((OscarStatement)source).cacheState = (short)4;
    }

    @Override
    protected boolean handleException(SQLException e, Statement slave, Statement master) throws SQLException {
        if (this.getErrorCode(e)) {
            if (slave != null) {
                try {
                    this.bind(slave, master == null ? this.getMainStatement() : master);
                }
                catch (Exception ex) {
                    throw new SQLException(ex.toString());
                }
            } else if (this.logFlag) {
                Driver.writeLog("slave is null,check the parameters:compatibleOldProtocol.");
            }
            return true;
        }
        return false;
    }
}

