/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.cluster;

import com.oscar.cluster.Cluster;
import com.oscar.cluster.INodeImportStream;
import com.oscar.cluster.Node;
import com.oscar.cluster.NodeImportStream;
import com.oscar.cluster.NodeImportStreamOverflow;
import com.oscar.cluster.RobinImportStrategy;
import com.oscar.cluster.core.ImportStrategy;
import com.oscar.core.BaseConnection;
import com.oscar.core.DistributeImportHandler;
import com.oscar.jdbc.OscarImportHandler;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ClusterImportHandler
extends OscarImportHandler
implements DistributeImportHandler {
    private Cluster cluster;
    private Cluster.ImportCredential importCredential;
    private List<Node> importNodes;
    private int importNodeConnectRetryTime;
    int nodenum = 0;
    protected volatile AtomicInteger rowCount = new AtomicInteger(0);
    private boolean hasBulk = false;
    private ImportStrategy strategy;
    private int executeBufferSize = 0x40000000;
    private boolean allowBufferOverflow = false;

    public ClusterImportHandler(BaseConnection conn, String schemName, String tableName) throws SQLException {
        super(conn, schemName, tableName);
        this.importNodeConnectRetryTime = conn.getClusterImportNodeRetryTime();
        if (conn.getCluster() == null) {
            conn.setCluster(new Cluster(conn));
        }
        this.cluster = conn.getCluster();
        this.importCredential = this.cluster.getClusterImportCredential();
        this.strategy = new RobinImportStrategy();
        try {
            String sizeString = conn.getConnectionProperties().getProperty("EXECUTEBUFFERSIZE");
            if (sizeString != null && sizeString.trim().length() > 0) {
                int size = Integer.parseInt(sizeString);
                this.setExecuteBufferSize(size);
            }
        }
        catch (NumberFormatException sizeString) {
            // empty catch block
        }
        try {
            String overflowString = conn.getConnectionProperties().getProperty("ENABLEBUFFEROVERFLOW");
            if (overflowString != null && overflowString.trim().length() > 0) {
                this.allowBufferOverflow = Boolean.parseBoolean(overflowString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public ClusterImportHandler(BaseConnection conn, String tableName) throws SQLException {
        this(conn, null, tableName);
    }

    public void reInit() throws SQLException {
        this.cluster.reInit();
        this.importCredential = this.cluster.getImportCredential();
        this.nodenum = 0;
    }

    @Override
    public void begin() throws SQLException {
        this.rowCount.set(0);
        this.isBegin = true;
        if (this.importStream == null) {
            this.importStream = this.allowBufferOverflow ? new NodeImportStreamOverflow(this, this.strategy) : new NodeImportStream(this, this.strategy);
        } else {
            ((INodeImportStream)((Object)this.importStream)).reStrategy(this.strategy);
            this.importStream.reInit();
        }
    }

    @Override
    public void endRow() throws SQLException {
        try {
            super.endRow();
            this.rowCount.incrementAndGet();
        }
        catch (SQLException e) {
            this.closeImportNodes();
            if (this.importStream != null && this.importStream.getThreadException() != null) {
                try {
                    this.cluster.importEnd();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw e;
        }
        if (this.importStream.needExecute()) {
            this.doExecute();
        }
    }

    public void closeImportNodes() {
        if (this.importNodes != null) {
            for (Node node : this.importNodes) {
                node.disConnect();
            }
            this.importNodes.clear();
            this.importNodes = null;
        }
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.hasRowNotSubmitted()) {
            this.endRow();
        }
        this.doExecute();
        return true;
    }

    private void doExecute() throws SQLException {
        if (this.isBegin()) {
            try {
                boolean canComplete = true;
                try {
                    super.endExecute();
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 1001) {
                        canComplete = false;
                    }
                    throw e;
                }
                if (canComplete) {
                    for (Node node : this.importNodes) {
                        node.importEnd();
                    }
                }
                int updateCount = this.cluster.importEnd();
                this.setCurrentUpdateCount(updateCount);
                this.hasBulk = false;
                long currentUpdateCount = this.getUpdateCount();
                if (currentUpdateCount > 0L) {
                    this.setUpdateCount((long)updateCount + currentUpdateCount);
                } else {
                    this.setUpdateCount(updateCount);
                }
            }
            catch (SQLException e) {
                this.closeImportNodes();
                this.importCredential = null;
                this.cluster.setClusterImportCredential(null);
                this.hasBulk = false;
                throw e;
            }
        }
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.importNodes != null) {
            this.importNodes.clear();
        }
        this.importNodes = null;
        this.importCredential = null;
    }

    @Override
    public void setNodeNum(int num) throws SQLException {
        if (num > this.cluster.getNodeMap().size()) {
            throw new SQLException("\u8282\u70b9\u6570\u91cf\u8fc7\u5927, \u5f53\u524d\u8282\u70b9\u6570" + this.cluster.getNodeMap().size());
        }
        this.nodenum = num;
    }

    protected void initImportNodes() throws SQLException {
        this.importNodes = this.cluster.getImportNodes(this.schemName, this.tableName, this.nodenum);
        boolean initNodeSuccessful = false;
        int retryTime = 0;
        do {
            try {
                if (this.importCredential == null) {
                    this.importCredential = this.cluster.getClusterImportCredential();
                }
                for (Node node : this.importNodes) {
                    node.connect(this.importCredential);
                }
                initNodeSuccessful = true;
            }
            catch (Exception e) {
                this.closeImportNodes();
                initNodeSuccessful = false;
                if (retryTime >= this.importNodeConnectRetryTime) continue;
                this.reInit();
            }
        } while (!initNodeSuccessful && retryTime++ < this.importNodeConnectRetryTime);
        if (!initNodeSuccessful) {
            throw new SQLException("\u8282\u70b9\u8fde\u63a5\u521b\u5efa\u5931\u8d25\uff0c\u5c1d\u8bd5\u6b21\u6570" + (this.importNodeConnectRetryTime + 1));
        }
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public boolean isHasBulk() {
        return this.hasBulk;
    }

    public void setHasBulk(boolean hasBulk) {
        this.hasBulk = hasBulk;
    }

    public List<Node> getImportNodes() {
        return this.importNodes;
    }

    public int getExecuteBufferSize() {
        return this.executeBufferSize;
    }

    @Override
    public void setExecuteBufferSize(int size) {
        if (size <= 0) {
            this.executeBufferSize = 0;
            return;
        }
        this.executeBufferSize = size * 1024 * 1024;
    }
}

