/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.ae;

import com.oscar.Driver;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionCommon {
    protected static final boolean logFlag = Driver.getLogLevel() >= 2;
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final int HMAC_COUNT = 10000;

    public static KeyPair generateKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(3072);
        KeyPair pair = keyGen.generateKeyPair();
        PublicKey publicKey = pair.getPublic();
        PrivateKey privateKey = pair.getPrivate();
        if (logFlag) {
            Driver.writeLog("\u516c\u94a5: " + publicKey.toString());
            Driver.writeLog("\u79c1\u94a5: " + privateKey);
        }
        return pair;
    }

    public static byte[] encryptWithPrivateKey(byte[] privateKeyBytes, byte[] originalBytes) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException {
        PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(privateKeyBytes));
        Cipher encryptCipher = Cipher.getInstance("RSA");
        encryptCipher.init(1, privateKey);
        byte[] encryptedBytes = encryptCipher.doFinal(originalBytes);
        return encryptedBytes;
    }

    public static byte[] decryptWithPublicKey(byte[] publicKeyBytes, byte[] encryptedBytes, String columnEncryptKeyMode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException {
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicKeyBytes));
        Cipher encryptCipher = Cipher.getInstance("RSA");
        encryptCipher.init(2, publicKey);
        byte[] originalBytes = encryptCipher.doFinal(encryptedBytes);
        return originalBytes;
    }

    public static byte[] encryptKey_AES256_CBC_HMAC_SHA256(byte[] plainBytes, String password, byte[] vectorKeyBytes) throws Exception {
        return EncryptionCommon.encryptKey_AES_CBC_HMAC_SHA256(plainBytes, password, vectorKeyBytes, 256);
    }

    public static byte[] encryptKey_AES128_CBC_HMAC_SHA256(byte[] plainBytes, String password, byte[] vectorKeyBytes) throws Exception {
        return EncryptionCommon.encryptKey_AES_CBC_HMAC_SHA256(plainBytes, password, vectorKeyBytes, 128);
    }

    public static byte[] encryptKey_AES_CBC_HMAC_SHA256(byte[] plainBytes, String password, byte[] vectorKeyBytes, int aseKeyLength) throws Exception {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), vectorKeyBytes, 10000, aseKeyLength);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec secretKey = new SecretKeySpec(tmp.getEncoded(), "AES");
        IvParameterSpec iv = new IvParameterSpec(vectorKeyBytes);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)secretKey, iv);
        byte[] encrypted = cipher.doFinal(plainBytes);
        return encrypted;
    }

    public static byte[] decryptKey_AES256_CBC_HMAC_SHA256(byte[] encryptedValue, String password, byte[] vectorKeyBytes) throws Exception {
        return EncryptionCommon.decryptKey_AES_CBC_HMAC_SHA256(encryptedValue, password, vectorKeyBytes, 256);
    }

    public static byte[] decryptKey_AES128_CBC_HMAC_SHA256(byte[] encryptedValue, String password, byte[] vectorKeyBytes) throws Exception {
        return EncryptionCommon.decryptKey_AES_CBC_HMAC_SHA256(encryptedValue, password, vectorKeyBytes, 128);
    }

    public static byte[] decryptKey_AES_CBC_HMAC_SHA256(byte[] encryptedValue, String password, byte[] vectorKeyBytes, int aesKeyLength) throws Exception {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), vectorKeyBytes, 10000, aesKeyLength);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec secretKey = new SecretKeySpec(tmp.getEncoded(), "AES");
        IvParameterSpec iv = new IvParameterSpec(vectorKeyBytes);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)secretKey, iv);
        byte[] plain = cipher.doFinal(encryptedValue);
        return plain;
    }

    public static byte[] decryptKey(byte[] encryptedValue, byte[] secretBytes, byte[] vectorKeyBytes) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecretKeySpec secretKey = new SecretKeySpec(secretBytes, "AES");
        IvParameterSpec iv = new IvParameterSpec(vectorKeyBytes);
        cipher.init(2, (Key)secretKey, iv);
        byte[] plain = cipher.doFinal(encryptedValue);
        return plain;
    }

    public static enum ColumnEncryptionAlgorithm {
        INVALID_ALGORITHM,
        AEAD_AES_256_CBC_HMAC_SHA256,
        AEAD_AES_128_CBC_HMAC_SHA256,
        SM4_SM3;

    }

    public static enum EncryptionType {
        DETERMINISTIC,
        NONE,
        RANDOMIZED;

    }

    public static enum CmkAlgorithm {
        INVALID_ALGORITHM,
        RSA_2048,
        AES_256_CBC,
        SM2,
        SM4,
        AES_256_GCM;

    }

    public static enum CmkKeyStore {
        INVALID_KEYSTORE,
        LOCALKMS;

    }
}

