/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.ae;

import com.oscar.Driver;
import com.oscar.ae.CmkManager;
import com.oscar.ae.ColumnEncryptionKey;
import com.oscar.ae.ColumnMasterKey;
import com.oscar.ae.EncryptionCommon;
import com.oscar.ae.OscarCekLocalKmsProvider;
import com.oscar.util.Hex;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;

public class CekManager {
    protected boolean logFlag = Driver.getLogLevel() >= 2;
    private final List<ColumnEncryptionKey> CEK_LIST = new CopyOnWriteArrayList<ColumnEncryptionKey>();
    private OscarCekLocalKmsProvider provider = new OscarCekLocalKmsProvider();

    private CekManager() {
    }

    public static CekManager singleton() {
        return SingletonHandler.INSTANCE;
    }

    public ColumnEncryptionKey getCek(String columnEncryptKeyValue, String columnMasterKeyPath, String columnEncryptKeyMode) throws Exception {
        ColumnMasterKey publicCmk;
        ColumnEncryptionKey columnEncryptionKey = null;
        int index = Collections.binarySearch(this.CEK_LIST, columnEncryptKeyValue);
        if (index >= 0) {
            columnEncryptionKey = this.CEK_LIST.get(index);
            if (columnEncryptionKey.getKeyValueRaw() != null) {
                return columnEncryptionKey;
            }
        } else {
            columnEncryptionKey = new ColumnEncryptionKey();
            columnEncryptionKey.setEncryptedValue(columnEncryptKeyValue);
            columnEncryptionKey.setAlgorithmName(columnEncryptKeyMode);
        }
        if ((publicCmk = CmkManager.singleton().getCmkOrFind(columnMasterKeyPath, false)) == null) {
            throw new SQLException("\u627e\u4e0d\u5230cmk:" + columnMasterKeyPath);
        }
        if (columnEncryptionKey.getCmk() != null) {
            publicCmk.setKeystoreName(columnEncryptionKey.getCmk().getKeystoreName());
        }
        String plaintext = this.decryptCek(columnEncryptKeyValue, publicCmk, columnEncryptKeyMode);
        columnEncryptionKey.setCmk(publicCmk);
        columnEncryptionKey.setKeyValueRaw(plaintext);
        this.cache(columnEncryptionKey);
        return columnEncryptionKey;
    }

    public synchronized void cache(ColumnEncryptionKey cek) {
        int index = Collections.binarySearch(this.CEK_LIST, cek);
        if (index < 0) {
            this.CEK_LIST.add(-index - 1, cek);
        }
    }

    public ColumnEncryptionKey generateNew(Connection conn, String cekeyName, ColumnMasterKey cmk) throws Exception {
        String cekRaw = this.createCekRaw();
        byte[] encryptedValueBytes = this.provider.encryptColumnEncryptionKey(cmk.getPath(), EncryptionCommon.ColumnEncryptionAlgorithm.AEAD_AES_128_CBC_HMAC_SHA256.name(), cekRaw.getBytes());
        String encryptedValue = new String(encryptedValueBytes, EncryptionCommon.ISO_8859_1);
        try {
            this.saveTo(conn, cmk.getKeyName(), cekeyName, EncryptionCommon.ColumnEncryptionAlgorithm.AEAD_AES_128_CBC_HMAC_SHA256.name(), encryptedValue);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        ColumnEncryptionKey cek = new ColumnEncryptionKey(cekeyName);
        cek.setCmk(cmk);
        cek.setKeyValueRaw(cekRaw);
        cek.setAlgorithmName(EncryptionCommon.ColumnEncryptionAlgorithm.AEAD_AES_128_CBC_HMAC_SHA256.name());
        cek.setEncryptedValue(encryptedValue);
        return cek;
    }

    public String decryptCek(String cekValueRaw, ColumnMasterKey cmk, String encryptionAlgorithm) throws Exception {
        byte[] raw16After = Hex.hexStringToByte(cekValueRaw);
        byte[] afterValue = this.provider.decryptColumnEncryptionKey(cmk.getPath(), encryptionAlgorithm, raw16After);
        if (this.logFlag) {
            Driver.writeLog("cmk\u660e\u6587 \u516c\u94a5:" + Arrays.toString(cmk.getPublicKeyInfo().getKeyValueRawBytes()));
            Driver.writeLog("cek\u5341\u516d\u8fdb\u5236\uff1a" + cekValueRaw);
            Driver.writeLog("cek\u5bc6\u6587\uff1a" + new String(raw16After));
            Driver.writeLog("cek\u660e\u6587:" + new String(afterValue, EncryptionCommon.ISO_8859_1));
        }
        return new String(afterValue, EncryptionCommon.ISO_8859_1);
    }

    private String createCekRaw() {
        return UUID.randomUUID().toString().replace("-", "").substring(0, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(Connection conn, String cmkeyName, String cekeyName, String algorithmName, String encryptedValue) throws SQLException {
        String sqlString = "CREATE COLUMN ENCRYPTION KEY %key_name%   \r\nWITH VALUES  \r\n  (  \r\n    COLUMN_MASTER_KEY = '%COLUMN_MASTER_KEY%',   \r\n    ALGORITHM = '%ALGORITHM%',     \r\n    ENCRYPTED_VALUE = '%ENCRYPTED_VALUE%'  \r\n  )";
        sqlString = sqlString.replaceFirst("%key_name%", cekeyName);
        sqlString = sqlString.replaceFirst("%COLUMN_MASTER_KEY%", cmkeyName);
        sqlString = sqlString.replaceFirst("%ALGORITHM%", algorithmName);
        sqlString = sqlString.replaceFirst("%ENCRYPTED_VALUE%", encryptedValue);
        try (Statement stmt = null;){
            stmt = conn.createStatement();
            stmt.execute(sqlString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectCekOid(Connection conn, ColumnEncryptionKey cek) throws SQLException {
        block9: {
            String sql = "select cek.CEKOID from v_sys_attribute_encrypted_key_values m,v_sys_attribute_master_keys cmk,v_sys_attribute_encrypted_keys cek where cmk.cmkoid=m.cmkoid and m.cekoid=cek.cekoid and cek.cekname=? and cmk.CMKNAME=?";
            try (PreparedStatement stmt = null;){
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, cek.getKeyName());
                stmt.setString(2, cek.getCmk().getKeyName());
                try (ResultSet rSet = null;){
                    rSet = stmt.executeQuery();
                    if (rSet.next()) {
                        long oid = rSet.getLong(1);
                        cek.setOid(oid);
                        break block9;
                    }
                    throw new SQLException("\u6ca1\u6709\u67e5\u8be2\u5230cek oid, cekname:" + cek.getKeyName() + ", cmkname:" + cek.getCmk().getKeyName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropCek(Connection conn, String cekeyName) throws SQLException {
        String sqlString = "DROP COLUMN ENCRYPTION KEY " + cekeyName;
        try (Statement stmt = null;){
            stmt = conn.createStatement();
            stmt.execute(sqlString);
        }
    }

    private static class SingletonHandler {
        private static final CekManager INSTANCE = new CekManager();

        private SingletonHandler() {
        }
    }
}

