/*
 * Decompiled with CFR 0.152.
 */
package com.oscar;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class DriverInfo {
    private static String versionInfo = null;

    public static void main(String[] args) {
        HashMap<String, String> manifestMap = DriverInfo.getManifestMap(DriverInfo.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        System.out.println("oscarjdbc: " + manifestMap.get("Bundle-Version") + " compiled with " + manifestMap.get("Build_Compiler_Version"));
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> getManifestMap(String jarPath) {
        HashMap<String, String> manifestMap = new HashMap<String, String>();
        if (!jarPath.endsWith(".jar")) {
            return manifestMap;
        }
        JarFile jarFile = null;
        InputStream file = null;
        try {
            jarPath = URLDecoder.decode(jarPath, "UTF-8");
            jarFile = new JarFile(jarPath);
            file = DriverInfo.loadResourceFromJarURL(jarFile, "META-INF/MANIFEST.MF");
            if (file != null) {
                Manifest manifest = new Manifest(file);
                Attributes attr = manifest.getMainAttributes();
                for (Map.Entry<Object, Object> entry : attr.entrySet()) {
                    manifestMap.put(entry.getKey().toString(), entry.getValue().toString());
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException e) {}
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {}
            }
        }
        return manifestMap;
    }

    public static InputStream loadResourceFromJarURL(JarFile jarFile, String resPath) {
        try {
            JarEntry jarEntry = jarFile.getJarEntry(resPath);
            if (jarEntry == null) {
                return null;
            }
            return jarFile.getInputStream(jarEntry);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getVersion() {
        if (versionInfo != null) return versionInfo;
        Class<DriverInfo> clazz = DriverInfo.class;
        synchronized (DriverInfo.class) {
            if (versionInfo != null) return versionInfo;
            try {
                HashMap<String, String> manifestMap = DriverInfo.getManifestMap(DriverInfo.class.getProtectionDomain().getCodeSource().getLocation().getPath());
                versionInfo = manifestMap.get("Bundle-Version") != null ? "oscarjdbc: " + manifestMap.get("Bundle-Version") + " compiled with " + manifestMap.get("Build_Compiler_Version") : "";
            }
            catch (Exception e) {
                versionInfo = "";
            }
            return versionInfo;
        }
    }
}

