/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util.converter;

public class ByteConverter {
    public static byte[] convertByteArr(byte[] src) {
        if (src != null && src.length > 240) {
            byte[] s = ByteConverter.convertVarcharData(src);
            return s;
        }
        return src;
    }

    public static byte[] convertVarcharData(byte[] data) {
        int len = data.length + 1 + (data.length + 240 - 1) / 240 + 1;
        byte[] result = new byte[len];
        result[0] = -2;
        int srcPosition = 0;
        int destPosition = 1;
        int tmp = data.length - srcPosition;
        while (true) {
            if (tmp == 240) {
                result[destPosition] = -16;
                System.arraycopy(data, srcPosition, result, ++destPosition, 240);
                srcPosition += 240;
                destPosition += 240;
                break;
            }
            if (tmp > 240) {
                result[destPosition] = -16;
                System.arraycopy(data, srcPosition, result, ++destPosition, 240);
                destPosition += 240;
            } else {
                result[destPosition] = (byte)tmp;
                System.arraycopy(data, srcPosition, result, ++destPosition, tmp);
                srcPosition += tmp;
                destPosition += tmp;
                break;
            }
            tmp = data.length - (srcPosition += 240);
        }
        result[len - 1] = 0;
        return result;
    }

    public static long int8(byte[] bytes, int idx) {
        return ((long)(bytes[idx + 0] & 0xFF) << 56) + ((long)(bytes[idx + 1] & 0xFF) << 48) + ((long)(bytes[idx + 2] & 0xFF) << 40) + ((long)(bytes[idx + 3] & 0xFF) << 32) + ((long)(bytes[idx + 4] & 0xFF) << 24) + ((long)(bytes[idx + 5] & 0xFF) << 16) + ((long)(bytes[idx + 6] & 0xFF) << 8) + (long)(bytes[idx + 7] & 0xFF);
    }

    public static void int8(byte[] target, int idx, long value) {
        target[idx + 0] = (byte)(value >>> 56);
        target[idx + 1] = (byte)(value >>> 48);
        target[idx + 2] = (byte)(value >>> 40);
        target[idx + 3] = (byte)(value >>> 32);
        target[idx + 4] = (byte)(value >>> 24);
        target[idx + 5] = (byte)(value >>> 16);
        target[idx + 6] = (byte)(value >>> 8);
        target[idx + 7] = (byte)value;
    }

    public static double float8(byte[] bytes, int idx) {
        return Double.longBitsToDouble(ByteConverter.int8(bytes, idx));
    }

    public static void float8(byte[] target, int idx, double value) {
        ByteConverter.int8(target, idx, Double.doubleToRawLongBits(value));
    }
}

