/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.Field;
import com.oscar.jdbc.OscarArray;
import com.oscar.util.OSQLException;
import com.oscar.util.TypeConverter;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;

public class ResultArray
extends OscarArray {
    private BaseConnection conn = null;
    private Field field = null;
    protected OscarArrayList arrayList;
    private Calendar localCalendar;

    public ResultArray(BaseConnection conn, int idx, Field field, BaseResultSet rs) throws SQLException {
        this.conn = conn;
        this.field = field;
        this.rawString = rs.getString(idx);
        this.localCalendar = conn.getCalendar();
    }

    @Override
    public Object getArray() throws SQLException {
        return this.getArray(1L, 0, null);
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        return this.getArray(index, count, null);
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.conn.getSQLType(this.getBaseTypeName());
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        String fType = this.field.getDBType();
        if (fType.charAt(0) == '_') {
            fType = fType.substring(1);
        }
        return fType;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(1L, 0, null);
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        return this.getResultSet(index, count, null);
    }

    @Override
    public void free() throws SQLException {
        this.field = null;
        this.rawString = null;
        this.free = true;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        return this.getArray(1L, 0, map);
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        this.checkFree();
        if (map != null) {
            throw Driver.notImplemented();
        }
        if (index < 1L) {
            throw new OSQLException("OSCAR-00304", "88888", 304);
        }
        this.buildArrayList();
        if (count == 0) {
            count = this.arrayList.size();
        }
        if (--index + (long)count > (long)this.arrayList.size()) {
            throw new OSQLException("OSCAR-00304", "888880", 304);
        }
        return this.buildArray(this.arrayList, (int)index, count);
    }

    private synchronized void buildArrayList() throws SQLException {
        if (this.arrayList != null) {
            return;
        }
        this.arrayList = new OscarArrayList();
        char delim = '}';
        if (this.rawString != null) {
            char[] chars = this.rawString.toCharArray();
            StringBuilder buffer = null;
            boolean insideString = false;
            boolean wasInsideString = false;
            ArrayList<OscarArrayList> dims = new ArrayList<OscarArrayList>();
            OscarArrayList curArray = this.arrayList;
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == '\\') {
                    ++i;
                } else {
                    if (!insideString && chars[i] == '{') {
                        if (dims.isEmpty()) {
                            dims.add(this.arrayList);
                        } else {
                            OscarArrayList arrayList = new OscarArrayList();
                            OscarArrayList preArrayList = (OscarArrayList)dims.get(dims.size() - 1);
                            preArrayList.add(arrayList);
                            dims.add(arrayList);
                        }
                        curArray = (OscarArrayList)dims.get(dims.size() - 1);
                        for (int t = i + 1; t < chars.length; ++t) {
                            if (Character.isWhitespace(chars[t])) continue;
                            if (chars[t] != '{') break;
                            ++curArray.dimensionsCount;
                        }
                        buffer = new StringBuilder();
                        continue;
                    }
                    if (chars[i] == '\"') {
                        insideString = !insideString;
                        wasInsideString = true;
                        continue;
                    }
                    if (!insideString && Character.isWhitespace(chars[i])) continue;
                    if (!insideString && (chars[i] == delim || chars[i] == '}' || chars[i] == ',') || i == chars.length - 1) {
                        String b;
                        if (chars[i] != '\"' && chars[i] != '}' && chars[i] != delim && buffer != null && chars[i] != ',') {
                            buffer.append(chars[i]);
                        }
                        String string = b = buffer == null ? null : buffer.toString();
                        if (b != null && (b.length() > 0 || wasInsideString)) {
                            curArray.add(!wasInsideString && b.equals("NULL") ? null : b);
                        }
                        wasInsideString = false;
                        buffer = new StringBuilder();
                        if (chars[i] != '}') continue;
                        dims.remove(dims.size() - 1);
                        if (!dims.isEmpty()) {
                            curArray = (OscarArrayList)dims.get(dims.size() - 1);
                        }
                        buffer = null;
                        continue;
                    }
                }
                if (buffer == null) continue;
                buffer.append(chars[i]);
            }
        }
    }

    private Object buildArray(OscarArrayList input, int index, int count) throws SQLException {
        int[] dimsLength;
        if (count < 0) {
            count = input.size();
        }
        Object[] ret = null;
        int dims = input.dimensionsCount;
        int[] nArray = dimsLength = dims > 1 ? new int[dims] : null;
        if (dims > 1) {
            for (int i = 0; i < dims; ++i) {
                dimsLength[i] = i == 0 ? count : 0;
            }
        }
        int length = 0;
        switch (this.getBaseType()) {
            case 16: {
                Boolean[] paBool = null;
                Object[] oaBool = null;
                if (dims > 1) {
                    oaBool = (Object[])Array.newInstance(Boolean.class, dimsLength);
                    ret = oaBool;
                } else {
                    paBool = new Boolean[count];
                    ret = paBool;
                }
                while (count > 0) {
                    Object o = input.get(index++);
                    if (dims > 1) {
                        oaBool[length++] = o == null ? null : this.buildArray((OscarArrayList)o, 0, -1);
                    } else {
                        paBool[length++] = o == null ? false : TypeConverter.toBoolean((String)o, -7);
                    }
                    --count;
                }
                break;
            }
            case 4: 
            case 5: {
                Integer[] paInt = null;
                Object[] oaInt = null;
                if (dims > 1) {
                    oaInt = (Object[])Array.newInstance(Integer.class, dimsLength);
                    ret = oaInt;
                } else {
                    paInt = new Integer[count];
                    ret = paInt;
                }
                while (count > 0) {
                    Object o = input.get(index++);
                    if (dims > 1) {
                        oaInt[length++] = o == null ? null : this.buildArray((OscarArrayList)o, 0, -1);
                    } else {
                        paInt[length++] = o == null ? 0 : TypeConverter.toInt((String)o, 4);
                    }
                    --count;
                }
                break;
            }
            case -5: {
                Long[] paLong = null;
                Object[] oaLong = null;
                if (dims > 1) {
                    oaLong = (Object[])Array.newInstance(Long.class, dimsLength);
                    ret = oaLong;
                } else {
                    paLong = new Long[count];
                    ret = paLong;
                }
                while (count > 0) {
                    Object o = input.get(index++);
                    if (dims > 1) {
                        oaLong[length++] = o == null ? null : this.buildArray((OscarArrayList)o, 0, -1);
                    } else {
                        paLong[length++] = o == null ? 0L : TypeConverter.toLong((String)o, -5);
                    }
                    --count;
                }
                break;
            }
            case 2: 
            case 3: {
                BigDecimal[] oaNum = null;
                oaNum = dims > 1 ? (Object[])Array.newInstance(BigDecimal.class, dimsLength) : new BigDecimal[count];
                ret = oaNum;
                while (count > 0) {
                    Object v = input.get(index++);
                    oaNum[length++] = dims > 1 && v != null ? this.buildArray((OscarArrayList)v, 0, -1) : (v == null ? null : TypeConverter.toBigDecimal((String)v, 2));
                    --count;
                }
                break;
            }
            case 7: {
                Float[] paReal = null;
                Object[] oaReal = null;
                if (dims > 1) {
                    oaReal = (Object[])Array.newInstance(Float.class, dimsLength);
                    ret = oaReal;
                } else {
                    paReal = new Float[count];
                    ret = paReal;
                }
                while (count > 0) {
                    Object o = input.get(index++);
                    if (dims > 1) {
                        oaReal[length++] = o == null ? null : this.buildArray((OscarArrayList)o, 0, -1);
                    } else {
                        paReal[length++] = Float.valueOf(o == null ? 0.0f : TypeConverter.toFloat((String)o, 7));
                    }
                    --count;
                }
                break;
            }
            case 8: {
                Double[] paDou = null;
                Object[] oaDou = null;
                if (dims > 1) {
                    oaDou = (Object[])Array.newInstance(Double.class, dimsLength);
                    ret = oaDou;
                } else {
                    paDou = new Double[count];
                    ret = paDou;
                }
                while (count > 0) {
                    Object o = input.get(index++);
                    if (dims > 1) {
                        oaDou[length++] = o == null ? null : this.buildArray((OscarArrayList)o, 0, -1);
                    } else {
                        paDou[length++] = o == null ? 0.0 : TypeConverter.toDouble((String)o, 8);
                    }
                    --count;
                }
                break;
            }
            case -7: 
            case -1: 
            case 1: 
            case 12: {
                String[] oa = null;
                oa = dims > 1 ? (Object[])Array.newInstance(String.class, dimsLength) : new String[count];
                ret = oa;
                while (count > 0) {
                    Object v = input.get(index++);
                    oa[length++] = dims > 1 && v != null ? this.buildArray((OscarArrayList)v, 0, -1) : v;
                    --count;
                }
                break;
            }
            case 91: {
                Date[] oaDate = null;
                oaDate = dims > 1 ? (Object[])Array.newInstance(Date.class, dimsLength) : new Date[count];
                ret = oaDate;
                while (count > 0) {
                    Object v = input.get(index++);
                    oaDate[length++] = dims > 1 && v != null ? this.buildArray((OscarArrayList)v, 0, -1) : (v == null ? null : TypeConverter.toDate((String)v, 91));
                    --count;
                }
                break;
            }
            case 92: {
                Time[] oaTime = null;
                oaTime = dims > 1 ? (Object[])Array.newInstance(Time.class, dimsLength) : new Time[count];
                ret = oaTime;
                while (count > 0) {
                    Object v = input.get(index++);
                    oaTime[length++] = dims > 1 && v != null ? this.buildArray((OscarArrayList)v, 0, -1) : (v == null ? null : TypeConverter.toTime((String)v, 92, this.localCalendar));
                    --count;
                }
                break;
            }
            case 93: {
                Timestamp[] oaTs = null;
                oaTs = dims > 1 ? (Object[])Array.newInstance(Timestamp.class, dimsLength) : new Timestamp[count];
                ret = oaTs;
                while (count > 0) {
                    Object v = input.get(index++);
                    oaTs[length++] = dims > 1 && v != null ? this.buildArray((OscarArrayList)v, 0, -1) : (v == null ? null : TypeConverter.toTimestamp((String)v, 93, this.localCalendar));
                    --count;
                }
                break;
            }
            default: {
                throw Driver.notImplemented();
            }
        }
        return ret;
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        return this.getResultSet(1L, 0, map);
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        this.checkFree();
        ResultSet rs = null;
        rs = this.conn.getProtocolVersion().getProtocolType() >= 2 ? this.getResultSetV2(this.conn, index, count, map) : this.getResultSetV1(this.conn, index, count, map);
        return rs;
    }

    private static class OscarArrayList
    extends ArrayList<Object> {
        private static final long serialVersionUID = 2052783752654562677L;
        int dimensionsCount = 1;

        private OscarArrayList() {
        }
    }
}

