/*
 * Decompiled with CFR 0.152.
 */
package com.oscar;

import com.oscar.Config;
import com.oscar.DriverInfo;
import com.oscar.dispatcher.core.ConnectionMangerV2;
import com.oscar.dispatcher.entity.DispatchConnection;
import com.oscar.jdbc.OscarJdbc2BulkConnection;
import com.oscar.jdbc.OscarJdbc2Connection;
import com.oscar.jdbc.OscarJdbc2RacConnection;
import com.oscar.util.MessageTranslator;
import com.oscar.util.OSQLException;
import com.oscar.util.TrackLog;
import com.oscar.util.VersionConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class Driver
implements java.sql.Driver {
    private static volatile TrackLog trackLog;
    public static final AtomicInteger sessionID;
    public static final boolean debug = false;
    public static final boolean err = true;
    public static final boolean out = false;
    public static final String AUTH_TYPE_PW = "PW";
    public static final String AUTH_TYPE_OS = "OS";
    public static final String AUTH_TYPE_FP = "FP";
    public static final String AUTH_TYPE_RA = "RA";
    public static final boolean JDBC3;
    private VersionConfig versionConfig = VersionConfig.getInstance();
    private static Config config;
    private static final Object[][] knownProperties;
    final ThreadLocal<Random> random = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };
    private static Set<String> hostSet;

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.connect(url, info, null);
    }

    public Connection connect(String url, Properties info, OscarJdbc2Connection connection) throws SQLException {
        try {
            if (JDBC3) {
                Properties props = this.parseURL(url, info);
                if (props == null) {
                    return null;
                }
                this.checkTrackLog(props);
                if (Driver.getLogLevel() != 0) {
                    trackLog.writeLog("jdbc version:: " + DriverInfo.getVersion());
                    trackLog.writeLog("jdbc connect start:: " + url);
                }
                long loginTimeout = 0L;
                String loginTimeoutValue = props.getProperty("LOGINTIMEOUT");
                loginTimeout = loginTimeoutValue != null ? (long)Float.parseFloat(loginTimeoutValue) : (long)(DriverManager.getLoginTimeout() * 1000);
                int rwha = 0;
                if (Boolean.valueOf(props.getProperty("RWHA", "FALSE")).booleanValue()) {
                    rwha = 1;
                } else {
                    try {
                        rwha = Integer.parseInt(props.getProperty("RWHA", "0"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (Boolean.valueOf(props.getProperty("USEDISPATCH", "FALSE")).booleanValue()) {
                    return this.dispatchConnection(loginTimeout, url, props, rwha);
                }
                if (props.get("DBHOSTS") != null && Boolean.valueOf(props.getProperty("FAILOVER", "false")).booleanValue()) {
                    props.setProperty("CLEANSTATEMENT", "true");
                    props.setProperty("URL", url);
                    return this.racConnection(loginTimeout, url, props, connection);
                }
                if (rwha == 1 || rwha == 2) {
                    return this.masterConnection(loginTimeout, url, props, rwha);
                }
                return this.commonConnection(loginTimeout, url, props, null);
            }
            throw new SQLException("not support jdbc2.0");
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception ex) {
            Driver.writeLog("jdbc connect Exception,", ex);
            throw new SQLException(ex.getMessage(), ex);
        }
    }

    private Connection commonConnection(long loginTimeout, String url, Properties props, OscarJdbc2Connection conn) throws SQLException {
        if (loginTimeout <= 0L) {
            return this.makeConnection(conn, url, props);
        }
        ConnectThread ct = new ConnectThread(url, props, conn);
        new Thread((Runnable)ct, "OSCAR JDBC driver connection thread " + ct.hashCode()).start();
        return ct.getResult(loginTimeout);
    }

    private Connection racConnection(long loginTimeout, String url, Properties props, OscarJdbc2Connection conn) throws SQLException {
        Object hostObject = props.get("DBHOSTS");
        int host_next_index = -1;
        int host_index = -1;
        int host_end_index = -1;
        if (props.get("RAC_HOST_INIT_INDEX") != null) {
            host_index = Integer.parseInt(props.get("RAC_HOST_INIT_INDEX").toString());
            host_end_index = Integer.parseInt(props.get("RAC_HOST_END_INDEX").toString());
        }
        while (true) {
            try {
                return this.commonConnection(loginTimeout, url, props, conn);
            }
            catch (SQLException e) {
                String[] hosts = (String[])hostObject;
                if (host_next_index == -1) {
                    host_next_index = host_index + 1 == hosts.length ? 0 : host_index + 1;
                } else {
                    ++host_next_index;
                    if (host_end_index > host_index) {
                        if (host_next_index > host_end_index) {
                            throw e;
                        }
                    } else {
                        if (host_next_index == host_end_index + 1) {
                            throw e;
                        }
                        if (host_next_index >= hosts.length) {
                            host_next_index = 0;
                        }
                    }
                }
                this.setNextHost(hosts, host_next_index, props);
                continue;
            }
            break;
        }
    }

    private Connection dispatchConnection(long loginTimeout, String url, Properties props, int rwha) throws SQLException {
        boolean hasNext = true;
        Object hostsObject = props.get("DBHOSTS");
        String[] hosts = hostsObject != null ? (String[])hostsObject : null;
        String hostsIndex = props.getProperty("DBHOSTS_INDEX");
        int dbHosts_index = hostsIndex == null ? -1 : Integer.parseInt(hostsIndex);
        Connection firstConnection = null;
        do {
            try {
                Connection conn = this.commonConnection(loginTimeout, url, props, null);
                if (hosts == null || ((OscarJdbc2Connection)conn).isMaster()) {
                    String password = props.getProperty("PASSWORD") == null ? "" : props.getProperty("PASSWORD");
                    String database = props.getProperty("DBNAME", "");
                    conn = ConnectionMangerV2.createConnection((OscarJdbc2Connection)conn, password, database, props, ((OscarJdbc2Connection)conn).initSlavesInfo(props));
                }
                if (hosts != null) {
                    if (conn instanceof DispatchConnection) {
                        hasNext = false;
                        if (firstConnection != null) {
                            try {
                                firstConnection.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        return conn;
                    }
                    if (firstConnection == null) {
                        firstConnection = conn;
                    } else {
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (++dbHosts_index >= hosts.length) {
                        if (rwha == 2) {
                            return firstConnection;
                        }
                        throw new OSQLException("OSCAR-00126", "88888", 126);
                    }
                } else {
                    return conn;
                }
                this.setNextHost(hosts, dbHosts_index, props);
            }
            catch (SQLException e) {
                if (hostsIndex != null) {
                    if (++dbHosts_index >= hosts.length) {
                        if (firstConnection != null) {
                            if (rwha == 2) {
                                return firstConnection;
                            }
                            throw new OSQLException("OSCAR-00126", "88888", 126);
                        }
                        throw e;
                    }
                    this.setNextHost(hosts, dbHosts_index, props);
                    continue;
                }
                throw e;
            }
        } while (hasNext);
        return null;
    }

    private Connection masterConnection(long loginTimeout, String url, Properties props, int rwha) throws SQLException {
        boolean hasNext = true;
        Object hostsObject = props.get("DBHOSTS");
        String[] hosts = hostsObject != null ? (String[])hostsObject : null;
        String hostsIndex = props.getProperty("DBHOSTS_INDEX");
        int dbHostsIndex = hostsIndex == null ? -1 : Integer.parseInt(hostsIndex);
        Connection firstConnection = null;
        boolean noMaster = false;
        do {
            try {
                Connection conn = this.commonConnection(loginTimeout, url, props, null);
                if (hosts != null) {
                    if (((OscarJdbc2Connection)conn).isMaster()) {
                        hasNext = false;
                        if (firstConnection != null) {
                            try {
                                firstConnection.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        return conn;
                    }
                    if (firstConnection == null) {
                        firstConnection = conn;
                    } else {
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (++dbHostsIndex >= hosts.length) {
                        if (rwha == 2) {
                            return firstConnection;
                        }
                        noMaster = true;
                        throw new OSQLException("OSCAR-00126", "88888", 126);
                    }
                } else {
                    return conn;
                }
                this.setNextHost(hosts, dbHostsIndex, props);
            }
            catch (SQLException e) {
                if (hostsIndex != null && !noMaster) {
                    if (++dbHostsIndex >= hosts.length) {
                        if (firstConnection != null) {
                            if (rwha == 2) {
                                return firstConnection;
                            }
                            throw new OSQLException("OSCAR-00126", "88888", 126);
                        }
                        throw e;
                    }
                    this.setNextHost(hosts, dbHostsIndex, props);
                    continue;
                }
                throw e;
            }
        } while (hasNext);
        return null;
    }

    public void setNextHost(String[] hosts, int dbHosts_index, Properties props) {
        String hostAndPort = hosts[dbHosts_index];
        StringTokenizer tokener = new StringTokenizer(hostAndPort, ":", true);
        if (tokener.countTokens() == 1) {
            props.put("DBHOST", hostAndPort);
        } else {
            int index = hostAndPort.lastIndexOf(":");
            String host = hostAndPort.substring(0, index);
            String port = hostAndPort.substring(index + 1, hostAndPort.length());
            props.put("DBHOST", host);
            props.put("DBPORT", Integer.decode(port).toString());
        }
    }

    protected OscarJdbc2Connection initOscarConn(Properties props) {
        OscarJdbc2Connection con = null;
        boolean useBulkInsertBatch = Boolean.valueOf(props.getProperty("USEBULKINSERTBATCH", "FALSE"));
        con = useBulkInsertBatch ? new OscarJdbc2BulkConnection() : (props.get("DBHOSTS") != null && Boolean.valueOf(props.getProperty("FAILOVER", "false")) != false ? new OscarJdbc2RacConnection() : new OscarJdbc2Connection());
        return con;
    }

    private Connection makeConnection(OscarJdbc2Connection conn, String url, Properties props) throws SQLException {
        OscarJdbc2Connection con = null;
        con = conn != null ? conn : this.initOscarConn(props);
        con.sessionID = sessionID.getAndIncrement();
        String host = props.getProperty("DBHOST", "localhost");
        int port = Integer.parseInt(props.getProperty("DBPORT", "2003"));
        String database = props.getProperty("DBNAME", "");
        con.openConnection(host, port, props, database, url, this);
        if (trackLog != null && trackLog.getLogLevel() > 0) {
            trackLog.writeLog("session " + con.getSessionID() + " JDBC \u8fde\u63a5\u4fe1\u606f\uff1a" + props.toString());
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkTrackLog(Properties props) {
        Object logLevel = props.get("LOGLEVEL");
        if (logLevel == null || trackLog != null) return;
        Class<Driver> clazz = Driver.class;
        synchronized (Driver.class) {
            if (trackLog != null) return;
            int iLogLevel = Integer.parseInt(logLevel.toString());
            Object logFilePath = props.get("LOGFILEPATH");
            String logPath = Config.getDefultLogPath();
            if (logFilePath != null && !"".equals(logFilePath)) {
                logPath = logFilePath.toString();
            }
            Object maxFileSize = props.get("MAXFILESIZE");
            trackLog = TrackLog.getInstance(iLogLevel, logPath, maxFileSize);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.parseURL(url, null) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Properties newPro = this.parseURL(url, info);
        DriverPropertyInfo[] props = new DriverPropertyInfo[knownProperties.length];
        for (int i = 0; i < knownProperties.length; ++i) {
            String name = (String)knownProperties[i][0];
            String value = newPro.getProperty(name);
            props[i] = new DriverPropertyInfo(name, value);
            props[i].required = (Boolean)knownProperties[i][1];
            props[i].description = (String)knownProperties[i][2];
            if (value == null && knownProperties[i].length > 3) {
                props[i].value = (String)knownProperties[i][3];
            }
            if (knownProperties[i].length <= 4) continue;
            props[i].choices = (String[])knownProperties[i][4];
        }
        return props;
    }

    @Override
    public int getMajorVersion() {
        return this.versionConfig.getDriverMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.versionConfig.getDriverMinorVersion();
    }

    public static String getVersion() {
        VersionConfig vc = VersionConfig.getInstance();
        return vc.getDriverMajorVersion() + "." + vc.getDriverMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    Properties parseURL(String url, Properties defaults) throws SQLException {
        urlProps = new Properties();
        state = -1;
        if (defaults != null) {
            o = null;
            destKey = null;
            e = defaults.keys();
            while (e.hasMoreElements()) {
                o = e.nextElement();
                destKey = ((String)o).toUpperCase();
                urlProps.put(destKey, defaults.get(o));
            }
        }
        l_urlServer = url;
        l_urlArgs = "";
        l_qPos = url.indexOf(63);
        if (l_qPos == -1) {
            l_qPos = url.indexOf(59);
        }
        if (l_qPos != -1) {
            l_urlServer = url.substring(0, l_qPos);
            l_urlArgs = url.substring(l_qPos + 1);
        }
        st = new StringTokenizer(l_urlServer, "/", true);
        tokener = null;
        token = null;
        hosts = null;
        protocols = this.getProtocols();
        count = 0;
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (count == 0) {
                tokener = new StringTokenizer(token, ":", true);
                tcount = 0;
                while (tokener.hasMoreTokens()) {
                    if (tcount > 3 || !tokener.nextToken().equals(protocols[tcount])) {
                        return null;
                    }
                    ++tcount;
                }
            } else if (count == 1 || count == 2) {
                state = 1;
            } else if (count == 3 && state == 1) {
                if (token.indexOf(",") != -1) {
                    hosts = token.split(",");
                } else {
                    tokener = new StringTokenizer(token, ":", true);
                    if (tokener.countTokens() == 1) {
                        urlProps.put("DBHOST", token);
                    } else {
                        index = token.lastIndexOf(":");
                        host = token.substring(0, index);
                        port = token.substring(index + 1, token.length());
                        state = tokener.countTokens() > 1 ? 2 : 3;
                        urlProps.put("DBHOST", host);
                        urlProps.put("DBPORT", Integer.decode(port).toString());
                    }
                }
            } else if (count == 4) {
                state = 4;
            } else if (count == 5 && state == 4) {
                urlProps.put("DBNAME", token);
                state = -2;
            }
            ++count;
        }
        qst = new StringTokenizer(l_urlArgs, "&");
        count = 0;
        while (qst.hasMoreTokens()) {
            gtoken = qst.nextToken().trim();
            l_pos = gtoken.indexOf(61);
            if (l_pos == -1) {
                urlProps.put(gtoken.toUpperCase().trim(), "");
            } else {
                key = gtoken.substring(0, l_pos);
                value = gtoken.substring(l_pos + 1);
                if (key != null && value != null) {
                    urlProps.put(key.toUpperCase().trim(), value.trim());
                }
            }
            ++count;
        }
        configPath = urlProps.get("CONFIGFILE");
        configProps = null;
        if (configPath != null) {
            configProps = new Properties();
            is = null;
            try {
                f = new File(configPath.toString());
                if (!f.exists()) ** GOTO lbl116
                is = new FileInputStream(f);
                tmpProp = new Properties();
                tmpProp.load(is);
                if (tmpProp == null) ** GOTO lbl116
                o = null;
                destKey = null;
                e = tmpProp.keys();
                while (e.hasMoreElements()) {
                    o = e.nextElement();
                    destKey = ((String)o).toUpperCase();
                    configProps.put(destKey, tmpProp.get(o));
                }
            }
            catch (IOException f) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException f) {}
                }
            }
        } else {
            configProps = Config.getConfigProp();
        }
lbl116:
        // 5 sources

        if (configProps != null) {
            e = configProps.keys();
            while (e.hasMoreElements()) {
                obj = e.nextElement();
                if (urlProps.get(obj) != null) continue;
                urlProps.put(obj, configProps.get(obj));
            }
        }
        if (hosts != null) {
            urlProps.put("DBHOSTS", hosts);
            hostAndPort = null;
            if (Boolean.valueOf(urlProps.getProperty("LOADBALANCE", "FALSE")).booleanValue() && !Boolean.valueOf(urlProps.getProperty("USEDISPATCH", "FALSE")).booleanValue()) {
                if (Driver.hostSet.size() > 0) {
                    it = Driver.hostSet.iterator();
                    list = new ArrayList<String>(Arrays.asList(hosts));
                    add = false;
                    while (it.hasNext()) {
                        object = it.next();
                        if (list.contains(object)) continue;
                        list.add(object);
                        add = true;
                    }
                    if (add) {
                        hosts = new String[list.size()];
                        list.toArray(hosts);
                        urlProps.put("DBHOSTS", hosts);
                    }
                }
                random_num = this.random.get().nextInt(hosts.length);
                hostAndPort = hosts[random_num];
                urlProps.put("RAC_HOST_INIT_INDEX", (Object)random_num);
                if (random_num == 0) {
                    urlProps.put("RAC_HOST_END_INDEX", (Object)(hosts.length - 1));
                } else {
                    urlProps.put("RAC_HOST_END_INDEX", (Object)(random_num - 1));
                }
            } else {
                hostAndPort = hosts[0];
                urlProps.put("RAC_HOST_INIT_INDEX", (Object)0);
                urlProps.put("RAC_HOST_END_INDEX", (Object)(hosts.length - 1));
            }
            urlProps.setProperty("DBHOSTS_INDEX", "0");
            tokener = new StringTokenizer(hostAndPort, ":", true);
            if (tokener.countTokens() == 1) {
                urlProps.put("DBHOST", hostAndPort);
            } else {
                index = hostAndPort.lastIndexOf(":");
                host = hostAndPort.substring(0, index);
                port = hostAndPort.substring(index + 1, hostAndPort.length());
                urlProps.put("DBHOST", host);
                urlProps.put("DBPORT", Integer.decode(port).toString());
            }
        }
        return urlProps;
    }

    public static SQLException notImplemented() throws SQLException {
        return new SQLFeatureNotSupportedException("oscar.unimplemented");
    }

    public static boolean sslEnabled() {
        return true;
    }

    public static int getLogLevel() {
        if (trackLog == null) {
            return 0;
        }
        return trackLog.getLogLevel();
    }

    public static void writeLog(String msg) {
        if (trackLog != null && (trackLog.getLogLevel() > 0 || trackLog.getLogLevel() == -1)) {
            trackLog.writeLog(msg);
        }
    }

    public static void writeLog(Integer conId, int sessionId, String msg) {
        if (trackLog != null && (trackLog.getLogLevel() > 0 || trackLog.getLogLevel() == -1)) {
            trackLog.writeLog("conid: " + conId + ", /*Session " + sessionId + "*/ " + msg);
        }
    }

    public static void writeLog(String prefix, Throwable throwable) {
        if (trackLog != null && (trackLog.getLogLevel() > 0 || trackLog.getLogLevel() == -1)) {
            String msg = Driver.getStackTrace(throwable);
            msg = prefix == null ? msg : prefix + " " + msg;
            trackLog.writeLog(msg);
        }
    }

    public static void writeLog(Throwable throwable) {
        Driver.writeLog(null, throwable);
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = null;){
            pw = new PrintWriter((Writer)sw, true);
            throwable.printStackTrace(pw);
            pw.flush();
        }
        return sw.getBuffer().toString();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    protected String[] getProtocols() {
        return new String[]{"jdbc", ":", "oscar", ":"};
    }

    public static Set<String> getHostSet() {
        return hostSet;
    }

    static {
        sessionID = new AtomicInteger(0);
        JDBC3 = "1.4".compareTo(System.getProperty("java.specification.version")) <= 0;
        knownProperties = new Object[][]{{"DBNAME", Boolean.TRUE, MessageTranslator.translate("DRIVER_DBNAME")}, {"DBHOST", Boolean.TRUE, MessageTranslator.translate("DRIVER_DBHOST")}, {"DBPORT", Boolean.TRUE, "DRIVER_DBPORT"}, {"LOGLEVEL", Boolean.FALSE, MessageTranslator.translate("DRIVER_LOGLEVEL"), "0", new String[]{"0", "1", "2", "3", "4"}}, {"LOGFILEPATH", Boolean.FALSE, MessageTranslator.translate("DRIVER_LOGFILEPATH")}, {"LOGINTIMEOUT", Boolean.FALSE, MessageTranslator.translate("DRIVER_LOGINTIMEOUT"), "0"}, {"REQUESTTIMEOUT", Boolean.FALSE, MessageTranslator.translate("DRIVER_REQUESTTIMEOUT"), "0"}, {"NOTREALPREPARE", Boolean.FALSE, MessageTranslator.translate("DRIVER_NOTREALPREPARE"), "false", new String[]{"true", "false"}}, {"COMPATIBLEOLDPROTOCOL", Boolean.FALSE, MessageTranslator.translate("DRIVER_COMPATIBLEOLDPROTOCOL"), "false", new String[]{"true", "false"}}, {"FETCHSIZE", Boolean.FALSE, MessageTranslator.translate("DRIVER_FETCHSIZE"), "16"}, {"PREPARESIMPLEEXECUTE", Boolean.FALSE, MessageTranslator.translate("DRIVER_PREPARESIMPLEEXECUTE"), "true", new String[]{"true", "false"}}, {"VERIFYPOOLCONNECTIN", Boolean.FALSE, MessageTranslator.translate("DRIVER_VERIFYPOOLCONNECTIN"), "false", new String[]{"true", "false"}}, {"USEASYNBATCH", Boolean.FALSE, MessageTranslator.translate("DRIVER_USEASYNBATCH"), "false", new String[]{"true", "false"}}, {"BATCHCOUNT", Boolean.FALSE, MessageTranslator.translate("DRIVER_BATCHCOUNT"), "0"}, {"TCPKEEPALIVE", Boolean.FALSE, MessageTranslator.translate("DRIVER_TCPKEEPALIVE"), "false", new String[]{"true", "false"}}, {"USEDISPATCH", Boolean.FALSE, MessageTranslator.translate("DRIVER_USEDISPATCH"), "false", new String[]{"true", "false"}}, {"USEASYNCHRONOUS", Boolean.FALSE, MessageTranslator.translate("DRIVER_USEASYNCHRONOUS"), "true", new String[]{"true", "false"}}, {"USESLAVESYNCREAD", Boolean.FALSE, MessageTranslator.translate("DRIVER_USESLAVESYNCREAD"), "false", new String[]{"true", "false"}}, {"TRANSACTIONDISPATCHSTRATEGY", Boolean.FALSE, MessageTranslator.translate("DRIVER_TRANSACTIONDISPATCHSTRATEGY"), "1", new String[]{"1", "2", "3"}}, {"VALIDTESTSTRING", Boolean.FALSE, MessageTranslator.translate("DRIVER_VALIDTESTSTRING"), "select 1", new String[]{"select 'mpp nodeagent probeing'", "select 'user direct testing'", "select 'mpp master probeing'"}}, {"CHECKDBLINKSQL", Boolean.FALSE, MessageTranslator.translate("DRIVER_CHECKDBLINKSQL"), "false", new String[]{"true", "false"}}, {"SENDBINARYTYPEASHEX", Boolean.FALSE, MessageTranslator.translate("DRIVER_SENDBINARYTYPEASHEX"), "false", new String[]{"true", "false"}}};
        hostSet = new HashSet<String>();
        try {
            config = new Config();
            config.init();
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private class ConnectThread
    implements Runnable {
        private String url;
        private Properties props;
        private Connection result;
        private Throwable resultException;
        private boolean abandoned = false;
        private OscarJdbc2Connection oscarCon = null;

        ConnectThread(String url, Properties props, OscarJdbc2Connection connection) {
            this.url = url;
            this.props = props;
            this.oscarCon = connection != null ? connection : Driver.this.initOscarConn(props);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection conn = null;
            Throwable error = null;
            try {
                conn = Driver.this.makeConnection(this.oscarCon, this.url, this.props);
                error = null;
            }
            catch (Throwable t) {
                error = t;
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                if (this.abandoned) {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                } else {
                    this.result = conn;
                    this.resultException = error;
                    this.notify();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Connection getResult(long timeout) throws SQLException {
            if (Driver.getLogLevel() != 0) {
                trackLog.writeLog("getResultAsConnection start, hashcode:" + this.hashCode());
            }
            long expiry = System.currentTimeMillis() + timeout;
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                while (true) {
                    if (this.result != null) {
                        if (Driver.getLogLevel() != 0) {
                            trackLog.writeLog("getResultAsConnection return, session: " + ((OscarJdbc2Connection)this.result).getSessionID() + " hashcode: " + this.hashCode());
                        }
                        return this.result;
                    }
                    if (this.resultException != null) {
                        if (this.resultException instanceof SQLException) {
                            this.resultException.fillInStackTrace();
                            Driver.writeLog("getResultAsConnection, hashcode: " + this.hashCode() + "exception on new connection:", this.resultException);
                            throw (SQLException)this.resultException;
                        }
                        Driver.writeLog("getResultAsConnection timeout1--" + timeout + " hashcode: " + this.hashCode());
                        throw new OSQLException("OSCAR-00121", "08001", 121);
                    }
                    long delay = expiry - System.currentTimeMillis();
                    if (delay <= 0L) {
                        this.abandoned = true;
                        if (this.oscarCon != null) {
                            this.oscarCon.close();
                        }
                        Driver.writeLog("getResultAsConnection timeout2--" + timeout + " hashcode: " + this.hashCode());
                        throw new OSQLException("OSCAR-00122", "08001", 122);
                    }
                    try {
                        this.wait(delay);
                    }
                    catch (InterruptedException ie) {
                        this.abandoned = true;
                        Driver.writeLog("getResultAsConnection timeout3--" + timeout + " hashcode: " + this.hashCode());
                        throw new OSQLException("OSCAR-00123", "08001", 123);
                    }
                }
            }
        }
    }
}

